-- Zephyr RocketLauncher Package
-- August 2010 Joomla template release
-- http://www.rockettheme.com

-- --------------------------------------------------------

--
-- Table structure for table `#__banner`
--

DROP TABLE IF EXISTS `#__banner`;
CREATE TABLE IF NOT EXISTS `#__banner` (
  `bid` int(11) NOT NULL AUTO_INCREMENT,
  `cid` int(11) NOT NULL DEFAULT '0',
  `type` varchar(30) NOT NULL DEFAULT 'banner',
  `name` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(255) NOT NULL DEFAULT '',
  `imptotal` int(11) NOT NULL DEFAULT '0',
  `impmade` int(11) NOT NULL DEFAULT '0',
  `clicks` int(11) NOT NULL DEFAULT '0',
  `imageurl` varchar(100) NOT NULL DEFAULT '',
  `clickurl` varchar(200) NOT NULL DEFAULT '',
  `date` datetime DEFAULT NULL,
  `showBanner` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `editor` varchar(50) DEFAULT NULL,
  `custombannercode` text,
  `catid` int(10) unsigned NOT NULL DEFAULT '0',
  `description` text NOT NULL,
  `sticky` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `tags` text NOT NULL,
  `params` text NOT NULL,
  PRIMARY KEY (`bid`),
  KEY `viewbanner` (`showBanner`),
  KEY `idx_banner_catid` (`catid`)
);

--
-- Dumping data for table `#__banner`
--

INSERT INTO `#__banner` (`bid`, `cid`, `type`, `name`, `alias`, `imptotal`, `impmade`, `clicks`, `imageurl`, `clickurl`, `date`, `showBanner`, `checked_out`, `checked_out_time`, `editor`, `custombannercode`, `catid`, `description`, `sticky`, `ordering`, `publish_up`, `publish_down`, `tags`, `params`) VALUES
(1, 1, 'banner', 'OSM 1', 'osm-1', 0, 43, 0, 'osmbanner1.png', 'http://www.opensourcematters.org', '2004-07-07 15:31:29', 1, 0, '0000-00-00 00:00:00', '', '', 13, '', 0, 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', ''),
(2, 1, 'banner', 'OSM 2', 'osm-2', 0, 49, 0, 'osmbanner2.png', 'http://www.opensourcematters.org', '2004-07-07 15:31:29', 1, 0, '0000-00-00 00:00:00', '', '', 13, '', 0, 2, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', ''),
(3, 1, '', 'Joomla!', 'joomla', 0, 18, 0, '', 'http://www.joomla.org', '2006-05-29 14:21:28', 1, 0, '0000-00-00 00:00:00', '', '<a href="{CLICKURL}" target="_blank">{NAME}</a>\r\n<br/>\r\nJoomla! The most popular and widely used Open Source CMS Project in the world.', 14, '', 0, 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', ''),
(4, 1, '', 'JoomlaCode', 'joomlacode', 0, 18, 0, '', 'http://joomlacode.org', '2006-05-29 14:19:26', 1, 0, '0000-00-00 00:00:00', '', '<a href="{CLICKURL}" target="_blank">{NAME}</a>\r\n<br/>\r\nJoomlaCode, development and distribution made easy.', 14, '', 0, 2, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', ''),
(5, 1, '', 'Joomla! Extensions', 'joomla-extensions', 0, 13, 0, '', 'http://extensions.joomla.org', '2006-05-29 14:23:21', 1, 0, '0000-00-00 00:00:00', '', '<a href="{CLICKURL}" target="_blank">{NAME}</a>\r\n<br/>\r\nJoomla! Components, Modules, Plugins and Languages by the bucket load.', 14, '', 0, 3, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', ''),
(6, 1, '', 'Joomla! Shop', 'joomla-shop', 0, 13, 0, '', 'http://shop.joomla.org', '2006-05-29 14:23:21', 1, 0, '0000-00-00 00:00:00', '', '<a href="{CLICKURL}" target="_blank">{NAME}</a>\r\n<br/>\r\nFor all your Joomla! merchandise.', 14, '', 0, 4, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', ''),
(7, 1, '', 'Joomla! Promo Shop', 'joomla-promo-shop', 0, 8, 1, 'shop-ad.jpg', 'http://shop.joomla.org', '2007-09-19 17:26:24', 1, 0, '0000-00-00 00:00:00', '', '', 33, '', 0, 3, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', ''),
(8, 1, '', 'Joomla! Promo Books', 'joomla-promo-books', 0, 10, 0, 'shop-ad-books.jpg', 'http://shop.joomla.org/amazoncom-bookstores.html', '2007-09-19 17:28:01', 1, 0, '0000-00-00 00:00:00', '', '', 33, '', 0, 4, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `#__bannerclient`
--

DROP TABLE IF EXISTS `#__bannerclient`;
CREATE TABLE IF NOT EXISTS `#__bannerclient` (
  `cid` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `contact` varchar(255) NOT NULL DEFAULT '',
  `email` varchar(255) NOT NULL DEFAULT '',
  `extrainfo` text NOT NULL,
  `checked_out` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out_time` time DEFAULT NULL,
  `editor` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`cid`)
);

--
-- Dumping data for table `#__bannerclient`
--

INSERT INTO `#__bannerclient` (`cid`, `name`, `contact`, `email`, `extrainfo`, `checked_out`, `checked_out_time`, `editor`) VALUES
(1, 'Open Source Matters', 'Administrator', 'admin@opensourcematters.org', '', 0, '00:00:00', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `#__bannertrack`
--

DROP TABLE IF EXISTS `#__bannertrack`;
CREATE TABLE IF NOT EXISTS `#__bannertrack` (
  `track_date` date NOT NULL,
  `track_type` int(10) unsigned NOT NULL,
  `banner_id` int(10) unsigned NOT NULL
);

--
-- Dumping data for table `#__bannertrack`
--


-- --------------------------------------------------------

--
-- Table structure for table `#__categories`
--

DROP TABLE IF EXISTS `#__categories`;
CREATE TABLE IF NOT EXISTS `#__categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(255) NOT NULL DEFAULT '',
  `image` varchar(255) NOT NULL DEFAULT '',
  `section` varchar(50) NOT NULL DEFAULT '',
  `image_position` varchar(30) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `editor` varchar(50) DEFAULT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  `access` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `count` int(11) NOT NULL DEFAULT '0',
  `params` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `cat_idx` (`section`,`published`,`access`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`)
);

--
-- Dumping data for table `#__categories`
--

INSERT INTO `#__categories` (`id`, `parent_id`, `title`, `name`, `alias`, `image`, `section`, `image_position`, `description`, `published`, `checked_out`, `checked_out_time`, `editor`, `ordering`, `access`, `count`, `params`) VALUES
(1, 0, 'Latest', '', 'latest-news', 'taking_notes.jpg', '1', 'left', 'The latest news from the Joomla! Team', 1, 0, '0000-00-00 00:00:00', '', 1, 0, 1, ''),
(2, 0, 'Joomla! Specific Links', '', 'joomla-specific-links', 'clock.jpg', 'com_weblinks', 'left', 'A selection of links that are all related to the Joomla! Project.', 1, 0, '0000-00-00 00:00:00', NULL, 1, 0, 0, ''),
(3, 0, 'Newsflash', '', 'newsflash', '', '1', 'left', '', 1, 0, '0000-00-00 00:00:00', '', 2, 0, 0, ''),
(4, 0, 'Joomla!', '', 'joomla', '', 'com_newsfeeds', 'left', '', 1, 0, '0000-00-00 00:00:00', NULL, 2, 0, 0, ''),
(5, 0, 'Free and Open Source Software', '', 'free-and-open-source-software', '', 'com_newsfeeds', 'left', 'Read the latest news about free and open source software from some of its leading advocates.', 1, 0, '0000-00-00 00:00:00', NULL, 3, 0, 0, ''),
(6, 0, 'Related Projects', '', 'related-projects', '', 'com_newsfeeds', 'left', 'Joomla builds on and collaborates with many other free and open source projects. Keep up with the latest news from some of them.', 1, 0, '0000-00-00 00:00:00', NULL, 4, 0, 0, ''),
(12, 0, 'Contacts', '', 'contacts', '', 'com_contact_details', 'left', 'Contact Details for this Web site', 1, 0, '0000-00-00 00:00:00', NULL, 0, 0, 0, ''),
(13, 0, 'Joomla', '', 'joomla', '', 'com_banner', 'left', '', 1, 0, '0000-00-00 00:00:00', NULL, 0, 0, 0, ''),
(14, 0, 'Text Ads', '', 'text-ads', '', 'com_banner', 'left', '', 1, 0, '0000-00-00 00:00:00', NULL, 0, 0, 0, ''),
(15, 0, 'Features', '', 'features', '', 'com_content', 'left', '', 0, 0, '0000-00-00 00:00:00', NULL, 6, 0, 0, ''),
(17, 0, 'Benefits', '', 'benefits', '', 'com_content', 'left', '', 0, 0, '0000-00-00 00:00:00', NULL, 4, 0, 0, ''),
(18, 0, 'Platforms', '', 'platforms', '', 'com_content', 'left', '', 0, 0, '0000-00-00 00:00:00', NULL, 3, 0, 0, ''),
(19, 0, 'Other Resources', '', 'other-resources', '', 'com_weblinks', 'left', '', 1, 0, '0000-00-00 00:00:00', NULL, 2, 0, 0, ''),
(29, 0, 'The CMS', '', 'the-cms', '', '4', 'left', 'Information about the software behind Joomla!<br />', 1, 0, '0000-00-00 00:00:00', NULL, 2, 0, 0, ''),
(28, 0, 'Current Users', '', 'current-users', '', '3', 'left', 'Questions that users migrating to Joomla! 1.5 are likely to raise<br />', 1, 0, '0000-00-00 00:00:00', NULL, 2, 0, 0, ''),
(25, 0, 'The Project', '', 'the-project', '', '4', 'left', 'General facts about Joomla!<br />', 1, 0, '0000-00-00 00:00:00', NULL, 1, 0, 0, ''),
(27, 0, 'New to Joomla!', '', 'new-to-joomla', '', '3', 'left', 'Questions for new users of Joomla!', 1, 0, '0000-00-00 00:00:00', NULL, 3, 0, 0, ''),
(30, 0, 'The Community', '', 'the-community', '', '4', 'left', 'About the millions of Joomla! users and Web sites<br />', 1, 0, '0000-00-00 00:00:00', NULL, 3, 0, 0, ''),
(31, 0, 'General', '', 'general', '', '3', 'left', 'General questions about the Joomla! CMS', 1, 0, '0000-00-00 00:00:00', NULL, 1, 0, 0, ''),
(32, 0, 'Languages', '', 'languages', '', '3', 'left', 'Questions related to localisation and languages', 1, 0, '0000-00-00 00:00:00', NULL, 4, 0, 0, ''),
(33, 0, 'Joomla! Promo', '', 'joomla-promo', '', 'com_banner', 'left', '', 1, 0, '0000-00-00 00:00:00', NULL, 1, 0, 0, ''),
(34, 0, 'Demo Articles', '', 'demo-articles', '', '5', 'left', '', 1, 0, '0000-00-00 00:00:00', NULL, 1, 0, 0, ''),
(35, 0, 'Basic', '', 'basic', '', 'com_rokcandy', 'left', '', 1, 0, '0000-00-00 00:00:00', NULL, 1, 0, 0, ''),
(36, 0, 'Typography', '', 'typography', '', 'com_rokcandy', 'left', '', 1, 0, '0000-00-00 00:00:00', NULL, 1, 0, 0, ''),
(37, 0, 'RokStories Samples', '', 'rokstories-samples', '', '5', 'left', '', 1, 0, '0000-00-00 00:00:00', NULL, 1, 0, 0, ''),
(38, 0, 'FP RokStories', '', 'fp-rokstories', '', '5', 'left', '', 1, 0, '0000-00-00 00:00:00', NULL, 2, 0, 0, ''),
(40, 0, 'RokTabs Samples', '', 'roktabs-samples', '', '5', 'left', '', 1, 0, '0000-00-00 00:00:00', NULL, 4, 0, 0, ''),
(41, 0, 'JComments', '', 'jcomments', '', '5', 'left', '', 1, 0, '0000-00-00 00:00:00', NULL, 5, 0, 0, ''),
(42, 0, 'FP RNP', '', 'fp-rnp', '', '5', 'left', '', 1, 0, '0000-00-00 00:00:00', NULL, 6, 0, 0, ''),
(43, 0, 'FP RokTabs', '', 'fp-roktabs', '', '5', 'left', '', 1, 0, '0000-00-00 00:00:00', NULL, 7, 0, 0, ''),
(44, 0, 'RokIntroScroller', '', 'rokintroscroller', '', '5', 'left', '', 1, 0, '0000-00-00 00:00:00', NULL, 8, 0, 0, '');

-- --------------------------------------------------------

--
-- Table structure for table `#__components`
--

DROP TABLE IF EXISTS `#__components`;
CREATE TABLE IF NOT EXISTS `#__components` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '',
  `link` varchar(255) NOT NULL DEFAULT '',
  `menuid` int(11) unsigned NOT NULL DEFAULT '0',
  `parent` int(11) unsigned NOT NULL DEFAULT '0',
  `admin_menu_link` varchar(255) NOT NULL DEFAULT '',
  `admin_menu_alt` varchar(255) NOT NULL DEFAULT '',
  `option` varchar(50) NOT NULL DEFAULT '',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `admin_menu_img` varchar(255) NOT NULL DEFAULT '',
  `iscore` tinyint(4) NOT NULL DEFAULT '0',
  `params` text NOT NULL,
  `enabled` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `parent_option` (`parent`,`option`(32))
);

--
-- Dumping data for table `#__components`
--

INSERT INTO `#__components` (`id`, `name`, `link`, `menuid`, `parent`, `admin_menu_link`, `admin_menu_alt`, `option`, `ordering`, `admin_menu_img`, `iscore`, `params`, `enabled`) VALUES
(1, 'Banners', '', 0, 0, '', 'Banner Management', 'com_banners', 0, 'js/ThemeOffice/component.png', 0, 'track_impressions=0\ntrack_clicks=0\ntag_prefix=\n\n', 1),
(2, 'Banners', '', 0, 1, 'option=com_banners', 'Active Banners', 'com_banners', 1, 'js/ThemeOffice/edit.png', 0, '', 1),
(3, 'Clients', '', 0, 1, 'option=com_banners&c=client', 'Manage Clients', 'com_banners', 2, 'js/ThemeOffice/categories.png', 0, '', 1),
(4, 'Web Links', 'option=com_weblinks', 0, 0, '', 'Manage Weblinks', 'com_weblinks', 0, 'js/ThemeOffice/component.png', 0, 'show_comp_description=1\ncomp_description=\nshow_link_hits=1\nshow_link_description=1\nshow_other_cats=1\nshow_headings=1\nshow_page_title=1\nlink_target=0\nlink_icons=\n\n', 1),
(5, 'Links', '', 0, 4, 'option=com_weblinks', 'View existing weblinks', 'com_weblinks', 1, 'js/ThemeOffice/edit.png', 0, '', 1),
(6, 'Categories', '', 0, 4, 'option=com_categories&section=com_weblinks', 'Manage weblink categories', '', 2, 'js/ThemeOffice/categories.png', 0, '', 1),
(7, 'Contacts', 'option=com_contact', 0, 0, '', 'Edit contact details', 'com_contact', 0, 'js/ThemeOffice/component.png', 1, 'contact_icons=0\nicon_address=\nicon_email=\nicon_telephone=\nicon_fax=\nicon_misc=\nshow_headings=1\nshow_position=1\nshow_email=0\nshow_telephone=1\nshow_mobile=1\nshow_fax=1\nbannedEmail=\nbannedSubject=\nbannedText=\nsession=1\ncustomReply=0\n\n', 1),
(8, 'Contacts', '', 0, 7, 'option=com_contact', 'Edit contact details', 'com_contact', 0, 'js/ThemeOffice/edit.png', 1, '', 1),
(9, 'Categories', '', 0, 7, 'option=com_categories&section=com_contact_details', 'Manage contact categories', '', 2, 'js/ThemeOffice/categories.png', 1, 'contact_icons=0\nicon_address=\nicon_email=\nicon_telephone=\nicon_fax=\nicon_misc=\nshow_headings=1\nshow_position=1\nshow_email=0\nshow_telephone=1\nshow_mobile=1\nshow_fax=1\nbannedEmail=\nbannedSubject=\nbannedText=\nsession=1\ncustomReply=0\n\n', 1),
(10, 'Polls', 'option=com_poll', 0, 0, 'option=com_poll', 'Manage Polls', 'com_poll', 0, 'js/ThemeOffice/component.png', 0, '', 1),
(11, 'News Feeds', 'option=com_newsfeeds', 0, 0, '', 'News Feeds Management', 'com_newsfeeds', 0, 'js/ThemeOffice/component.png', 0, '', 1),
(12, 'Feeds', '', 0, 11, 'option=com_newsfeeds', 'Manage News Feeds', 'com_newsfeeds', 1, 'js/ThemeOffice/edit.png', 0, 'show_headings=1\nshow_name=1\nshow_articles=1\nshow_link=1\nshow_cat_description=1\nshow_cat_items=1\nshow_feed_image=1\nshow_feed_description=1\nshow_item_description=1\nfeed_word_count=0\n\n', 1),
(13, 'Categories', '', 0, 11, 'option=com_categories&section=com_newsfeeds', 'Manage Categories', '', 2, 'js/ThemeOffice/categories.png', 0, '', 1),
(14, 'User', 'option=com_user', 0, 0, '', '', 'com_user', 0, '', 1, '', 1),
(15, 'Search', 'option=com_search', 0, 0, 'option=com_search', 'Search Statistics', 'com_search', 0, 'js/ThemeOffice/component.png', 1, 'enabled=0\n\n', 1),
(16, 'Categories', '', 0, 1, 'option=com_categories&section=com_banner', 'Categories', '', 3, '', 1, '', 1),
(17, 'Wrapper', 'option=com_wrapper', 0, 0, '', 'Wrapper', 'com_wrapper', 0, '', 1, '', 1),
(18, 'Mail To', '', 0, 0, '', '', 'com_mailto', 0, '', 1, '', 1),
(19, 'Media Manager', '', 0, 0, 'option=com_media', 'Media Manager', 'com_media', 0, '', 1, 'upload_extensions=bmp,csv,doc,epg,gif,ico,jpg,odg,odp,ods,odt,pdf,png,ppt,swf,txt,xcf,xls,BMP,CSV,DOC,EPG,GIF,ICO,JPG,ODG,ODP,ODS,ODT,PDF,PNG,PPT,SWF,TXT,XCF,XLS\nupload_maxsize=10000000\nfile_path=images\nimage_path=images/stories\nrestrict_uploads=1\nallowed_media_usergroup=3\ncheck_mime=1\nimage_extensions=bmp,gif,jpg,png\nignore_extensions=\nupload_mime=image/jpeg,image/gif,image/png,image/bmp,application/x-shockwave-flash,application/msword,application/excel,application/pdf,application/powerpoint,text/plain,application/x-zip\nupload_mime_illegal=text/html\nenable_flash=0\n\n', 1),
(20, 'Articles', 'option=com_content', 0, 0, '', '', 'com_content', 0, '', 1, 'show_noauth=0\nshow_title=1\nlink_titles=0\nshow_intro=1\nshow_section=0\nlink_section=0\nshow_category=0\nlink_category=0\nshow_author=0\nshow_create_date=0\nshow_modify_date=0\nshow_item_navigation=0\nshow_readmore=1\nshow_vote=0\nshow_icons=0\nshow_pdf_icon=0\nshow_print_icon=0\nshow_email_icon=0\nshow_hits=1\nfeed_summary=0\nfilter_tags=\nfilter_attritbutes=\n\n', 1),
(21, 'Configuration Manager', '', 0, 0, '', 'Configuration', 'com_config', 0, '', 1, '', 1),
(22, 'Installation Manager', '', 0, 0, '', 'Installer', 'com_installer', 0, '', 1, '', 1),
(23, 'Language Manager', '', 0, 0, '', 'Languages', 'com_languages', 0, '', 1, 'administrator=en-GB\nsite=en-GB', 1),
(24, 'Mass mail', '', 0, 0, '', 'Mass Mail', 'com_massmail', 0, '', 1, 'mailSubjectPrefix=\nmailBodySuffix=\n\n', 1),
(25, 'Menu Editor', '', 0, 0, '', 'Menu Editor', 'com_menus', 0, '', 1, '', 1),
(27, 'Messaging', '', 0, 0, '', 'Messages', 'com_messages', 0, '', 1, '', 1),
(28, 'Modules Manager', '', 0, 0, '', 'Modules', 'com_modules', 0, '', 1, '', 1),
(29, 'Plugin Manager', '', 0, 0, '', 'Plugins', 'com_plugins', 0, '', 1, '', 1),
(30, 'Template Manager', '', 0, 0, '', 'Templates', 'com_templates', 0, '', 1, '', 1),
(31, 'User Manager', '', 0, 0, '', 'Users', 'com_users', 0, '', 1, 'allowUserRegistration=0\nnew_usertype=Registered\nuseractivation=1\nfrontend_userparams=1\n\n', 1),
(32, 'Cache Manager', '', 0, 0, '', 'Cache', 'com_cache', 0, '', 1, '', 1),
(33, 'Control Panel', '', 0, 0, '', 'Control Panel', 'com_cpanel', 0, '', 1, '', 1),
(34, 'RokCandyBundle', '', 0, 0, '', 'RokCandyBundle', 'com_rokcandybundle', 0, '', 0, '', 0),
(35, 'RokCandy', '', 0, 0, 'option=com_rokcandy', 'RokCandy', 'com_rokcandy', 0, 'components/com_rokcandy/assets/rokcandy-icon-16.png', 1, '', 1),
(36, 'Macros', '', 0, 35, 'option=com_rokcandy', 'Macros', 'com_rokcandy', 0, 'images/blank.png', 0, '', 1),
(37, 'Categories', '', 0, 35, 'option=com_categories&section=com_rokcandy', 'Categories', 'com_rokcandy', 1, 'images/blank.png', 0, '', 1),
(38, 'RokModule', '', 0, 0, '', 'RokModule', 'com_rokmodule', 0, '', 0, '', 1),
(40, 'Gantry', '', 0, 0, '', 'Gantry', 'com_gantry', 0, '', 0, '', 1),
(41, 'RokNavMenuBundle', '', 0, 0, '', 'RokNavMenuBundle', 'com_roknavmenubundle', 0, '', 0, '', 1);

-- --------------------------------------------------------

--
-- Table structure for table `#__contact_details`
--

DROP TABLE IF EXISTS `#__contact_details`;
CREATE TABLE IF NOT EXISTS `#__contact_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(255) NOT NULL DEFAULT '',
  `con_position` varchar(255) DEFAULT NULL,
  `address` text,
  `suburb` varchar(100) DEFAULT NULL,
  `state` varchar(100) DEFAULT NULL,
  `country` varchar(100) DEFAULT NULL,
  `postcode` varchar(100) DEFAULT NULL,
  `telephone` varchar(255) DEFAULT NULL,
  `fax` varchar(255) DEFAULT NULL,
  `misc` mediumtext,
  `image` varchar(255) DEFAULT NULL,
  `imagepos` varchar(20) DEFAULT NULL,
  `email_to` varchar(255) DEFAULT NULL,
  `default_con` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `published` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `checked_out` int(11) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text NOT NULL,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `catid` int(11) NOT NULL DEFAULT '0',
  `access` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `mobile` varchar(255) NOT NULL DEFAULT '',
  `webpage` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `catid` (`catid`)
);

--
-- Dumping data for table `#__contact_details`
--

INSERT INTO `#__contact_details` (`id`, `name`, `alias`, `con_position`, `address`, `suburb`, `state`, `country`, `postcode`, `telephone`, `fax`, `misc`, `image`, `imagepos`, `email_to`, `default_con`, `published`, `checked_out`, `checked_out_time`, `ordering`, `params`, `user_id`, `catid`, `access`, `mobile`, `webpage`) VALUES
(1, 'Name', 'name', 'Position', 'Street', 'Suburb', 'State', 'Country', 'Zip Code', 'Telephone', 'Fax', 'Miscellanous info', 'powered_by.png', 'top', 'email@email.com', 1, 1, 0, '0000-00-00 00:00:00', 1, 'show_name=1\r\nshow_position=1\r\nshow_email=0\r\nshow_street_address=1\r\nshow_suburb=1\r\nshow_state=1\r\nshow_postcode=1\r\nshow_country=1\r\nshow_telephone=1\r\nshow_mobile=1\r\nshow_fax=1\r\nshow_webpage=1\r\nshow_misc=1\r\nshow_image=1\r\nallow_vcard=0\r\ncontact_icons=0\r\nicon_address=\r\nicon_email=\r\nicon_telephone=\r\nicon_fax=\r\nicon_misc=\r\nshow_email_form=1\r\nemail_description=1\r\nshow_email_copy=1\r\nbanned_email=\r\nbanned_subject=\r\nbanned_text=', 0, 12, 0, '', '');

-- --------------------------------------------------------

--
-- Table structure for table `#__content`
--

DROP TABLE IF EXISTS `#__content`;
CREATE TABLE IF NOT EXISTS `#__content` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(255) NOT NULL DEFAULT '',
  `title_alias` varchar(255) NOT NULL DEFAULT '',
  `introtext` mediumtext NOT NULL,
  `fulltext` mediumtext NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `sectionid` int(11) unsigned NOT NULL DEFAULT '0',
  `mask` int(11) unsigned NOT NULL DEFAULT '0',
  `catid` int(11) unsigned NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(11) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(11) unsigned NOT NULL DEFAULT '0',
  `checked_out` int(11) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `images` text NOT NULL,
  `urls` text NOT NULL,
  `attribs` text NOT NULL,
  `version` int(11) unsigned NOT NULL DEFAULT '1',
  `parentid` int(11) unsigned NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `metakey` text NOT NULL,
  `metadesc` text NOT NULL,
  `access` int(11) unsigned NOT NULL DEFAULT '0',
  `hits` int(11) unsigned NOT NULL DEFAULT '0',
  `metadata` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_section` (`sectionid`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`)
);

--
-- Dumping data for table `#__content`
--

INSERT INTO `#__content` (`id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`) VALUES
(1, 'Welcome to Joomla!', 'welcome-to-joomla', '', '<div align="left"><strong>Joomla! is a free open source framework and content publishing system designed for quickly creating highly interactive multi-language Web sites, online communities, media portals, blogs and eCommerce applications. <br /></strong></div><p><strong><br /></strong>Joomla! provides an easy-to-use graphical user interface that simplifies the management and publishing of large volumes of content including HTML, documents, and rich media.  Joomla! is used by organisations of all sizes for intranets and extranets and is supported by a community of tens of thousands of users. </p>', 'With a fully documented library of developer resources, Joomla! allows the customisation of every aspect of a Web site including presentation, layout, administration, and the rapid integration with third-party applications.<p>Joomla! now provides more developer power while making the user experience all the more friendly. For those who always wanted increased extensibility, Joomla! 1.5 can make this happen.</p><p>A new framework, ground-up refactoring, and a highly-active development team brings the excitement of ''the next generation CMS'' to your fingertips.  Whether you are a systems architect or a complete ''noob'' Joomla! can take you to the next level of content delivery. ''More than a CMS'' is something we have been playing with as a catchcry because the new Joomla! API has such incredible power and flexibility, you are free to take whatever direction your creative mind takes you and Joomla! can help you get there so much more easily than ever before.</p><p>Thinking Web publishing? Think Joomla!</p>', 1, 1, 0, 1, '2008-08-12 10:00:00', 62, '', '2010-07-19 23:11:22', 62, 0, '0000-00-00 00:00:00', '2006-01-03 01:00:00', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 30, 0, 1, '', '', 0, 92, 'robots=\nauthor='),
(2, 'Newsflash 1', 'newsflash-1', '', '<p>Joomla! makes it easy to launch a Web site of any kind. Whether you want a brochure site or you are building a large online community, Joomla! allows you to deploy a new site in minutes and add extra functionality as you need it. The hundreds of available Extensions will help to expand your site and allow you to deliver new services that extend your reach into the Internet.</p>', '', 1, 1, 0, 3, '2008-08-10 06:30:34', 62, '', '2008-08-10 06:30:34', 62, 0, '0000-00-00 00:00:00', '2004-08-09 10:00:00', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 7, 0, 3, '', '', 0, 1, 'robots=\nauthor='),
(3, 'Newsflash 2', 'newsflash-2', '', '<p>The one thing about a Web site, it always changes! Joomla! makes it easy to add Articles, content, images, videos, and more. Site administrators can edit and manage content ''in-context'' by clicking the ''Edit'' link. Webmasters can also edit content through a graphical Control Panel that gives you complete control over your site.</p>', '', 1, 1, 0, 3, '2008-08-09 22:30:34', 62, '', '2008-08-09 22:30:34', 62, 0, '0000-00-00 00:00:00', '2004-08-09 06:00:00', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 6, 0, 4, '', '', 0, 0, 'robots=\nauthor='),
(4, 'Newsflash 3', 'newsflash-3', '', '<p>With a library of thousands of free <a href="http://extensions.joomla.org" target="_blank" title="The Joomla! Extensions Directory">Extensions</a>, you can add what you need as your site grows. Don''t wait, look through the <a href="http://extensions.joomla.org/" target="_blank" title="Joomla! Extensions">Joomla! Extensions</a>  library today. </p>', '', 1, 1, 0, 3, '2008-08-10 06:30:34', 62, '', '2008-08-10 06:30:34', 62, 0, '0000-00-00 00:00:00', '2004-08-09 10:00:00', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 7, 0, 5, '', '', 0, 1, 'robots=\nauthor='),
(5, 'Joomla! License Guidelines', 'joomla-license-guidelines', 'joomla-license-guidelines', '<p>This Web site is powered by <a href="http://joomla.org/" target="_blank" title="Joomla!">Joomla!</a> The software and default templates on which it runs are Copyright 2005-2008 <a href="http://www.opensourcematters.org/" target="_blank" title="Open Source Matters">Open Source Matters</a>. The sample content distributed with Joomla! is licensed under the <a href="http://docs.joomla.org/JEDL" target="_blank" title="Joomla! Electronic Document License">Joomla! Electronic Documentation License.</a> All data entered into this Web site and templates added after installation, are copyrighted by their respective copyright owners.</p> <p>If you want to distribute, copy, or modify Joomla!, you are welcome to do so under the terms of the <a href="http://www.gnu.org/licenses/old-licenses/gpl-2.0.html#SEC1" target="_blank" title="GNU General Public License"> GNU General Public License</a>. If you are unfamiliar with this license, you might want to read <a href="http://www.gnu.org/licenses/old-licenses/gpl-2.0.html#SEC4" target="_blank" title="How To Apply These Terms To Your Program">''How To Apply These Terms To Your Program''</a> and the <a href="http://www.gnu.org/licenses/old-licenses/gpl-2.0-faq.html" target="_blank" title="GNU General Public License FAQ">''GNU General Public License FAQ''</a>.</p> <p>The Joomla! licence has always been GPL.</p>', '', 1, 4, 0, 25, '2008-08-20 10:11:07', 62, '', '2008-08-20 10:11:07', 62, 0, '0000-00-00 00:00:00', '2004-08-19 06:00:00', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 7, 0, 2, '', '', 0, 100, 'robots=\nauthor='),
(6, 'We are Volunteers', 'we-are-volunteers', '', '<p>The Joomla Core Team and Working Group members are volunteer developers, designers, administrators and managers who have worked together to take Joomla! to new heights in its relatively short life. Joomla! has some wonderfully talented people taking Open Source concepts to the forefront of industry standards.  Joomla! 1.5 is a major leap forward and represents the most exciting Joomla! release in the history of the project. </p>', '', 1, 1, 0, 1, '2007-07-07 09:54:06', 62, '', '2007-07-07 09:54:06', 62, 0, '0000-00-00 00:00:00', '2004-07-06 22:00:00', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 10, 0, 4, '', '', 0, 54, 'robots=\nauthor='),
(9, 'Millions of Smiles', 'millions-of-smiles', '', '<p>The Joomla! team has millions of good reasons to be smiling about the Joomla! 1.5. In its current incarnation, it''s had millions of downloads, taking it to an unprecedented level of popularity.  The new code base is almost an entire re-factor of the old code base.  The user experience is still extremely slick but for developers the API is a dream.  A proper framework for real PHP architects seeking the best of the best.</p><p>If you''re a former Mambo User or a 1.0 series Joomla! User, 1.5 is the future of CMSs for a number of reasons.  It''s more powerful, more flexible, more secure, and intuitive.  Our developers and interface designers have worked countless hours to make this the most exciting release in the content management system sphere.</p><p>Go on ... get your FREE copy of Joomla! today and spread the word about this benchmark project. </p>', '', 1, 1, 0, 1, '2007-07-07 09:54:06', 62, '', '2007-07-07 09:54:06', 62, 0, '0000-00-00 00:00:00', '2004-07-06 22:00:00', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 5, 0, 5, '', '', 0, 23, 'robots=\nauthor='),
(10, 'How do I localise Joomla! to my language?', 'how-do-i-localise-joomla-to-my-language', '', '<h4>General<br /></h4><p>In Joomla! 1.5 all User interfaces can be localised. This includes the installation, the Back-end Control Panel and the Front-end Site.</p><p>The core release of Joomla! 1.5 is shipped with multiple language choices in the installation but, other than English (the default), languages for the Site and Administration interfaces need to be added after installation. Links to such language packs exist below.</p>', '<p>Translation Teams for Joomla! 1.5 may have also released fully localised installation packages where site, administrator and sample data are in the local language. These localised releases can be found in the specific team projects on the <a href="http://extensions.joomla.org/component/option,com_mtree/task,listcats/cat_id,1837/Itemid,35/" target="_blank" title="JED">Joomla! Extensions Directory</a>.</p><h4>How do I install language packs?</h4><ul><li>First download both the admin and the site language packs that you require.</li><li>Install each pack separately using the Extensions-&gt;Install/Uninstall Menu selection and then the package file upload facility.</li><li>Go to the Language Manager and be sure to select Site or Admin in the sub-menu. Then select the appropriate language and make it the default one using the Toolbar button.</li></ul><h4>How do I select languages?</h4><ul><li>Default languages can be independently set for Site and for Administrator</li><li>In addition, users can define their preferred language for each Site and Administrator. This takes affect after logging in.</li><li>While logging in to the Administrator Back-end, a language can also be selected for the particular session.</li></ul><h4>Where can I find Language Packs and Localised Releases?</h4><p><em>Please note that Joomla! 1.5 is new and language packs for this version may have not been released at this time.</em> </p><ul><li><a href="http://joomlacode.org/gf/project/jtranslation/" target="_blank" title="Accredited Translations">The Joomla! Accredited Translations Project</a>  - This is a joint repository for language packs that were developed by teams that are members of the Joomla! Translations Working Group.</li><li><a href="http://extensions.joomla.org/component/option,com_mtree/task,listcats/cat_id,1837/Itemid,35/" target="_blank" title="Translations">The Joomla! Extensions Site - Translations</a>  </li><li><a href="http://community.joomla.org/translations.html" target="_blank" title="Translation Work Group Teams">List of Translation Teams and Translation Partner Sites for Joomla! 1.5</a> </li></ul>', 1, 3, 0, 32, '2008-07-30 14:06:37', 62, '', '2008-07-30 14:06:37', 62, 0, '0000-00-00 00:00:00', '2006-09-29 10:00:00', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 9, 0, 5, '', '', 0, 10, 'robots=\nauthor='),
(11, 'How do I upgrade to Joomla! 1.5 ?', 'how-do-i-upgrade-to-joomla-15', '', '<p>Joomla! 1.5 does not provide an upgrade path from earlier versions. Converting an older site to a Joomla! 1.5 site requires creation of a new empty site using Joomla! 1.5 and then populating the new site with the content from the old site. This migration of content is not a one-to-one process and involves conversions and modifications to the content dump.</p> <p>There are two ways to perform the migration:</p>', ' <div id="post_content-107"><li>An automated method of migration has been provided which uses a migrator Component to create the migration dump out of the old site (Mambo 4.5.x up to Joomla! 1.0.x) and a smart import facility in the Joomla! 1.5 Installation that performs required conversions and modifications during the installation process.</li> <li>Migration can be performed manually. This involves exporting the required tables, manually performing required conversions and modifications and then importing the content to the new site after it is installed.</li>  <p><!--more--></p> <h2><strong> Automated migration</strong></h2>  <p>This is a two phased process using two tools. The first tool is a migration Component named <font face="courier new,courier">com_migrator</font>. This Component has been contributed by Harald Baer and is based on his <strong>eBackup </strong>Component. The migrator needs to be installed on the old site and when activated it prepares the required export dump of the old site''s data. The second tool is built into the Joomla! 1.5 installation process. The exported content dump is loaded to the new site and all conversions and modification are performed on-the-fly.</p> <h3><u> Step 1 - Using com_migrator to export data from old site:</u></h3> <li>Install the <font face="courier new,courier">com_migrator</font> Component on the <u><strong>old</strong></u> site. It can be found at the <a href="http://joomlacode.org/gf/project/pasamioprojects/frs/" target="_blank" title="JoomlaCode">JoomlaCode developers forge</a>.</li> <li>Select the Component in the Component Menu of the Control Panel.</li> <li>Click on the <strong>Dump it</strong> icon. Three exported <em>gzipped </em>export scripts will be created. The first is a complete backup of the old site. The second is the migration content of all core elements which will be imported to the new site. The third is a backup of all 3PD Component tables.</li> <li>Click on the download icon of the particular exports files needed and store locally.</li> <li>Multiple export sets can be created.</li> <li>The exported data is not modified in anyway and the original encoding is preserved. This makes the <font face="courier new,courier">com_migrator</font> tool a recommended tool to use for manual migration as well.</li> <h3><u> Step 2 - Using the migration facility to import and convert data during Joomla! 1.5 installation:</u></h3><p>Note: This function requires the use of the <em><font face="courier new,courier">iconv </font></em>function in PHP to convert encodings. If <em><font face="courier new,courier">iconv </font></em>is not found a warning will be provided.</p> <li>In step 6 - Configuration select the ''Load Migration Script'' option in the ''Load Sample Data, Restore or Migrate Backed Up Content'' section of the page.</li> <li>Enter the table prefix used in the content dump. For example: ''#__'' or ''site2_'' are acceptable values.</li> <li>Select the encoding of the dumped content in the dropdown list. This should be the encoding used on the pages of the old site. (As defined in the _ISO variable in the language file or as seen in the browser page info/encoding/source)</li> <li>Browse the local host and select the migration export and click on <strong>Upload and Execute</strong></li> <li>A success message should appear or alternately a listing of database errors</li> <li>Complete the other required fields in the Configuration step such as Site Name and Admin details and advance to the final step of installation. (Admin details will be ignored as the imported data will take priority. Please remember admin name and password from the old site)</li> <p><u><br /></u></p></div>', 1, 3, 0, 28, '2008-07-30 20:27:52', 62, '', '2008-07-30 20:27:52', 62, 0, '0000-00-00 00:00:00', '2006-09-29 12:00:00', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 10, 0, 3, '', '', 0, 14, 'robots=\nauthor='),
(12, 'Why does Joomla! 1.5 use UTF-8 encoding?', 'why-does-joomla-15-use-utf-8-encoding', '', '<p>Well... how about never needing to mess with encoding settings again?</p><p>Ever needed to display several languages on one page or site and something always came up in Giberish?</p><p>With utf-8 (a variant of Unicode) glyphs (character forms) of basically all languages can be displayed with one single encoding setting. </p>', '', 1, 3, 0, 31, '2008-08-05 01:11:29', 62, '', '2008-08-05 01:11:29', 62, 0, '0000-00-00 00:00:00', '2006-10-03 10:00:00', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 8, 0, 8, '', '', 0, 29, 'robots=\nauthor='),
(13, 'What happened to the locale setting?', 'what-happened-to-the-locale-setting', '', 'This is now defined in the Language [<em>lang</em>].xml file in the Language metadata settings. If you are having locale problems such as dates do not appear in your language for example, you might want to check/edit the entries in the locale tag. Note that multiple locale strings can be set and the host will usually accept the first one recognised.', '', 1, 3, 0, 28, '2008-08-06 16:47:35', 62, '', '2008-08-06 16:47:35', 62, 0, '0000-00-00 00:00:00', '2006-10-05 14:00:00', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 7, 0, 2, '', '', 0, 11, 'robots=\nauthor='),
(14, 'What is the FTP layer for?', 'what-is-the-ftp-layer-for', '', '<p>The FTP Layer allows file operations (such as installing Extensions or updating the main configuration file) without having to make all the folders and files writable. This has been an issue on Linux and other Unix based platforms in respect of file permissions. This makes the site admin''s life a lot easier and increases security of the site.</p><p>You can check the write status of relevent folders by going to ''''Help-&gt;System Info" and then in the sub-menu to "Directory Permissions". With the FTP Layer enabled even if all directories are red, Joomla! will operate smoothly.</p><p>NOTE: the FTP layer is not required on a Windows host/server. </p>', '', 1, 3, 0, 31, '2008-08-06 21:27:49', 62, '', '2008-08-06 21:27:49', 62, 0, '0000-00-00 00:00:00', '2006-10-05 16:00:00', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=', 6, 0, 6, '', '', 0, 24, 'robots=\nauthor='),
(15, 'Can Joomla! 1.5 operate with PHP Safe Mode On?', 'can-joomla-15-operate-with-php-safe-mode-on', '', '<p>Yes it can! This is a significant security improvement.</p><p>The <em>safe mode</em> limits PHP to be able to perform actions only on files/folders who''s owner is the same as PHP is currently using (this is usually ''apache''). As files normally are created either by the Joomla! application or by FTP access, the combination of PHP file actions and the FTP Layer allows Joomla! to operate in PHP Safe Mode.</p>', '', 1, 3, 0, 31, '2008-08-06 19:28:35', 62, '', '2008-08-06 19:28:35', 62, 0, '0000-00-00 00:00:00', '2006-10-05 14:00:00', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 7, 0, 4, '', '', 0, 8, 'robots=\nauthor='),
(16, 'Only one edit window! How do I create "Read more..."?', 'only-one-edit-window-how-do-i-create-read-more', '', '<p>This is now implemented by inserting a <strong>Read more...</strong> tag (the button is located below the editor area) a dotted line appears in the edited text showing the split location for the <em>Read more....</em> A new Plugin takes care of the rest.</p><p>It is worth mentioning that this does not have a negative effect on migrated data from older sites. The new implementation is fully backward compatible.</p>', '', 1, 3, 0, 28, '2008-08-06 19:29:28', 62, '', '2008-08-06 19:29:28', 62, 0, '0000-00-00 00:00:00', '2006-10-05 14:00:00', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 7, 0, 4, '', '', 0, 20, 'robots=\nauthor='),
(17, 'My MySQL database does not support UTF-8. Do I have a problem?', 'my-mysql-database-does-not-support-utf-8-do-i-have-a-problem', '', 'No you don''t. Versions of MySQL lower than 4.1 do not have built in UTF-8 support. However, Joomla! 1.5 has made provisions for backward compatibility and is able to use UTF-8 on older databases. Let the installer take care of all the settings and there is no need to make any changes to the database (charset, collation, or any other).', '', 1, 3, 0, 31, '2008-08-07 09:30:37', 62, '', '2008-08-07 09:30:37', 62, 0, '0000-00-00 00:00:00', '2006-10-05 20:00:00', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 10, 0, 7, '', '', 0, 9, 'robots=\nauthor='),
(18, 'Joomla! Features', 'joomla-features', '', '<h4><font color="#ff6600">Joomla! features:</font></h4> <ul><li>Completely database driven site engines </li><li>News, products, or services sections fully editable and manageable</li><li>Topics sections can be added to by contributing Authors </li><li>Fully customisable layouts including <em>left</em>, <em>center</em>, and <em>right </em>Menu boxes </li><li>Browser upload of images to your own library for use anywhere in the site </li><li>Dynamic Forum/Poll/Voting booth for on-the-spot results </li><li>Runs on Linux, FreeBSD, MacOSX server, Solaris, and AIX', '  </li></ul> <h4>Extensive Administration:</h4> <ul><li>Change order of objects including news, FAQs, Articles etc. </li><li>Random Newsflash generator </li><li>Remote Author submission Module for News, Articles, FAQs, and Links </li><li>Object hierarchy - as many Sections, departments, divisions, and pages as you want </li><li>Image library - store all your PNGs, PDFs, DOCs, XLSs, GIFs, and JPEGs online for easy use </li><li>Automatic Path-Finder. Place a picture and let Joomla! fix the link </li><li>News Feed Manager. Easily integrate news feeds into your Web site.</li><li>E-mail a friend and Print format available for every story and Article </li><li>In-line Text editor similar to any basic word processor software </li><li>User editable look and feel </li><li>Polls/Surveys - Now put a different one on each page </li><li>Custom Page Modules. Download custom page Modules to spice up your site </li><li>Template Manager. Download Templates and implement them in seconds </li><li>Layout preview. See how it looks before going live </li><li>Banner Manager. Make money out of your site.</li></ul>', 1, 4, 0, 29, '2008-08-08 23:32:45', 62, '', '2008-08-08 23:32:45', 62, 0, '0000-00-00 00:00:00', '2006-10-07 06:00:00', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 11, 0, 4, '', '', 0, 59, 'robots=\nauthor='),
(19, 'Joomla! Overview', 'joomla-overview', '', '<p>If you''re new to Web publishing systems, you''ll find that Joomla! delivers sophisticated solutions to your online needs. It can deliver a robust enterprise-level Web site, empowered by endless extensibility for your bespoke publishing needs. Moreover, it is often the system of choice for small business or home users who want a professional looking site that''s simple to deploy and use. <em>We do content right</em>.<br /> </p><p>So what''s the catch? How much does this system cost?</p><p> Well, there''s good news ... and more good news! Joomla! 1.5 is free, it is released under an Open Source license - the GNU/General Public License v 2.0. Had you invested in a mainstream, commercial alternative, there''d be nothing but moths left in your wallet and to add new functionality would probably mean taking out a second mortgage each time you wanted something adding!</p><p>Joomla! changes all that ... <br />Joomla! is different from the normal models for content management software. For a start, it''s not complicated. Joomla! has been developed for everybody, and anybody can develop it further. It is designed to work (primarily) with other Open Source, free, software such as PHP, MySQL, and Apache. </p><p>It is easy to install and administer, and is reliable. </p><p>Joomla! doesn''t even require the user or administrator of the system to know HTML to operate it once it''s up and running.</p><p>To get the perfect Web site with all the functionality that you require for your particular application may take additional time and effort, but with the Joomla! Community support that is available and the many Third Party Developers actively creating and releasing new Extensions for the 1.5 platform on an almost daily basis, there is likely to be something out there to meet your needs. Or you could develop your own Extensions and make these available to the rest of the community. </p>', '', 1, 4, 0, 29, '2008-08-09 07:49:20', 62, '', '2008-08-09 07:49:20', 62, 0, '0000-00-00 00:00:00', '2006-10-07 10:00:00', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 13, 0, 2, '', '', 0, 194, 'robots=\nauthor='),
(20, 'Support and Documentation', 'support-and-documentation', '', '<h1>Support </h1><p>Support for the Joomla! CMS can be found on several places. The best place to start would be the <a href="http://docs.joomla.org/" target="_blank" title="Joomla! Official Documentation Wiki">Joomla! Official Documentation Wiki</a>. Here you can help yourself to the information that is regularly published and updated as Joomla! develops. There is much more to come too!</p> <p>Of course you should not forget the Help System of the CMS itself. On the <em>topmenu </em>in the Back-end Control panel you find the Help button which will provide you with lots of explanation on features.</p> <p>Another great place would of course be the <a href="http://forum.joomla.org/" target="_blank" title="Forum">Forum</a> . On the Joomla! Forum you can find help and support from Community members as well as from Joomla! Core members and Working Group members. The forum contains a lot of information, FAQ''s, just about anything you are looking for in terms of support.</p> <p>Two other resources for Support are the <a href="http://developer.joomla.org/" target="_blank" title="Joomla! Developer Site">Joomla! Developer Site</a> and the <a href="http://extensions.joomla.org/" target="_blank" title="Joomla! Extensions Directory">Joomla! Extensions Directory</a> (JED). The Joomla! Developer Site provides lots of technical information for the experienced Developer as well as those new to Joomla! and development work in general. The JED whilst not a support site in the strictest sense has many of the Extensions that you will need as you develop your own Web site.</p> <p>The Joomla! Developers and Bug Squad members are regularly posting their blog reports about several topics such as programming techniques and security issues.</p> <h1>Documentation</h1> <p>Joomla! Documentation can of course be found on the <a href="http://docs.joomla.org/" target="_blank" title="Joomla! Official Documentation Wiki">Joomla! Official Documentation Wiki</a>. You can find information for beginners, installation, upgrade, Frequently Asked Questions, developer topics, and a lot more. The Documentation Team helps oversee the wiki but you are invited to contribute content, as well.</p> <p>There are also books written about Joomla! You can find a listing of these books in the <a href="http://shop.joomla.org/" target="_blank" title="Joomla! Shop">Joomla! Shop</a>.</p>', '', 1, 4, 0, 25, '2008-08-09 08:33:57', 62, '', '2008-08-09 08:33:57', 62, 0, '0000-00-00 00:00:00', '2006-10-07 10:00:00', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 13, 0, 1, '', '', 0, 6, 'robots=\nauthor='),
(21, 'Joomla! Facts', 'joomla-facts', '', '<p>Here are some interesting facts about Joomla!</p><ul><li><span>Over 210,000 active registered Users on the <a href="http://forum.joomla.org" target="_blank" title="Joomla Forums">Official Joomla! community forum</a> and more on the many international community sites.</span><ul><li><span>over 1,000,000 posts in over 200,000 topics</span></li><li>over 1,200 posts per day</li><li>growing at 150 new participants each day!</li></ul></li><li><span>1168 Projects on the JoomlaCode (<a href="http://joomlacode.org/" target="_blank" title="JoomlaCode">joomlacode.org</a> ). All for open source addons by third party developers.</span><ul><li><span>Well over 6,000,000 downloads of Joomla! since the migration to JoomlaCode in March 2007.<br /></span></li></ul></li><li><span>Nearly 4,000 extensions for Joomla! have been registered on the <a href="http://extensions.joomla.org" target="_blank" title="http://extensions.joomla.org">Joomla! Extension Directory</a>  </span></li><li><span>Joomla.org exceeds 2 TB of traffic per month!</span></li></ul>', '', 1, 4, 0, 30, '2008-08-09 16:46:37', 62, '', '2008-08-09 16:46:37', 62, 0, '0000-00-00 00:00:00', '2006-10-07 14:00:00', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 13, 0, 1, '', '', 0, 50, 'robots=\nauthor='),
(22, 'What''s New in 1.5?', 'whats-new-in-15', '', '<p>As with previous releases, Joomla! provides a unified and easy-to-use framework for delivering content for Web sites of all kinds. To support the changing nature of the Internet and emerging Web technologies, Joomla! required substantial restructuring of its core functionality and we also used this effort to simplify many challenges within the current user interface. Joomla! 1.5 has many new features.</p>', '<p style="margin-bottom: 0in">In Joomla! 1.5, you''ll notice: </p>    <ul><li>     <p style="margin-bottom: 0in">       Substantially improved usability, manageability, and scalability far beyond the original Mambo foundations</p>   </li><li>     <p style="margin-bottom: 0in"> Expanded accessibility to support internationalisation, double-byte characters and right-to-left support for Arabic, Farsi, and Hebrew languages among others</p>   </li><li>     <p style="margin-bottom: 0in"> Extended integration of external applications through Web services and remote authentication such as the Lightweight Directory Access Protocol (LDAP)</p>   </li><li>     <p style="margin-bottom: 0in"> Enhanced content delivery, template and presentation capabilities to support accessibility standards and content delivery to any destination</p>   </li><li>     <p style="margin-bottom: 0in">       A more sustainable and flexible framework for Component and Extension developers</p>   </li><li>     <p style="margin-bottom: 0in">Backward compatibility with previous releases of Components, Templates, Modules, and other Extensions</p></li></ul>', 1, 4, 0, 29, '2008-08-11 22:13:58', 62, '', '2008-08-11 22:13:58', 62, 0, '0000-00-00 00:00:00', '2006-10-10 18:00:00', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 10, 0, 1, '', '', 0, 92, 'robots=\nauthor='),
(23, 'Platforms and Open Standards', 'platforms-and-open-standards', '', '<p class="MsoNormal">Joomla! runs on any platform including Windows, most flavours of Linux, several Unix versions, and the Apple OS/X platform.  Joomla! depends on PHP and the MySQL database to deliver dynamic content.  </p>            <p class="MsoNormal">The minimum requirements are:</p>      <ul><li>Apache 1.x, 2.x and higher</li><li>PHP 4.3 and higher</li><li>MySQL 3.23 and higher</li></ul>It will also run on alternative server platforms such as Windows IIS - provided they support PHP and MySQL - but these require additional configuration in order for the Joomla! core package to be successful installed and operated.', '', 1, 4, 0, 25, '2008-08-11 04:22:14', 62, '', '2008-08-11 04:22:14', 62, 0, '0000-00-00 00:00:00', '2006-10-10 08:00:00', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 7, 0, 3, '', '', 0, 11, 'robots=\nauthor='),
(24, 'Content Layouts', 'content-layouts', '', '<p>Joomla! provides plenty of flexibility when displaying your Web content. Whether you are using Joomla! for a blog site, news or a Web site for a company, you''ll find one or more content styles to showcase your information. You can also change the style of content dynamically depending on your preferences. Joomla! calls how a page is laid out a <strong>layout</strong>. Use the guide below to understand which layouts are available and how you might use them. </p> <h2>Content </h2> <p>Joomla! makes it extremely easy to add and display content. All content  is placed where your mainbody tag in your template is located. There are three main types of layouts available in Joomla! and all of them can be customised via parameters. The display and parameters are set in the Menu Item used to display the content your working on. You create these layouts by creating a Menu Item and choosing how you want the content to display.</p> <h3>Blog Layout<br /> </h3> <p>Blog layout will show a listing of all Articles of the selected blog type (Section or Category) in the mainbody position of your template. It will give you the standard title, and Intro of each Article in that particular Category and/or Section. You can customise this layout via the use of the Preferences and Parameters, (See Article Parameters) this is done from the Menu not the Section Manager!</p> <h3>Blog Archive Layout<br /> </h3> <p>A Blog Archive layout will give you a similar output of Articles as the normal Blog Display but will add, at the top, two drop down lists for month and year plus a search button to allow Users to search for all Archived Articles from a specific month and year.</p> <h3>List Layout<br /> </h3> <p>Table layout will simply give you a <em>tabular </em>list<em> </em>of all the titles in that particular Section or Category. No Intro text will be displayed just the titles. You can set how many titles will be displayed in this table by Parameters. The table layout will also provide a filter Section so that Users can reorder, filter, and set how many titles are listed on a single page (up to 50)</p> <h2>Wrapper</h2> <p>Wrappers allow you to place stand alone applications and Third Party Web sites inside your Joomla! site. The content within a Wrapper appears within the primary content area defined by the "mainbody" tag and allows you to display their content as a part of your own site. A Wrapper will place an IFRAME into the content Section of your Web site and wrap your standard template navigation around it so it appears in the same way an Article would.</p> <h2>Content Parameters</h2> <p>The parameters for each layout type can be found on the right hand side of the editor boxes in the Menu Item configuration screen. The parameters available depend largely on what kind of layout you are configuring.</p>', '', 1, 4, 0, 29, '2008-08-12 22:33:10', 62, '', '2008-08-12 22:33:10', 62, 0, '0000-00-00 00:00:00', '2006-10-11 06:00:00', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 11, 0, 5, '', '', 0, 70, 'robots=\nauthor='),
(25, 'What are the requirements to run Joomla! 1.5?', 'what-are-the-requirements-to-run-joomla-15', '', '<p>Joomla! runs on the PHP pre-processor. PHP comes in many flavours, for a lot of operating systems. Beside PHP you will need a Web server. Joomla! is optimized for the Apache Web server, but it can run on different Web servers like Microsoft IIS it just requires additional configuration of PHP and MySQL. Joomla! also depends on a database, for this currently you can only use MySQL. </p>Many people know from their own experience that it''s not easy to install an Apache Web server and it gets harder if you want to add MySQL, PHP and Perl. XAMPP, WAMP, and MAMP are easy to install distributions containing Apache, MySQL, PHP and Perl for the Windows, Mac OSX and Linux operating systems. These packages are for localhost installations on non-public servers only.<br />The minimum version requirements are:<br /><ul><li>Apache 1.x or 2.x</li><li>PHP 4.3 or up</li><li>MySQL 3.23 or up</li></ul>For the latest minimum requirements details, see <a href="http://www.joomla.org/about-joomla/technical-requirements.html" target="_blank" title="Joomla! Technical Requirements">Joomla! Technical Requirements</a>.', '', 1, 3, 0, 31, '2008-08-11 00:42:31', 62, '', '2008-08-11 00:42:31', 62, 0, '0000-00-00 00:00:00', '2006-10-10 06:00:00', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 6, 0, 5, '', '', 0, 25, 'robots=\nauthor='),
(26, 'Extensions', 'extensions', '', '<p>Out of the box, Joomla! does a great job of managing the content needed to make your Web site sing. But for many people, the true power of Joomla! lies in the application framework that makes it possible for developers all around the world to create powerful add-ons that are called <strong>Extensions</strong>. An Extension is used to add capabilities to Joomla! that do not exist in the base core code. Here are just some examples of the hundreds of available Extensions:</p> <ul>   <li>Dynamic form builders</li>   <li>Business or organisational directories</li>   <li>Document management</li>   <li>Image and multimedia galleries</li>   <li>E-commerce and shopping cart engines</li>   <li>Forums and chat software</li>   <li>Calendars</li>   <li>E-mail newsletters</li>   <li>Data collection and reporting tools</li>   <li>Banner advertising systems</li>   <li>Paid subscription services</li>   <li>and many, many, more</li> </ul> <p>You can find more examples over at our ever growing <a href="http://extensions.joomla.org" target="_blank" title="Joomla! Extensions Directory">Joomla! Extensions Directory</a>. Prepare to be amazed at the amount of exciting work produced by our active developer community!</p><p>A useful guide to the Extension site can be found at:<br /><a href="http://extensions.joomla.org/content/view/15/63/" target="_blank" title="Guide to the Joomla! Extension site">http://extensions.joomla.org/content/view/15/63/</a> </p> <h3>Types of Extensions </h3><p>There are five types of extensions:</p> <ul>   <li>Components</li>   <li>Modules</li>   <li>Templates</li>   <li>Plugins</li>   <li>Languages</li> </ul> <p>You can read more about the specifics of these using the links in the Article Index - a Table of Contents (yet another useful feature of Joomla!) - at the top right or by clicking on the <strong>Next </strong>link below.<br /> </p> <hr title="Components" class="system-pagebreak" /> <h3><img src="images/stories/ext_com.png" border="0" alt="Component - Joomla! Extension Directory" title="Component - Joomla! Extension Directory" width="17" height="17" /> Components</h3> <p>A Component is the largest and most complex of the Extension types.  Components are like mini-applications that render the main body of the  page. An analogy that might make the relationship easier to understand  would be that Joomla! is a book and all the Components are chapters in  the book. The core Article Component (<font face="courier new,courier">com_content</font>), for example, is the  mini-application that handles all core Article rendering just as the  core registration Component (<font face="courier new,courier">com_user</font>) is the mini-application  that handles User registration.</p> <p>Many of Joomla!''s core features are provided by the use of default Components such as:</p> <ul>   <li>Contacts</li>   <li>Front Page</li>   <li>News Feeds</li>   <li>Banners</li>   <li>Mass Mail</li>   <li>Polls</li></ul><p>A Component will manage data, set displays, provide functions, and in general can perform any operation that does not fall under the general functions of the core code.</p> <p>Components work hand in hand with Modules and Plugins to provide a rich variety of content display and functionality aside from the standard Article and content display. They make it possible to completely transform Joomla! and greatly expand its capabilities.</p>  <hr title="Modules" class="system-pagebreak" /> <h3><img src="images/stories/ext_mod.png" border="0" alt="Module - Joomla! Extension Directory" title="Module - Joomla! Extension Directory" width="17" height="17" /> Modules</h3> <p>A more lightweight and flexible Extension used for page rendering is a Module. Modules are used for small bits of the page that are generally  less complex and able to be seen across different Components. To  continue in our book analogy, a Module can be looked at as a footnote  or header block, or perhaps an image/caption block that can be rendered  on a particular page. Obviously you can have a footnote on any page but  not all pages will have them. Footnotes also might appear regardless of  which chapter you are reading. Simlarly Modules can be rendered  regardless of which Component you have loaded.</p> <p>Modules are like little mini-applets that can be placed anywhere on your site. They work in conjunction with Components in some cases and in others are complete stand alone snippets of code used to display some data from the database such as Articles (Newsflash) Modules are usually used to output data but they can also be interactive form items to input data for example the Login Module or Polls.</p> <p>Modules can be assigned to Module positions which are defined in your Template and in the back-end using the Module Manager and editing the Module Position settings. For example, "left" and "right" are common for a 3 column layout. </p> <h4>Displaying Modules</h4> <p>Each Module is assigned to a Module position on your site. If you wish it to display in two different locations you must copy the Module and assign the copy to display at the new location. You can also set which Menu Items (and thus pages) a Module will display on, you can select all Menu Items or you can pick and choose by holding down the control key and selecting multiple locations one by one in the Modules [Edit] screen</p> <p>Note: Your Main Menu is a Module! When you create a new Menu in the Menu Manager you are actually copying the Main Menu Module (<font face="courier new,courier">mod_mainmenu</font>) code and giving it the name of your new Menu. When you copy a Module you do not copy all of its parameters, you simply allow Joomla! to use the same code with two separate settings.</p> <h4>Newsflash Example</h4> <p>Newsflash is a Module which will display Articles from your site in an assignable Module position. It can be used and configured to display one Category, all Categories, or to randomly choose Articles to highlight to Users. It will display as much of an Article as you set, and will show a <em>Read more...</em> link to take the User to the full Article.</p> <p>The Newsflash Component is particularly useful for things like Site News or to show the latest Article added to your Web site.</p>  <hr title="Plugins" class="system-pagebreak" /> <h3><img src="images/stories/ext_plugin.png" border="0" alt="Plugin - Joomla! Extension Directory" title="Plugin - Joomla! Extension Directory" width="17" height="17" /> Plugins</h3> <p>One  of the more advanced Extensions for Joomla! is the Plugin. In previous  versions of Joomla! Plugins were known as Mambots. Aside from changing their name their  functionality has been expanded. A Plugin is a section of code that  runs when a pre-defined event happens within Joomla!. Editors are Plugins, for example, that execute when the Joomla! event <font face="courier new,courier">onGetEditorArea</font> occurs. Using a Plugin allows a developer to change  the way their code behaves depending upon which Plugins are installed  to react to an event.</p>  <hr title="Languages" class="system-pagebreak" /> <h3><img src="images/stories/ext_lang.png" border="0" alt="Language - Joomla! Extensions Directory" title="Language - Joomla! Extensions Directory" width="17" height="17" /> Languages</h3> <p>New  to Joomla! 1.5 and perhaps the most basic and critical Extension is a Language. Joomla! is released with multiple Installation Languages but the base Site and Administrator are packaged in just the one Language <strong>en-GB</strong> - being English with GB spelling for example. To include all the translations currently available would bloat the core package and make it unmanageable for uploading purposes. The Language files enable all the User interfaces both Front-end and Back-end to be presented in the local preferred language. Note these packs do not have any impact on the actual content such as Articles. </p> <p>More information on languages is available from the <br />   <a href="http://community.joomla.org/translations.html" target="_blank" title="Joomla! Translation Teams">http://community.joomla.org/translations.html</a></p>', '', 1, 4, 0, 29, '2008-08-11 06:00:00', 62, '', '2008-08-11 06:00:00', 62, 0, '0000-00-00 00:00:00', '2006-10-10 22:00:00', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 24, 0, 3, 'About Joomla!, General, Extensions', '', 0, 102, 'robots=\nauthor=');
INSERT INTO `#__content` (`id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`) VALUES
(27, 'The Joomla! Community', 'the-joomla-community', '', '<p><strong>Got a question? </strong>With more than 210,000 members, the Joomla! Discussion Forums at <a href="http://forum.joomla.org/" target="_blank" title="Forums">forum.joomla.org</a> are a great resource for both new and experienced users. Ask your toughest questions the community is waiting to see what you''ll do with your Joomla! site.</p><p><strong>Do you want to show off your new Joomla! Web site?</strong> Visit the <a href="http://forum.joomla.org/viewforum.php?f=514" target="_blank" title="Site Showcase">Site Showcase</a> section of our forum.</p><p><strong>Do you want to contribute?</strong></p><p>If you think working with Joomla is fun, wait until you start working on it. We''re passionate about helping Joomla users become contributors. There are many ways you can help Joomla''s development:</p><ul>	<li>Submit news about Joomla. We syndicate Joomla-related news on <a href="http://news.joomla.org" target="_blank" title="JoomlaConnect">JoomlaConnect<sup>TM</sup></a>. If you have Joomla news that you would like to share with the community, find out how to get connected <a href="http://community.joomla.org/connect.html" target="_blank" title="JoomlaConnect">here</a>.</li>	<li>Report bugs and request features in our <a href="http://joomlacode.org/gf/project/joomla/tracker/" target="_blank" title="Joomla! developement trackers">trackers</a>. Please read <a href="http://docs.joomla.org/Filing_bugs_and_issues" target="_blank" title="Reporting Bugs">Reporting Bugs</a>, for details on how we like our bug reports served up</li><li>Submit patches for new and/or fixed behaviour. Please read <a href="http://docs.joomla.org/Patch_submission_guidelines" target="_blank" title="Submitting Patches">Submitting Patches</a>, for details on how to submit a patch.</li><li>Join the <a href="http://forum.joomla.org/viewforum.php?f=509" target="_blank" title="Joomla! development forums">developer forums</a> and share your ideas for how to improve Joomla. We''re always open to suggestions, although we''re likely to be sceptical of large-scale suggestions without some code to back it up.</li><li>Join any of the <a href="http://www.joomla.org/about-joomla/the-project/working-groups.html" target="_blank" title="Joomla! working groups">Joomla Working Groups</a> and bring your personal expertise to the Joomla community. </li></ul><p>These are just a few ways you can contribute. See <a href="http://www.joomla.org/about-joomla/contribute-to-joomla.html" target="_blank" title="Contribute">Contribute to Joomla</a> for many more ways.</p>', '', 1, 4, 0, 30, '2008-08-12 16:50:48', 62, '', '2008-08-12 16:50:48', 62, 0, '0000-00-00 00:00:00', '2006-10-11 02:00:00', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 12, 0, 2, '', '', 0, 52, 'robots=\nauthor='),
(28, 'How do I install Joomla! 1.5?', 'how-do-i-install-joomla-15', '', '<p>Installing of Joomla! 1.5 is pretty easy. We assume you have set-up your Web site, and it is accessible with your browser.<br /><br />Download Joomla! 1.5, unzip it and upload/copy the files into the directory you Web site points to, fire up your browser and enter your Web site address and the installation will start.  </p><p>For full details on the installation processes check out the <a href="http://help.joomla.org/content/category/48/268/302" target="_blank" title="Joomla! 1.5 Installation Manual">Installation Manual</a> on the <a href="http://help.joomla.org" target="_blank" title="Joomla! Help Site">Joomla! Help Site</a> where you will also find download instructions for a PDF version too. </p>', '', 1, 3, 0, 31, '2008-08-11 01:10:59', 62, '', '2008-08-11 01:10:59', 62, 0, '0000-00-00 00:00:00', '2006-10-10 06:00:00', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 5, 0, 3, '', '', 0, 5, 'robots=\nauthor='),
(29, 'What is the purpose of the collation selection in the installation screen?', 'what-is-the-purpose-of-the-collation-selection-in-the-installation-screen', '', 'The collation option determines the way ordering in the database is done. In languages that use special characters, for instance the German umlaut, the database collation determines the sorting order. If you don''t know which collation you need, select the "utf8_general_ci" as most languages use this. The other collations listed are exceptions in regards to the general collation. If your language is not listed in the list of collations it most likely means that "utf8_general_ci is suitable.', '', 1, 3, 0, 32, '2008-08-11 03:11:38', 62, '', '2008-08-11 03:11:38', 62, 0, '0000-00-00 00:00:00', '2006-10-10 08:00:00', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=', 4, 0, 4, '', '', 0, 6, 'robots=\nauthor='),
(30, 'What languages are supported by Joomla! 1.5?', 'what-languages-are-supported-by-joomla-15', '', 'Within the Installer you will find a wide collection of languages. The installer currently supports the following languages: Arabic, Bulgarian, Bengali, Czech, Danish, German, Greek, English, Spanish, Finnish, French, Hebrew, Devanagari(India), Croatian(Croatia), Magyar (Hungary), Italian, Malay, Norwegian bokmal, Dutch, Portuguese(Brasil), Portugues(Portugal), Romanian, Russian, Serbian, Svenska, Thai and more are being added all the time.<br />By default the English language is installed for the Back and Front-ends. You can download additional language files from the <a href="http://extensions.joomla.org" target="_blank" title="Joomla! Extensions Directory">Joomla!Extensions Directory</a>. ', '', 1, 3, 0, 32, '2008-08-11 01:12:18', 62, '', '2008-08-11 01:12:18', 62, 0, '0000-00-00 00:00:00', '2006-10-10 06:00:00', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 5, 0, 2, '', '', 0, 8, 'robots=\nauthor='),
(31, 'Is it useful to install the sample data?', 'is-it-useful-to-install-the-sample-data', '', 'Well you are reading it right now! This depends on what you want to achieve. If you are new to Joomla! and have no clue how it all fits together, just install the sample data. If you don''t like the English sample data because you - for instance - speak Chinese, then leave it out.', '', 1, 3, 0, 27, '2008-08-11 09:12:55', 62, '', '2008-08-11 09:12:55', 62, 0, '0000-00-00 00:00:00', '2006-10-10 10:00:00', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 6, 0, 3, '', '', 0, 3, 'robots=\nauthor='),
(32, 'Where is the Static Content Item?', 'where-is-the-static-content', '', '<p>In Joomla! versions prior to 1.5 there were separate processes for creating a Static Content Item and normal Content Items. The processes have been combined now and whilst both content types are still around they are renamed as Articles for Content Items and Uncategorized Articles for Static Content Items. </p><p>If you want to create a static item, create a new Article in the same way as for standard content and rather than relating this to a particular Section and Category just select <span style="font-style: italic">Uncategorized</span> as the option in the Section and Category drop down lists.</p>', '', 1, 3, 0, 28, '2008-08-10 23:13:33', 62, '', '2008-08-10 23:13:33', 62, 0, '0000-00-00 00:00:00', '2006-10-10 04:00:00', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 6, 0, 6, '', '', 0, 5, 'robots=\nauthor='),
(33, 'What is an Uncategorised Article?', 'what-is-uncategorised-article', '', 'Most Articles will be assigned to a Section and Category. In many cases, you might not know where you want it to appear so put the Article in the <em>Uncategorized </em>Section/Category. The Articles marked as <em>Uncategorized </em>are handled as static content.', '', 1, 3, 0, 31, '2008-08-11 15:14:11', 62, '', '2008-08-11 15:14:11', 62, 0, '0000-00-00 00:00:00', '2006-10-10 12:00:00', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 8, 0, 2, '', '', 0, 6, 'robots=\nauthor='),
(34, 'Does the PDF icon render pictures and special characters?', 'does-the-pdf-icon-render-pictures-and-special-characters', '', 'Yes! Prior to Joomla! 1.5, only the text values of an Article and only for ISO-8859-1 encoding was allowed in the PDF rendition. With the new PDF library in place, the complete Article including images is rendered and applied to the PDF. The PDF generator also handles the UTF-8 texts and can handle any character sets from any language. The appropriate fonts must be installed but this is done automatically during a language pack installation.', '', 1, 3, 0, 32, '2008-08-11 17:14:57', 62, '', '2008-08-11 17:14:57', 62, 0, '0000-00-00 00:00:00', '2006-10-10 14:00:00', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 7, 0, 3, '', '', 0, 6, 'robots=\nauthor='),
(35, 'Is it possible to change A Menu Item''s Type?', 'is-it-possible-to-change-the-types-of-menu-entries', '', '<p>You indeed can change the Menu Item''s Type to whatever you want, even after they have been created. </p><p>If, for instance, you want to change the Blog Section of a Menu link, go to the Control Panel-&gt;Menus Menu-&gt;[menuname]-&gt;Menu Item Manager and edit the Menu Item. Select the <strong>Change Type</strong> button and choose the new style of Menu Item Type from the available list. Thereafter, alter the Details and Parameters to reconfigure the display for the new selection  as you require it.</p>', '', 1, 3, 0, 31, '2008-08-10 23:15:36', 62, '', '2008-08-10 23:15:36', 62, 0, '0000-00-00 00:00:00', '2006-10-10 04:00:00', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 6, 0, 1, '', '', 0, 18, 'robots=\nauthor='),
(36, 'Where did the Installers go?', 'where-did-the-installer-go', '', 'The improved Installer can be found under the Extensions Menu. With versions prior to Joomla! 1.5 you needed to select a specific Extension type when you wanted to install it and use the Installer associated with it, with Joomla! 1.5 you just select the Extension you want to upload, and click on install. The Installer will do all the hard work for you.', '', 1, 3, 0, 28, '2008-08-10 23:16:20', 62, '', '2008-08-10 23:16:20', 62, 0, '0000-00-00 00:00:00', '2006-10-10 04:00:00', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 6, 0, 1, '', '', 0, 4, 'robots=\nauthor='),
(37, 'Where did the Mambots go?', 'where-did-the-mambots-go', '', '<p>Mambots have been renamed as Plugins. </p><p>Mambots were introduced in Mambo and offered possibilities to add plug-in logic to your site mainly for the purpose of manipulating content. In Joomla! 1.5, Plugins will now have much broader capabilities than Mambots. Plugins are able to extend functionality at the framework layer as well.</p>', '', 1, 3, 0, 28, '2008-08-11 09:17:00', 62, '', '2008-08-11 09:17:00', 62, 0, '0000-00-00 00:00:00', '2006-10-10 10:00:00', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 6, 0, 5, '', '', 0, 5, 'robots=\nauthor='),
(38, 'I installed with my own language, but the Back-end is still in English', 'i-installed-with-my-own-language-but-the-back-end-is-still-in-english', '', '<p>A lot of different languages are available for the Back-end, but by default this language may not be installed. If you want a translated Back-end, get your language pack and install it using the Extension Installer. After this, go to the Extensions Menu, select Language Manager and make your language the default one. Your Back-end will be translated immediately.</p><p>Users who have access rights to the Back-end may choose the language they prefer in their Personal Details parameters. This is of also true for the Front-end language.</p><p> A good place to find where to download your languages and localised versions of Joomla! is <a href="http://extensions.joomla.org/index.php?option=com_mtree&task=listcats&cat_id=1837&Itemid=35" target="_blank" title="Translations for Joomla!">Translations for Joomla!</a> on JED.</p>', '', 0, 3, 0, 32, '2008-08-11 17:18:14', 62, '', '2008-08-11 17:18:14', 62, 0, '0000-00-00 00:00:00', '2006-10-10 14:00:00', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 7, 0, 1, '', '', 0, 7, 'robots=\nauthor='),
(39, 'How do I remove an Article?', 'how-do-i-remove-an-article', '', '<p>To completely remove an Article, select the Articles that you want to delete and move them to the Trash. Next, open the Article Trash in the Content Menu and select the Articles you want to delete. After deleting an Article, it is no longer available as it has been deleted from the database and it is not possible to undo this operation.  </p>', '', 1, 3, 0, 27, '2008-08-11 09:19:01', 62, '', '2008-08-11 09:19:01', 62, 0, '0000-00-00 00:00:00', '2006-10-10 10:00:00', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 6, 0, 2, '', '', 0, 4, 'robots=\nauthor='),
(40, 'What is the difference between Archiving and Trashing an Article? ', 'what-is-the-difference-between-archiving-and-trashing-an-article', '', '<p>When you <em>Archive </em>an Article, the content is put into a state which removes it from your site as published content. The Article is still available from within the Control Panel and can be <em>retrieved </em>for editing or republishing purposes. Trashed Articles are just one step from being permanently deleted but are still available until you Remove them from the Trash Manager. You should use Archive if you consider an Article important, but not current. Trash should be used when you want to delete the content entirely from your site and from future search results.  </p>', '', 1, 3, 0, 27, '2008-08-11 05:19:43', 62, '', '2008-08-11 05:19:43', 62, 0, '0000-00-00 00:00:00', '2006-10-10 06:00:00', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 8, 0, 1, '', '', 0, 5, 'robots=\nauthor='),
(41, 'Newsflash 5', 'newsflash-5', '', 'Joomla! 1.5 - ''Experience the Freedom''!. It has never been easier to create your own dynamic Web site. Manage all your content from the best CMS admin interface and in virtually any language you speak.', '', 1, 1, 0, 3, '2008-08-12 00:17:31', 62, '', '2008-08-12 00:17:31', 62, 0, '0000-00-00 00:00:00', '2006-10-11 06:00:00', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 5, 0, 2, '', '', 0, 4, 'robots=\nauthor='),
(42, 'Newsflash 4', 'newsflash-4', '', 'Yesterday all servers in the U.S. went out on strike in a bid to get more RAM and better CPUs. A spokes person said that the need for better RAM was due to some fool increasing the front-side bus speed. In future, buses will be told to slow down in residential motherboards.', '', 1, 1, 0, 3, '2008-08-12 00:25:50', 62, '', '2008-08-12 00:25:50', 62, 0, '0000-00-00 00:00:00', '2006-10-11 06:00:00', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 5, 0, 1, '', '', 0, 5, 'robots=\nauthor='),
(43, 'Example Pages and Menu Links', 'example-pages-and-menu-links', '', '<p>This page is an example of content that is <em>Uncategorized</em>; that is, it does not belong to any Section or Category. You will see there is a new Menu in the left column. It shows links to the same content presented in 4 different page layouts.</p><ul><li>Section Blog</li><li>Section Table</li><li> Blog Category</li><li>Category Table</li></ul><p>Follow the links in the <strong>Example Pages</strong> Menu to see some of the options available to you to present all the different types of content included within the default installation of Joomla!.</p><p>This includes Components and individual Articles. These links or Menu Item Types (to give them their proper name) are all controlled from within the <strong><font face="courier new,courier">Menu Manager-&gt;[menuname]-&gt;Menu Items Manager</font></strong>. </p>', '', 1, 0, 0, 0, '2008-08-12 09:26:52', 62, '', '2008-08-12 09:26:52', 62, 0, '0000-00-00 00:00:00', '2006-10-11 10:00:00', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 7, 0, 1, 'Uncategorized, Uncategorized, Example Pages and Menu Links', '', 0, 43, 'robots=\nauthor='),
(44, 'Joomla! Security Strike Team', 'joomla-security-strike-team', '', '<p>The Joomla! Project has assembled a top-notch team of experts to form the new Joomla! Security Strike Team. This new team will solely focus on investigating and resolving security issues. Instead of working in relative secrecy, the JSST will have a strong public-facing presence at the <a href="http://developer.joomla.org/security.html" target="_blank" title="Joomla! Security Center">Joomla! Security Center</a>.</p>', '<p>The new JSST will call the new <a href="http://developer.joomla.org/security.html" target="_blank" title="Joomla! Security Center">Joomla! Security Center</a> their home base. The Security Center provides a public presence for <a href="http://developer.joomla.org/security/news.html" target="_blank" title="Joomla! Security News">security issues</a> and a platform for the JSST to <a href="http://developer.joomla.org/security/articles-tutorials.html" target="_blank" title="Joomla! Security Articles">help the general public better understand security</a> and how it relates to Joomla!. The Security Center also offers users a clearer understanding of how security issues are handled. There''s also a <a href="http://feeds.joomla.org/JoomlaSecurityNews" target="_blank" title="Joomla! Security News Feed">news feed</a>, which provides subscribers an up-to-the-minute notification of security issues as they arise.</p>', 1, 1, 0, 1, '2007-07-07 09:54:06', 62, '', '2007-07-07 09:54:06', 62, 0, '0000-00-00 00:00:00', '2004-07-06 22:00:00', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 1, 0, 3, '', '', 0, 0, 'robots=\nauthor='),
(45, 'Joomla! Community Portal', 'joomla-community-portal', '', '<p>The <a href="http://community.joomla.org/" target="_blank" title="Joomla! Community Portal">Joomla! Community Portal</a> is now online. There, you will find a constant source of information about the activities of contributors powering the Joomla! Project. Learn about <a href="http://community.joomla.org/events.html" target="_blank" title="Joomla! Events">Joomla! Events</a> worldwide, and see if there is a <a href="http://community.joomla.org/user-groups.html" target="_blank" title="Joomla! User Groups">Joomla! User Group</a> nearby.</p><p>The <a href="http://magazine.joomla.org/" target="_blank" title="Joomla! Community Magazine">Joomla! Community Magazine</a> promises an interesting overview of feature articles, community accomplishments, learning topics, and project updates each month. Also, check out <a href="http://community.joomla.org/connect.html" target="_blank" title="JoomlaConnect">JoomlaConnect&#0153;</a>. This aggregated RSS feed brings together Joomla! news from all over the world in your language. Get the latest and greatest by clicking <a href="http://community.joomla.org/connect.html" target="_blank" title="JoomlaConnect">here</a>.</p>', '', 1, 1, 0, 1, '2007-07-07 09:54:06', 62, '', '2007-07-07 09:54:06', 62, 0, '0000-00-00 00:00:00', '2004-07-06 22:00:00', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 2, 0, 2, '', '', 0, 5, 'robots=\nauthor='),
(46, 'Template Features', 'template-features', '', '<p><em class="bold2">Top Features</em></p>\r\n\r\n<p class="dropcap"><span class="dropcap">1</span><a href="index.php?option=com_content&amp;view=article&amp;id=63&amp;Itemid=55"><strong>Transparent Design with Color Chooser:</strong></a> A combination of a <strong>transparent</strong> design and the Gantry-based <strong>Color Chooser</strong> constitute the stylistic core of the template, allowing for absolute and versatile stylistic <strong>control</strong> and diversity.</p>\r\n\r\n<p class="dropcap"><span class="dropcap">2</span><a href="index.php?option=com_content&amp;view=article&amp;id=47&amp;Itemid=54"><strong>Gantry Framework:</strong></a> A powerful core <strong>framework</strong>, offering features such as per-menu item parameters, an <strong>iPhone</strong> version and so much more, which substantially <strong>extends</strong> the features and functions of the Joomla core.</p>\r\n\r\n<p class="dropcap"><span class="dropcap">3</span><a href="index.php?option=com_content&amp;view=article&amp;id=82&amp;Itemid=145"><strong>3rd Party <em>Compatibility</em> Styling:</strong></a> Compatibility styling constitutes <strong>basic</strong> CSS alterations to better integrate the extensions with the template, rather than full theme integration. Example extensions: K2, Tienda and <strong>JomSocial</strong>.</p>\r\n\r\n<div class="rt-demo-grid-4">\r\n	<p><em class="bold2">Core Template Features</em></p>\r\n	<ul class="bullet-check">\r\n		<li>Transparent Design</li>\r\n		<li>Color Chooser</li>\r\n		<li>12 Preset Styles</li>\r\n		<li>Fusion with MegaMenu</li>\r\n		<li>Splitmenu</li>\r\n		<li>Custom Typography</li>\r\n		<li>68 Module Positions</li>\r\n		<li>24 Module Variations - 72 Combo Possibilities</li>\r\n		<li>RocketTheme Extensions Styling</li>\r\n		<li>3rd Party Extensions <em>Compatibility</em> Styling</li>\r\n		<li>Javascript Input Styling <em>(Checkboxes etc...)</em></li>\r\n		<li>FF 3.6, Safari 4, Opera 10.x, IE7-IE8 Compatible</li>\r\n		<li>Limited IE6 Browser Compatibility</li>\r\n		<li>Template RTL Support</li>\r\n		<li>W3C XHTML 1.0 / CSS 3 Valid</li>\r\n	</ul>\r\n	[readon2 url="http://www.rockettheme.com/joomla-templates/zephyr"]More Template Information[/readon2]\r\n</div>\r\n<div class="rt-demo-grid-4">\r\n	<p><em class="bold2">Gantry Framework Features</em></p>\r\n	<ul class="bullet-check">\r\n		<li>960 Grid System - 6 Grids per Row</li>\r\n		<li>Image Smart Loading</li>\r\n		<li>Ajax Article Loading</li>\r\n		<li>IE6 Warning Message</li>\r\n		<li>Source Ordered Mainbody</li>\r\n		<li>38 Layout Combinations for Mainbody</li>\r\n		<li>Extensive Administrator Interface</li>\r\n		<li>Per-menu-item Configuration / Parameters</li>\r\n		<li>Per Browser based CSS / JS control</li>\r\n		<li>Built-in GZip and General Caching</li>\r\n		<li>iPhone Version - Mobile Theme</li>\r\n		<li>Google Web Fonts Support</li>		\r\n		<li>Grid RTL Support</li>\r\n		<li>Tableless Overrides</li>\r\n		<li>Optimized Code Base</li>\r\n	</ul>\r\n	[readon2 url="index.php?option=com_content&amp;view=article&amp;id=47&amp;Itemid=54"]More Gantry Information[/readon2]\r\n</div>\r\n\r\n<div class="rt-demo-grid-4"><div class="rt-block">\r\n<p><em class="bold2">RocketTheme Extensions</em></p>\r\n<p>This demo includes a series of RocketTheme Extensions, some of which have template specific styling.</p>\r\n[readon2 url="index.php?option=com_content&amp;view=article&amp;id=53&amp;Itemid=61"]Included Extensions[/readon2]\r\n</div></div>\r\n<div class="rt-demo-grid-4"><div class="rt-block">\r\n<p><em class="bold2">Tutorial Information</em></p>\r\n<p>This demo has a range of tutorials and guides to introduce you to the core features and basics of the template.</p>\r\n[readon2 url="index.php?option=com_content&amp;view=article&amp;id=54&amp;Itemid=62"]Available Guides[/readon2]\r\n</div></div>\r\n<div class="clear"></div>', '', 1, 5, 0, 34, '2010-07-18 23:32:56', 62, '', '2010-07-31 00:52:29', 63, 0, '0000-00-00 00:00:00', '2010-07-18 23:32:56', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 34, 0, 2, '', '', 0, 319, 'robots=\nauthor='),
(84, 'Mass Effect', 'mass-effect', '', '<img src="images/stories/demo/roknewspager/review5.jpg" class="floatleft rt-image" alt="Image" width="116" height="160"/>\r\n<p>Conceived as a trilogy, the sequel to Mass Effect...</p>\r\n\r\n', '\r\n<p>In erat. Pellentesque erat. Mauris vehicula vestibulum justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nulla pulvinar est. Integer urna. Pellentesque pulvinar dui a magna. Nulla facilisi. Proin imperdiet. Aliquam ornare, metus vitae gravida dignissim, nisi nisl ultricies felis, ac tristique enim pede eget elit. Integer non erat nec turpis sollicitudin malesuada. Vestibulum dapibus. Nulla facilisi. Nulla iaculis, leo sit amet mollis luctus, sapien eros consectetur dolor, eu faucibus elit nibh eu nibh. Maecenas lacus pede, lobortis non, rhoncus id, tristique a, mi. Cras auctor libero vitae sem vestibulum euismod. Nunc fermentum.</p>\r\n\r\n<p>Mauris lobortis. Aliquam lacinia purus. Pellentesque magna. Mauris euismod metus nec tortor. Phasellus elementum, quam a euismod imperdiet, ligula felis faucibus enim, eu malesuada nunc felis sed turpis. Morbi convallis luctus tortor. Integer bibendum lacinia velit. Suspendisse mi lorem, porttitor ut, interdum et, lobortis a, lectus. Phasellus vitae est at massa luctus iaculis. In tincidunt.</p>\r\n\r\n<p>Integer fermentum elit in tellus. Integer ligula ipsum, gravida aliquet, fringilla non, interdum eget, ipsum. Praesent id dolor non erat viverra volutpat. Fusce tellus libero, luctus adipiscing, tincidunt vel, egestas vitae, eros. Vestibulum mollis, est id rhoncus volutpat, dolor velit tincidunt neque, vitae pellentesque ante sem eu nisl. Donec facilisis, magna eget elementum pellentesque, augue arcu aliquet eros, eget convallis mauris ante quis magna. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Aenean et libero. Nam aliquam. Quisque vitae tortor id neque dignissim laoreet. Duis eu ante. Integer at sapien. Praesent sed nisl tempor est pulvinar tristique. Maecenas non lorem quis mi laoreet adipiscing. Sed ac arcu. Sed tincidunt libero eu dolor. Cras pharetra posuere eros. Donec ac eros id diam tempor faucibus. Fusce feugiat consequat nulla. Vestibulum tincidunt vulputate ipsum.</p>\r\n\r\n<p>Nullam eget neque. Nullam imperdiet venenatis ligula. Integer a leo. Nunc consectetur. Maecenas sem. Proin vulputate, massa vel volutpat laoreet, purus erat pretium ligula, eget varius arcu nibh sed libero. Fusce ante. Nullam interdum aliquet metus. Ut ultrices vestibulum tellus. Praesent quis erat. Nam id turpis sit amet neque cursus luctus. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Quisque id tortor. In vitae sapien. Nunc quis tellus.</p>', 1, 5, 0, 42, '2010-07-21 21:33:23', 63, '', '2010-07-29 00:25:16', 63, 0, '0000-00-00 00:00:00', '2010-07-21 21:33:23', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 5, 0, 17, '', '', 0, 2, 'robots=\nauthor='),
(85, 'Mafia II', 'mafia-ii', '', '<img src="images/stories/demo/roknewspager/review4.jpg" class="floatleft rt-image" alt="Image" width="116" height="160"/>\r\n<p>Mafia 2 immerses players in the mob underworld...</p>\r\n\r\n', '\r\n<p>In erat. Pellentesque erat. Mauris vehicula vestibulum justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nulla pulvinar est. Integer urna. Pellentesque pulvinar dui a magna. Nulla facilisi. Proin imperdiet. Aliquam ornare, metus vitae gravida dignissim, nisi nisl ultricies felis, ac tristique enim pede eget elit. Integer non erat nec turpis sollicitudin malesuada. Vestibulum dapibus. Nulla facilisi. Nulla iaculis, leo sit amet mollis luctus, sapien eros consectetur dolor, eu faucibus elit nibh eu nibh. Maecenas lacus pede, lobortis non, rhoncus id, tristique a, mi. Cras auctor libero vitae sem vestibulum euismod. Nunc fermentum.</p>\r\n\r\n<p>Mauris lobortis. Aliquam lacinia purus. Pellentesque magna. Mauris euismod metus nec tortor. Phasellus elementum, quam a euismod imperdiet, ligula felis faucibus enim, eu malesuada nunc felis sed turpis. Morbi convallis luctus tortor. Integer bibendum lacinia velit. Suspendisse mi lorem, porttitor ut, interdum et, lobortis a, lectus. Phasellus vitae est at massa luctus iaculis. In tincidunt.</p>\r\n\r\n<p>Integer fermentum elit in tellus. Integer ligula ipsum, gravida aliquet, fringilla non, interdum eget, ipsum. Praesent id dolor non erat viverra volutpat. Fusce tellus libero, luctus adipiscing, tincidunt vel, egestas vitae, eros. Vestibulum mollis, est id rhoncus volutpat, dolor velit tincidunt neque, vitae pellentesque ante sem eu nisl. Donec facilisis, magna eget elementum pellentesque, augue arcu aliquet eros, eget convallis mauris ante quis magna. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Aenean et libero. Nam aliquam. Quisque vitae tortor id neque dignissim laoreet. Duis eu ante. Integer at sapien. Praesent sed nisl tempor est pulvinar tristique. Maecenas non lorem quis mi laoreet adipiscing. Sed ac arcu. Sed tincidunt libero eu dolor. Cras pharetra posuere eros. Donec ac eros id diam tempor faucibus. Fusce feugiat consequat nulla. Vestibulum tincidunt vulputate ipsum.</p>\r\n\r\n<p>Nullam eget neque. Nullam imperdiet venenatis ligula. Integer a leo. Nunc consectetur. Maecenas sem. Proin vulputate, massa vel volutpat laoreet, purus erat pretium ligula, eget varius arcu nibh sed libero. Fusce ante. Nullam interdum aliquet metus. Ut ultrices vestibulum tellus. Praesent quis erat. Nam id turpis sit amet neque cursus luctus. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Quisque id tortor. In vitae sapien. Nunc quis tellus.</p>', 1, 5, 0, 42, '2010-07-21 21:33:43', 63, '', '2010-07-29 00:25:27', 63, 0, '0000-00-00 00:00:00', '2010-07-21 21:33:43', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 5, 0, 16, '', '', 0, 2, 'robots=\nauthor='),
(47, 'Gantry Framework', 'gantry-framework', '', '<p>\r\n	<strong>gan·try</strong> (gan′trē) <em>noun</em>\r\n</p>\r\n<ol>\r\n	<li><strong>(RocketTheme) A framework used for assembling, building and maintaining a RocketTheme template</strong></li>\r\n</ol>\r\n<br />\r\n[readon url="http://www.gantry-framework.org/documentation"]Extensive Gantry Documentation[/readon]\r\n<br />\r\n<div class="module-title"><h3 class="title">Key Features</h3></div>\r\n\r\n<p>Gantry has a plethora of features, below is just a brief list:</p>\r\n\r\n<ul class="bullet-check">\r\n	<li>960 Grid System</li>\r\n	<li>Stunning Administrator interface</li>\r\n	<li>XML driven and with overrides for unprecedented levels of customization</li>\r\n	<li>Per-menu-item level control over any configuration parameter</li>\r\n	<li>Preset any combination of configuration parameters, and save custom presets</li>\r\n	<li>65 base module positions.  Easily add more!</li>\r\n	<li>36 possible layout combinations for mainbody and sidebars</li>\r\n	<li>Up to 3 sidebars for a total of 4 column layouts</li>\r\n	<li>Many built-in features such as font-sizer, to-top smooth slider, IE6 warning message, etc.</li>\r\n	<li>Flexible grid layout system for unparalleled control over block sizes</li>\r\n	<li>iPhone Native Version, a mobile specific version / theme</li>\r\n	<li>Google Web Fonts, load custom fonts from Googles''s Font Directory</li>\r\n	<li>Smart Loading, only load the images that are in focus for optimized loading</li>\r\n</ul>\r\n\r\n<div class="clear"></div>\r\n\r\n<p><a class="readon" href="http://www.gantry-framework.org/documentation/joomla/basics/key-features" title="Gantry Framework Features" target="_blank"><span>More Features</span></a></p>\r\n<br />\r\n<div class="module-title"><h3 class="title">Installing / Updating Gantry</h3></div>\r\n\r\n<p>For Zephyr, you should install the Zephyr Template (Bundle) package, <em>rt_zephyr_j15-bundle.tar.gz</em>, which includes both the template and Gantry. Use the standalone package if Gantry is already installed. However, in the event of Gantry needing to be installed, see the instructions below:</p>\r\n\r\n<p><a class="readon" href="http://gantry-framework.org/documentation/joomla/basics/installation" title="Gantry Framework Features" target="_blank"><span>Installation Instructions</span></a></p>\r\n\r\n<br />\r\n<div class="module-title"><h3 class="title">Overview of the Administrator Interface</h3></div>\r\n\r\n<p>The Gantry administrator is a very extensive interface for controlling allow aspects of the Framework, and is split into several parts:</p>\r\n\r\n<div class="rt-demo-grid-4">\r\n<ul class="bullet-1">\r\n	<li><strong>Per-Menu Item Configuration</strong></li>\r\n	<li><strong>Presets</strong></li>\r\n	<li><strong>Settings</strong></li>\r\n</ul>\r\n</div>\r\n<div class="rt-demo-grid-3">\r\n<ul class="bullet-1">\r\n	<li><strong>Features</strong></li>\r\n	<li><strong>Layouts</strong></li>\r\n	<li><strong>Advanced</strong></li>\r\n</ul>\r\n</div>\r\n<div class="clear"></div>\r\n\r\n<div class="note"><div class="typo-icon">The best way to discover all the options available, as well as what they do, is to visit the administrator itself at <strong>Extensions &rarr; Template Manager &rarr; rt_zephyr_j15</strong></div></div>\r\n\r\n[readon url="http://www.gantry-framework.org/documentation/joomla/configure/diagnostic-status"]Gantry Administrator Documentation[/readon]', '', 1, 5, 0, 34, '2010-07-18 23:34:05', 62, '', '2010-07-26 19:50:46', 63, 0, '0000-00-00 00:00:00', '2010-07-18 23:34:05', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 10, 0, 4, '', '', 0, 87, 'robots=\nauthor='),
(48, 'Module Variations', 'module-variations', '', '<p>Module Variations allow you to individually style a module Enter any available suffixes at <strong>Extensions &rarr; Module Manager &rarr; <em>Module</em> &rarr; Module Class Suffix</strong></p>\r\n\r\n<p>There are 24 suffixes: <strong>title1-6</strong>, <strong>box1-12</strong>; <strong>flush</strong>, <strong>flushtop</strong>, <strong>flushbottom</strong>; plus <strong>standardcase</strong>, <strong>uppercasefa</strong> and <strong>lowercase</strong>.</p>\r\n\r\n<div class="notice"><div class="typo-icon"><strong>Note:</strong> You can compound multiple suffixes together such as &quot;<em>title2 standardcase flushbottom</em>&quot;.</div></div>\r\n\r\n<div class="rt-demo-grid-3a rt-demo-grid-alpha">\r\n	<ul class="bullet-1">\r\n		<li><strong>Title:</strong> 6 suffixes that vary the appearance of the module title.</li>\r\n		<li><strong>Standard/Upper/Lower Case:</strong> change the case style of the module title.</li>		\r\n	</ul>\r\n</div>\r\n<div class="rt-demo-grid-3a rt-demo-grid-omega">\r\n	<ul class="bullet-1">\r\n		<li><strong>Box:</strong> 12 variations to change the background of the module.</li>		\r\n		<li><strong>Flush/FlusTop/FlushBottom:</strong> removes the margin/padding around the module surround.</li>\r\n	</ul>\r\n</div>\r\n<div class="clear"></div>\r\n\r\n<div class="note"><div class="typo-icon"><strong>Note:</strong> There are <em class="bold2">72</em> possible stylistic module variations, combining the <strong>title</strong> and <strong>box</strong> suffixes such as <em class="bold2">box1 title1</em></div></div>', '', 1, 5, 0, 34, '2010-07-18 23:34:20', 62, '', '2010-07-27 00:14:42', 63, 0, '0000-00-00 00:00:00', '2010-07-18 23:34:20', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 7, 0, 5, '', '', 0, 254, 'robots=\nauthor='),
(49, 'Module Positions', 'module-positions', '', '<p>There are <em class="bold2">68</em> module positions. If no module is published to a position, it will not appear, collapsing the entire area.</p>\r\n\r\n<p><em class="bold2">Non-Standard Elements</em></p>\r\n\r\n<p>There are <strong>non-standard</strong> elements that are injected into the template grid structure when enabled via the <strong>template parameter</strong>, such as the <strong>logo</strong> into <strong>header-a</strong>. These features <strong>stack</strong> vertically with any modules published to that position.</p>\r\n\r\n<div class="note"><div class="typo-icon">You can change the positions of these elements at <strong>Extensions &rarr; Template Manager &rarr; rt_zephyr_j15</strong></div></div>\r\n\r\n<p><em class="bold2">Layout Control</em></p>\r\n\r\n<p>Control all modules positions with Gantry, in terms of widths within the module row, and left/right/middle placement for the mainbody/sidebar area.</p>\r\n\r\n<p><img src="images/stories/demo/general/position-1.jpg" alt="image" width="559" height="92" class="rt-image" /></p>\r\n<p><img src="images/stories/demo/general/position-2.jpg" alt="image" width="559" height="92" class="rt-image" /></p>\r\n\r\n[readon url="http://www.gantry-framework.org/documentation/joomla/configure/layouts"]Gantry Framework : Layouts Documentation[/readon]\r\n\r\n<p><em class="bold2">Preview</em></p>\r\n\r\n<div class="notice"><div class="typo-icon">View all module positions live by appending <strong>?tp=1</strong> or <strong>&amp;tp=1</strong> to the end of your URL such as <strong><a href="#">http://yoursite.com/index.php?tp=1</a></strong>.</div></div>\r\n\r\n<p>The below diagram is of the <a href="index.php?option=com_content&amp;view=article&amp;id=48&amp;Itemid=56">Module Variations</a> page.</p>\r\n\r\n<img src="images/stories/demo/general/position-3.jpg" alt="Module Positions" class="rt-image" width="650" height="2026"/>', '', 1, 5, 0, 34, '2010-07-18 23:34:32', 62, '', '2010-07-27 20:23:04', 63, 0, '0000-00-00 00:00:00', '2010-07-18 23:34:32', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 12, 0, 6, '', '', 0, 39, 'robots=\nauthor=');
INSERT INTO `#__content` (`id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`) VALUES
(51, 'HTML Typography', 'html-typography', '', '<div class="note"><div class="typo-icon">This page shows all the template typography in its HTML format. Visit the <a href="index.php?option=com_content&amp;view=article&amp;id=52&amp;Itemid=60">RokCandy Examples</a> page for typography in the RokCandy Format.</div></div>\r\n\r\n<div class="rt-demo-grid-4">\r\n	<div class="componentheading">This is a ComponentHeading</div>\r\n	<p>Praesent rutrum sapien ac felis. Phasellus elementum dolor quis turpis. Vestibulum nec mi vitae pede.</p>\r\n</div>\r\n\r\n<div class="rt-demo-grid-4">\r\n	<div class="contentheading">This is a Contentheading</div>\r\n	<p>Proin ac nunc eu nunc condimentum accumsan. Phasellus odio justo, euismod vitae, egestas a.</p>\r\n</div>\r\n<div class="clear"></div>\r\n\r\n<div class="rt-demo-grid-4">\r\n	<h1>This is a H1 Header</h1>\r\n	<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Proin sit amet odio quis sapien molestie ultrices.</p>\r\n</div>\r\n\r\n<div class="rt-demo-grid-4">\r\n	<h2>This is a H2 Header</h2>\r\n	<p>Proin ac nunc eu nunc condimentum accumsan. Phasellus odio justo, euismod vitae, egestas a, porttitor</p>\r\n</div>\r\n<div class="clear"></div>\r\n\r\n<div class="rt-demo-grid-4">\r\n	<h3>This is a H3 Header</h3>\r\n	<p>Mauris euismod. In ac massa vitae quam tincidunt dapibus. Ut at tortor nec mi mattis blandit.</p>\r\n</div>\r\n\r\n<div class="rt-demo-grid-4">\r\n	<h4>This is a H4 Header</h4>\r\n	<p>Vestibulum posuere, lacus aliquet pulvinar faucibus, tortor urna luctus diam, vitae ultrices ante.</p>\r\n</div>\r\n<div class="clear"></div>\r\n\r\n<h5>This is a H5 Header</h5>\r\n\r\n<p>Pellentesque vel enim urna, sit amet blandit ipsum. Maecenas quis sem sit amet nunc pretium mattis. Sed dapibus semper est, sed pretium erat sodales sed. Aenean hendrerit fringilla sem, et tincidunt libero ornare at. </p>\r\n\r\n<h3><a name="blockquotes" href="#blockquotes">Blockquote Example</a></h3>\r\n\r\n<blockquote><p><strong>This is a blockquote, you will want to use the following formatting: &lt;blockquote&gt;&lt;p&gt;....&lt;/p&gt;&lt;/blockquote&gt;</strong>. Praesent rutrum sapien ac felis. Phasellus elementum dolor quis turpis. Vestibulum nec mi vitae pede tincidunt nonummy.</p></blockquote>\r\n\r\n<h3><a name="dropcap" href="#dropcap">DropCap Styles</a></h3>\r\n\r\n<p class="dropcap"><span class="dropcap">P</span>Praesent rutrum sapien ac felis. Phasellus elementum dolor quis turpis. Vestibulum nec mi vitae pede tincidunt nonummy. Vestibulum facilisis mollis neque. Sed orci. Cum sociis natoque penatibus et magnis dis.</p>\r\n	\r\n<p>You will need to use the following formatting: <strong>&lt;p class=&quot;dropcap&quot;&gt;&lt;span class=&quot;<em class="normal">dropcap</em>&quot;&gt;<em class="normal">P</em>&lt;/span&gt;&lt;/p&gt;</strong></p>\r\n\r\n<p><strong>Number Examples</strong></p>\r\n<p class="dropcap">\r\n	<span class="dropcap">1</span>\r\n	You will need to use the following formatting: <strong>&lt;p class=&quot;dropcap&quot;&gt;&lt;span class=&quot;<em class="normal">dropcap</em>&quot;&gt;<em class="normal">1</em>&lt;/span&gt;&lt;/p&gt;</strong>.\r\n	<br /><em>Praesent rutrum sapien ac felis. Phasellus elementum dolor quis turpis. Vestibulum nec mi vitae pede tincidunt nonummy. Vestibulum facilisis mollis neque. Sed orci. Cum sociis natoque penatibus et magnis dis parturient.</em>\r\n</p>\r\n<p class="dropcap">\r\n	<span class="dropcap">2</span>\r\n	You will need to use the following formatting: <strong>&lt;p class=&quot;dropcap&quot;&gt;&lt;span class=&quot;<em class="normal">dropcap</em>&quot;&gt;<em class="normal">2</em>&lt;/span&gt;&lt;/p&gt;</strong>.\r\n	<br /><em>Praesent rutrum sapien ac felis. Phasellus elementum dolor quis turpis. Vestibulum nec mi vitae pede tincidunt nonummy. Vestibulum facilisis mollis neque. Sed orci. Cum sociis natoque penatibus et magnis dis parturient.</em>\r\n</p>\r\n<p class="dropcap">\r\n	<span class="dropcap">3</span>\r\n	You will need to use the following formatting: <strong>&lt;p class=&quot;dropcap&quot;&gt;&lt;span class=&quot;<em class="normal">dropcap</em>&quot;&gt;<em class="normal">3</em>&lt;/span&gt;&lt;/p&gt;</strong>.\r\n	<br /><em>Praesent rutrum sapien ac felis. Phasellus elementum dolor quis turpis. Vestibulum nec mi vitae pede tincidunt nonummy. Vestibulum facilisis mollis neque. Sed orci. Cum sociis natoque penatibus et magnis dis parturient.</em>\r\n</p>\r\n\r\n<h3><a name="icon-bullets" href="#icon-bullets">List Styles - Icon Bullets</a></h3>\r\n<p>Below is a list with <em class="normal">icons</em>.  To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">class name</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong></p>\r\n\r\n\r\n<div class="rt-demo-grid-4">\r\n<ul class="bullet-add">\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-1dd</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-1dd</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n</ul>\r\n<br />\r\n<ul class="bullet-arrow">\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-arrow</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-arrow</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n</ul>\r\n<br />\r\n<ul class="bullet-arrow2">\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-arrow2</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-arrow2</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n</ul>\r\n<br />\r\n<ul class="bullet-briefcase">\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-briefcase</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-briefcase</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n</ul>\r\n<br />\r\n<ul class="bullet-calendar">\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-calendar</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-calendar</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n</ul>\r\n<br />\r\n<ul class="bullet-check">\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-check</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-check</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n</ul>\r\n<br />\r\n<ul class="bullet-crank">\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-crank</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-crank</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n</ul>\r\n<br />\r\n<ul class="bullet-delete">\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-delete</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-delete</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n</ul>\r\n<br />\r\n<ul class="bullet-docs">\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-docs</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-docs</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n</ul>\r\n<br />\r\n<ul class="bullet-email">\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-email</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-email</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n</ul>\r\n<br />\r\n<ul class="bullet-home">\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-home</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-home</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n</ul>\r\n<br />\r\n<ul class="bullet-key">\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-key</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-key</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n</ul>\r\n<br />\r\n</div>\r\n\r\n<div class="rt-demo-grid-4">\r\n<ul class="bullet-lock">\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-lock</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-lock</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n</ul>\r\n<br />\r\n<ul class="bullet-minus">\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-minus</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-minus</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n</ul>\r\n<br />\r\n<ul class="bullet-monitor">\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-monitor</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-monitor</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n</ul>\r\n<br />\r\n<ul class="bullet-notes">\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-notes</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-notes</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n</ul>\r\n<br />\r\n<ul class="bullet-post">\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-post</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-post</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n</ul>\r\n<br />\r\n<ul class="bullet-printer">\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-printer</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-printer</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n</ul>\r\n<br />\r\n<ul class="bullet-rss">\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-rss</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-rss</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n</ul>\r\n<br />\r\n<ul class="bullet-star">\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-star</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-star</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n</ul>\r\n<br />\r\n<ul class="bullet-star2">\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-star2</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-star2</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n</ul>\r\n<br />\r\n<ul class="bullet-unlock">\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-unlock</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-unlock</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n</ul>\r\n<br />\r\n<ul class="bullet-warning">\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-warning</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-warning</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n</ul>\r\n<br />\r\n<ul class="bullet-write">\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-write</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-write</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n</ul>\r\n<br />\r\n</div>\r\n<div class="clear"></div>\r\n\r\n<h3><a name="bullets" href="#bullets">List Styles - Numbers</a></h3>\r\n<p>Below is a list with <em class="normal">numbers</em>.  To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">class name</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong></p>\r\n\r\n<div class="rt-demo-grid-4">\r\n<ul class="bullet-no1">\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-no1</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n</ul>\r\n<ul class="bullet-no2">\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-no2</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n</ul>\r\n<ul class="bullet-no3">\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-no3</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n</ul>\r\n<ul class="bullet-no4">\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-no4</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n</ul>\r\n<ul class="bullet-no5">\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-no5</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n</ul>\r\n</div>\r\n\r\n<div class="rt-demo-grid-4">\r\n<ul class="bullet-no6">\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-no6</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n</ul>\r\n<ul class="bullet-no7">\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-no7</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n</ul>\r\n<ul class="bullet-no8">\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-no8</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n</ul>\r\n<ul class="bullet-no9">\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-no9</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n</ul>\r\n<ul class="bullet-no10">\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-no10</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n</ul>\r\n</div>\r\n<div class="clear"></div>\r\n\r\n<h3><a name="bullets" href="#bullets">List Styles - Bullets</a></h3>\r\n<p>Below is a list with <em class="normal">bullets</em>.  To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">class name</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong></p>\r\n\r\n<div class="rt-demo-grid-4">\r\n<ul class="bullet-1">\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-1</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-1</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n</ul>\r\n<br />\r\n<ul class="bullet-2">\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-2</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-2</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n</ul>\r\n<br />\r\n<ul class="bullet-3">\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-3</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-3</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n</ul>\r\n<br />\r\n<ul class="bullet-4">\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-4</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-4</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n</ul>\r\n<br />\r\n<ul class="bullet-5">\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-5</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-5</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n</ul>\r\n<br />\r\n</div>\r\n\r\n<div class="rt-demo-grid-4">\r\n<ul class="bullet-6">\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-6</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-6</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n</ul>\r\n<br />\r\n<ul class="bullet-7">\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-7</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-7</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n</ul>\r\n<br />\r\n<ul class="bullet-8">\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-8</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-8</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n</ul>\r\n<br />\r\n<ul class="bullet-9">\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-9</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-9</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n</ul>\r\n<br />\r\n<ul class="bullet-10">\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-10</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n  <li>To use this style create a list in the following format: <strong>&lt;ul class="</strong><em class="normal">bullet-10</em><strong>"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt;</strong>.</li>\r\n</ul>\r\n</div>\r\n<div class="clear"></div>\r\n\r\n<h3><a name="emphasis" href="#emphasis">Emphasis Styles</a></h3>\r\n\r\nThis is a emphasis tag that allows you to <em class="italic">highlight words or phrases</em>. Use the following format: <strong>&lt;em class=&quot;<em class="normal">italic</em>&quot;&gt;...&lt;/em&gt;</strong><br /><br />\r\n\r\nThis is a emphasis tag that allows you to <em class="bold">highlight words or phrases</em>. Use the following format: <strong>&lt;em class=&quot;<em class="normal">bold</em>&quot;&gt;...&lt;/em&gt;</strong><br /><br />\r\n\r\nThis is a emphasis tag that allows you to <em class="bold2">highlight words or phrases</em>. Use the following format: <strong>&lt;em class=&quot;<em class="normal">bold2</em>&quot;&gt;...&lt;/em&gt;</strong><br /><br />\r\n\r\n<h3><a name="insets" href="#insets">Inset Styles</a></h3>\r\n\r\n<p>\r\n	Praesent rutrum sapien ac felis. Phasellus elementum dolor quis turpis. Vestibulum nec mi vitae pede tincidunt nonummy. Vestibulum facilisis mollis neque. Sed orci. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.\r\n	<span class="inset-right"><span class="inset-right-title">Inset Right Title</span>You will need to use the following formatting: <strong>&lt;span class=&quot;inset-right&quot;&gt; &lt;span class=&quot;inset-right-title&quot;&gt; .... &lt;/span&gt; <em class="normal"> ... some content ... </em>&lt;/strong&gt;</strong></span>\r\n	Vestibulum facilisis mollis neque. Sed orci. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Sed euismod magna a nibh.\r\n</p>\r\n\r\n<p>\r\n	Praesent rutrum sapien ac felis. Phasellus elementum dolor quis turpis. Vestibulum nec mi vitae pede tincidunt nonummy. Vestibulum facilisis mollis neque. Sed orci. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.\r\n	<span class="inset-left"><span class="inset-left-title">Inset Left Title</span>You will need to use the following formatting: <strong>&lt;span class=&quot;inset-left&quot;&gt; &lt;span class=&quot;inset-left-title&quot;&gt; .... &lt;/span&gt; <em class="normal"> ... some content ... </em>&lt;/strong&gt;</strong></span>\r\n	Vestibulum facilisis mollis neque. Sed orci. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Sed euismod magna a nibh.</p><p>Sed euismod magna a nibh. Praesent rutrum sapien ac felis. Phasellus elementum dolor quis turpis. Vestibulum nec mi vitae pede tincidunt nonummy. Praesent rutrum sapien ac felis. Phasellus elementum dolor quis turpis. Vestibulum nec mi vitae pede tincidunt nonummy. Vestibulum facilisis mollis neque. Sed orci. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.Praesent rutrum sapien ac felis. Phasellus elementum dolor quis turpis. Vestibulum nec mi vitae pede tincidunt nonummy. Vestibulum facilisis mollis neque. Sed orci. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.\r\n</p>\r\n\r\n<h3><a name="notice" href="#notice">Notice Styles</a></h3>\r\n\r\n<div class="alert"><div class="typo-icon">This is a sample of the <em>alert</em> style.  Use this style to <a href="javascript:void(0);">highlight information</a> to your users. To use this use the following html: <strong>&lt;div class="alert"&gt;&lt;div class=&quot;typo-icon&quot;&gt;....&lt;/div&gt;&lt;/div&gt;</strong>.</div></div>\r\n\r\n<div class="approved"><div class="typo-icon">This is a sample of the <em>approved</em> style.  Use this style to <a href="javascript:void(0);">highlight information</a> to your users. To use this use the following html: <strong>&lt;div class="approved"&gt;&lt;div class=&quot;typo-icon&quot;&gt;....&lt;/div&gt;&lt;/div&gt;</strong>.</div></div>\r\n\r\n<div class="attention"><div class="typo-icon">This is a sample of the <em>attention</em> style.  Use this style to <a href="javascript:void(0);">highlight information</a> to your users. To use this use the following html: <strong>&lt;div class="attention"&gt;&lt;div class=&quot;typo-icon&quot;&gt;....&lt;/div&gt;&lt;/div&gt;</strong>.</div></div>\r\n\r\n<div class="camera"><div class="typo-icon">This is a sample of the <em>camera</em> style.  Use this style to <a href="javascript:void(0);">highlight information</a> to your users. To use this use the following html: <strong>&lt;div class="camera"&gt;&lt;div class=&quot;typo-icon&quot;&gt;....&lt;/div&gt;&lt;/div&gt;</strong>.</div></div>\r\n\r\n<div class="cart"><div class="typo-icon">This is a sample of the <em>cart</em> style.  Use this style to <a href="javascript:void(0);">highlight information</a> to your users. To use this use the following html: <strong>&lt;div class="cart"&gt;&lt;div class=&quot;typo-icon&quot;&gt;....&lt;/div&gt;&lt;/div&gt;</strong>.</div></div>\r\n\r\n<div class="doc"><div class="typo-icon">This is a sample of the <em>doc</em> style.  Use this style to <a href="javascript:void(0);">highlight information</a> to your users. To use this use the following html: <strong>&lt;div class="doc"&gt;&lt;div class=&quot;typo-icon&quot;&gt;....&lt;/div&gt;&lt;/div&gt;</strong>.</div></div>\r\n\r\n<div class="download"><div class="typo-icon">This is a sample of the <em>download</em> style.  Use this style to <a href="javascript:void(0);">highlight information</a> to your users. To use this use the following html: <strong>&lt;div class="download"&gt;&lt;div class=&quot;typo-icon&quot;&gt;....&lt;/div&gt;&lt;/div&gt;</strong>.</div></div>\r\n\r\n<div class="media"><div class="typo-icon">This is a sample of the <em>media</em> style.  Use this style to <a href="javascript:void(0);">highlight information</a> to your users. To use this use the following html: <strong>&lt;div class="media"&gt;&lt;div class=&quot;typo-icon&quot;&gt;....&lt;/div&gt;&lt;/div&gt;</strong>.</div></div>\r\n\r\n<div class="note"><div class="typo-icon">This is a sample of the <em>note</em> style.  Use this style to <a href="javascript:void(0);">highlight information</a> to your users. To use this use the following html: <strong>&lt;div class="note"&gt;&lt;div class=&quot;typo-icon&quot;&gt;....&lt;/div&gt;&lt;/div&gt;</strong>.</div></div>\r\n\r\n<div class="notice"><div class="typo-icon">This is a sample of the <em>notice</em> style.  Use this style to <a href="javascript:void(0);">highlight information</a> to your users. To use this use the following html: <strong>&lt;div class="notice"&gt;&lt;div class=&quot;typo-icon&quot;&gt;....&lt;/div&gt;&lt;/div&gt;</strong>.</div></div>\r\n\r\n<div class="quote"><div class="quote-l"><div class="quote-r">This is a sample of the <em>quote</em> style.  Use this style to <a href="javascript:void(0);">highlight information</a> to your users. To use this use the following html: <strong>&lt;div class="quote"&gt;&lt;div class=&quot;quote-l&quot;&gt;&lt;div class=&quot;quote-r&quot;&gt;....&lt;/div&gt;&lt;/div&gt;&lt;/div&gt;</strong></div></div></div>\r\n\r\n<h3><a name="pre-example" href="#pre-example">Pre Example</a></h3>\r\n\r\n<pre>\r\nThis is a sample <strong>&lt;pre&gt;...&lt;/pre&gt;</strong> tag:\r\n\r\ndiv.modulebox-black div.bx1 {\r\n  background: url(../images/black/box_bl.png) 0 100% no-repeat;\r\n}\r\n\r\ndiv.modulebox-black div.bx2 {\r\n  background: url(../images/black/box_tr.png) 100% 0 no-repeat;\r\n}\r\n\r\ndiv.modulebox-black div.bx3 {\r\n  background: url(../images/black/box_tl.png) 0 0 no-repeat;\r\n  padding: 0;\r\n  margin: 0;\r\n}\r\n</pre>', '', 1, 5, 0, 34, '2010-07-18 23:34:52', 62, '', '2010-07-27 22:35:03', 63, 0, '0000-00-00 00:00:00', '2010-07-18 23:34:52', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 28, 0, 7, '', '', 0, 106, 'robots=\nauthor='),
(107, 'Fable', 'fable', '', '<img src="images/stories/demo/roknewspager/review8.jpg" class="floatleft" alt="Image" width="116" height="160"/>\r\n<p>The fables of Fable continue to be told with this...</p>\r\n\r\n', '\r\n<p>In erat. Pellentesque erat. Mauris vehicula vestibulum justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nulla pulvinar est. Integer urna. Pellentesque pulvinar dui a magna. Nulla facilisi. Proin imperdiet. Aliquam ornare, metus vitae gravida dignissim, nisi nisl ultricies felis, ac tristique enim pede eget elit. Integer non erat nec turpis sollicitudin malesuada. Vestibulum dapibus. Nulla facilisi. Nulla iaculis, leo sit amet mollis luctus, sapien eros consectetur dolor, eu faucibus elit nibh eu nibh. Maecenas lacus pede, lobortis non, rhoncus id, tristique a, mi. Cras auctor libero vitae sem vestibulum euismod. Nunc fermentum.</p>\r\n\r\n<p>Mauris lobortis. Aliquam lacinia purus. Pellentesque magna. Mauris euismod metus nec tortor. Phasellus elementum, quam a euismod imperdiet, ligula felis faucibus enim, eu malesuada nunc felis sed turpis. Morbi convallis luctus tortor. Integer bibendum lacinia velit. Suspendisse mi lorem, porttitor ut, interdum et, lobortis a, lectus. Phasellus vitae est at massa luctus iaculis. In tincidunt.</p>\r\n\r\n<p>Integer fermentum elit in tellus. Integer ligula ipsum, gravida aliquet, fringilla non, interdum eget, ipsum. Praesent id dolor non erat viverra volutpat. Fusce tellus libero, luctus adipiscing, tincidunt vel, egestas vitae, eros. Vestibulum mollis, est id rhoncus volutpat, dolor velit tincidunt neque, vitae pellentesque ante sem eu nisl. Donec facilisis, magna eget elementum pellentesque, augue arcu aliquet eros, eget convallis mauris ante quis magna. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Aenean et libero. Nam aliquam. Quisque vitae tortor id neque dignissim laoreet. Duis eu ante. Integer at sapien. Praesent sed nisl tempor est pulvinar tristique. Maecenas non lorem quis mi laoreet adipiscing. Sed ac arcu. Sed tincidunt libero eu dolor. Cras pharetra posuere eros. Donec ac eros id diam tempor faucibus. Fusce feugiat consequat nulla. Vestibulum tincidunt vulputate ipsum.</p>\r\n\r\n<p>Nullam eget neque. Nullam imperdiet venenatis ligula. Integer a leo. Nunc consectetur. Maecenas sem. Proin vulputate, massa vel volutpat laoreet, purus erat pretium ligula, eget varius arcu nibh sed libero. Fusce ante. Nullam interdum aliquet metus. Ut ultrices vestibulum tellus. Praesent quis erat. Nam id turpis sit amet neque cursus luctus. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Quisque id tortor. In vitae sapien. Nunc quis tellus.</p>', 1, 5, 0, 42, '2010-07-21 21:33:43', 63, '', '2010-07-29 00:40:09', 63, 0, '0000-00-00 00:00:00', '2010-07-21 21:33:43', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 2, 0, 20, '', '', 0, 2, 'robots=\nauthor=');
INSERT INTO `#__content` (`id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`) VALUES
(52, 'RokCandy Typography', 'rokcandy-typography', '', '<div class="note"><div class="typo-icon">This page shows all the template typography in its <a href="index.php?option=com_content&amp;view=article&amp;id=53&amp;Itemid=61"><em class="bold2">RokCandy</em></a> format. Visit the <a href="index.php?option=com_content&amp;view=article&amp;id=51&amp;Itemid=59">HTML Examples</a> page for typography in the HTML Format.</div></div>\r\n\r\n\r\n<div class="rt-demo-grid-4">\r\n	[componentheading]This is a ComponentHeading[/componentheading]\r\n	<p>Praesent rutrum sapien ac felis. Phasellus elementum dolor quis turpis. Vestibulum nec mi vitae pede.</p>\r\n</div>\r\n\r\n<div class="rt-demo-grid-4">\r\n	[contentheading]This is a ContentHeading[/contentheading]\r\n	<p>Proin ac nunc eu nunc condimentum accumsan. Phasellus odio justo, euismod vitae, egestas a.</p>\r\n</div>\r\n<div class="clear"></div>\r\n\r\n<div class="rt-demo-grid-4">\r\n	[h1]This is a H1 Header[/h1]\r\n	<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Proin sit amet odio quis sapien molestie ultrices.</p>\r\n</div>\r\n\r\n<div class="rt-demo-grid-4">\r\n	[h2]This is a H2 Header[/h2]\r\n	<p>Proin ac nunc eu nunc condimentum accumsan. Phasellus odio justo, euismod vitae, egestas a, porttitor</p>\r\n</div>\r\n<div class="clear"></div>\r\n\r\n<div class="rt-demo-grid-4">\r\n	[h3]This is a H3 Header[/h3]\r\n	<p>Mauris euismod. In ac massa vitae quam tincidunt dapibus. Ut at tortor nec mi mattis blandit.</p>\r\n</div>\r\n\r\n<div class="rt-demo-grid-4">\r\n	[h4]This is a H4 Header[/h4]\r\n	<p>Vestibulum posuere, lacus aliquet pulvinar faucibus, tortor urna luctus diam, vitae ultrices ante.</p>\r\n</div>\r\n<div class="clear"></div>\r\n\r\n[h5]This is a H5 Header[/h5]\r\n\r\n<p>Pellentesque vel enim urna, sit amet blandit ipsum. Maecenas quis sem sit amet nunc pretium mattis. Sed dapibus semper est, sed pretium erat sodales sed. Aenean hendrerit fringilla sem, et tincidunt libero ornare at. </p>\r\n\r\n[h3]<a name="blockquotes" href="#blockquotes">Blockquote Styles</a>[/h3]\r\n\r\n[blockquote]This is a blockquote, you will want to use the following formatting: <strong>&#91;blockquote&#93;....&#91;/blockquote&#93;</strong>. Praesent rutrum sapien ac felis. Phasellus elementum dolor quis turpis. Vestibulum nec mi vitae pede tincidunt nonummy.[/blockquote]\r\n\r\n[h3]<a name="dropcap" href="#dropcap">DropCap Styles</a>[/h3]\r\n\r\n[dropcap cap="P"]Praesent rutrum sapien ac felis. Phasellus elementum dolor quis turpis. Vestibulum nec mi vitae pede tincidunt nonummy. Vestibulum facilisis mollis neque. Sed orci. Cum sociis natoque penatibus et magnis dis.<br /><br />You will need to use the following formatting: <strong>&#91;dropcap cap="P"&#93;...some content...&#91;/dropcap&#93;</strong>[/dropcap]\r\n\r\n[dropcap cap="1"]You will need to use the following formatting: <strong>&#91;dropcap cap="1"&#93;...some content...&#91;/dropcap&#93;</strong><br /><em>Praesent rutrum sapien ac felis. Phasellus elementum dolor quis turpis. Vestibulum nec mi vitae pede tincidunt nonummy. Vestibulum facilisis mollis neque. Sed orci. Cum sociis natoque penatibus et magnis dis parturient.</em>[/dropcap]\r\n[dropcap cap="2"]You will need to use the following formatting: <strong>&#91;dropcap cap="2"&#93;...some content...&#91;/dropcap&#93;</strong><br /><em>Praesent rutrum sapien ac felis. Phasellus elementum dolor quis turpis. Vestibulum nec mi vitae pede tincidunt nonummy. Vestibulum facilisis mollis neque. Sed orci. Cum sociis natoque penatibus et magnis dis parturient.</em>[/dropcap]\r\n[dropcap cap="3"]You will need to use the following formatting: <strong>&#91;dropcap cap="3"&#93;...some content...&#91;/dropcap&#93;</strong><br /><em>Praesent rutrum sapien ac felis. Phasellus elementum dolor quis turpis. Vestibulum nec mi vitae pede tincidunt nonummy. Vestibulum facilisis mollis neque. Sed orci. Cum sociis natoque penatibus et magnis dis parturient.</em>[/dropcap]\r\n\r\n[h3]<a name="icon-bullets" href="#icon-bullets">List Styles - Icon Bullets</a>[/h3]\r\n<p>Below is a list with <em style="font-weight: normal !important;">icons</em>.  To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">class name</em><strong>&#93;&#91;li&#93;....&#91;/li&#93;&#91;li....&#91;/li&#93;&#91;/list&#93;</strong></p>\r\n\r\n<div class="rt-demo-grid-4">\r\n[list class="bullet-add"][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-add"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-add"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][/list]<br />\r\n[list class="bullet-arrow"][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-arrow"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-arrow"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][/list]<br />\r\n[list class="bullet-arrow2"][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-arrow2"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-arrow2"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][/list]<br />\r\n[list class="bullet-briefcase"][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-briefcase"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-briefcase"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][/list]<br />\r\n[list class="bullet-calendar"][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-calendar"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-calendar"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][/list]<br />\r\n[list class="bullet-check"][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-check"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-check"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][/list]<br />\r\n[list class="bullet-crank"][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-crank"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-crank"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][/list]<br />\r\n[list class="bullet-delete"][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-delete"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-delete"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][/list]<br />\r\n[list class="bullet-docs"][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-docs"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-docs"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][/list]<br />\r\n[list class="bullet-email"][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-email"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-email"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][/list]<br />\r\n[list class="bullet-home"][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-home"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-home"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][/list]<br />\r\n</div>\r\n\r\n<div class="rt-demo-grid-4">\r\n[list class="bullet-key"][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-key"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-key"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][/list]<br />\r\n[list class="bullet-lock"][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-lock"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-lock"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][/list]<br />\r\n[list class="bullet-minus"][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-minus"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-minus"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][/list]<br />\r\n[list class="bullet-monitor"][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-monitor"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-monitor"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][/list]<br />\r\n[list class="bullet-notes"][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-notes"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-notes"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][/list]<br />\r\n[list class="bullet-post"][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-post"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-post"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][/list]<br />\r\n[list class="bullet-printer"][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-printer"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-printer"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][/list]<br />\r\n[list class="bullet-rss"][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-rss"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-rss"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][/list]<br />\r\n[list class="bullet-unlock"][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-unlock"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-unlock"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][/list]<br />\r\n[list class="bullet-warning"][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-warning"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-warning"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][/list]<br />\r\n[list class="bullet-write"][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-write"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-write"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][/list]<br />\r\n</div>\r\n<div class="clear"></div>\r\n\r\n[h3]<a name="bullets" href="#bullets">List Styles - Mumbers</a>[/h3]\r\n<p>Below is a list with <em style="font-weight: normal !important;">numbers</em>.  To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">class name</em><strong>&#93;&#91;li&#93;....&#91;/li&#93;&#91;li....&#91;/li&#93;&#91;/list&#93;</strong></p>\r\n\r\n<div class="rt-demo-grid-4">\r\n[list class="bullet-no1"][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-no1"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][/list]\r\n[list class="bullet-no2"][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-no2"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][/list]\r\n[list class="bullet-no3"][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-no3"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][/list]\r\n[list class="bullet-no4"][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-no4"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][/list]\r\n[list class="bullet-no5"][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-no5"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][/list]\r\n</div>\r\n\r\n<div class="rt-demo-grid-4">\r\n[list class="bullet-no6"][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-no6"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][/list]\r\n[list class="bullet-no7"][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-no7"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][/list]\r\n[list class="bullet-no8"][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-no8"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][/list]\r\n[list class="bullet-no9"][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-no9"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][/list]\r\n[list class="bullet-no10"][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-no10"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][/list]\r\n</div>\r\n<div class="clear"></div>\r\n\r\n[h3]<a name="bullets" href="#bullets">List Styles - Bullets</a>[/h3]\r\n<p>Below is a list with <em style="font-weight: normal !important;">bullets</em>.  To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">class name</em><strong>&#93;&#91;li&#93;....&#91;/li&#93;&#91;li....&#91;/li&#93;&#91;/list&#93;</strong></p>\r\n\r\n<div class="rt-demo-grid-4">\r\n[list class="bullet-1"][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-1"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-1"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][/list]<br />\r\n[list class="bullet-2"][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-2"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-2"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][/list]<br />\r\n[list class="bullet-3"][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-3"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-3"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][/list]<br />\r\n[list class="bullet-4"][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-4"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-4"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][/list]<br />\r\n[list class="bullet-5"][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-5"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-5"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][/list]<br />\r\n</div>\r\n\r\n<div class="rt-demo-grid-4">\r\n[list class="bullet-6"][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-6"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-6"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][/list]<br />\r\n[list class="bullet-7"][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-7"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-7"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][/list]<br />\r\n[list class="bullet-8"][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-8"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-8"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][/list]<br />\r\n[list class="bullet-9"][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-9"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-9"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][/list]<br />\r\n[list class="bullet-10"][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-10"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][li]To use this style create a list in the following format: <strong>&#91;list class=</strong><em style="font-weight: normal !important;">"bullet-10"</em><strong>&#93;&#91;li&#93;...&#91;/li&#93;&#91;li&#93;...&#91;/li&#93;&#91;/list&#93;</strong>.[/li][/list]\r\n</div>\r\n<div class="clear"></div>\r\n\r\n[h3]<a name="emphasis-styles" href="#emphasis-styles">Emphasis Styles</a>[/h3]\r\n\r\nThis is a span that allows you to [emphasis]highlight words or phrases[/emphasis]. Use the following format: <strong>&#91;emphasis&#93; ... some content ... &#91;/emphasis&#93;</strong><br /><br />\r\n\r\nThis is a span that allows you to [emphasisbold]highlight words or phrases[/emphasisbold]. Use the following format: <strong>&#91;emphasisbold&#93; ... some content .... &#91;/emphasisbold&#93;</strong><br /><br />\r\n\r\nThis is a span that allows you to [emphasisbold2]highlight words or phrases[/emphasisbold2]. Use the following format: <strong>&#91;emphasisbold2&#93; ... some content .... &#91;/emphasisbold2&#93;</strong><br /><br />\r\n\r\n[h3]<a name="insets" href="#insets">Inset Styles</a>[/h3]\r\n\r\n<p>Praesent rutrum sapien ac felis. Phasellus elementum dolor quis turpis. Vestibulum nec mi vitae pede tincidunt nonummy. Vestibulum facilisis mollis neque. Sed orci. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.[inset side="right" title="Inset Right Title"]You will need to use the following formatting: <strong>&#91;inset side="right" title="Inset Right Title"&#93; ... some content ...&#91;/inset&#93;</strong>[/inset]Vestibulum facilisis mollis neque. Sed orci. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Sed euismod magna a nibh.</p>\r\n\r\n<p>Praesent rutrum sapien ac felis. Phasellus elementum dolor quis turpis. Vestibulum nec mi vitae pede tincidunt nonummy. Vestibulum facilisis mollis neque. Sed orci. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.[inset side="left" title="Inset Left Title"]You will need to use the following formatting: <strong>&#91;inset side="left" title="Inset Left Title"&#93; ... some content ...&#91;/inset&#93;</strong>[/inset]Vestibulum facilisis mollis neque. Sed orci. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Sed euismod magna a nibh.</p><p>Sed euismod magna a nibh. Praesent rutrum sapien ac felis. Phasellus elementum dolor quis turpis. Vestibulum nec mi vitae pede tincidunt nonummy. Praesent rutrum sapien ac felis. Phasellus elementum dolor quis turpis. Vestibulum nec mi vitae pede tincidunt nonummy. Vestibulum facilisis mollis neque. Sed orci. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.Praesent rutrum sapien ac felis. Phasellus elementum dolor quis turpis. Vestibulum nec mi vitae pede tincidunt nonummy. Vestibulum facilisis mollis neque. Sed orci. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n\r\n[h3]<a name="notice-styles" href="#notice-styles">Notice Styles</a>[/h3]\r\n\r\n[div class="alert" class2="typo-icon"]This is a sample of the ''alert'' style.  Use this style to denote very important information to your users. To use this use the following syntax: <strong>&#91;div&nbsp;class="alert" class2="typo-icon"&#93;</strong> ...some content.... <strong>&#91;/div&#93;</strong>[/div]\r\n\r\n[div class="approved" class2="typo-icon"]This is a sample of the ''approved'' style.  Use this style to denote very important information to your users. To use this use the following syntax: <strong>&#91;div&nbsp;class="approved" class2="typo-icon"&#93;</strong> ...some content.... <strong>&#91;/div&#93;</strong>[/div]\r\n\r\n[div class="attention" class2="typo-icon"]This is a sample of the ''attention'' style.  Use this style to denote very important information to your users. To use this use the following syntax: <strong>&#91;div&nbsp;class="attention" class2="typo-icon"&#93;</strong> ...some content.... <strong>&#91;/div&#93;</strong>[/div]\r\n\r\n[div class="camera" class2="typo-icon"]This is a sample of the ''camera'' style.  Use this style to denote very important information to your users. To use this use the following syntax: <strong>&#91;div&nbsp;class="camera" class2="typo-icon"&#93;</strong> ...some content.... <strong>&#91;/div&#93;</strong>[/div]\r\n\r\n[div class="cart" class2="typo-icon"]This is a sample of the ''cart'' style.  Use this style to denote very important information to your users. To use this use the following syntax: <strong>&#91;div&nbsp;class="cart" class2="typo-icon"&#93;</strong> ...some content.... <strong>&#91;/div&#93;</strong>[/div]\r\n\r\n[div class="doc" class2="typo-icon"]This is a sample of the ''doc'' style.  Use this style to denote very important information to your users. To use this use the following syntax: <strong>&#91;div&nbsp;class="doc" class2="typo-icon"&#93;</strong> ...some content.... <strong>&#91;/div&#93;</strong>[/div]\r\n\r\n[div class="download" class2="typo-icon"]This is a sample of the ''download'' style.  Use this style to denote very important information to your users. To use this use the following syntax: <strong>&#91;div&nbsp;class="download" class2="typo-icon"&#93;</strong> ...some content.... <strong>&#91;/div&#93;</strong>[/div]\r\n\r\n[div class="media" class2="typo-icon"]This is a sample of the ''media'' style.  Use this style to denote very important information to your users. To use this use the following syntax: <strong>&#91;div&nbsp;class="media" class2="typo-icon"&#93;</strong> ...some content.... <strong>&#91;/div&#93;</strong>[/div]\r\n\r\n[div class="note" class2="typo-icon"]This is a sample of the ''note'' style.  Use this style to denote very important information to your users. To use this use the following syntax: <strong>&#91;div&nbsp;class="note" class2="typo-icon"&#93;</strong> ...some content.... <strong>&#91;/div&#93;</strong>[/div]\r\n\r\n[div class="notice" class2="typo-icon"]This is a sample of the ''notice'' style.  Use this style to denote very important information to your users. To use this use the following syntax: <strong>&#91;div&nbsp;class="notice" class2="typo-icon"&#93;</strong> ...some content.... <strong>&#91;/div&#93;</strong>[/div]\r\n\r\n[div3 class="quote" class2="quote-l" class3="quote-r"]This is a sample of the ''quote'' style.  Use this style to denote very important information to your users. To use this use the following syntax: <strong>&#91;div3&nbsp;class=&quot;quote&quot; class2=&quot;quote-l&quot; class3=&quot;quote-r&quot;&#93;</strong> ...some content.... <strong>&#91;/div3&#93;</strong>[/div3]\r\n\r\n[h3]<a name="pre-example" href="#pre-example">Pre Example</a>[/h3]\r\n\r\n[pre]\r\nThis is a sample <strong>&#91;pre&#93; ... &#91;/pre&#93;</strong> tag:\r\n\r\ndiv.modulebox-black div.bx1 {\r\nbackground: url(../images/black/box_bl.png) 0 100% no-repeat;\r\n}\r\n\r\ndiv.modulebox-black div.bx2 {\r\nbackground: url(../images/black/box_tr.png) 100% 0 no-repeat;\r\n}\r\n\r\ndiv.modulebox-black div.bx3 {\r\nbackground: url(../images/black/box_tl.png) 0 0 no-repeat;\r\npadding: 0;\r\nmargin: 0;\r\n}\r\n[/pre]', '', 1, 5, 0, 34, '2010-07-18 23:35:28', 62, '', '2010-07-27 22:54:58', 63, 0, '0000-00-00 00:00:00', '2010-07-18 23:35:28', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 6, 0, 8, '', '', 0, 32, 'robots=\nauthor='),
(106, 'Fallout', 'fallout', '', '<img src="images/stories/demo/roknewspager/review7.jpg" class="floatleft rt-image" alt="Image" width="116" height="160"/>\r\n<p>From Bethesda Softworks and the veteran RPG...</p>\r\n\r\n', '\r\n<p>In erat. Pellentesque erat. Mauris vehicula vestibulum justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nulla pulvinar est. Integer urna. Pellentesque pulvinar dui a magna. Nulla facilisi. Proin imperdiet. Aliquam ornare, metus vitae gravida dignissim, nisi nisl ultricies felis, ac tristique enim pede eget elit. Integer non erat nec turpis sollicitudin malesuada. Vestibulum dapibus. Nulla facilisi. Nulla iaculis, leo sit amet mollis luctus, sapien eros consectetur dolor, eu faucibus elit nibh eu nibh. Maecenas lacus pede, lobortis non, rhoncus id, tristique a, mi. Cras auctor libero vitae sem vestibulum euismod. Nunc fermentum.</p>\r\n\r\n<p>Mauris lobortis. Aliquam lacinia purus. Pellentesque magna. Mauris euismod metus nec tortor. Phasellus elementum, quam a euismod imperdiet, ligula felis faucibus enim, eu malesuada nunc felis sed turpis. Morbi convallis luctus tortor. Integer bibendum lacinia velit. Suspendisse mi lorem, porttitor ut, interdum et, lobortis a, lectus. Phasellus vitae est at massa luctus iaculis. In tincidunt.</p>\r\n\r\n<p>Integer fermentum elit in tellus. Integer ligula ipsum, gravida aliquet, fringilla non, interdum eget, ipsum. Praesent id dolor non erat viverra volutpat. Fusce tellus libero, luctus adipiscing, tincidunt vel, egestas vitae, eros. Vestibulum mollis, est id rhoncus volutpat, dolor velit tincidunt neque, vitae pellentesque ante sem eu nisl. Donec facilisis, magna eget elementum pellentesque, augue arcu aliquet eros, eget convallis mauris ante quis magna. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Aenean et libero. Nam aliquam. Quisque vitae tortor id neque dignissim laoreet. Duis eu ante. Integer at sapien. Praesent sed nisl tempor est pulvinar tristique. Maecenas non lorem quis mi laoreet adipiscing. Sed ac arcu. Sed tincidunt libero eu dolor. Cras pharetra posuere eros. Donec ac eros id diam tempor faucibus. Fusce feugiat consequat nulla. Vestibulum tincidunt vulputate ipsum.</p>\r\n\r\n<p>Nullam eget neque. Nullam imperdiet venenatis ligula. Integer a leo. Nunc consectetur. Maecenas sem. Proin vulputate, massa vel volutpat laoreet, purus erat pretium ligula, eget varius arcu nibh sed libero. Fusce ante. Nullam interdum aliquet metus. Ut ultrices vestibulum tellus. Praesent quis erat. Nam id turpis sit amet neque cursus luctus. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Quisque id tortor. In vitae sapien. Nunc quis tellus.</p>', 1, 5, 0, 42, '2010-07-21 21:33:23', 63, '', '2010-07-29 00:28:40', 63, 0, '0000-00-00 00:00:00', '2010-07-21 21:33:23', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 1, 0, 19, '', '', 0, 2, 'robots=\nauthor='),
(53, 'Integrated Extensions', 'integrated-extensions', '', '<p><em class="bold2">Third Party Extensions - <em class="italic">Compatibility</em> Styling Support</em></p>\r\n\r\n<p><strong>Compatibility</strong> styling constitutes basic CSS alterations to better integrate the extensions with the template, rather than full theme integration. Example extensions: K2, Tienda, JComments, Virtuemart and JomSocial.</p>\r\n\r\n[readon url="index.php?option=com_content&amp;view=article&amp;id=82&amp;Itemid=145"]More Details[/readon]\r\n\r\n<p><em class="bold2">RocketTheme Extensions</em></p>\r\n\r\n<div class="rt-demo-grid-2 rt-center">\r\n	<img class="rt-ext-img" width="80" height="80" alt="image" src="images/stories/demo/general/ext/rokquickcart.png" />\r\n	<strong><a target="_blank" href="http://www.rockettheme.com/extensions-joomla/rokquickcart" rel="rokbox[fullscreen]">RokQuickCart</a></strong> A simple shopping cart extension.\r\n</div>\r\n\r\n<div class="rt-demo-grid-2 rt-center">\r\n	<img class="rt-ext-img" width="80" height="80" alt="image" src="images/stories/demo/general/ext/rokstories.png" />\r\n	<strong><a target="_blank" href="http://www.rockettheme.com/extensions-joomla/rokstories" rel="rokbox[fullscreen]">RokStories</a></strong> A versatile content rotator.\r\n</div>\r\n\r\n<div class="rt-demo-grid-2 rt-center">\r\n	<img class="rt-ext-img" width="80" height="80" alt="image" src="images/stories/demo/general/ext/rokajaxsearch.png" />\r\n	<strong><a target="_blank" href="http://www.rockettheme.com/extensions-joomla/rokajaxsearch" rel="rokbox[fullscreen]">RokAjaxSearch</a></strong> Ajax powered search module.\r\n</div>\r\n\r\n<div class="rt-demo-grid-2 rt-center">\r\n	<img class="rt-ext-img" width="80" height="80" alt="image" src="images/stories/demo/general/ext/roktabs.png" />\r\n	<strong><a target="_blank" href="http://www.rockettheme.com/extensions-joomla/roktabs" rel="rokbox[fullscreen]">RokTabs</a></strong> A mootools tabbed content module.\r\n</div>\r\n\r\n<div class="clear"></div>\r\n<br />\r\n\r\n<div class="rt-demo-grid-2 rt-center">\r\n	<img class="rt-ext-img" width="80" height="80" alt="image" src="images/stories/demo/general/ext/roknewspager.png" />\r\n	<strong><a target="_blank" href="http://www.rockettheme.com/extensions-joomla/roknewspager" rel="rokbox[fullscreen]">RokNewsPager</a></strong> A simple shopping cart extension.\r\n</div>\r\n\r\n<div class="rt-demo-grid-2 rt-center">\r\n	<img class="rt-ext-img" width="80" height="80" alt="image" src="images/stories/demo/general/ext/roknavmenu.png" />\r\n	<strong><a target="_blank" href="http://www.rockettheme.com/extensions-joomla/roknavmenu" rel="rokbox[fullscreen]">RokNavMenu</a></strong> Advanced menu system extension.\r\n</div>\r\n\r\n<div class="rt-demo-grid-2 rt-center">\r\n	<img class="rt-ext-img" width="80" height="80" alt="image" src="images/stories/demo/general/ext/rokbox.png" />\r\n	<strong><a target="_blank" href="http://www.rockettheme.com/extensions-joomla/rokbox" rel="rokbox[fullscreen]">RokBox</a></strong> Popup window utility for images etc...\r\n</div>\r\n\r\n<div class="rt-demo-grid-2 rt-center">\r\n	<img class="rt-ext-img" width="80" height="80" alt="image" src="images/stories/demo/general/ext/rokcandy.png" />\r\n	<strong><a target="_blank" href="http://www.rockettheme.com/extensions-joomla/rokcandy" rel="rokbox[fullscreen]">RokCandy</a></strong> A macro content plugin.\r\n</div>\r\n\r\n<div class="clear"></div>\r\n<br />\r\n\r\n<div class="rt-demo-grid-2 rt-center">\r\n	<img class="rt-ext-img" width="80" height="80" alt="image" src="images/stories/demo/general/ext/rokgzipper.png" />\r\n	<strong><a target="_blank" href="http://www.rockettheme.com/extensions-joomla/rokgzipper" rel="rokgzipper[fullscreen]">RokGZipper</a></strong> CSS/JS performance plugin.\r\n</div>\r\n\r\n<div class="rt-demo-grid-2 rt-center">\r\n	<img class="rt-ext-img" width="80" height="80" alt="image" src="images/stories/demo/general/ext/rokpad.png" />\r\n	<strong><a target="_blank" href="http://www.rockettheme.com/extensions-joomla/rokpad" rel="rokbox[fullscreen]">RokPad</a></strong> An advanced code editor for Joomla.\r\n</div>\r\n\r\n<div class="rt-demo-grid-2 rt-center">\r\n	<img class="rt-ext-img" width="80" height="80" alt="image" src="images/stories/demo/general/ext/rokgeneric.png" />\r\n	<strong><a target="_blank" href="http://www.rockettheme.com/extensions-downloads/free/1012-rokmodule" rel="rokbox[fullscreen]">RokModule</a></strong> Utility addon for Ajax modules.\r\n</div>\r\n\r\n<div class="clear"></div>\r\n<br />\r\n\r\n<a class="readon" href="http://www.rockettheme.com/extensions-joomla" target="_blank"><span>Learn about all RocketTheme Extensions</span></a>', '', 1, 5, 0, 34, '2010-07-18 23:35:41', 62, '', '2010-07-30 18:31:14', 63, 0, '0000-00-00 00:00:00', '2010-07-18 23:35:41', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 15, 0, 9, '', '', 0, 139, 'robots=\nauthor='),
(105, 'Gears of War', 'gears-of-war', '', '<img src="images/stories/demo/roknewspager/review6.jpg" class="floatleft rt-image" alt="Image" width="116" height="160"/>\r\n<p>War rages on in the third (and possibly...</p>\r\n\r\n', '\r\n<p>In erat. Pellentesque erat. Mauris vehicula vestibulum justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nulla pulvinar est. Integer urna. Pellentesque pulvinar dui a magna. Nulla facilisi. Proin imperdiet. Aliquam ornare, metus vitae gravida dignissim, nisi nisl ultricies felis, ac tristique enim pede eget elit. Integer non erat nec turpis sollicitudin malesuada. Vestibulum dapibus. Nulla facilisi. Nulla iaculis, leo sit amet mollis luctus, sapien eros consectetur dolor, eu faucibus elit nibh eu nibh. Maecenas lacus pede, lobortis non, rhoncus id, tristique a, mi. Cras auctor libero vitae sem vestibulum euismod. Nunc fermentum.</p>\r\n\r\n<p>Mauris lobortis. Aliquam lacinia purus. Pellentesque magna. Mauris euismod metus nec tortor. Phasellus elementum, quam a euismod imperdiet, ligula felis faucibus enim, eu malesuada nunc felis sed turpis. Morbi convallis luctus tortor. Integer bibendum lacinia velit. Suspendisse mi lorem, porttitor ut, interdum et, lobortis a, lectus. Phasellus vitae est at massa luctus iaculis. In tincidunt.</p>\r\n\r\n<p>Integer fermentum elit in tellus. Integer ligula ipsum, gravida aliquet, fringilla non, interdum eget, ipsum. Praesent id dolor non erat viverra volutpat. Fusce tellus libero, luctus adipiscing, tincidunt vel, egestas vitae, eros. Vestibulum mollis, est id rhoncus volutpat, dolor velit tincidunt neque, vitae pellentesque ante sem eu nisl. Donec facilisis, magna eget elementum pellentesque, augue arcu aliquet eros, eget convallis mauris ante quis magna. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Aenean et libero. Nam aliquam. Quisque vitae tortor id neque dignissim laoreet. Duis eu ante. Integer at sapien. Praesent sed nisl tempor est pulvinar tristique. Maecenas non lorem quis mi laoreet adipiscing. Sed ac arcu. Sed tincidunt libero eu dolor. Cras pharetra posuere eros. Donec ac eros id diam tempor faucibus. Fusce feugiat consequat nulla. Vestibulum tincidunt vulputate ipsum.</p>\r\n\r\n<p>Nullam eget neque. Nullam imperdiet venenatis ligula. Integer a leo. Nunc consectetur. Maecenas sem. Proin vulputate, massa vel volutpat laoreet, purus erat pretium ligula, eget varius arcu nibh sed libero. Fusce ante. Nullam interdum aliquet metus. Ut ultrices vestibulum tellus. Praesent quis erat. Nam id turpis sit amet neque cursus luctus. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Quisque id tortor. In vitae sapien. Nunc quis tellus.</p>', 1, 5, 0, 42, '2010-07-21 21:33:23', 63, '', '2010-07-29 00:27:55', 63, 0, '0000-00-00 00:00:00', '2010-07-21 21:33:23', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 3, 0, 18, '', '', 0, 2, 'robots=\nauthor=');
INSERT INTO `#__content` (`id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`) VALUES
(54, 'Tutorials and Guides', 'tutorials-and-guides', '', '<p><em class="bold2">Written Tutorials</em></p>\r\n\r\n<div class="rt-demo-grid-3a rt-demo-grid-alpha">\r\n	<ul class="bullet-1">\r\n		<li><a href="index.php?option=com_content&amp;view=article&amp;id=55&amp;Itemid=63">Installation</a></li>\r\n		<li><a href="index.php?option=com_content&amp;view=article&amp;id=56&amp;Itemid=64">RocketLauncher</a></li>\r\n		<li><a href="index.php?option=com_content&amp;view=article&amp;id=57&amp;Itemid=65">Style Control</a></li>\r\n	</ul>\r\n</div>\r\n<div class="rt-demo-grid-3a">\r\n	<ul class="bullet-1">\r\n		<li><a href="http://www.gantry-framework.org/documentation" target="_blank">Gantry Documentation</a></li>\r\n		<li><a href="index.php?option=com_content&amp;view=article&amp;id=58&amp;Itemid=66">Menu Options</a></li>\r\n		<li><a href="index.php?option=com_content&amp;view=article&amp;id=100&amp;Itemid=214">Fusion Menu</a></li>\r\n	</ul>\r\n</div>\r\n<div class="rt-demo-grid-3a rt-demo-grid-omega">\r\n	<ul class="bullet-1">\r\n		<li><a href="index.php?option=com_content&amp;view=article&amp;id=59&amp;Itemid=67">Logo Editing</a></li>\r\n		<li><a href="index.php?option=com_content&amp;view=article&amp;id=60&amp;Itemid=68">Using Typography</a></li>\r\n		<li><a href="index.php?option=com_content&amp;view=article&amp;id=63&amp;Itemid=55">Color Chooser</a></li>\r\n	</ul>\r\n</div>\r\n\r\n<div class="clear"></div>\r\n\r\n<p><em class="bold2">Video Tutorials</em></p>\r\n\r\n<div class="rt-demo-grid-3a rt-demo-grid-alpha">\r\n	<ul class="bullet-1">\r\n		<li><a href="http://www.rockettheme.com/video/joomla15/template-installation-joomla15.mov" title="Video Tutorial :: Joomla Template Installation Video Tutorial" rel="rokbox[800 620]">Template Installation Video</a></li>\r\n		<li><a href="http://www.rockettheme.com/video/joomla15/menu-configuration-joomla15.mov" title="Video Tutorial :: Joomla Menu Setup Video Tutorial" rel="rokbox[504 336]">Menu Setup Video</a></li>\r\n	</ul>\r\n</div>\r\n<div class="rt-demo-grid-3a">\r\n	<ul class="bullet-1">\r\n		<li><a href="http://www.rockettheme.com/video/joomla15/using-typography-joomla15.mov" title="Video Tutorial :: Joomla Using Typography Video Tutorial" rel="rokbox[540 380]">Using Typography Video</a></li>\r\n		<li><a href="http://www.rockettheme.com/video/joomla15/installing-rocketlauncher-joomla15.mov" title="Video Tutorial :: Joomla RocketLauncher Installation Video Tutorial" rel="rokbox[503 356]">RocketLauncher Installation Video</a></li>\r\n	</ul>\r\n</div>		\r\n<div class="rt-demo-grid-3a rt-demo-grid-omega">\r\n	<ul class="bullet-1">	\r\n		<li><a href="video/logo.mov" title="Video Tutorial :: Zephyr Logo Editing Video Tutorial" rel="rokbox[504 306]">Zephyr Logo Editing Video</a></li>\r\n		<li><a href="http://www.gantry-framework.org/documentation" target="_blank">Gantry Video Tutorials</a></li>\r\n	</ul>\r\n</div>\r\n\r\n<div class="clear"></div>\r\n\r\n<p><em class="bold2">Forum Tutorials &amp; Guides</em></p>\r\n\r\n<div class="rt-demo-grid-3a rt-demo-grid-alpha">\r\n	<ul class="bullet-1">\r\n		<li><a href="http://www.rockettheme.com/forum/index.php?f=393&amp;t=105978&amp;rb_v=viewtopic" target="_blank">Demo Content Information</a></li>\r\n		<li><a href="http://www.rockettheme.com/forum/index.php?f=393&amp;t=105976&amp;rb_v=viewtopic" target="_blank">Editing Template Text</a></li>\r\n	</ul>\r\n</div>\r\n<div class="rt-demo-grid-3a">\r\n	<ul class="bullet-1">\r\n		<li><a href="http://www.rockettheme.com/forum/index.php?f=393&amp;t=105791&amp;rb_v=viewtopic" target="_blank">RokBox Member Login</a></li>\r\n		<li><a href="http://www.rockettheme.com/forum/index.php?f=393&amp;t=105975&amp;rb_v=viewtopic" target="_blank">Editing the Logo</a></li>\r\n	</ul>\r\n</div>		\r\n<div class="rt-demo-grid-3a rt-demo-grid-omega">\r\n	<ul class="bullet-1">\r\n		<li><a href="http://www.rockettheme.com/forum/index.php?f=393&amp;t=105718&amp;rb_v=viewtopic" target="_blank">RokIntroScroller Tutorial</a></li>\r\n		<li><a href="http://www.rockettheme.com/forum/index.php?f=393&amp;t=105718&amp;rb_v=viewtopic" target="_blank">Popup Module Tutorial</a></li>\r\n	</ul>\r\n</div>\r\n\r\n<div class="clear"></div>\r\n<br />\r\n<div class="module-title"><h3 class="title">Template Configuration &amp; Setup</h3></div>\r\n\r\n<p>Go to <strong>Extensions &rarr; Template Manager &rarr; rt_zephyr_j15</strong>. Mouseover the labels to view a description of each parameter.</p>\r\n\r\n\r\n<p><em class="bold2">IE6 PNG Fix</em></p>\r\n\r\n<p>To allow for transparent PNG32 images, add <em class="bold">class=&quot;png&quot;</em> to the element, such as in the examples below:</p>\r\n\r\n<pre>\r\n&lt;img src=&quot;images/sample1.png&quot; alt=&quot;sample&quot; /&gt;\r\n\r\n</pre>\r\n\r\n<p>Change to</p>\r\n\r\n<pre>\r\n&lt;img src=&quot;images/sample1.png&quot; alt=&quot;sample&quot; <em class="bold">class="png"</em> /&gt;\r\n\r\n</pre>', '', 1, 5, 0, 34, '2010-07-18 23:36:13', 62, '', '2010-07-31 20:03:25', 63, 0, '0000-00-00 00:00:00', '2010-07-18 23:36:13', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 12, 0, 10, '', '', 0, 77, 'robots=\nauthor='),
(55, 'Installation Instructions', 'installation-instructions', '', '<div class="notice"><div class="typo-icon"><strong>Note:</strong> The <strong>Bundle</strong> Template is only necessary if the Gantry Library is not installed at <strong> /components/com_gantry</strong>.</div></div>\r\n\r\n<div class="module-title"><h3 class="title">Step 1 - Download</h3></div>\r\n\r\n<div class="rt-demo-grid-4">\r\n<p><em class="bold2">Necessary Files</em></p>\r\n\r\n<p>Files required for the template to function:</p>\r\n\r\n<ul class="bullet-crank">\r\n	<li><strong>Template (Standalone)</strong> <em>rt_zephyr_j15.tgz</em> - Standalone template file.</li>\r\n	<li><strong>Template (Bundle)</strong> <em>rt_zephyr_j15-bundle.tar.gz</em> - Template plus Gantry Component.</li>\r\n	<li><strong>RokNavMenu</strong> <em>rt_zephyr_j15-extensions.zip(<strong>unzip first</strong>) or mod_roknavmenu.zip</em> - Required for the menu to work..</li>\r\n</ul>\r\n</div>\r\n<div class="rt-demo-grid-4">\r\n<p><em class="bold2">Additional Files</em></p>\r\n\r\n<p>Ancillary files for the template:</p>\r\n\r\n<ul class="bullet-notes">\r\n	<li><strong>Source PNG(s)</strong> <em>rt_zephyr_j15-sources.zip</em> - Adobe&reg; Fireworks PNG source file(s) and any applicable fonts.</li>\r\n	<li><strong>Extensions</strong> <em>rt_zephyr_j15-extensions.zip</em> - All extensions for the template.</li>\r\n	<li><strong>RocketLauncher</strong> <em>rt_zephyr_j15-rocketlauncher.zip</em> - Demo replica installer.</li>\r\n</ul>\r\n</div>\r\n<div class="clear"></div>\r\n\r\n<div class="note"><div class="typo-icon">The latest extensions can be downloaded from the Extensions Download area located <a href="http://www.rockettheme.com/extensions-downloads/" target="-blank">here</a></div></div>\r\n\r\n<div class="module-title"><h3 class="title">Step 2 - Installation</h3></div>\r\n\r\n<p>Install from <strong>Admin &rarr; Extensions &rarr; Install/Uninstall &rarr; Choose File &rarr; Select file &rarr; Upload File &amp; Install</strong></p>\r\n\r\n<p><img width="650" height="317" class="rt-image" alt="Image" src="images/stories/demo/general/install1.jpg" /></p>\r\n\r\n<div class="module-title"><h3 class="title">Step 3 - Template Default</h3></div>\r\n\r\n<p>Make the template default at Admin &rarr; Extensions &rarr; Template Manager &rarr; rt_zephyr_j15 &rarr; Default</p>\r\n\r\n<img width="650" height="272" class="rt-image nomarginbottom" alt="Image" src="images/stories/demo/general/install2.jpg" />', '', 1, 5, 0, 34, '2010-07-18 23:36:33', 62, '', '2010-07-30 17:17:49', 63, 0, '0000-00-00 00:00:00', '2010-07-18 23:36:33', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 23, 0, 11, '', '', 0, 65, 'robots=\nauthor='),
(56, 'RocketLauncher Setup', 'rocketlauncher-setup', '', '<div class="alert"><div class="typo-icon"><strong>Note</strong>: All sample content images will be replaced with blank versions in the RocketLauncher version.</div></div>\r\n\r\n<p><strong>RocketLauncher</strong> is a customized <strong>Joomla</strong> install, that installs a <strong>replica</strong> of the <strong>demo</strong> onto your site - inclusive of sample data, content, extensions, the template and sample images.</p>\r\n\r\n<div class="note"><div class="typo-icon"><strong>Note:</strong> We always recommend installing a RocketLauncher first to trial and understand the template more efficiently.\r\n<br />\r\nIt must be installed as <strong>new</strong>, and <strong>not</strong> over an existing Joomla install.	\r\n</div></div>\r\n\r\n<div class="module-title"><h3 class="title">Step 1 - Upload</h3></div>\r\n\r\n<ul class="bullet-1">\r\n	<li><strong>Download</strong> the RocketLauncher <em>(rt_zephyr_j15-rocketlauncher.zip)</em></li>\r\n	<li><strong>Unzip</strong> to reveal the <em>rt_zephyr_j15-rocketlauncher</em> folder</li>\r\n	<li><strong>Upload</strong></li>\r\n</ul>\r\n\r\n<div class="notice"><div class="typo-icon"><strong>Note;</strong> You can upload all the files via FTP, or use cPanel or SSH to upload the zip and unzip directly onto the server. Enquire with your hosting provider.</div></div>\r\n\r\n<div class="module-title"><h3 class="title">Step 2 - Installation</h3></div>\r\n\r\n<ul class="bullet-1">\r\n	<li>Go to <a href="#">www.yoursite.com/rt_zephyr_j15-rocketlauncher</a></li>\r\n	<li>Follow the Installation instructions</li>\r\n	<li>Ensure you click <em class="bold2">Install Sample Data</em> during installation</li>\r\n	<li>Delete the <strong>/installation</strong> directory on your server</li>\r\n</ul>\r\n\r\n<div class="alert"><div class="typo-icon">Ensure you click <em class="bold2">Install Sample Data</em> during installation, otherwise your site will be blank.</div></div>', '', 1, 5, 0, 34, '2010-07-18 23:36:51', 62, '', '2010-07-29 21:01:56', 63, 0, '0000-00-00 00:00:00', '2010-07-18 23:36:51', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 9, 0, 12, '', '', 0, 30, 'robots=\nauthor='),
(57, 'Style Control', 'style-control', '', '<div class="camera"><div class="typo-icon">Preview all available styles and any associated combination at the <a href="index.php?option=com_content&amp;view=article&amp;id=61&amp;Itemid=69">Preset Styles</a> page.</div></div>\r\n\r\n<div class="module-title"><h3 class="title">Access Style Control</h3></div>\r\n\r\n<p>Access the Style Control settings from <strong>Admin &rarr; Extensions &rarr; Template Manager &rarr; rt_zephyr_j15 &rarr; Settings</strong>. Located here are both the Color Chooser and Other Style Controls settings.</p>\r\n\r\n<p><img width="650" height="350" src="images/stories/demo/general/color-1.jpg" alt="Image" class="rt-image" /></p>\r\n\r\n<div class="module-title"><h3 class="title">Configuration</h3></div>\r\n\r\n<p>The options are as follows, and the areas that they control are indicative in their name:</p>\r\n\r\n<ul class="bullet-1">\r\n	<li><strong>Style Presets:</strong> Preset 1 to Preset 12</li>\r\n	<li><strong>Static CSS:</strong> On - Off</li>\r\n	<li><strong>Body Level:</strong> High or Low</li>\r\n	<li><strong>Background Image:</strong> <em>List of Images</em></li>\r\n	<li><strong><em>Color Chooser Options:</em></strong> Main, Header, Body, Footer, Feature, Showcase, Utility, Bottom, Navigation - <a href="index.php?option=com_content&amp;view=article&amp;id=63&amp;Itemid=55">more information</a></li>\r\n	<li><strong>Read More Style:</strong> Button or Link</li>\r\n	<li><strong>Article Style:</strong> Default, Title1-6</li>\r\n	<li><strong>Article Overlay:</strong> Light or Dark</li>\r\n	<li><strong>Article Info Style:</strong> Layout1-3</li>\r\n	<li><strong>Fixed Footer:</strong> On - Off</li>\r\n	<li><strong>Web Fonts:</strong> On - Off; Google Font Directory</li>\r\n	<li><strong>Font Settings</strong>:\r\n			<ul>\r\n				<li><strong>Font Family:</strong> Enigmatic, Geneva, Optima, Helvetica, Trebuchet, Lucida, Georgia, Palatino, or <strong>Various Google Fonts</strong> <em>(dropdown)</em></li>\r\n				<li><strong>Font Size:</strong> Default, Extra Large, Large, Small, Extra Small <em>(dropdown)</em></li>\r\n			</ul>\r\n		</li>\r\n</ul>\r\n\r\n<div class="note"><div class="typo-icon">Note: <strong>Gantry</strong> allows you to configure <em>all</em> parameters, on a <strong>per menu item</strong> basis. For example, you can assign preset2 to one page and preset4 to another.</div></div>\r\n\r\n<div class="module-title"><h3 class="title">Creating your own Preset Styles</h3></div>\r\n\r\n<ul class="bullet-1">\r\n	<li>Go to <strong>Extensions &rarr; Template Manager &rarr; rt_zephyr_j15 &rarr; Settings</strong></li>\r\n	<li>Configure the Settings</li>\r\n	<li>Click <strong>Save Custom Presets as New</strong></li>\r\n	<li>Follow the <strong>Preset Saver procedure</strong></li>\r\n</ul>\r\n\r\n<div class="notice"><div class="typo-icon">You can edit the prebuilt presets in the <strong>gantry.config.php</strong> file.</div></div>\r\n\r\n<p>\r\n	<img width="315" height="212" class="rt-image floatleft" alt="Image" src="images/stories/demo/general/style-1.jpg" />\r\n	<img width="315" height="212" class="rt-image" alt="Image" src="images/stories/demo/general/style-2.jpg" />\r\n</p>\r\n\r\n<div class="clear"></div>\r\n\r\n<div class="module-title"><h3 class="title">Assigning a Style to a Specific Page</h3></div>\r\n\r\n<img src="images/stories/demo/general/style-3.jpg" alt="Image" class="rt-image floatright" width="315" height="319" />\r\n\r\n<p>With Gantry, the ability to assign a certain style to an individual page has never been easier and/or more efficient. Just follow these simple steps:</p>\r\n\r\n<ul class="bullet-1">\r\n	<li>Go to <strong>Extensions &rarr; Template Manager &rarr; rt_zephyr_j15</strong></li>\r\n	<li>Select the <strong>Menu Items</strong> tab - located in the right column of the page in the orange box</li>\r\n	<li>Choose a menu item you wish to assign a different style to</li>\r\n	<li>Select your preset of choice from the <strong>Presets &rarr; Style Presets</strong> parameter area</li>\r\n	<li>Configure the <strong>Settings</strong> area to your personal preferences</li>\r\n	<li>Save</li>\r\n</ul>\r\n\r\n[readon url="http://gantry-framework.org/documentation/joomla/configure/per-menu-item-configuration"]Gantry Framework: Per Menu Item Configuration [/readon]', '', 1, 5, 0, 34, '2010-07-18 23:37:05', 62, '', '2010-07-30 22:44:02', 63, 0, '0000-00-00 00:00:00', '2010-07-18 23:37:05', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 14, 0, 13, '', '', 0, 37, 'robots=\nauthor='),
(58, 'Menu Options', 'menu-options', '', '<div class="alert"><div class="typo-icon">Please ensure you are using the latest version of RokNavMenu, available <a href="http://www.rockettheme.com/extensions-joomla/roknavmenu" target="_blank">here</a>.</div></div>\r\n\r\n<div class="module-title"><h3 class="title">Menu Types</h3></div>\r\n\r\n<div class="rt-demo-grid-3a rt-demo-grid-alpha">\r\n	<ul class="bullet-notes">\r\n		<li><em class="bold2"><a href="index.php?option=com_content&amp;view=article&amp;id=58&amp;Itemid=66&amp;menu-type=fusionmenu">Fusion Menu</a></em><br />\r\n		A Mootools enhanced CSS dropdown menu, with multi-columns, icons and more.</li>\r\n	</ul>\r\n</div>\r\n<div class="rt-demo-grid-3a">\r\n	<ul class="bullet-notes">\r\n		<li><em class="bold2"><a href="index.php?option=com_content&amp;view=article&amp;id=58&amp;Itemid=66&amp;menu-type=splitmenu">SplitMenu</a></em><br /> \r\n		A static two level menu placing parents items in the header area, and child items in the sidebar.</li>\r\n	</ul>\r\n</div>\r\n<div class="rt-demo-grid-3a rt-demo-grid-omega">\r\n	<ul class="bullet-notes">\r\n		<li><em class="bold2"><a href="index.php?option=com_content&amp;view=article&amp;id=58&amp;Itemid=66&amp;menu-type=nomenu">No Menu</a></em><br />\r\n		An option to disable the menu, allowing for normal module use of the <strong>navigation</strong> position.</li>\r\n	</ul>\r\n</div>\r\n<div class="clear"></div>\r\n\r\n<div class="notice"><div class="typo-icon">Fusion is inoperable in <strong>IE6</strong>, and will automatically switch to <strong>Suckerfish</strong>.</div></div>\r\n\r\n<div class="module-title"><h3 class="title">Configuration</h3></div>\r\n\r\n<p>Go to <strong>Extensions &rarr; Template Manager &rarr; rt_zephyr_j15 &rarr; Menu Control</strong> to find all the parameters for Fusion Menu and Splitmenu, such as transitions, duration and sublevel position.</p>\r\n\r\n<div class="attention"><div class="typo-icon">Descriptions of each template parameter can be seen when you mouseover the label of each option.</div></div>\r\n\r\n<br />\r\n<div class="module-title"><h3 class="title">Fusion Menu <em>with Mega Menu</em></h3></div>\r\n\r\n<p><strong>Fusion Menu</strong> is a menu theme of the <strong>RokNavMenu</strong> extension, the addon that drives all RocketTheme template menus. It is primarily a javascript enhanced CSS dropdown menu, that combines standard suckerfish type functionality with animations, transitions and other advanced effects provided by Mootools.</p>\r\n\r\n<div class="alert"><div class="typo-icon"><strong>NOTE:</strong> The latest version of <a target="_blank" href="http://www.rockettheme.com/extensions-joomla/roknavmenu">RokNavMenu</a> is required, in order for Fusion to operate.</div></div>\r\n\r\n<div class="rt-demo-grid-4">\r\n<p><em class="bold2">New Features</em></p>\r\n\r\n<p>In Zephyr, Fusion Menu has been extended with the following features:</p>\r\n\r\n<ul class="bullet-check">\r\n	<li>Triple / Quad Column Mode</li>\r\n	<li>Column Menu Grouping</li>\r\n	<li>Column Width Control</li>\r\n	<li>Load Modules inside Dropdowns</li>\r\n	<li>Load Module Positions inside Dropdowns</li>\r\n</ul>\r\n</div>\r\n<div class="rt-demo-grid-4">\r\n<p><em class="bold2">Recurring Features</em></p>\r\n\r\n<p>Below is a list of the standard, recurring features of the Fusion Menu:</p>\r\n\r\n<ul class="bullet-check">\r\n	<li>Single Column Mode</li>\r\n	<li>Dual Column Mode</li>\r\n	<li>Menu Item Subtext</li>\r\n	<li>Menu Item Icons</li>\r\n	<li>Javascript Controls</li>\r\n</ul>\r\n</div>\r\n<div class="clear"></div>\r\n\r\n[readon url="index.php?option=com_content&amp;view=article&amp;id=100&amp;Itemid=214"]Documentation: Fusion Menu[/readon]\r\n\r\n<br />\r\n<div class="module-title"><h3 class="title">Splitmenu</h3></div>\r\n\r\n<p>A static menu system that displays submenu items outside of the main horizontal menu and the 2nd level items in the Sidebar.</p>\r\n\r\n<p><em class="bold2">Template Configuration: Splitmenu</em></p>\r\n\r\n<p>Go to <strong>Extensions &rarr; Template Manager &rarr; rt_zephyr_j15 &rarr; Menu</strong> Set <strong>Menu Control</strong> to <strong>Type</strong> : <strong>Split-Menu</strong>, to load all the Splitmenu parameters.</p>\r\n\r\n<p>\r\n	<img src="images/stories/demo/menu/tut-menu-26.jpg" alt="Image" width="522" height="270" class="rt-image" />\r\n</p>\r\n\r\n<p><em class="bold2">Menu Item Parameters: Subtext</em></p>\r\n\r\n<p><strong>Subtext Line</strong> is the option that allows you to insert additional text to the <strong>Menu Item Title</strong>. There is separate styling for this, making it useful for adding brief descriptions to menu items.</p>\r\n\r\n<p>\r\n	<img src="images/stories/demo/menu/tut-menu-27.jpg" alt="Image" width="315" height="212" class="rt-image floatleft" />\r\n	<img src="images/stories/demo/menu/tut-menu-28.jpg" alt="Image" width="315" height="212" class="rt-image" />	\r\n</p>\r\n\r\n<p><em class="bold2">Code Modification: Remove the <em class="normal">Menu</em> in the Title</em></p>\r\n\r\n<p>Open <strong>/templates/rt_zephyr_j15/html/modules.php</strong> and change:</p>\r\n\r\n<pre class="extended-pre">\r\n&lt;?php echo $menu_title_item-&gt;name.&#x27; &#x27;.JText::_(&#x27;Menu&#x27;); ?&gt;\r\n\r\n</pre>\r\n\r\n<p>To</p>\r\n\r\n<pre class="extended-pre">\r\n&lt;?php echo $menu_title_item-&gt;name; ?&gt;\r\n\r\n</pre>\r\n\r\n<br />\r\n<div class="module-title"><h3 class="title">How to create Child / Sublevel menu items in Joomla</h3></div>\r\n\r\n<p>Go to <strong>Admin &rarr; Menu &rarr; <em>A Menu</em> &rarr; <em>A Menu Item</em> &rarr; Select a <em>Parent Item</em></strong>, and it will appear as a child of it.</p>\r\n\r\n<p>\r\n	<img src="images/stories/demo/menu/tut-menu-29.jpg" alt="Image" width="315" height="212" class="rt-image floatleft" />\r\n	<img src="images/stories/demo/menu/tut-menu-30.jpg" alt="Image" width="315" height="212" class="rt-image" />	\r\n</p>', '', 1, 5, 0, 34, '2010-07-18 23:37:35', 62, '', '2010-07-30 04:55:47', 63, 0, '0000-00-00 00:00:00', '2010-07-18 23:37:35', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 19, 0, 14, '', '', 0, 53, 'robots=\nauthor='),
(59, 'Logo Editing', 'logo-editing', '', '<div class="note"><div class="typo-icon">Gantry sets the dimensions of the logo, so CSS modification is unnecessary.</div></div>\r\n\r\n<p><em class="bold2">Logo Editing Requirements</em></p>\r\n\r\n<ul class="bullet-check">\r\n	<li><strong>Adobe&reg; Fireworks:</strong> CS5 is preferred, but CS3/4 will be sufficient.</li>\r\n	<li><strong>Logo Font:</strong> Download and install before proceeding to edit in Fireworks.</li>\r\n	<li><strong>Source File:</strong> Download the <strong>logo-source.png</strong> file from the rt_zephyr_j15-sources.zip package.</li>\r\n</ul>\r\n\r\n<br />\r\n<div class="module-title"><h3 class="title">Step 1 - Open the File</h3></div>\r\n\r\n<ul class="bullet-1">\r\n	<li>Open the <strong>logo-source.png</strong> file in Adobe&reg; Fireworks.</li>\r\n</ul>\r\n\r\n<img src="images/stories/demo/logo/logo1-thumb.jpg" alt="Logo" width="351" height="101" class="rt-image floatnone" />\r\n\r\n<ul class="bullet-1">\r\n	<li>Focus on the right column, titled <strong>Layers</strong>. Select the <strong>Web layers</strong> directory and click the eye icon to the left of the logo slice (the green object). This will make the slice invisible so you can edit the file.</li>\r\n</ul>\r\n\r\n<br />\r\n<div class="module-title"><h3 class="title">Step 2 - Text/Slogan/Icon Editing</h3></div>\r\n\r\n<ul class="bullet-1">\r\n	<li>Double click on the logo text. Now you can edit the text of logo to your choosing.</li>\r\n</ul>\r\n<img src="images/stories/demo/logo/logo2-thumb.jpg" alt="Logo" width="351" height="101" class="rt-image floatnone" />\r\n<img src="images/stories/demo/logo/logo3-thumb.jpg" alt="Logo" width="351" height="101" class="rt-image floatnone" />\r\n\r\n<ul class="bullet-1">\r\n	<li>If necessary, move the location of the logo text.</li>\r\n</ul>\r\n<img src="images/stories/demo/logo/logo4-thumb.jpg" alt="Logo" width="351" height="101" class="rt-image floatnone" />\r\n\r\n<ul class="bullet-1">\r\n	<li>Select the slogan and disable/edit it as you wish.</li>\r\n</ul>\r\n<img src="images/stories/demo/logo/logo5-thumb.jpg" alt="Logo" width="351" height="101" class="rt-image floatnone" />\r\n\r\n<img src="images/stories/demo/logo/logo6-thumb.jpg" alt="Logo" width="351" height="101" class="rt-image floatnone" />\r\n\r\n<ul class="bullet-1">\r\n	<li>Now, select the icon and disable/edit it as you wish.</li>\r\n</ul>\r\n<img src="images/stories/demo/logo/logo7-thumb.jpg" alt="Logo" width="351" height="101" class="rt-image floatnone" />\r\n<img src="images/stories/demo/logo/logo8-thumb.jpg" alt="Logo" width="351" height="101" class="rt-image floatnone" />\r\n\r\n<br />\r\n<div class="module-title"><h3 class="title">Step 3 - Slice Modification</h3></div>\r\n\r\n<ul class="bullet-1">\r\n	<li>Reactivate the Slice in the Web Layers column, this will place a green rectangle over the logo image. Change the size of the slice (or move it) to match the new size if applicable.</li>\r\n</ul>\r\n\r\n<img src="images/stories/demo/logo/logo9-thumb.jpg" alt="Logo" width="351" height="101" class="rt-image floatnone" />\r\n<img src="images/stories/demo/logo/logo10-thumb.jpg" alt="Logo" width="351" height="101" class="rt-image floatnone" />\r\n\r\n<br />\r\n<div class="module-title"><h3 class="title">Step 4 - Export</h3></div>\r\n<ul class="bullet-1">\r\n	<li>Now you will want to export the logo. Right click on the image slice and select <strong>Exported Selected Slices...</strong> from the contextual menu. Proceed to export it to your computer for uploading.</li>\r\n</ul>\r\n<img src="images/stories/demo/logo/logo11-thumb.jpg" alt="Logo" width="351" height="101" class="rt-image floatnone" />\r\n\r\n<br />\r\n<div class="module-title"><h3 class="title">Step 5 - Multiple Frames/States</h3></div>\r\n<ul class="bullet-1">\r\n	<li>If there are multiple logos for a template, they are located in <strong>Frames</strong> or <strong>States</strong> within Fireworks.</li>\r\n</ul>\r\n<img src="images/stories/demo/logo/logo-frame1.jpg" alt="Logo" width="258" height="152" class="rt-image floatleft" />\r\n<img src="images/stories/demo/logo/logo-frame2.jpg" alt="Logo" width="321" height="136" class="rt-image floatnone" />\r\n<div class="clear"></div>\r\n\r\n<br />\r\n<div class="module-title"><h3 class="title">Step 6 - Uploading</h3></div>\r\n\r\n<ul class="bullet-1">\r\n	<li>Upload <strong>logo.png</strong> to the <strong>/templates/rt_zephyr_15/images/logo/*style*/</strong> directory</li>\r\n  <li>Clear your browser cache and refresh your site.</li>\r\n</ol>\r\n\r\n<div class="attention"><div class="typo-icon">If you cannot see your new logo, ensure you have uploaded it to the right directory and that the directory permissions are writeable. Enquire with your hosting provider.</div></div>', '', 1, 5, 0, 34, '2010-07-18 23:38:21', 62, '', '2010-07-31 07:11:26', 63, 0, '0000-00-00 00:00:00', '2010-07-18 23:38:21', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 13, 0, 15, '', '', 0, 37, 'robots=\nauthor='),
(60, 'Using Typography', 'using-typography', '', '<div class="notice"><div class="typo-icon">If you are using the TinyMCE editor, go to <strong>Extensions &rarr; Plugin Manager &rarr; TinyMCE 2.0 &rarr; Set Code Clean-up on Save to Never</strong>.</div></div>\r\n<br />\r\n<div class="module-title"><h3 class="title">Typography - RokCandy</h3></div>\r\n\r\n<div class="attention"><div class="typo-icon">View all RokCandy typography at the <a href="index.php?option=com_content&amp;view=article&amp;id=52&amp;Itemid=60">RokCandy Examples</a> page</div></div>\r\n\r\n<p>In this example, we will use the Attention Span Style - Syntax: <strong>&#91;div class="attention" class2="typo-icon"&#93;...&#91;/div&#93;</strong> syntax.</p>\r\n\r\n<ul class="bullet-1">\r\n	<li>Go to <strong>Content &rarr; Article Manager &rarr; Select an Article</strong>.</li>\r\n	<li>Insert <strong>&#91;div class="attention" class2="typo-icon"&#93;</strong> <em>.... some content ....</em> <strong>&#91;/div&#93;</strong></li>\r\n	<li>Save</li>\r\n</ul>\r\n<br />\r\n<div class="module-title"><h3 class="title">Typography - HTML</h3></div>\r\n\r\n<div class="attention"><div class="typo-icon">View all HTML typography at the <a href="index.php?option=com_content&amp;view=article&amp;id=51&amp;Itemid=59">HTML Examples</a> page</div></div>\r\n\r\n<p>In this example, we will use the Attention Span Style - Syntax: <strong>&lt;div class=&quot;attention&quot;&gt;&lt;div class=&quot;typo-icon&quot;&gt;...&lt;/div&gt;&lt;/div&gt;</strong> syntax.</p>\r\n\r\n\r\n<div class="rt-demo-grid-4">\r\n<p><em class="bold2">Content Editor</em></p>\r\n\r\n<ul class="bullet-1">\r\n	<li>Go to <strong>Content &rarr; Article Manager &rarr; Select an Article</strong>; or <strong>Extensions &rarr; Module Manager &rarr; A Module, for a custom module.</strong></li>\r\n	<li>Click the <strong>HTML mode</strong> or equivalent in your editor</li>\r\n	<li>Insert <strong>&lt;div class=&quot;attention&quot;&gt;&lt;div class=&quot;typo-icon&quot;&gt; ... some content ... &lt;/div&gt;&lt;/div&gt;</strong></li>\r\n	<li>Save</li>\r\n</ul>\r\n</div>\r\n\r\n<div class="rt-demo-grid-4">\r\n<p><em class="bold2">No Editor</em></p>\r\n\r\n<ul class="bullet-1">\r\n	<li>Go to <strong>Content &rarr; Article Manager &rarr; Select an Article</strong>; or <strong>Extensions &rarr; Module Manager &rarr; A Module, for a custom module.</strong></li>\r\n	<li>Click the <strong>HTML mode</strong> or equivalent in your editor</li>\r\n	<li>Insert <strong>&lt;div class=&quot;attention&quot;&gt;&lt;div class=&quot;typo-icon&quot;&gt; ... some content ... &lt;/div&gt;&lt;/div&gt;</strong></li>\r\n	<li>Save</li>\r\n</ul>\r\n</div>\r\n<div class="clear"></div>\r\n\r\n<div class="note"><div class="typo-icon">Note, with the Content Editor (WYSIWYG) enabled, you need to enter HTML mode.</div></div>', '', 1, 5, 0, 34, '2010-07-18 23:38:51', 62, '', '2010-07-30 22:42:16', 63, 0, '0000-00-00 00:00:00', '2010-07-18 23:38:51', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 9, 0, 16, '', '', 0, 25, 'robots=\nauthor='),
(61, 'Preset Styles', 'preset-styles', '', '<p>Zephyr has 12 preset styles / style variations. See the links below for guides on customizing/configuring styles.</p>\r\n\r\n<div class="rt-demo-grid-2">\r\n	[readon2 url="index.php?option=com_content&amp;view=article&amp;id=57&amp;Itemid=65"]Style Control[/readon2]\r\n</div>\r\n<div class="rt-demo-grid-2">\r\n	[readon2 url="index.php?option=com_content&amp;view=article&amp;id=63&amp;Itemid=55"]Color Chooser[/readon2]\r\n</div>\r\n\r\n<div class="rt-demo-grid-2">\r\n	[readon2 url="index.php?option=com_content&amp;view=article&amp;id=47&amp;Itemid=54"]Gantry Framework[/readon2]\r\n</div>\r\n<div class="clear"></div>\r\n\r\n<div class="notice"><div class="typo-icon">View all styles live by appending <strong>?presets=preset#</strong> or <strong>&amp;presets=preset#</strong> to the end of your URL such as <strong><a href="#">http://yoursite.com/index.php?presets=preset4</a></strong>.</div></div>\r\n\r\n<p>In sequential order, <strong>Preset 1 - Preset 12</strong>. Please click on the image to load a live example of each style variation.</p>\r\n\r\n\r\n<a href="index.php?option=com_content&amp;view=article&amp;id=61&amp;Itemid=69&amp;presets=preset1">\r\n	<img alt="Preset 1" src="images/stories/demo/styles/ss1.jpg" width="315" height="240" class="rt-image floatleft"/>\r\n</a>\r\n<a href="index.php?option=com_content&amp;view=article&amp;id=61&amp;Itemid=69&amp;presets=preset2">\r\n	<img alt="Preset 2" src="images/stories/demo/styles/ss2.jpg" width="315" height="240" class="rt-image"/>\r\n</a>\r\n\r\n<a href="index.php?option=com_content&amp;view=article&amp;id=61&amp;Itemid=69&amp;presets=preset3">\r\n	<img alt="Preset 3" src="images/stories/demo/styles/ss3.jpg" width="315" height="240" class="rt-image floatleft"/>\r\n</a>\r\n<a href="index.php?option=com_content&amp;view=article&amp;id=61&amp;Itemid=69&amp;presets=preset4">\r\n	<img alt="Preset 4" src="images/stories/demo/styles/ss4.jpg" width="315" height="240" class="rt-image"/>\r\n</a>\r\n\r\n<a href="index.php?option=com_content&amp;view=article&amp;id=61&amp;Itemid=69&amp;presets=preset5">\r\n	<img alt="Preset 5" src="images/stories/demo/styles/ss5.jpg" width="315" height="240" class="rt-image floatleft"/>\r\n</a>\r\n<a href="index.php?option=com_content&amp;view=article&amp;id=61&amp;Itemid=69&amp;presets=preset6">\r\n	<img alt="Preset 6" src="images/stories/demo/styles/ss6.jpg" width="315" height="240" class="rt-image"/>\r\n</a>\r\n\r\n<a href="index.php?option=com_content&amp;view=article&amp;id=61&amp;Itemid=69&amp;presets=preset7">\r\n	<img alt="Preset 7" src="images/stories/demo/styles/ss7.jpg" width="315" height="240" class="rt-image floatleft"/>\r\n</a>\r\n<a href="index.php?option=com_content&amp;view=article&amp;id=61&amp;Itemid=69&amp;presets=preset8">\r\n	<img alt="Preset 8" src="images/stories/demo/styles/ss8.jpg" width="315" height="240" class="rt-image"/>\r\n</a>\r\n\r\n<a href="index.php?option=com_content&amp;view=article&amp;id=61&amp;Itemid=69&amp;presets=preset9">\r\n	<img alt="Preset 9" src="images/stories/demo/styles/ss9.jpg" width="315" height="240" class="rt-image floatleft"/>\r\n</a>\r\n<a href="index.php?option=com_content&amp;view=article&amp;id=61&amp;Itemid=69&amp;presets=preset10">\r\n	<img alt="Preset 10" src="images/stories/demo/styles/ss10.jpg" width="315" height="240" class="rt-image"/>\r\n</a>\r\n\r\n<a href="index.php?option=com_content&amp;view=article&amp;id=61&amp;Itemid=69&amp;presets=preset11">\r\n	<img alt="Preset 11" src="images/stories/demo/styles/ss11.jpg" width="315" height="240" class="rt-image floatleft"/>\r\n</a>\r\n<a href="index.php?option=com_content&amp;view=article&amp;id=61&amp;Itemid=69&amp;presets=preset12">\r\n	<img alt="Preset 12" src="images/stories/demo/styles/ss12.jpg" width="315" height="240" class="rt-image"/>\r\n</a>\r\n\r\n<div class="clear"></div>\r\n\r\n<br />\r\n<div class="module-title"><h3 class="title">Article Details Layouts</h3></div>\r\n\r\n<p>The template has 3 layout styles for the Article Details, the block of information and tools concerning the content item such as Author.</p>\r\n\r\n<a href="index.php?option=com_content&amp;view=article&amp;id=61&amp;Itemid=69&amp;articledetails=layout1">\r\n	<img alt="Layout 1 1" src="images/stories/demo/styles/layout1.jpg" width="315" height="212" class="rt-image floatleft"/>\r\n</a>\r\n<a href="index.php?option=com_content&amp;view=article&amp;id=61&amp;Itemid=69&amp;articledetails=layout2">\r\n	<img alt="Layout 2" src="images/stories/demo/styles/layout2.jpg" width="315" height="212" class="rt-image"/>\r\n</a>\r\n\r\n<a href="index.php?option=com_content&amp;view=article&amp;id=61&amp;Itemid=69&amp;articledetails=layout3">\r\n	<img alt="Layout 3" src="images/stories/demo/styles/layout3.jpg" width="315" height="212" class="rt-image floatleft"/>\r\n</a>\r\n\r\n\r\n<img alt="Settings" src="images/stories/demo/styles/layout-settings.jpg" width="315" height="212" class="rt-image"/>', '', 1, 5, 0, 34, '2010-07-18 23:39:11', 62, '', '2010-07-31 19:37:32', 63, 0, '0000-00-00 00:00:00', '2010-07-18 23:39:11', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 14, 0, 17, '', '', 0, 97, 'robots=\nauthor='),
(62, 'Child Item', 'child-item', '', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec sit amet nibh. Vivamus non arcu. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam dapibus, tellus ac ornare aliquam, massa diam tristique urna, id faucibus lectus erat ut pede. Maecenas varius neque nec libero laoreet faucibus. Phasellus sodales, lectus sed vulputate rutrum, ipsum nulla lacinia magna, sed imperdiet ligula nisi eu ipsum. Donec nunc magna, posuere eget, aliquam in, vulputate in, lacus. Sed venenatis. Donec nec dolor vitae mauris dapibus ullamcorper. Etiam iaculis mollis tortor.</p>\r\n\r\n<p>In erat. Pellentesque erat. Mauris vehicula vestibulum justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nulla pulvinar est. Integer urna. Pellentesque pulvinar dui a magna. Nulla facilisi. Proin imperdiet. Aliquam ornare, metus vitae gravida dignissim, nisi nisl ultricies felis, ac tristique enim pede eget elit. Integer non erat nec turpis sollicitudin malesuada. Vestibulum dapibus. Nulla facilisi. Nulla iaculis, leo sit amet mollis luctus, sapien eros consectetur dolor, eu faucibus elit nibh eu nibh. Maecenas lacus pede, lobortis non, rhoncus id, tristique a, mi. Cras auctor libero vitae sem vestibulum euismod. Nunc fermentum.</p>\r\n\r\n<p>Mauris lobortis. Aliquam lacinia purus. Pellentesque magna. Mauris euismod metus nec tortor. Phasellus elementum, quam a euismod imperdiet, ligula felis faucibus enim, eu malesuada nunc felis sed turpis. Morbi convallis luctus tortor. Integer bibendum lacinia velit. Suspendisse mi lorem, porttitor ut, interdum et, lobortis a, lectus. Phasellus vitae est at massa luctus iaculis. In tincidunt.</p>\r\n\r\n<p>Integer fermentum elit in tellus. Integer ligula ipsum, gravida aliquet, fringilla non, interdum eget, ipsum. Praesent id dolor non erat viverra volutpat. Fusce tellus libero, luctus adipiscing, tincidunt vel, egestas vitae, eros. Vestibulum mollis, est id rhoncus volutpat, dolor velit tincidunt neque, vitae pellentesque ante sem eu nisl. Donec facilisis, magna eget elementum pellentesque, augue arcu aliquet eros, eget convallis mauris ante quis magna. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Aenean et libero. Nam aliquam. Quisque vitae tortor id neque dignissim laoreet. Duis eu ante. Integer at sapien. Praesent sed nisl tempor est pulvinar tristique. Maecenas non lorem quis mi laoreet adipiscing. Sed ac arcu. Sed tincidunt libero eu dolor. Cras pharetra posuere eros. Donec ac eros id diam tempor faucibus. Fusce feugiat consequat nulla. Vestibulum tincidunt vulputate ipsum.</p>\r\n\r\n<p>Nullam eget neque. Nullam imperdiet venenatis ligula. Integer a leo. Nunc consectetur. Maecenas sem. Proin vulputate, massa vel volutpat laoreet, purus erat pretium ligula, eget varius arcu nibh sed libero. Fusce ante. Nullam interdum aliquet metus. Ut ultrices vestibulum tellus. Praesent quis erat. Nam id turpis sit amet neque cursus luctus. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Quisque id tortor. In vitae sapien. Nunc quis tellus.</p>', '', 1, 5, 0, 34, '2010-07-18 23:39:55', 62, '', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2010-07-18 23:39:55', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 1, 0, 18, '', '', 0, 7, 'robots=\nauthor='),
(63, 'Color Chooser', 'color-chooser', '', '<p>Color Chooser is a Gantry-Admin based control interface which, through simple controls, allows you to change all color and style elements of the template, such as text and background color.</p>\r\n\r\n<div class="module-title"><h3 class="title">Access the Color Chooser</h3></div>\r\n\r\n<p>Access the Color Chooser from <strong>Admin &rarr; Extensions &rarr; Template Manager &rarr; rt_zephyr_j15 &rarr; Settings</strong></p>\r\n\r\n<p><img width="650" height="350" class="rt-image" alt="Image" src="images/stories/demo/general/color-1.jpg" /></p>\r\n\r\n<div class="module-title"><h3 class="title">Configuration</h3></div>\r\n\r\n<p>You can control 7 sections of the template, in 4 different aspects:</p>\r\n\r\n<div class="rt-demo-grid-4">\r\n<p><em class="bold2">Color Chooser Sections</em></p>\r\n\r\n<ul class="bullet-1">\r\n	<li>Body - <em>Background Area</em></li>\r\n	<li>Main - <em>Mainbody / Content Area</em></li>\r\n	<li>Navigation - <em>Menu Area</em></li>\r\n	<li>Header; Showcase; Feature; Utility; Bottom; Footer - <em>Module Position Rows</em></li>\r\n</ul>\r\n</div>\r\n<div class="rt-demo-grid-4">\r\n<p><em class="bold2">Section Controls</em></p>\r\n\r\n<ul class="bullet-1">\r\n	<li>Background Color</li>\r\n	<li>Overlay Type - <em>Light or Dark</em></li>	\r\n	<li>Text Color</li>\r\n	<li>Link Color</li>\r\n</ul>\r\n</div>\r\n\r\n<p><img width="650" height="681" class="rt-image" alt="Image" src="images/stories/demo/general/color-2.jpg" /></p>\r\n\r\n<p><em class="bold2">Configuration: Background Controls</em></p>\r\n\r\n<ul class="bullet-1">\r\n	<li><strong>Static CSS:</strong> Places all inline CSS into CSS files for increased performance</li>\r\n	<li><strong>Body Level:</strong> <em>High or Low</em> to reduce the detailing of the template such as no overlays</li>\r\n	<li><strong>Background Image:</strong> Select an image to display in the page backgorund</li>\r\n</ul>\r\n\r\n<p><img width="528" height="430" class="rt-image" alt="Image" src="images/stories/demo/general/color-6.jpg" /></p>\r\n\r\n<p><em class="bold2">MooRainbow &amp; Transparent Mode</em></p>\r\n\r\n<p>Click on the color icons to trigger the <strong>MooRainbow</strong> popup. Pick any <strong>color</strong> or <strong>transparent</strong>.</p>\r\n\r\n<p>\r\n	<img src="images/stories/demo/general/color-3.jpg" alt="Image" width="315" height="212" class="rt-image floatleft" />\r\n	<img src="images/stories/demo/general/color-4.jpg" alt="Image" width="315" height="212" class="rt-image" />	\r\n</p>\r\n\r\n<div class="module-title"><h3 class="title">Gantry Settings &rarr; General Style Controls</h3></div>\r\n\r\n<p>Theses settings are not directly affiliated with the Color Chooser portion, but affect the template styling nevertheless.</p>\r\n\r\n<p><img src="images/stories/demo/general/color-5.jpg" alt="Image" width="315" height="280" class="rt-image floatright" /></p>\r\n\r\n<ul class="bullet-1">\r\n	<li><strong>Read More Style:</strong> Button or Link</li>\r\n	<li><strong>Article Style:</strong> Default, Title1-6</li>\r\n	<li><strong>Article Overlay:</strong> Light or Dark</li>\r\n	<li><strong>Article Info Style:</strong> Layout1-3</li>\r\n	<li><strong>Fixed Footer:</strong> On - Off</li>\r\n	<li><strong>Web Fonts:</strong> On - Off; Google Font Directory</li>\r\n	<li><strong>Font Settings</strong>:\r\n			<ul>\r\n				<li><strong>Font Family:</strong> Enigmatic, Geneva, Optima, Helvetica, Trebuchet, Lucida, Georgia, Palatino, or <strong>Various Google Fonts</strong> <em>(dropdown)</em></li>\r\n				<li><strong>Font Size:</strong> Default, Extra Large, Large, Small, Extra Small <em>(dropdown)</em></li>\r\n			</ul>\r\n		</li>\r\n</ul>\r\n\r\n[readon url="index.php?option=com_content&amp;view=article&amp;id=57&amp;Itemid=65"]Learn more[/readon]', '', 1, 5, 0, 34, '2010-07-19 21:06:08', 62, '', '2010-07-30 18:20:18', 63, 0, '0000-00-00 00:00:00', '2010-07-19 21:06:08', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 16, 0, 3, '', '', 0, 92, 'robots=\nauthor='),
(64, 'Featured Article Headline', 'featured-article-headline', '', '<img src="images/stories/demo/rokstories/rokstories3.jpg" alt="image" />\r\n\r\nInteger consequat iaculis sollicitudin. Donec faucibus urna mattis ipsum egestas ullamcorper. Nam semper lacinia blandit. Integer aliquet quam sit amet nibh posuere pharetra. Fusce fermentum, neque ut tincidunt suscipit, tortor mauris placerat augue, at ultricies tortor ante id est.\r\n<br /><br />', '', 1, 5, 0, 37, '2009-06-11 06:09:41', 62, '', '2010-07-30 18:32:39', 63, 0, '0000-00-00 00:00:00', '2009-06-11 06:09:41', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 5, 0, 3, '', '', 0, 0, 'robots=\nauthor='),
(65, 'Another Featured Article', 'another-featured-article', '', '<img src="images/stories/demo/rokstories/rokstories2.jpg" alt="image" />\r\n\r\nPhasellus sit amet odio eros. Ut sagittis metus volutpat eros bibendum accumsan. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. In scelerisque aliquam tincidunt. Duis quis dui ac augue hendrerit elementum. Phasellus risus mauris, volutpat eget molestie vel, rhoncus eu lorem. Morbi a nisi quam.\r\n<br /><br />', '', 1, 5, 0, 37, '2009-06-11 06:11:38', 62, '', '2010-07-30 18:32:31', 63, 0, '0000-00-00 00:00:00', '2009-06-11 06:11:38', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 5, 0, 2, '', '', 0, 0, 'robots=\nauthor='),
(66, 'Important Featured Story', 'important-featured-story', '', '<img src="images/stories/demo/rokstories/rokstories1.jpg" alt="image" />\r\n\r\nPhasellus sit amet odio eros. Ut sagittis metus volutpat eros bibendum accumsan. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. In scelerisque aliquam tincidunt. Duis quis dui ac augue hendrerit elementum. Phasellus risus mauris, volutpat eget molestie vel, rhoncus eu lorem. Morbi a nisi quam.\r\n<br /><br />', '', 1, 5, 0, 37, '2009-06-11 06:12:23', 62, '', '2010-07-30 18:31:59', 63, 0, '0000-00-00 00:00:00', '2009-06-11 06:12:23', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 5, 0, 1, '', '', 0, 0, 'robots=\nauthor='),
(67, 'Ultimate Style Control', 'ultimate-style-control', '', '<p><img src="images/stories/demo/frontpage/rokstories1.jpg" alt="image" class="rt-image"/></p>\r\n\r\nZephyr, the August 2010 Template Club release, features an impressive assortment of stylistic tools, ranging from its completely transparent base, to an extensive array of Color Chooser controls.\r\n<br /><br />\r\n', '\r\n\r\n<p>In erat. Pellentesque erat. Mauris vehicula vestibulum justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nulla pulvinar est. Integer urna. Pellentesque pulvinar dui a magna. Nulla facilisi. Proin imperdiet. Aliquam ornare, metus vitae gravida dignissim, nisi nisl ultricies felis, ac tristique enim pede eget elit. Integer non erat nec turpis sollicitudin malesuada. Vestibulum dapibus. Nulla facilisi. Nulla iaculis, leo sit amet mollis luctus, sapien eros consectetur dolor, eu faucibus elit nibh eu nibh. Maecenas lacus pede, lobortis non, rhoncus id, tristique a, mi. Cras auctor libero vitae sem vestibulum euismod. Nunc fermentum.</p>\r\n\r\n<p>Mauris lobortis. Aliquam lacinia purus. Pellentesque magna. Mauris euismod metus nec tortor. Phasellus elementum, quam a euismod imperdiet, ligula felis faucibus enim, eu malesuada nunc felis sed turpis. Morbi convallis luctus tortor. Integer bibendum lacinia velit. Suspendisse mi lorem, porttitor ut, interdum et, lobortis a, lectus. Phasellus vitae est at massa luctus iaculis. In tincidunt.</p>', 1, 5, 0, 38, '2009-06-11 06:12:23', 62, '', '2010-07-31 01:21:29', 63, 0, '0000-00-00 00:00:00', '2009-06-11 06:12:23', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 13, 0, 1, '', '', 0, 5, 'robots=\nauthor=');
INSERT INTO `#__content` (`id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`) VALUES
(102, 'iPhone Compatible', 'iphone-compatible', '', '<p><img src="images/stories/demo/frontpage/rokstories5.jpg" alt="image" class="rt-image"/></p>\r\n\r\nZephyr supports mobile viewing on the iPhone, offering an intuitive mobile browsing experience, complete with an interactive Fusion Menu and extensive configuration options within the Gantry Framework.\r\n<br /><br />\r\n', '\r\n\r\n<p>In erat. Pellentesque erat. Mauris vehicula vestibulum justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nulla pulvinar est. Integer urna. Pellentesque pulvinar dui a magna. Nulla facilisi. Proin imperdiet. Aliquam ornare, metus vitae gravida dignissim, nisi nisl ultricies felis, ac tristique enim pede eget elit. Integer non erat nec turpis sollicitudin malesuada. Vestibulum dapibus. Nulla facilisi. Nulla iaculis, leo sit amet mollis luctus, sapien eros consectetur dolor, eu faucibus elit nibh eu nibh. Maecenas lacus pede, lobortis non, rhoncus id, tristique a, mi. Cras auctor libero vitae sem vestibulum euismod. Nunc fermentum.</p>\r\n\r\n<p>Mauris lobortis. Aliquam lacinia purus. Pellentesque magna. Mauris euismod metus nec tortor. Phasellus elementum, quam a euismod imperdiet, ligula felis faucibus enim, eu malesuada nunc felis sed turpis. Morbi convallis luctus tortor. Integer bibendum lacinia velit. Suspendisse mi lorem, porttitor ut, interdum et, lobortis a, lectus. Phasellus vitae est at massa luctus iaculis. In tincidunt.</p>', 1, 5, 0, 38, '2009-06-11 06:11:38', 62, '', '2010-07-31 18:01:17', 63, 0, '0000-00-00 00:00:00', '2009-06-11 06:11:38', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 4, 0, 6, '', '', 0, 0, 'robots=\nauthor='),
(68, 'Fusion with MegaMenu', 'fusion-with-megamenu', '', '<p><img src="images/stories/demo/frontpage/rokstories2.jpg" alt="image" class="rt-image"/></p>\r\n\r\nFusion has been expanded with MegaMenu features, ranging from the ability to group Child items inline, to being able to load modules / positions within the dropdowns, as well as extensive custom width controls.\r\n<br /><br />\r\n', '\r\n\r\n<p>In erat. Pellentesque erat. Mauris vehicula vestibulum justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nulla pulvinar est. Integer urna. Pellentesque pulvinar dui a magna. Nulla facilisi. Proin imperdiet. Aliquam ornare, metus vitae gravida dignissim, nisi nisl ultricies felis, ac tristique enim pede eget elit. Integer non erat nec turpis sollicitudin malesuada. Vestibulum dapibus. Nulla facilisi. Nulla iaculis, leo sit amet mollis luctus, sapien eros consectetur dolor, eu faucibus elit nibh eu nibh. Maecenas lacus pede, lobortis non, rhoncus id, tristique a, mi. Cras auctor libero vitae sem vestibulum euismod. Nunc fermentum.</p>\r\n\r\n<p>Mauris lobortis. Aliquam lacinia purus. Pellentesque magna. Mauris euismod metus nec tortor. Phasellus elementum, quam a euismod imperdiet, ligula felis faucibus enim, eu malesuada nunc felis sed turpis. Morbi convallis luctus tortor. Integer bibendum lacinia velit. Suspendisse mi lorem, porttitor ut, interdum et, lobortis a, lectus. Phasellus vitae est at massa luctus iaculis. In tincidunt.</p>', 1, 5, 0, 38, '2009-06-11 06:11:38', 62, '', '2010-07-31 17:48:31', 63, 0, '0000-00-00 00:00:00', '2009-06-11 06:11:38', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 9, 0, 2, '', '', 0, 2, 'robots=\nauthor='),
(69, 'Smart / Ajax Loading', 'smart-ajax-loading', '', '<p><img src="images/stories/demo/frontpage/rokstories3.jpg" alt="image" class="rt-image"/></p>\r\n\r\nGantry offers a series of performance boosting features, 2 of these are Image Smart Loading: only loading images within the browser window; and Ajax Loading: view new articles via Ajax versus a full browser reload.\r\n<br /><br />\r\n', '\r\n\r\n<p>In erat. Pellentesque erat. Mauris vehicula vestibulum justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nulla pulvinar est. Integer urna. Pellentesque pulvinar dui a magna. Nulla facilisi. Proin imperdiet. Aliquam ornare, metus vitae gravida dignissim, nisi nisl ultricies felis, ac tristique enim pede eget elit. Integer non erat nec turpis sollicitudin malesuada. Vestibulum dapibus. Nulla facilisi. Nulla iaculis, leo sit amet mollis luctus, sapien eros consectetur dolor, eu faucibus elit nibh eu nibh. Maecenas lacus pede, lobortis non, rhoncus id, tristique a, mi. Cras auctor libero vitae sem vestibulum euismod. Nunc fermentum.</p>\r\n\r\n<p>Mauris lobortis. Aliquam lacinia purus. Pellentesque magna. Mauris euismod metus nec tortor. Phasellus elementum, quam a euismod imperdiet, ligula felis faucibus enim, eu malesuada nunc felis sed turpis. Morbi convallis luctus tortor. Integer bibendum lacinia velit. Suspendisse mi lorem, porttitor ut, interdum et, lobortis a, lectus. Phasellus vitae est at massa luctus iaculis. In tincidunt.</p>', 1, 5, 0, 38, '2009-06-11 06:09:41', 62, '', '2010-07-31 17:57:05', 63, 0, '0000-00-00 00:00:00', '2009-06-11 06:09:41', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 8, 0, 5, '', '', 0, 0, 'robots=\nauthor='),
(78, 'Ultimate Style Control', 'ultimate-style-control', '', '<p><strong>Transparency</strong> lays at the heart of the Zephyr template, with the entire theme being developed around it. Every structural image is transparent to allow <strong>background colors</strong> to bleed through seamlessly.</p>			\r\n			\r\nIn unison is the <strong>Color Chooser</strong>, providing extension controls, in a user friendly interface, over all style in the template, ranging from <strong>background, text or link colors</strong> to the overlay styles.\r\n\r\n', '\r\n\r\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec sit amet nibh. Vivamus non arcu. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam dapibus, tellus ac ornare aliquam, massa diam tristique urna, id faucibus lectus erat ut pede. Maecenas varius neque nec libero laoreet faucibus. Phasellus sodales, lectus sed vulputate rutrum, ipsum nulla lacinia magna, sed imperdiet ligula nisi eu ipsum. Donec nunc magna, posuere eget, aliquam in, vulputate in, lacus. Sed venenatis. Donec nec dolor vitae mauris dapibus ullamcorper. Etiam iaculis mollis tortor.</p>\r\n\r\n<p>In erat. Pellentesque erat. Mauris vehicula vestibulum justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nulla pulvinar est. Integer urna. Pellentesque pulvinar dui a magna. Nulla facilisi. Proin imperdiet. Aliquam ornare, metus vitae gravida dignissim, nisi nisl ultricies felis, ac tristique enim pede eget elit. Integer non erat nec turpis sollicitudin malesuada. Vestibulum dapibus. Nulla facilisi. Nulla iaculis, leo sit amet mollis luctus, sapien eros consectetur dolor, eu faucibus elit nibh eu nibh. Maecenas lacus pede, lobortis non, rhoncus id, tristique a, mi. Cras auctor libero vitae sem vestibulum euismod. Nunc fermentum.</p>\r\n\r\n<p>Mauris lobortis. Aliquam lacinia purus. Pellentesque magna. Mauris euismod metus nec tortor. Phasellus elementum, quam a euismod imperdiet, ligula felis faucibus enim, eu malesuada nunc felis sed turpis. Morbi convallis luctus tortor. Integer bibendum lacinia velit. Suspendisse mi lorem, porttitor ut, interdum et, lobortis a, lectus. Phasellus vitae est at massa luctus iaculis. In tincidunt.</p>', 1, 5, 0, 34, '2010-07-20 01:22:44', 62, '', '2010-07-31 17:24:39', 63, 0, '0000-00-00 00:00:00', '2010-07-20 01:22:44', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=0\nshow_create_date=0\nshow_modify_date=0\nshow_pdf_icon=0\nshow_print_icon=0\nshow_email_icon=0\nlanguage=\nkeyref=\nreadmore=', 10, 0, 1, '', '', 0, 0, 'robots=\nauthor='),
(94, 'Template RTL Support', 'template-rtl-support', '', '<div class="feature-img-surround"><img src="images/stories/demo/frontpage/feature-example6.jpg" alt="image" class="feature-img" /></div>', '', 1, 5, 0, 44, '2010-07-21 00:00:00', 63, '', '2010-07-29 05:04:17', 63, 0, '0000-00-00 00:00:00', '2010-07-21 00:00:00', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 4, 0, 6, '', '', 0, 0, 'robots=\nauthor='),
(79, 'Tab One', 'tab-one', '', '<p><img width="90" height="60" src="images/stories/demo/rokstories/rokstories1_thumb.jpg" class="rt-image floatleft" alt="image"/> Donec sit amet nibh. Vivamus non arcu ipsum.</p>\r\n\r\n<p>Vestibulum at sem ut ipsum vesti bulum euismod sit amet arkyat.</p>\r\n\r\n[readon url="javascript:void(0);"]Read More[/readon]', '', 1, 5, 0, 40, '2010-07-20 01:30:25', 62, '', '2010-07-29 06:08:01', 63, 0, '0000-00-00 00:00:00', '2010-07-20 01:30:25', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 9, 0, 1, '', '', 0, 0, 'robots=\nauthor='),
(80, 'Tab Two', 'tab-two', '', '<p><img width="90" height="60" src="images/stories/demo/rokstories/rokstories2_thumb.jpg" class="rt-image floatleft" alt="image"/> Donec sit amet nibh. Vivamus non arcu ipsum.</p>\r\n\r\n<p>Vestibulum at sem ut ipsum vesti bulum euismod sit amet arkyat.</p>\r\n\r\n[readon url="javascript:void(0);"]Read More[/readon]', '', 1, 5, 0, 40, '2010-07-20 01:30:25', 62, '', '2010-07-29 06:08:14', 63, 0, '0000-00-00 00:00:00', '2010-07-20 01:30:25', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 7, 0, 2, '', '', 0, 0, 'robots=\nauthor='),
(82, 'Third Party Extensions Compatibility Styling', 'third-party-extensions-compatibility-styling', '', '<div class="rt-demo-grid-2"><a href="http://www.jomsocial.com" target="_blank"><img src="images/stories/demo/general/jomsocial.png" alt="image" class="rt-ext-img" width="140" height="35"/></a></div>\r\n<div class="rt-demo-grid-2"><a href="http://getk2.org/" target="_blank"><img src="images/stories/demo/general/k2.png" alt="image" class="rt-ext-img" width="106" height="42"/></a></div>\r\n<div class="rt-demo-grid-2"><a href="http://www.dioscouri.com/" target="_blank"><img src="images/stories/demo/general/tienda.png" alt="image" class="rt-ext-img" width="118" height="42"/></a></div>\r\n<div class="rt-demo-grid-2"><a href="http://virtuemart.net/" target="_blank"><img src="images/stories/demo/general/virtuemart.png" alt="image" class="rt-ext-img" width="126" height="34"/></a></div>\r\n\r\n<div class="clear"></div>\r\n\r\n<br /><p><strong>Compatibility</strong> styling constitutes basic CSS alterations to better integrate the extensions with the template, rather than full theme integration. Example extensions: <strong>K2, Tienda, <a href="http://www.joomlatune.com/jcomments-downloads.html" target="_blank">JComments</a>, Virtuemart and JomSocial</strong>.</p>\r\n\r\n<div class="alert"><div class="typo-icon"><strong>Note:</strong> All the extensions below and their peripheries will not be included in the RocketLauncher package. You will need to download and install separately.</div></div>\r\n\r\n<div class="module-title"><h3 class="title">Control Third Party Styling</h3></div>\r\n\r\n<p>Enabled or Disable from <strong>Admin &rarr; Extensions &rarr; Template Manager &rarr; rt_zephyr_j15 &rarr; Advanced &rarr; Third Party Styling</strong>. Disable if you are not using any of the extensions for performance purposes.</p>\r\n\r\n<div class="notice"><div class="typo-icon">All styling is located in the <strong>/templates/rt_zephyr_j15/css/extended.css</strong> file, so any customizations you wish to make, edit the contents of that CSS file.</div></div>', '', 1, 5, 0, 34, '2010-07-20 19:37:25', 62, '', '2010-07-31 20:06:37', 63, 0, '0000-00-00 00:00:00', '2010-07-20 19:37:25', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 17, 0, 19, '', '', 0, 50, 'robots=\nauthor='),
(83, 'JComments Demo', 'jcomments-demo', '', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec sit amet nibh. Vivamus non arcu. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam dapibus, tellus ac ornare aliquam, massa diam tristique urna, id faucibus lectus erat ut pede. Maecenas varius neque nec libero laoreet faucibus. Phasellus sodales, lectus sed vulputate rutrum, ipsum nulla lacinia magna, sed imperdiet ligula nisi eu ipsum. Donec nunc magna, posuere eget, aliquam in, vulputate in, lacus. Sed venenatis. Donec nec dolor vitae mauris dapibus ullamcorper. Etiam iaculis mollis tortor.</p>\r\n\r\n<p>In erat. Pellentesque erat. Mauris vehicula vestibulum justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nulla pulvinar est. Integer urna. Pellentesque pulvinar dui a magna. Nulla facilisi. Proin imperdiet. Aliquam ornare, metus vitae gravida dignissim, nisi nisl ultricies felis, ac tristique enim pede eget elit. Integer non erat nec turpis sollicitudin malesuada. Vestibulum dapibus. Nulla facilisi. Nulla iaculis, leo sit amet mollis luctus, sapien eros consectetur dolor, eu faucibus elit nibh eu nibh. Maecenas lacus pede, lobortis non, rhoncus id, tristique a, mi. Cras auctor libero vitae sem vestibulum euismod. Nunc fermentum.</p>\r\n\r\n{jcomments on}', '', 1, 5, 0, 41, '2010-07-21 00:09:36', 62, '', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2010-07-21 00:09:36', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 1, 0, 1, '', '', 0, 21, 'robots=\nauthor='),
(86, 'Madden 11', 'madden-11', '', '<img src="images/stories/demo/roknewspager/review3.jpg" class="floatleft" alt="Image" width="116" height="160"/>\r\n<p>Prepare for a new season with Madden 11...</p>\r\n\r\n', '\r\n<p>In erat. Pellentesque erat. Mauris vehicula vestibulum justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nulla pulvinar est. Integer urna. Pellentesque pulvinar dui a magna. Nulla facilisi. Proin imperdiet. Aliquam ornare, metus vitae gravida dignissim, nisi nisl ultricies felis, ac tristique enim pede eget elit. Integer non erat nec turpis sollicitudin malesuada. Vestibulum dapibus. Nulla facilisi. Nulla iaculis, leo sit amet mollis luctus, sapien eros consectetur dolor, eu faucibus elit nibh eu nibh. Maecenas lacus pede, lobortis non, rhoncus id, tristique a, mi. Cras auctor libero vitae sem vestibulum euismod. Nunc fermentum.</p>\r\n\r\n<p>Mauris lobortis. Aliquam lacinia purus. Pellentesque magna. Mauris euismod metus nec tortor. Phasellus elementum, quam a euismod imperdiet, ligula felis faucibus enim, eu malesuada nunc felis sed turpis. Morbi convallis luctus tortor. Integer bibendum lacinia velit. Suspendisse mi lorem, porttitor ut, interdum et, lobortis a, lectus. Phasellus vitae est at massa luctus iaculis. In tincidunt.</p>\r\n\r\n<p>Integer fermentum elit in tellus. Integer ligula ipsum, gravida aliquet, fringilla non, interdum eget, ipsum. Praesent id dolor non erat viverra volutpat. Fusce tellus libero, luctus adipiscing, tincidunt vel, egestas vitae, eros. Vestibulum mollis, est id rhoncus volutpat, dolor velit tincidunt neque, vitae pellentesque ante sem eu nisl. Donec facilisis, magna eget elementum pellentesque, augue arcu aliquet eros, eget convallis mauris ante quis magna. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Aenean et libero. Nam aliquam. Quisque vitae tortor id neque dignissim laoreet. Duis eu ante. Integer at sapien. Praesent sed nisl tempor est pulvinar tristique. Maecenas non lorem quis mi laoreet adipiscing. Sed ac arcu. Sed tincidunt libero eu dolor. Cras pharetra posuere eros. Donec ac eros id diam tempor faucibus. Fusce feugiat consequat nulla. Vestibulum tincidunt vulputate ipsum.</p>\r\n\r\n<p>Nullam eget neque. Nullam imperdiet venenatis ligula. Integer a leo. Nunc consectetur. Maecenas sem. Proin vulputate, massa vel volutpat laoreet, purus erat pretium ligula, eget varius arcu nibh sed libero. Fusce ante. Nullam interdum aliquet metus. Ut ultrices vestibulum tellus. Praesent quis erat. Nam id turpis sit amet neque cursus luctus. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Quisque id tortor. In vitae sapien. Nunc quis tellus.</p>', 1, 5, 0, 42, '2010-07-21 21:33:43', 63, '', '2010-07-29 00:25:43', 63, 0, '0000-00-00 00:00:00', '2010-07-21 21:33:43', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 4, 0, 15, '', '', 0, 2, 'robots=\nauthor='),
(87, 'FIFA ''11', 'fifa-11', '', '<img src="images/stories/demo/roknewspager/review2.jpg" class="floatleft rt-image" alt="Image" width="116" height="160"/>\r\n<p>Play on until the final whistle with the ''11 edition... </p>\r\n\r\n', '\r\n<p>In erat. Pellentesque erat. Mauris vehicula vestibulum justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nulla pulvinar est. Integer urna. Pellentesque pulvinar dui a magna. Nulla facilisi. Proin imperdiet. Aliquam ornare, metus vitae gravida dignissim, nisi nisl ultricies felis, ac tristique enim pede eget elit. Integer non erat nec turpis sollicitudin malesuada. Vestibulum dapibus. Nulla facilisi. Nulla iaculis, leo sit amet mollis luctus, sapien eros consectetur dolor, eu faucibus elit nibh eu nibh. Maecenas lacus pede, lobortis non, rhoncus id, tristique a, mi. Cras auctor libero vitae sem vestibulum euismod. Nunc fermentum.</p>\r\n\r\n<p>Mauris lobortis. Aliquam lacinia purus. Pellentesque magna. Mauris euismod metus nec tortor. Phasellus elementum, quam a euismod imperdiet, ligula felis faucibus enim, eu malesuada nunc felis sed turpis. Morbi convallis luctus tortor. Integer bibendum lacinia velit. Suspendisse mi lorem, porttitor ut, interdum et, lobortis a, lectus. Phasellus vitae est at massa luctus iaculis. In tincidunt.</p>\r\n\r\n<p>Integer fermentum elit in tellus. Integer ligula ipsum, gravida aliquet, fringilla non, interdum eget, ipsum. Praesent id dolor non erat viverra volutpat. Fusce tellus libero, luctus adipiscing, tincidunt vel, egestas vitae, eros. Vestibulum mollis, est id rhoncus volutpat, dolor velit tincidunt neque, vitae pellentesque ante sem eu nisl. Donec facilisis, magna eget elementum pellentesque, augue arcu aliquet eros, eget convallis mauris ante quis magna. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Aenean et libero. Nam aliquam. Quisque vitae tortor id neque dignissim laoreet. Duis eu ante. Integer at sapien. Praesent sed nisl tempor est pulvinar tristique. Maecenas non lorem quis mi laoreet adipiscing. Sed ac arcu. Sed tincidunt libero eu dolor. Cras pharetra posuere eros. Donec ac eros id diam tempor faucibus. Fusce feugiat consequat nulla. Vestibulum tincidunt vulputate ipsum.</p>\r\n\r\n<p>Nullam eget neque. Nullam imperdiet venenatis ligula. Integer a leo. Nunc consectetur. Maecenas sem. Proin vulputate, massa vel volutpat laoreet, purus erat pretium ligula, eget varius arcu nibh sed libero. Fusce ante. Nullam interdum aliquet metus. Ut ultrices vestibulum tellus. Praesent quis erat. Nam id turpis sit amet neque cursus luctus. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Quisque id tortor. In vitae sapien. Nunc quis tellus.</p>', 1, 5, 0, 42, '2010-07-21 21:33:23', 63, '', '2010-07-29 00:25:38', 63, 0, '0000-00-00 00:00:00', '2010-07-21 21:33:23', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 5, 0, 14, '', '', 0, 2, 'robots=\nauthor='),
(89, 'Starcraft II', 'starcraft-ii', '', '<img src="images/stories/demo/frontpage/sidebar1.jpg" alt="image" class="rt-image" width="180" height="235" />', '', 1, 5, 0, 43, '2010-07-22 02:03:50', 63, '', '2010-07-31 06:33:50', 63, 0, '0000-00-00 00:00:00', '2010-07-22 02:03:50', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 6, 0, 2, '', '', 0, 0, 'robots=\nauthor='),
(103, 'Custom RokStories Styling', 'custom-rokstories-styling', '', '<p><img src="images/stories/demo/frontpage/rokstories6.jpg" alt="image" class="rt-image"/></p>\r\n\r\nThe default layout of RokStories benefits from a new custom styling from the template, adding a vertical scrolling thumbnail list to the side of the main thumbnail image, providing a new possibility in displaying dynamic content.\r\n<br /><br />\r\n', '\r\n\r\n<p>In erat. Pellentesque erat. Mauris vehicula vestibulum justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nulla pulvinar est. Integer urna. Pellentesque pulvinar dui a magna. Nulla facilisi. Proin imperdiet. Aliquam ornare, metus vitae gravida dignissim, nisi nisl ultricies felis, ac tristique enim pede eget elit. Integer non erat nec turpis sollicitudin malesuada. Vestibulum dapibus. Nulla facilisi. Nulla iaculis, leo sit amet mollis luctus, sapien eros consectetur dolor, eu faucibus elit nibh eu nibh. Maecenas lacus pede, lobortis non, rhoncus id, tristique a, mi. Cras auctor libero vitae sem vestibulum euismod. Nunc fermentum.</p>\r\n\r\n<p>Mauris lobortis. Aliquam lacinia purus. Pellentesque magna. Mauris euismod metus nec tortor. Phasellus elementum, quam a euismod imperdiet, ligula felis faucibus enim, eu malesuada nunc felis sed turpis. Morbi convallis luctus tortor. Integer bibendum lacinia velit. Suspendisse mi lorem, porttitor ut, interdum et, lobortis a, lectus. Phasellus vitae est at massa luctus iaculis. In tincidunt.</p>', 1, 5, 0, 38, '2009-06-11 06:09:41', 62, '', '2010-07-31 17:53:22', 63, 0, '0000-00-00 00:00:00', '2009-06-11 06:09:41', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 4, 0, 4, '', '', 0, 0, 'robots=\nauthor='),
(90, 'Halo Reach', 'halo-reach', '', '<img src="images/stories/demo/frontpage/sidebar2.jpg" alt="image" class="rt-image" width="180" height="235" />', '', 1, 5, 0, 43, '2010-07-22 02:03:50', 63, '', '2010-07-31 06:33:56', 63, 0, '0000-00-00 00:00:00', '2010-07-22 02:03:50', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 6, 0, 1, '', '', 0, 0, 'robots=\nauthor='),
(104, 'Halo Reach', 'halo-reach', '', '<img src="images/stories/demo/roknewspager/review1.jpg" class="floatleft rt-image" alt="Image" width="116" height="160"/>\r\n<p><em>FPS</em>  - Expansion of the popular Halo Universe...</p>\r\n\r\n', '\r\n<p>In erat. Pellentesque erat. Mauris vehicula vestibulum justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nulla pulvinar est. Integer urna. Pellentesque pulvinar dui a magna. Nulla facilisi. Proin imperdiet. Aliquam ornare, metus vitae gravida dignissim, nisi nisl ultricies felis, ac tristique enim pede eget elit. Integer non erat nec turpis sollicitudin malesuada. Vestibulum dapibus. Nulla facilisi. Nulla iaculis, leo sit amet mollis luctus, sapien eros consectetur dolor, eu faucibus elit nibh eu nibh. Maecenas lacus pede, lobortis non, rhoncus id, tristique a, mi. Cras auctor libero vitae sem vestibulum euismod. Nunc fermentum.</p>\r\n\r\n<p>Mauris lobortis. Aliquam lacinia purus. Pellentesque magna. Mauris euismod metus nec tortor. Phasellus elementum, quam a euismod imperdiet, ligula felis faucibus enim, eu malesuada nunc felis sed turpis. Morbi convallis luctus tortor. Integer bibendum lacinia velit. Suspendisse mi lorem, porttitor ut, interdum et, lobortis a, lectus. Phasellus vitae est at massa luctus iaculis. In tincidunt.</p>\r\n\r\n<p>Integer fermentum elit in tellus. Integer ligula ipsum, gravida aliquet, fringilla non, interdum eget, ipsum. Praesent id dolor non erat viverra volutpat. Fusce tellus libero, luctus adipiscing, tincidunt vel, egestas vitae, eros. Vestibulum mollis, est id rhoncus volutpat, dolor velit tincidunt neque, vitae pellentesque ante sem eu nisl. Donec facilisis, magna eget elementum pellentesque, augue arcu aliquet eros, eget convallis mauris ante quis magna. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Aenean et libero. Nam aliquam. Quisque vitae tortor id neque dignissim laoreet. Duis eu ante. Integer at sapien. Praesent sed nisl tempor est pulvinar tristique. Maecenas non lorem quis mi laoreet adipiscing. Sed ac arcu. Sed tincidunt libero eu dolor. Cras pharetra posuere eros. Donec ac eros id diam tempor faucibus. Fusce feugiat consequat nulla. Vestibulum tincidunt vulputate ipsum.</p>\r\n\r\n<p>Nullam eget neque. Nullam imperdiet venenatis ligula. Integer a leo. Nunc consectetur. Maecenas sem. Proin vulputate, massa vel volutpat laoreet, purus erat pretium ligula, eget varius arcu nibh sed libero. Fusce ante. Nullam interdum aliquet metus. Ut ultrices vestibulum tellus. Praesent quis erat. Nam id turpis sit amet neque cursus luctus. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Quisque id tortor. In vitae sapien. Nunc quis tellus.</p>', 1, 5, 0, 42, '2010-07-21 21:33:23', 63, '', '2010-07-29 00:25:33', 63, 0, '0000-00-00 00:00:00', '2010-07-21 21:33:23', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 5, 0, 13, '', '', 0, 4, 'robots=\nauthor='),
(92, 'Google Web Fonts', 'google-web-fonts', '', '<div class="feature-img-surround"><img src="images/stories/demo/frontpage/feature-example8.jpg" alt="image" class="feature-img" /></div>', '', 1, 5, 0, 44, '2010-07-21 00:00:00', 63, '', '2010-07-29 05:03:58', 63, 0, '0000-00-00 00:00:00', '2010-07-21 00:00:00', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 5, 0, 8, '', '', 0, 1, 'robots=\nauthor='),
(93, 'Tableless Overrides', 'tableless-overrides', '', '<div class="feature-img-surround"><img src="images/stories/demo/frontpage/feature-example7.jpg" alt="image" class="feature-img" /></div>', '', 1, 5, 0, 44, '2010-07-21 00:00:00', 63, '', '2010-07-29 05:04:09', 63, 0, '0000-00-00 00:00:00', '2010-07-21 00:00:00', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 4, 0, 7, '', '', 0, 0, 'robots=\nauthor='),
(95, '68 Module Positions', '68-module-positions', '', '<div class="feature-img-surround"><img src="images/stories/demo/frontpage/feature-example5.jpg" alt="image" class="feature-img" /></div>', '', 1, 5, 0, 44, '2010-07-21 00:00:00', 63, '', '2010-07-29 04:54:23', 63, 0, '0000-00-00 00:00:00', '2010-07-21 00:00:00', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 3, 0, 5, '', '', 0, 0, 'robots=\nauthor='),
(96, 'Fusion with MegaMenu', 'fusion-with-megamenu', '', '<div class="feature-img-surround"><img src="images/stories/demo/frontpage/feature-example1.jpg" alt="image" class="feature-img" /></div>', '', 1, 5, 0, 44, '2010-07-21 00:00:00', 63, '', '2010-07-29 04:01:04', 63, 0, '0000-00-00 00:00:00', '2010-07-21 00:00:00', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 4, 0, 1, '', '', 0, 0, 'robots=\nauthor='),
(97, 'Transparent Design Base', 'transparent-design-base', '', '<div class="feature-img-surround"><img src="images/stories/demo/frontpage/feature-example2.jpg" alt="image" class="feature-img" /></div>', '', 1, 5, 0, 44, '2010-07-21 00:00:00', 63, '', '2010-07-29 04:01:32', 63, 0, '0000-00-00 00:00:00', '2010-07-21 00:00:00', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 3, 0, 2, '', '', 0, 0, 'robots=\nauthor='),
(98, 'Advanced Color Chooser', 'advanced-color-chooser', '', '<div class="feature-img-surround"><img src="images/stories/demo/frontpage/feature-example3.jpg" alt="image" class="feature-img" /></div>', '', 1, 5, 0, 44, '2010-07-21 00:00:00', 63, '', '2010-07-29 04:14:08', 63, 0, '0000-00-00 00:00:00', '2010-07-21 00:00:00', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 3, 0, 3, '', '', 0, 0, 'robots=\nauthor='),
(99, '72 Module Suffix Combos', '72-module-suffix-combos', '', '<div class="feature-img-surround"><img src="images/stories/demo/frontpage/feature-example4.jpg" alt="image" class="feature-img" /></div>', '', 1, 5, 0, 44, '2010-07-21 00:00:00', 63, '', '2010-07-29 04:14:53', 63, 0, '0000-00-00 00:00:00', '2010-07-21 00:00:00', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 3, 0, 4, '', '', 0, 0, 'robots=\nauthor='),
(101, '72 Module Suffix Combos', '72-module-suffix-combos', '', '<p><img src="images/stories/demo/frontpage/rokstories4.jpg" alt="image" class="rt-image"/></p>\r\n\r\nModule Variations form the core of the stylistic individualism of Zephyr, with 18 style based suffixes: 12 Box and 6 Title Styles. These suffixes can be compounded together to an impressive 72 possible combinations.\r\n<br /><br />\r\n', '\r\n\r\n<p>In erat. Pellentesque erat. Mauris vehicula vestibulum justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nulla pulvinar est. Integer urna. Pellentesque pulvinar dui a magna. Nulla facilisi. Proin imperdiet. Aliquam ornare, metus vitae gravida dignissim, nisi nisl ultricies felis, ac tristique enim pede eget elit. Integer non erat nec turpis sollicitudin malesuada. Vestibulum dapibus. Nulla facilisi. Nulla iaculis, leo sit amet mollis luctus, sapien eros consectetur dolor, eu faucibus elit nibh eu nibh. Maecenas lacus pede, lobortis non, rhoncus id, tristique a, mi. Cras auctor libero vitae sem vestibulum euismod. Nunc fermentum.</p>\r\n\r\n<p>Mauris lobortis. Aliquam lacinia purus. Pellentesque magna. Mauris euismod metus nec tortor. Phasellus elementum, quam a euismod imperdiet, ligula felis faucibus enim, eu malesuada nunc felis sed turpis. Morbi convallis luctus tortor. Integer bibendum lacinia velit. Suspendisse mi lorem, porttitor ut, interdum et, lobortis a, lectus. Phasellus vitae est at massa luctus iaculis. In tincidunt.</p>', 1, 5, 0, 38, '2009-06-11 06:12:23', 62, '', '2010-07-31 17:51:14', 63, 0, '0000-00-00 00:00:00', '2009-06-11 06:12:23', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 2, 0, 3, '', '', 0, 0, 'robots=\nauthor='),
(100, 'Fusion menu', 'fusion-menu', '', '<p><strong>Fusion Menu</strong> is a menu theme of the <strong>RokNavMenu</strong> extension, the addon that drives all RocketTheme template menus. It is primarily a javascript enhanced CSS dropdown menu, that combines standard suckerfish type functionality with animations, transitions and other advanced effects provided by Mootools.</p>\r\n\r\n<div class="alert"><div class="typo-icon"><strong>NOTE:</strong> The latest version of <a href="http://www.rockettheme.com/extensions-joomla/roknavmenu" target="_blank">RokNavMenu</a> is required, in order for Fusion to operate.</div></div>\r\n\r\n<div class="rt-demo-grid-4">\r\n<p><em class="bold2">New Features</em></p>\r\n\r\n<p>In Zephyr, Fusion Menu has been extended with the following features:</p>\r\n\r\n<ul class="bullet-check">\r\n	<li>Triple / Quad Column Mode</li>\r\n	<li>Column Menu Grouping</li>\r\n	<li>Column Width Control</li>\r\n	<li>Load Modules inside Dropdowns</li>\r\n	<li>Load Module Positions inside Dropdowns</li>\r\n</ul>\r\n</div>\r\n<div class="rt-demo-grid-4">\r\n<p><em class="bold2">Recurring Features</em></p>\r\n\r\n<p>Below is a list of the standard, recurring features of the Fusion Menu:</p>\r\n\r\n<ul class="bullet-check">\r\n	<li>Single Column Mode</li>\r\n	<li>Dual Column Mode</li>\r\n	<li>Menu Item Subtext</li>\r\n	<li>Menu Item Icons</li>\r\n	<li>Javascript Controls</li>\r\n</ul>\r\n</div>\r\n<div class="clear"></div>\r\n\r\n<br />\r\n<div class="module-title"><h3 class="title">Editing Menu Items</h3></div>\r\n\r\n<p>All Menu Items can be edited from <strong>Admin &rarr; Menu &rarr; <em>Menu Name</em> &rarr; <em>Menu Item</em></strong>.</p>\r\n\r\n<p><img src="images/stories/demo/menu/tut-menu-1.jpg" alt="Image" width="650" height="370" class="rt-image" /></p>\r\n\r\n<div class="module-title"><h3 class="title">Basic Fusion Parameters</h3></div>\r\n\r\n<p><em class="bold2">Adding Subtext</em></p>\r\n\r\n<p><strong>Subtext Line</strong> is the option that allows you to insert additional text to the <strong>Menu Item Title</strong>. There is separate styling for this, making it useful for adding brief descriptions to menu items.</p>\r\n\r\n<p>\r\n	<img src="images/stories/demo/menu/tut-menu-2.jpg" alt="Image" width="315" height="212" class="rt-image floatleft" />\r\n	<img src="images/stories/demo/menu/tut-menu-3.jpg" alt="Image" width="315" height="212" class="rt-image" />	\r\n</p>\r\n\r\n<p><em class="bold2">Adding Menu Icons</em></p>\r\n\r\n<p><strong>Menu Image</strong> is the option that allows you to insert an inline icon / image to the <strong>Menu Item</strong>.</p>\r\n\r\n<p>\r\n	<img src="images/stories/demo/menu/tut-menu-4.jpg" alt="Image" width="315" height="212" class="rt-image floatleft" />\r\n	<img src="images/stories/demo/menu/tut-menu-5.jpg" alt="Image" width="315" height="212" class="rt-image" />	\r\n</p>\r\n\r\n<div class="module-title"><h3 class="title">Advanced Fusion Parameters: Columns</h3></div>\r\n\r\n<p><em class="bold2">Menu Columns</em></p>\r\n\r\n<p><strong>Columns of Child Items</strong> allows you to determine how many columns the <strong>Fusion</strong> dropdowns are presented in. You can have anywhere between a <strong>single dropdown</strong> to a <strong>four column</strong> dropdown.</p>\r\n\r\n<p>\r\n	<img src="images/stories/demo/menu/tut-menu-6.jpg" alt="Image" width="315" height="212" class="rt-image floatleft" />\r\n	<img src="images/stories/demo/menu/tut-menu-7.jpg" alt="Image" width="315" height="212" class="rt-image" />	\r\n</p>\r\n\r\n<p><em class="bold2">Item Distribution</em></p>\r\n\r\n<p><strong>Item Distribution</strong> allows you to control how the menu items are ordered in the dropdowns:</p>\r\n\r\n<ul class="bullet-star">\r\n	<li><strong>Evenly:</strong> If there are <strong>7</strong> menu items in <strong>3</strong> columns, Fusion will allocate a <em class="bold">3,2,2</em> distribution - trying to equalize each dropdown.</li>\r\n	<li><strong>Order:</strong> If there are <strong>7</strong> menu items in <strong>3</strong> columns, Fusion will allocate a <em class="bold">3,3,1</em> distribution - maintaining the item ordering.</li>\r\n</ul>\r\n\r\n<p>\r\n	<img src="images/stories/demo/menu/tut-menu-8.jpg" alt="Image" width="315" height="212" class="rt-image floatleft" />\r\n	<img src="images/stories/demo/menu/tut-menu-9.jpg" alt="Image" width="315" height="212" class="rt-image" />	\r\n</p>\r\n\r\n<div class="note"><div class="typo-icon"><strong>NOTE:</strong> If your <strong>Columns of Child Items</strong> setting is configured to be 2 or more columns, you will need to manually set the column widths and distribution, as outlined below. The default is 180px which is too small for multiple columns.</div></div>\r\n\r\n<p><em class="bold2">Drop-Down Width (px)</em></p>\r\n\r\n<p><strong>Drop-Down Width (px)</strong> determines the total width of the dropdown, regardless of how many columns are shown. This option is to be used in conjunction with <strong>Column Widths (px)</strong></p>\r\n\r\n<p>\r\n	<img src="images/stories/demo/menu/tut-menu-10.jpg" alt="Image" width="315" height="212" class="rt-image floatleft" />\r\n	<img src="images/stories/demo/menu/tut-menu-11.jpg" alt="Image" width="315" height="212" class="rt-image" />	\r\n</p>\r\n\r\n<p><em class="bold2">Column Widths (px)</em></p>\r\n\r\n<p><strong>Column Widths (px)</strong> determines the width of each Column. Separate each width by a comma. The final column''s width is determined automatically. This option is to be used in conjunction with <strong>Drop-Down Width (px)</strong></p>\r\n\r\n<p>Below are some example configurations:</p>\r\n\r\n<ul class="bullet-docs">\r\n	<li><strong>Drop-Down Width: 480px:</strong> <em>160,160</em>. Fusion automatically calculates the final width as <strong>160</strong>, so in practise, <em>160,160,160</em> is the actual distribution.</li>\r\n	<li><strong>Drop-Down Width: 600px:</strong> <em>160,160</em>. Fusion automatically calculates the final width as <strong>280</strong>, so in practise, <em>160,160,280</em> is the actual distribution.</li>\r\n</ul>\r\n\r\n<p>\r\n	<img src="images/stories/demo/menu/tut-menu-12.jpg" alt="Image" width="315" height="212" class="rt-image floatleft" />\r\n	<img src="images/stories/demo/menu/tut-menu-13.jpg" alt="Image" width="315" height="212" class="rt-image" />	\r\n</p>\r\n\r\n<div class="module-title"><h3 class="title">Advanced Fusion Parameters: Groupings</h3></div>\r\n\r\n<p><em class="bold2">What is Grouping?</em></p>\r\n\r\n<p><strong>Group Child Items</strong> changes the behaviour of child items in the dropdown menus, instead of creating a dropdown for the immediate sublevel, this option places them inline. See below for an illustrated example of the differences:</p>\r\n\r\n<p>\r\n	<img src="images/stories/demo/menu/tut-menu-14.jpg" alt="Image" width="315" height="212" class="rt-image floatleft" />\r\n	<img src="images/stories/demo/menu/tut-menu-15.jpg" alt="Image" width="315" height="212" class="rt-image" />	\r\n</p>\r\n\r\n<p><em class="bold2">Configuration</em></p>\r\n\r\n<div class="attention"><div class="typo-icon"><strong>NOTE:</strong> Grouping cannot be applied to <strong>root</strong> items, only <strong>child</strong> items.</div></div>\r\n\r\n<p>Set <strong>Group Child Items</strong> to Yes to activate the mode. The sublevels well then appear below the parent menu item in a categorical type structure.</p>\r\n\r\n<p>\r\n	<img src="images/stories/demo/menu/tut-menu-16.jpg" alt="Image" width="315" height="212" class="rt-image floatleft" />\r\n	<img src="images/stories/demo/menu/tut-menu-17.jpg" alt="Image" width="315" height="212" class="rt-image" />	\r\n</p>\r\n\r\n<p>Below is a diagram of how the menu groupings in Joomla translate into the Fusion Menu:</p>\r\n\r\n<p>\r\n	<img src="images/stories/demo/menu/tut-menu-18.jpg" alt="Image" width="650" height="350" class="rt-image" />	\r\n</p>\r\n\r\n<div class="module-title"><h3 class="title">Advanced Fusion Parameters: Modules</h3></div>\r\n\r\n<p><strong>Fusion</strong> is now capable of loading individual modules or entire module positions inside its dropdowns.</p>\r\n\r\n<p><em class="bold2">Loading Individual Modules</em></p>\r\n\r\n<p>Set <strong>Child Item Type</strong> to <strong>Modules</strong> to load all modules setup on your Joomla site in a list. Select the module you wish to display in the dropdown.</p>\r\n\r\n<p>\r\n	<img src="images/stories/demo/menu/tut-menu-19.jpg" alt="Image" width="315" height="212" class="rt-image floatleft" />\r\n	<img src="images/stories/demo/menu/tut-menu-20.jpg" alt="Image" width="315" height="212" class="rt-image" />	\r\n</p>\r\n\r\n<p><em class="bold2">Loading Module Positions</em></p>\r\n\r\n<p>Set <strong>Child Item Type</strong> to <strong>Modules Positions</strong> to load all module positions on your Joomla site in a list. Select the position you wish to display in the dropdown.</p>\r\n\r\n<p>\r\n	<img src="images/stories/demo/menu/tut-menu-21.jpg" alt="Image" width="315" height="212" class="rt-image floatleft" />\r\n	<img src="images/stories/demo/menu/tut-menu-22.jpg" alt="Image" width="315" height="212" class="rt-image" />	\r\n</p>\r\n\r\n<p>Below is an example of multiple modules appearing in a dropdown:</p>\r\n\r\n<p>\r\n	<img src="images/stories/demo/menu/tut-menu-23.jpg" alt="Image" width="315" height="212" class="rt-image floatleft" />\r\n	<img src="images/stories/demo/menu/tut-menu-24.jpg" alt="Image" width="315" height="212" class="rt-image" />	\r\n</p>\r\n\r\n<div class="module-title"><h3 class="title">Template Configuration: Fusion Menu</h3></div>\r\n\r\n<p>Go to <strong>Extensions &rarr; Template Manager &rarr; rt_zephyr_j15 &rarr; Menu</strong> Set <strong>Menu Control</strong> to <strong>Type</strong> : <strong>Fusion-Menu</strong>, to load all the Fusion parameters.</p>\r\n\r\n<p>\r\n	<img src="images/stories/demo/menu/tut-menu-25.jpg" alt="Image" width="522" height="627" class="rt-image" />\r\n</p>', '', 1, 5, 0, 34, '2010-07-24 01:12:43', 63, '', '2010-07-30 04:55:48', 63, 0, '0000-00-00 00:00:00', '2010-07-24 01:12:43', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 7, 0, 20, '', '', 0, 99, 'robots=\nauthor='),
(108, 'Dead Space', 'dead-space', '', '<img src="images/stories/demo/roknewspager/review8.jpg" class="floatleft rt-image" alt="Image" width="116" height="160"/>\r\n<p>Mafia 2 immerses players in the mob underworld...</p>\r\n\r\n', '\r\n<p>In erat. Pellentesque erat. Mauris vehicula vestibulum justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nulla pulvinar est. Integer urna. Pellentesque pulvinar dui a magna. Nulla facilisi. Proin imperdiet. Aliquam ornare, metus vitae gravida dignissim, nisi nisl ultricies felis, ac tristique enim pede eget elit. Integer non erat nec turpis sollicitudin malesuada. Vestibulum dapibus. Nulla facilisi. Nulla iaculis, leo sit amet mollis luctus, sapien eros consectetur dolor, eu faucibus elit nibh eu nibh. Maecenas lacus pede, lobortis non, rhoncus id, tristique a, mi. Cras auctor libero vitae sem vestibulum euismod. Nunc fermentum.</p>\r\n\r\n<p>Mauris lobortis. Aliquam lacinia purus. Pellentesque magna. Mauris euismod metus nec tortor. Phasellus elementum, quam a euismod imperdiet, ligula felis faucibus enim, eu malesuada nunc felis sed turpis. Morbi convallis luctus tortor. Integer bibendum lacinia velit. Suspendisse mi lorem, porttitor ut, interdum et, lobortis a, lectus. Phasellus vitae est at massa luctus iaculis. In tincidunt.</p>\r\n\r\n<p>Integer fermentum elit in tellus. Integer ligula ipsum, gravida aliquet, fringilla non, interdum eget, ipsum. Praesent id dolor non erat viverra volutpat. Fusce tellus libero, luctus adipiscing, tincidunt vel, egestas vitae, eros. Vestibulum mollis, est id rhoncus volutpat, dolor velit tincidunt neque, vitae pellentesque ante sem eu nisl. Donec facilisis, magna eget elementum pellentesque, augue arcu aliquet eros, eget convallis mauris ante quis magna. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Aenean et libero. Nam aliquam. Quisque vitae tortor id neque dignissim laoreet. Duis eu ante. Integer at sapien. Praesent sed nisl tempor est pulvinar tristique. Maecenas non lorem quis mi laoreet adipiscing. Sed ac arcu. Sed tincidunt libero eu dolor. Cras pharetra posuere eros. Donec ac eros id diam tempor faucibus. Fusce feugiat consequat nulla. Vestibulum tincidunt vulputate ipsum.</p>\r\n\r\n<p>Nullam eget neque. Nullam imperdiet venenatis ligula. Integer a leo. Nunc consectetur. Maecenas sem. Proin vulputate, massa vel volutpat laoreet, purus erat pretium ligula, eget varius arcu nibh sed libero. Fusce ante. Nullam interdum aliquet metus. Ut ultrices vestibulum tellus. Praesent quis erat. Nam id turpis sit amet neque cursus luctus. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Quisque id tortor. In vitae sapien. Nunc quis tellus.</p>', 1, 5, 0, 42, '2010-07-21 21:33:43', 63, '', '2010-07-29 00:30:44', 63, 0, '0000-00-00 00:00:00', '2010-07-21 21:33:43', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 1, 0, 21, '', '', 0, 2, 'robots=\nauthor=');
INSERT INTO `#__content` (`id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`) VALUES
(109, 'Black Ops', 'black-ops', '', '<img src="images/stories/demo/roknewspager/review10.jpg" class="floatleft rt-image" alt="Image" width="116" height="160"/>\r\n<p>Hear the call of duty once again with this 7th...</p>\r\n\r\n', '\r\n<p>In erat. Pellentesque erat. Mauris vehicula vestibulum justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nulla pulvinar est. Integer urna. Pellentesque pulvinar dui a magna. Nulla facilisi. Proin imperdiet. Aliquam ornare, metus vitae gravida dignissim, nisi nisl ultricies felis, ac tristique enim pede eget elit. Integer non erat nec turpis sollicitudin malesuada. Vestibulum dapibus. Nulla facilisi. Nulla iaculis, leo sit amet mollis luctus, sapien eros consectetur dolor, eu faucibus elit nibh eu nibh. Maecenas lacus pede, lobortis non, rhoncus id, tristique a, mi. Cras auctor libero vitae sem vestibulum euismod. Nunc fermentum.</p>\r\n\r\n<p>Mauris lobortis. Aliquam lacinia purus. Pellentesque magna. Mauris euismod metus nec tortor. Phasellus elementum, quam a euismod imperdiet, ligula felis faucibus enim, eu malesuada nunc felis sed turpis. Morbi convallis luctus tortor. Integer bibendum lacinia velit. Suspendisse mi lorem, porttitor ut, interdum et, lobortis a, lectus. Phasellus vitae est at massa luctus iaculis. In tincidunt.</p>\r\n\r\n<p>Integer fermentum elit in tellus. Integer ligula ipsum, gravida aliquet, fringilla non, interdum eget, ipsum. Praesent id dolor non erat viverra volutpat. Fusce tellus libero, luctus adipiscing, tincidunt vel, egestas vitae, eros. Vestibulum mollis, est id rhoncus volutpat, dolor velit tincidunt neque, vitae pellentesque ante sem eu nisl. Donec facilisis, magna eget elementum pellentesque, augue arcu aliquet eros, eget convallis mauris ante quis magna. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Aenean et libero. Nam aliquam. Quisque vitae tortor id neque dignissim laoreet. Duis eu ante. Integer at sapien. Praesent sed nisl tempor est pulvinar tristique. Maecenas non lorem quis mi laoreet adipiscing. Sed ac arcu. Sed tincidunt libero eu dolor. Cras pharetra posuere eros. Donec ac eros id diam tempor faucibus. Fusce feugiat consequat nulla. Vestibulum tincidunt vulputate ipsum.</p>\r\n\r\n<p>Nullam eget neque. Nullam imperdiet venenatis ligula. Integer a leo. Nunc consectetur. Maecenas sem. Proin vulputate, massa vel volutpat laoreet, purus erat pretium ligula, eget varius arcu nibh sed libero. Fusce ante. Nullam interdum aliquet metus. Ut ultrices vestibulum tellus. Praesent quis erat. Nam id turpis sit amet neque cursus luctus. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Quisque id tortor. In vitae sapien. Nunc quis tellus.</p>', 1, 5, 0, 42, '2010-07-21 21:33:23', 63, '', '2010-07-29 00:31:49', 63, 0, '0000-00-00 00:00:00', '2010-07-21 21:33:23', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 2, 0, 22, '', '', 0, 2, 'robots=\nauthor='),
(110, 'Brotherhood', 'brotherhood', '', '<img src="images/stories/demo/roknewspager/review11.jpg" class="floatleft rt-image" alt="Image" width="116" height="160"/>\r\n<p>The critically acclaimed single-player game...</p>\r\n\r\n', '\r\n<p>In erat. Pellentesque erat. Mauris vehicula vestibulum justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nulla pulvinar est. Integer urna. Pellentesque pulvinar dui a magna. Nulla facilisi. Proin imperdiet. Aliquam ornare, metus vitae gravida dignissim, nisi nisl ultricies felis, ac tristique enim pede eget elit. Integer non erat nec turpis sollicitudin malesuada. Vestibulum dapibus. Nulla facilisi. Nulla iaculis, leo sit amet mollis luctus, sapien eros consectetur dolor, eu faucibus elit nibh eu nibh. Maecenas lacus pede, lobortis non, rhoncus id, tristique a, mi. Cras auctor libero vitae sem vestibulum euismod. Nunc fermentum.</p>\r\n\r\n<p>Mauris lobortis. Aliquam lacinia purus. Pellentesque magna. Mauris euismod metus nec tortor. Phasellus elementum, quam a euismod imperdiet, ligula felis faucibus enim, eu malesuada nunc felis sed turpis. Morbi convallis luctus tortor. Integer bibendum lacinia velit. Suspendisse mi lorem, porttitor ut, interdum et, lobortis a, lectus. Phasellus vitae est at massa luctus iaculis. In tincidunt.</p>\r\n\r\n<p>Integer fermentum elit in tellus. Integer ligula ipsum, gravida aliquet, fringilla non, interdum eget, ipsum. Praesent id dolor non erat viverra volutpat. Fusce tellus libero, luctus adipiscing, tincidunt vel, egestas vitae, eros. Vestibulum mollis, est id rhoncus volutpat, dolor velit tincidunt neque, vitae pellentesque ante sem eu nisl. Donec facilisis, magna eget elementum pellentesque, augue arcu aliquet eros, eget convallis mauris ante quis magna. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Aenean et libero. Nam aliquam. Quisque vitae tortor id neque dignissim laoreet. Duis eu ante. Integer at sapien. Praesent sed nisl tempor est pulvinar tristique. Maecenas non lorem quis mi laoreet adipiscing. Sed ac arcu. Sed tincidunt libero eu dolor. Cras pharetra posuere eros. Donec ac eros id diam tempor faucibus. Fusce feugiat consequat nulla. Vestibulum tincidunt vulputate ipsum.</p>\r\n\r\n<p>Nullam eget neque. Nullam imperdiet venenatis ligula. Integer a leo. Nunc consectetur. Maecenas sem. Proin vulputate, massa vel volutpat laoreet, purus erat pretium ligula, eget varius arcu nibh sed libero. Fusce ante. Nullam interdum aliquet metus. Ut ultrices vestibulum tellus. Praesent quis erat. Nam id turpis sit amet neque cursus luctus. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Quisque id tortor. In vitae sapien. Nunc quis tellus.</p>', 1, 5, 0, 42, '2010-07-21 21:33:43', 63, '', '2010-07-29 03:45:40', 63, 0, '0000-00-00 00:00:00', '2010-07-21 21:33:43', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 2, 0, 23, '', '', 0, 3, 'robots=\nauthor='),
(111, 'Medal of Honor', 'medal-of-honor', '', '<img src="images/stories/demo/roknewspager/review12.jpg" class="floatleft rt-image" alt="Image" width="116" height="160"/>\r\n<p>Leaving the WWII theatre for the... </p>\r\n\r\n', '\r\n<p>In erat. Pellentesque erat. Mauris vehicula vestibulum justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nulla pulvinar est. Integer urna. Pellentesque pulvinar dui a magna. Nulla facilisi. Proin imperdiet. Aliquam ornare, metus vitae gravida dignissim, nisi nisl ultricies felis, ac tristique enim pede eget elit. Integer non erat nec turpis sollicitudin malesuada. Vestibulum dapibus. Nulla facilisi. Nulla iaculis, leo sit amet mollis luctus, sapien eros consectetur dolor, eu faucibus elit nibh eu nibh. Maecenas lacus pede, lobortis non, rhoncus id, tristique a, mi. Cras auctor libero vitae sem vestibulum euismod. Nunc fermentum.</p>\r\n\r\n<p>Mauris lobortis. Aliquam lacinia purus. Pellentesque magna. Mauris euismod metus nec tortor. Phasellus elementum, quam a euismod imperdiet, ligula felis faucibus enim, eu malesuada nunc felis sed turpis. Morbi convallis luctus tortor. Integer bibendum lacinia velit. Suspendisse mi lorem, porttitor ut, interdum et, lobortis a, lectus. Phasellus vitae est at massa luctus iaculis. In tincidunt.</p>\r\n\r\n<p>Integer fermentum elit in tellus. Integer ligula ipsum, gravida aliquet, fringilla non, interdum eget, ipsum. Praesent id dolor non erat viverra volutpat. Fusce tellus libero, luctus adipiscing, tincidunt vel, egestas vitae, eros. Vestibulum mollis, est id rhoncus volutpat, dolor velit tincidunt neque, vitae pellentesque ante sem eu nisl. Donec facilisis, magna eget elementum pellentesque, augue arcu aliquet eros, eget convallis mauris ante quis magna. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Aenean et libero. Nam aliquam. Quisque vitae tortor id neque dignissim laoreet. Duis eu ante. Integer at sapien. Praesent sed nisl tempor est pulvinar tristique. Maecenas non lorem quis mi laoreet adipiscing. Sed ac arcu. Sed tincidunt libero eu dolor. Cras pharetra posuere eros. Donec ac eros id diam tempor faucibus. Fusce feugiat consequat nulla. Vestibulum tincidunt vulputate ipsum.</p>\r\n\r\n<p>Nullam eget neque. Nullam imperdiet venenatis ligula. Integer a leo. Nunc consectetur. Maecenas sem. Proin vulputate, massa vel volutpat laoreet, purus erat pretium ligula, eget varius arcu nibh sed libero. Fusce ante. Nullam interdum aliquet metus. Ut ultrices vestibulum tellus. Praesent quis erat. Nam id turpis sit amet neque cursus luctus. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Quisque id tortor. In vitae sapien. Nunc quis tellus.</p>', 1, 5, 0, 42, '2010-07-21 21:33:23', 63, '', '2010-07-29 03:55:57', 63, 0, '0000-00-00 00:00:00', '2010-07-21 21:33:23', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 3, 0, 24, '', '', 0, 3, 'robots=\nauthor='),
(112, 'Halo Reach', 'halo-reach', '', '<img src="images/stories/demo/roknewspager/review1.jpg" class="floatleft rt-image" alt="Image" width="116" height="160"/>\r\n<p><em>FPS</em>  - Expansion of the popular Halo Universe...</p>\r\n\r\n', '\r\n<p>In erat. Pellentesque erat. Mauris vehicula vestibulum justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nulla pulvinar est. Integer urna. Pellentesque pulvinar dui a magna. Nulla facilisi. Proin imperdiet. Aliquam ornare, metus vitae gravida dignissim, nisi nisl ultricies felis, ac tristique enim pede eget elit. Integer non erat nec turpis sollicitudin malesuada. Vestibulum dapibus. Nulla facilisi. Nulla iaculis, leo sit amet mollis luctus, sapien eros consectetur dolor, eu faucibus elit nibh eu nibh. Maecenas lacus pede, lobortis non, rhoncus id, tristique a, mi. Cras auctor libero vitae sem vestibulum euismod. Nunc fermentum.</p>\r\n\r\n<p>Mauris lobortis. Aliquam lacinia purus. Pellentesque magna. Mauris euismod metus nec tortor. Phasellus elementum, quam a euismod imperdiet, ligula felis faucibus enim, eu malesuada nunc felis sed turpis. Morbi convallis luctus tortor. Integer bibendum lacinia velit. Suspendisse mi lorem, porttitor ut, interdum et, lobortis a, lectus. Phasellus vitae est at massa luctus iaculis. In tincidunt.</p>\r\n\r\n<p>Integer fermentum elit in tellus. Integer ligula ipsum, gravida aliquet, fringilla non, interdum eget, ipsum. Praesent id dolor non erat viverra volutpat. Fusce tellus libero, luctus adipiscing, tincidunt vel, egestas vitae, eros. Vestibulum mollis, est id rhoncus volutpat, dolor velit tincidunt neque, vitae pellentesque ante sem eu nisl. Donec facilisis, magna eget elementum pellentesque, augue arcu aliquet eros, eget convallis mauris ante quis magna. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Aenean et libero. Nam aliquam. Quisque vitae tortor id neque dignissim laoreet. Duis eu ante. Integer at sapien. Praesent sed nisl tempor est pulvinar tristique. Maecenas non lorem quis mi laoreet adipiscing. Sed ac arcu. Sed tincidunt libero eu dolor. Cras pharetra posuere eros. Donec ac eros id diam tempor faucibus. Fusce feugiat consequat nulla. Vestibulum tincidunt vulputate ipsum.</p>\r\n\r\n<p>Nullam eget neque. Nullam imperdiet venenatis ligula. Integer a leo. Nunc consectetur. Maecenas sem. Proin vulputate, massa vel volutpat laoreet, purus erat pretium ligula, eget varius arcu nibh sed libero. Fusce ante. Nullam interdum aliquet metus. Ut ultrices vestibulum tellus. Praesent quis erat. Nam id turpis sit amet neque cursus luctus. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Quisque id tortor. In vitae sapien. Nunc quis tellus.</p>', 1, 5, 0, 42, '2010-07-21 21:33:23', 63, '', '2010-07-29 00:25:33', 63, 0, '0000-00-00 00:00:00', '2010-07-21 21:33:23', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 0, 0, 1, '', '', 0, 3, 'robots=\nauthor='),
(113, 'FIFA ''11', 'fifa-11', '', '<img src="images/stories/demo/roknewspager/review2.jpg" class="floatleft rt-image" alt="Image" width="116" height="160"/>\r\n<p>Play on until the final whistle with the ''11 edition... </p>\r\n\r\n', '\r\n<p>In erat. Pellentesque erat. Mauris vehicula vestibulum justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nulla pulvinar est. Integer urna. Pellentesque pulvinar dui a magna. Nulla facilisi. Proin imperdiet. Aliquam ornare, metus vitae gravida dignissim, nisi nisl ultricies felis, ac tristique enim pede eget elit. Integer non erat nec turpis sollicitudin malesuada. Vestibulum dapibus. Nulla facilisi. Nulla iaculis, leo sit amet mollis luctus, sapien eros consectetur dolor, eu faucibus elit nibh eu nibh. Maecenas lacus pede, lobortis non, rhoncus id, tristique a, mi. Cras auctor libero vitae sem vestibulum euismod. Nunc fermentum.</p>\r\n\r\n<p>Mauris lobortis. Aliquam lacinia purus. Pellentesque magna. Mauris euismod metus nec tortor. Phasellus elementum, quam a euismod imperdiet, ligula felis faucibus enim, eu malesuada nunc felis sed turpis. Morbi convallis luctus tortor. Integer bibendum lacinia velit. Suspendisse mi lorem, porttitor ut, interdum et, lobortis a, lectus. Phasellus vitae est at massa luctus iaculis. In tincidunt.</p>\r\n\r\n<p>Integer fermentum elit in tellus. Integer ligula ipsum, gravida aliquet, fringilla non, interdum eget, ipsum. Praesent id dolor non erat viverra volutpat. Fusce tellus libero, luctus adipiscing, tincidunt vel, egestas vitae, eros. Vestibulum mollis, est id rhoncus volutpat, dolor velit tincidunt neque, vitae pellentesque ante sem eu nisl. Donec facilisis, magna eget elementum pellentesque, augue arcu aliquet eros, eget convallis mauris ante quis magna. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Aenean et libero. Nam aliquam. Quisque vitae tortor id neque dignissim laoreet. Duis eu ante. Integer at sapien. Praesent sed nisl tempor est pulvinar tristique. Maecenas non lorem quis mi laoreet adipiscing. Sed ac arcu. Sed tincidunt libero eu dolor. Cras pharetra posuere eros. Donec ac eros id diam tempor faucibus. Fusce feugiat consequat nulla. Vestibulum tincidunt vulputate ipsum.</p>\r\n\r\n<p>Nullam eget neque. Nullam imperdiet venenatis ligula. Integer a leo. Nunc consectetur. Maecenas sem. Proin vulputate, massa vel volutpat laoreet, purus erat pretium ligula, eget varius arcu nibh sed libero. Fusce ante. Nullam interdum aliquet metus. Ut ultrices vestibulum tellus. Praesent quis erat. Nam id turpis sit amet neque cursus luctus. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Quisque id tortor. In vitae sapien. Nunc quis tellus.</p>', 1, 5, 0, 42, '2010-07-21 21:33:23', 63, '', '2010-07-29 00:25:38', 63, 0, '0000-00-00 00:00:00', '2010-07-21 21:33:23', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 0, 0, 2, '', '', 0, 3, 'robots=\nauthor='),
(114, 'Madden 11', 'madden-11', '', '<img src="images/stories/demo/roknewspager/review3.jpg" class="floatleft" alt="Image" width="116" height="160"/>\r\n<p>Prepare for a new season with Madden 11...</p>\r\n\r\n', '\r\n<p>In erat. Pellentesque erat. Mauris vehicula vestibulum justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nulla pulvinar est. Integer urna. Pellentesque pulvinar dui a magna. Nulla facilisi. Proin imperdiet. Aliquam ornare, metus vitae gravida dignissim, nisi nisl ultricies felis, ac tristique enim pede eget elit. Integer non erat nec turpis sollicitudin malesuada. Vestibulum dapibus. Nulla facilisi. Nulla iaculis, leo sit amet mollis luctus, sapien eros consectetur dolor, eu faucibus elit nibh eu nibh. Maecenas lacus pede, lobortis non, rhoncus id, tristique a, mi. Cras auctor libero vitae sem vestibulum euismod. Nunc fermentum.</p>\r\n\r\n<p>Mauris lobortis. Aliquam lacinia purus. Pellentesque magna. Mauris euismod metus nec tortor. Phasellus elementum, quam a euismod imperdiet, ligula felis faucibus enim, eu malesuada nunc felis sed turpis. Morbi convallis luctus tortor. Integer bibendum lacinia velit. Suspendisse mi lorem, porttitor ut, interdum et, lobortis a, lectus. Phasellus vitae est at massa luctus iaculis. In tincidunt.</p>\r\n\r\n<p>Integer fermentum elit in tellus. Integer ligula ipsum, gravida aliquet, fringilla non, interdum eget, ipsum. Praesent id dolor non erat viverra volutpat. Fusce tellus libero, luctus adipiscing, tincidunt vel, egestas vitae, eros. Vestibulum mollis, est id rhoncus volutpat, dolor velit tincidunt neque, vitae pellentesque ante sem eu nisl. Donec facilisis, magna eget elementum pellentesque, augue arcu aliquet eros, eget convallis mauris ante quis magna. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Aenean et libero. Nam aliquam. Quisque vitae tortor id neque dignissim laoreet. Duis eu ante. Integer at sapien. Praesent sed nisl tempor est pulvinar tristique. Maecenas non lorem quis mi laoreet adipiscing. Sed ac arcu. Sed tincidunt libero eu dolor. Cras pharetra posuere eros. Donec ac eros id diam tempor faucibus. Fusce feugiat consequat nulla. Vestibulum tincidunt vulputate ipsum.</p>\r\n\r\n<p>Nullam eget neque. Nullam imperdiet venenatis ligula. Integer a leo. Nunc consectetur. Maecenas sem. Proin vulputate, massa vel volutpat laoreet, purus erat pretium ligula, eget varius arcu nibh sed libero. Fusce ante. Nullam interdum aliquet metus. Ut ultrices vestibulum tellus. Praesent quis erat. Nam id turpis sit amet neque cursus luctus. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Quisque id tortor. In vitae sapien. Nunc quis tellus.</p>', 1, 5, 0, 42, '2010-07-21 21:33:43', 63, '', '2010-07-29 00:25:43', 63, 0, '0000-00-00 00:00:00', '2010-07-21 21:33:43', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 0, 0, 3, '', '', 0, 2, 'robots=\nauthor='),
(115, 'Mafia II', 'mafia-ii', '', '<img src="images/stories/demo/roknewspager/review4.jpg" class="floatleft rt-image" alt="Image" width="116" height="160"/>\r\n<p>Mafia 2 immerses players in the mob underworld...</p>\r\n\r\n', '\r\n<p>In erat. Pellentesque erat. Mauris vehicula vestibulum justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nulla pulvinar est. Integer urna. Pellentesque pulvinar dui a magna. Nulla facilisi. Proin imperdiet. Aliquam ornare, metus vitae gravida dignissim, nisi nisl ultricies felis, ac tristique enim pede eget elit. Integer non erat nec turpis sollicitudin malesuada. Vestibulum dapibus. Nulla facilisi. Nulla iaculis, leo sit amet mollis luctus, sapien eros consectetur dolor, eu faucibus elit nibh eu nibh. Maecenas lacus pede, lobortis non, rhoncus id, tristique a, mi. Cras auctor libero vitae sem vestibulum euismod. Nunc fermentum.</p>\r\n\r\n<p>Mauris lobortis. Aliquam lacinia purus. Pellentesque magna. Mauris euismod metus nec tortor. Phasellus elementum, quam a euismod imperdiet, ligula felis faucibus enim, eu malesuada nunc felis sed turpis. Morbi convallis luctus tortor. Integer bibendum lacinia velit. Suspendisse mi lorem, porttitor ut, interdum et, lobortis a, lectus. Phasellus vitae est at massa luctus iaculis. In tincidunt.</p>\r\n\r\n<p>Integer fermentum elit in tellus. Integer ligula ipsum, gravida aliquet, fringilla non, interdum eget, ipsum. Praesent id dolor non erat viverra volutpat. Fusce tellus libero, luctus adipiscing, tincidunt vel, egestas vitae, eros. Vestibulum mollis, est id rhoncus volutpat, dolor velit tincidunt neque, vitae pellentesque ante sem eu nisl. Donec facilisis, magna eget elementum pellentesque, augue arcu aliquet eros, eget convallis mauris ante quis magna. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Aenean et libero. Nam aliquam. Quisque vitae tortor id neque dignissim laoreet. Duis eu ante. Integer at sapien. Praesent sed nisl tempor est pulvinar tristique. Maecenas non lorem quis mi laoreet adipiscing. Sed ac arcu. Sed tincidunt libero eu dolor. Cras pharetra posuere eros. Donec ac eros id diam tempor faucibus. Fusce feugiat consequat nulla. Vestibulum tincidunt vulputate ipsum.</p>\r\n\r\n<p>Nullam eget neque. Nullam imperdiet venenatis ligula. Integer a leo. Nunc consectetur. Maecenas sem. Proin vulputate, massa vel volutpat laoreet, purus erat pretium ligula, eget varius arcu nibh sed libero. Fusce ante. Nullam interdum aliquet metus. Ut ultrices vestibulum tellus. Praesent quis erat. Nam id turpis sit amet neque cursus luctus. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Quisque id tortor. In vitae sapien. Nunc quis tellus.</p>', 1, 5, 0, 42, '2010-07-21 21:33:43', 63, '', '2010-07-29 00:25:27', 63, 0, '0000-00-00 00:00:00', '2010-07-21 21:33:43', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 0, 0, 4, '', '', 0, 8, 'robots=\nauthor='),
(116, 'Mass Effect', 'mass-effect', '', '<img src="images/stories/demo/roknewspager/review5.jpg" class="floatleft rt-image" alt="Image" width="116" height="160"/>\r\n<p>Conceived as a trilogy, the sequel to Mass Effect...</p>\r\n\r\n', '\r\n<p>In erat. Pellentesque erat. Mauris vehicula vestibulum justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nulla pulvinar est. Integer urna. Pellentesque pulvinar dui a magna. Nulla facilisi. Proin imperdiet. Aliquam ornare, metus vitae gravida dignissim, nisi nisl ultricies felis, ac tristique enim pede eget elit. Integer non erat nec turpis sollicitudin malesuada. Vestibulum dapibus. Nulla facilisi. Nulla iaculis, leo sit amet mollis luctus, sapien eros consectetur dolor, eu faucibus elit nibh eu nibh. Maecenas lacus pede, lobortis non, rhoncus id, tristique a, mi. Cras auctor libero vitae sem vestibulum euismod. Nunc fermentum.</p>\r\n\r\n<p>Mauris lobortis. Aliquam lacinia purus. Pellentesque magna. Mauris euismod metus nec tortor. Phasellus elementum, quam a euismod imperdiet, ligula felis faucibus enim, eu malesuada nunc felis sed turpis. Morbi convallis luctus tortor. Integer bibendum lacinia velit. Suspendisse mi lorem, porttitor ut, interdum et, lobortis a, lectus. Phasellus vitae est at massa luctus iaculis. In tincidunt.</p>\r\n\r\n<p>Integer fermentum elit in tellus. Integer ligula ipsum, gravida aliquet, fringilla non, interdum eget, ipsum. Praesent id dolor non erat viverra volutpat. Fusce tellus libero, luctus adipiscing, tincidunt vel, egestas vitae, eros. Vestibulum mollis, est id rhoncus volutpat, dolor velit tincidunt neque, vitae pellentesque ante sem eu nisl. Donec facilisis, magna eget elementum pellentesque, augue arcu aliquet eros, eget convallis mauris ante quis magna. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Aenean et libero. Nam aliquam. Quisque vitae tortor id neque dignissim laoreet. Duis eu ante. Integer at sapien. Praesent sed nisl tempor est pulvinar tristique. Maecenas non lorem quis mi laoreet adipiscing. Sed ac arcu. Sed tincidunt libero eu dolor. Cras pharetra posuere eros. Donec ac eros id diam tempor faucibus. Fusce feugiat consequat nulla. Vestibulum tincidunt vulputate ipsum.</p>\r\n\r\n<p>Nullam eget neque. Nullam imperdiet venenatis ligula. Integer a leo. Nunc consectetur. Maecenas sem. Proin vulputate, massa vel volutpat laoreet, purus erat pretium ligula, eget varius arcu nibh sed libero. Fusce ante. Nullam interdum aliquet metus. Ut ultrices vestibulum tellus. Praesent quis erat. Nam id turpis sit amet neque cursus luctus. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Quisque id tortor. In vitae sapien. Nunc quis tellus.</p>', 1, 5, 0, 42, '2010-07-21 21:33:23', 63, '', '2010-07-29 00:25:16', 63, 0, '0000-00-00 00:00:00', '2010-07-21 21:33:23', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 0, 0, 5, '', '', 0, 2, 'robots=\nauthor='),
(117, 'Gears of War', 'gears-of-war', '', '<img src="images/stories/demo/roknewspager/review6.jpg" class="floatleft rt-image" alt="Image" width="116" height="160"/>\r\n<p>War rages on in the third (and possibly...</p>\r\n\r\n', '\r\n<p>In erat. Pellentesque erat. Mauris vehicula vestibulum justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nulla pulvinar est. Integer urna. Pellentesque pulvinar dui a magna. Nulla facilisi. Proin imperdiet. Aliquam ornare, metus vitae gravida dignissim, nisi nisl ultricies felis, ac tristique enim pede eget elit. Integer non erat nec turpis sollicitudin malesuada. Vestibulum dapibus. Nulla facilisi. Nulla iaculis, leo sit amet mollis luctus, sapien eros consectetur dolor, eu faucibus elit nibh eu nibh. Maecenas lacus pede, lobortis non, rhoncus id, tristique a, mi. Cras auctor libero vitae sem vestibulum euismod. Nunc fermentum.</p>\r\n\r\n<p>Mauris lobortis. Aliquam lacinia purus. Pellentesque magna. Mauris euismod metus nec tortor. Phasellus elementum, quam a euismod imperdiet, ligula felis faucibus enim, eu malesuada nunc felis sed turpis. Morbi convallis luctus tortor. Integer bibendum lacinia velit. Suspendisse mi lorem, porttitor ut, interdum et, lobortis a, lectus. Phasellus vitae est at massa luctus iaculis. In tincidunt.</p>\r\n\r\n<p>Integer fermentum elit in tellus. Integer ligula ipsum, gravida aliquet, fringilla non, interdum eget, ipsum. Praesent id dolor non erat viverra volutpat. Fusce tellus libero, luctus adipiscing, tincidunt vel, egestas vitae, eros. Vestibulum mollis, est id rhoncus volutpat, dolor velit tincidunt neque, vitae pellentesque ante sem eu nisl. Donec facilisis, magna eget elementum pellentesque, augue arcu aliquet eros, eget convallis mauris ante quis magna. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Aenean et libero. Nam aliquam. Quisque vitae tortor id neque dignissim laoreet. Duis eu ante. Integer at sapien. Praesent sed nisl tempor est pulvinar tristique. Maecenas non lorem quis mi laoreet adipiscing. Sed ac arcu. Sed tincidunt libero eu dolor. Cras pharetra posuere eros. Donec ac eros id diam tempor faucibus. Fusce feugiat consequat nulla. Vestibulum tincidunt vulputate ipsum.</p>\r\n\r\n<p>Nullam eget neque. Nullam imperdiet venenatis ligula. Integer a leo. Nunc consectetur. Maecenas sem. Proin vulputate, massa vel volutpat laoreet, purus erat pretium ligula, eget varius arcu nibh sed libero. Fusce ante. Nullam interdum aliquet metus. Ut ultrices vestibulum tellus. Praesent quis erat. Nam id turpis sit amet neque cursus luctus. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Quisque id tortor. In vitae sapien. Nunc quis tellus.</p>', 1, 5, 0, 42, '2010-07-21 21:33:23', 63, '', '2010-07-29 00:27:55', 63, 0, '0000-00-00 00:00:00', '2010-07-21 21:33:23', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 0, 0, 6, '', '', 0, 2, 'robots=\nauthor='),
(118, 'Fallout', 'fallout', '', '<img src="images/stories/demo/roknewspager/review7.jpg" class="floatleft rt-image" alt="Image" width="116" height="160"/>\r\n<p>From Bethesda Softworks and the veteran RPG...</p>\r\n\r\n', '\r\n<p>In erat. Pellentesque erat. Mauris vehicula vestibulum justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nulla pulvinar est. Integer urna. Pellentesque pulvinar dui a magna. Nulla facilisi. Proin imperdiet. Aliquam ornare, metus vitae gravida dignissim, nisi nisl ultricies felis, ac tristique enim pede eget elit. Integer non erat nec turpis sollicitudin malesuada. Vestibulum dapibus. Nulla facilisi. Nulla iaculis, leo sit amet mollis luctus, sapien eros consectetur dolor, eu faucibus elit nibh eu nibh. Maecenas lacus pede, lobortis non, rhoncus id, tristique a, mi. Cras auctor libero vitae sem vestibulum euismod. Nunc fermentum.</p>\r\n\r\n<p>Mauris lobortis. Aliquam lacinia purus. Pellentesque magna. Mauris euismod metus nec tortor. Phasellus elementum, quam a euismod imperdiet, ligula felis faucibus enim, eu malesuada nunc felis sed turpis. Morbi convallis luctus tortor. Integer bibendum lacinia velit. Suspendisse mi lorem, porttitor ut, interdum et, lobortis a, lectus. Phasellus vitae est at massa luctus iaculis. In tincidunt.</p>\r\n\r\n<p>Integer fermentum elit in tellus. Integer ligula ipsum, gravida aliquet, fringilla non, interdum eget, ipsum. Praesent id dolor non erat viverra volutpat. Fusce tellus libero, luctus adipiscing, tincidunt vel, egestas vitae, eros. Vestibulum mollis, est id rhoncus volutpat, dolor velit tincidunt neque, vitae pellentesque ante sem eu nisl. Donec facilisis, magna eget elementum pellentesque, augue arcu aliquet eros, eget convallis mauris ante quis magna. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Aenean et libero. Nam aliquam. Quisque vitae tortor id neque dignissim laoreet. Duis eu ante. Integer at sapien. Praesent sed nisl tempor est pulvinar tristique. Maecenas non lorem quis mi laoreet adipiscing. Sed ac arcu. Sed tincidunt libero eu dolor. Cras pharetra posuere eros. Donec ac eros id diam tempor faucibus. Fusce feugiat consequat nulla. Vestibulum tincidunt vulputate ipsum.</p>\r\n\r\n<p>Nullam eget neque. Nullam imperdiet venenatis ligula. Integer a leo. Nunc consectetur. Maecenas sem. Proin vulputate, massa vel volutpat laoreet, purus erat pretium ligula, eget varius arcu nibh sed libero. Fusce ante. Nullam interdum aliquet metus. Ut ultrices vestibulum tellus. Praesent quis erat. Nam id turpis sit amet neque cursus luctus. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Quisque id tortor. In vitae sapien. Nunc quis tellus.</p>', 1, 5, 0, 42, '2010-07-21 21:33:23', 63, '', '2010-07-29 00:28:40', 63, 0, '0000-00-00 00:00:00', '2010-07-21 21:33:23', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 0, 0, 7, '', '', 0, 2, 'robots=\nauthor='),
(119, 'Fable', 'fable', '', '<img src="images/stories/demo/roknewspager/review8.jpg" class="floatleft" alt="Image" width="116" height="160"/>\r\n<p>The fables of Fable continue to be told with this...</p>\r\n\r\n', '\r\n<p>In erat. Pellentesque erat. Mauris vehicula vestibulum justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nulla pulvinar est. Integer urna. Pellentesque pulvinar dui a magna. Nulla facilisi. Proin imperdiet. Aliquam ornare, metus vitae gravida dignissim, nisi nisl ultricies felis, ac tristique enim pede eget elit. Integer non erat nec turpis sollicitudin malesuada. Vestibulum dapibus. Nulla facilisi. Nulla iaculis, leo sit amet mollis luctus, sapien eros consectetur dolor, eu faucibus elit nibh eu nibh. Maecenas lacus pede, lobortis non, rhoncus id, tristique a, mi. Cras auctor libero vitae sem vestibulum euismod. Nunc fermentum.</p>\r\n\r\n<p>Mauris lobortis. Aliquam lacinia purus. Pellentesque magna. Mauris euismod metus nec tortor. Phasellus elementum, quam a euismod imperdiet, ligula felis faucibus enim, eu malesuada nunc felis sed turpis. Morbi convallis luctus tortor. Integer bibendum lacinia velit. Suspendisse mi lorem, porttitor ut, interdum et, lobortis a, lectus. Phasellus vitae est at massa luctus iaculis. In tincidunt.</p>\r\n\r\n<p>Integer fermentum elit in tellus. Integer ligula ipsum, gravida aliquet, fringilla non, interdum eget, ipsum. Praesent id dolor non erat viverra volutpat. Fusce tellus libero, luctus adipiscing, tincidunt vel, egestas vitae, eros. Vestibulum mollis, est id rhoncus volutpat, dolor velit tincidunt neque, vitae pellentesque ante sem eu nisl. Donec facilisis, magna eget elementum pellentesque, augue arcu aliquet eros, eget convallis mauris ante quis magna. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Aenean et libero. Nam aliquam. Quisque vitae tortor id neque dignissim laoreet. Duis eu ante. Integer at sapien. Praesent sed nisl tempor est pulvinar tristique. Maecenas non lorem quis mi laoreet adipiscing. Sed ac arcu. Sed tincidunt libero eu dolor. Cras pharetra posuere eros. Donec ac eros id diam tempor faucibus. Fusce feugiat consequat nulla. Vestibulum tincidunt vulputate ipsum.</p>\r\n\r\n<p>Nullam eget neque. Nullam imperdiet venenatis ligula. Integer a leo. Nunc consectetur. Maecenas sem. Proin vulputate, massa vel volutpat laoreet, purus erat pretium ligula, eget varius arcu nibh sed libero. Fusce ante. Nullam interdum aliquet metus. Ut ultrices vestibulum tellus. Praesent quis erat. Nam id turpis sit amet neque cursus luctus. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Quisque id tortor. In vitae sapien. Nunc quis tellus.</p>', 1, 5, 0, 42, '2010-07-21 21:33:43', 63, '', '2010-07-29 00:40:09', 63, 0, '0000-00-00 00:00:00', '2010-07-21 21:33:43', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 0, 0, 8, '', '', 0, 2, 'robots=\nauthor='),
(120, 'Dead Space', 'dead-space', '', '<img src="images/stories/demo/roknewspager/review8.jpg" class="floatleft rt-image" alt="Image" width="116" height="160"/>\r\n<p>Mafia 2 immerses players in the mob underworld...</p>\r\n\r\n', '\r\n<p>In erat. Pellentesque erat. Mauris vehicula vestibulum justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nulla pulvinar est. Integer urna. Pellentesque pulvinar dui a magna. Nulla facilisi. Proin imperdiet. Aliquam ornare, metus vitae gravida dignissim, nisi nisl ultricies felis, ac tristique enim pede eget elit. Integer non erat nec turpis sollicitudin malesuada. Vestibulum dapibus. Nulla facilisi. Nulla iaculis, leo sit amet mollis luctus, sapien eros consectetur dolor, eu faucibus elit nibh eu nibh. Maecenas lacus pede, lobortis non, rhoncus id, tristique a, mi. Cras auctor libero vitae sem vestibulum euismod. Nunc fermentum.</p>\r\n\r\n<p>Mauris lobortis. Aliquam lacinia purus. Pellentesque magna. Mauris euismod metus nec tortor. Phasellus elementum, quam a euismod imperdiet, ligula felis faucibus enim, eu malesuada nunc felis sed turpis. Morbi convallis luctus tortor. Integer bibendum lacinia velit. Suspendisse mi lorem, porttitor ut, interdum et, lobortis a, lectus. Phasellus vitae est at massa luctus iaculis. In tincidunt.</p>\r\n\r\n<p>Integer fermentum elit in tellus. Integer ligula ipsum, gravida aliquet, fringilla non, interdum eget, ipsum. Praesent id dolor non erat viverra volutpat. Fusce tellus libero, luctus adipiscing, tincidunt vel, egestas vitae, eros. Vestibulum mollis, est id rhoncus volutpat, dolor velit tincidunt neque, vitae pellentesque ante sem eu nisl. Donec facilisis, magna eget elementum pellentesque, augue arcu aliquet eros, eget convallis mauris ante quis magna. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Aenean et libero. Nam aliquam. Quisque vitae tortor id neque dignissim laoreet. Duis eu ante. Integer at sapien. Praesent sed nisl tempor est pulvinar tristique. Maecenas non lorem quis mi laoreet adipiscing. Sed ac arcu. Sed tincidunt libero eu dolor. Cras pharetra posuere eros. Donec ac eros id diam tempor faucibus. Fusce feugiat consequat nulla. Vestibulum tincidunt vulputate ipsum.</p>\r\n\r\n<p>Nullam eget neque. Nullam imperdiet venenatis ligula. Integer a leo. Nunc consectetur. Maecenas sem. Proin vulputate, massa vel volutpat laoreet, purus erat pretium ligula, eget varius arcu nibh sed libero. Fusce ante. Nullam interdum aliquet metus. Ut ultrices vestibulum tellus. Praesent quis erat. Nam id turpis sit amet neque cursus luctus. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Quisque id tortor. In vitae sapien. Nunc quis tellus.</p>', 1, 5, 0, 42, '2010-07-21 21:33:43', 63, '', '2010-07-29 00:30:44', 63, 0, '0000-00-00 00:00:00', '2010-07-21 21:33:43', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 0, 0, 9, '', '', 0, 2, 'robots=\nauthor='),
(121, 'Black Ops', 'black-ops', '', '<img src="images/stories/demo/roknewspager/review10.jpg" class="floatleft rt-image" alt="Image" width="116" height="160"/>\r\n<p>Hear the call of duty once again with this 7th...</p>\r\n\r\n', '\r\n<p>In erat. Pellentesque erat. Mauris vehicula vestibulum justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nulla pulvinar est. Integer urna. Pellentesque pulvinar dui a magna. Nulla facilisi. Proin imperdiet. Aliquam ornare, metus vitae gravida dignissim, nisi nisl ultricies felis, ac tristique enim pede eget elit. Integer non erat nec turpis sollicitudin malesuada. Vestibulum dapibus. Nulla facilisi. Nulla iaculis, leo sit amet mollis luctus, sapien eros consectetur dolor, eu faucibus elit nibh eu nibh. Maecenas lacus pede, lobortis non, rhoncus id, tristique a, mi. Cras auctor libero vitae sem vestibulum euismod. Nunc fermentum.</p>\r\n\r\n<p>Mauris lobortis. Aliquam lacinia purus. Pellentesque magna. Mauris euismod metus nec tortor. Phasellus elementum, quam a euismod imperdiet, ligula felis faucibus enim, eu malesuada nunc felis sed turpis. Morbi convallis luctus tortor. Integer bibendum lacinia velit. Suspendisse mi lorem, porttitor ut, interdum et, lobortis a, lectus. Phasellus vitae est at massa luctus iaculis. In tincidunt.</p>\r\n\r\n<p>Integer fermentum elit in tellus. Integer ligula ipsum, gravida aliquet, fringilla non, interdum eget, ipsum. Praesent id dolor non erat viverra volutpat. Fusce tellus libero, luctus adipiscing, tincidunt vel, egestas vitae, eros. Vestibulum mollis, est id rhoncus volutpat, dolor velit tincidunt neque, vitae pellentesque ante sem eu nisl. Donec facilisis, magna eget elementum pellentesque, augue arcu aliquet eros, eget convallis mauris ante quis magna. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Aenean et libero. Nam aliquam. Quisque vitae tortor id neque dignissim laoreet. Duis eu ante. Integer at sapien. Praesent sed nisl tempor est pulvinar tristique. Maecenas non lorem quis mi laoreet adipiscing. Sed ac arcu. Sed tincidunt libero eu dolor. Cras pharetra posuere eros. Donec ac eros id diam tempor faucibus. Fusce feugiat consequat nulla. Vestibulum tincidunt vulputate ipsum.</p>\r\n\r\n<p>Nullam eget neque. Nullam imperdiet venenatis ligula. Integer a leo. Nunc consectetur. Maecenas sem. Proin vulputate, massa vel volutpat laoreet, purus erat pretium ligula, eget varius arcu nibh sed libero. Fusce ante. Nullam interdum aliquet metus. Ut ultrices vestibulum tellus. Praesent quis erat. Nam id turpis sit amet neque cursus luctus. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Quisque id tortor. In vitae sapien. Nunc quis tellus.</p>', 1, 5, 0, 42, '2010-07-21 21:33:23', 63, '', '2010-07-29 00:31:49', 63, 0, '0000-00-00 00:00:00', '2010-07-21 21:33:23', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 0, 0, 10, '', '', 0, 2, 'robots=\nauthor='),
(122, 'Brotherhood', 'brotherhood', '', '<img src="images/stories/demo/roknewspager/review11.jpg" class="floatleft rt-image" alt="Image" width="116" height="160"/>\r\n<p>The critically acclaimed single-player game...</p>\r\n\r\n', '\r\n<p>In erat. Pellentesque erat. Mauris vehicula vestibulum justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nulla pulvinar est. Integer urna. Pellentesque pulvinar dui a magna. Nulla facilisi. Proin imperdiet. Aliquam ornare, metus vitae gravida dignissim, nisi nisl ultricies felis, ac tristique enim pede eget elit. Integer non erat nec turpis sollicitudin malesuada. Vestibulum dapibus. Nulla facilisi. Nulla iaculis, leo sit amet mollis luctus, sapien eros consectetur dolor, eu faucibus elit nibh eu nibh. Maecenas lacus pede, lobortis non, rhoncus id, tristique a, mi. Cras auctor libero vitae sem vestibulum euismod. Nunc fermentum.</p>\r\n\r\n<p>Mauris lobortis. Aliquam lacinia purus. Pellentesque magna. Mauris euismod metus nec tortor. Phasellus elementum, quam a euismod imperdiet, ligula felis faucibus enim, eu malesuada nunc felis sed turpis. Morbi convallis luctus tortor. Integer bibendum lacinia velit. Suspendisse mi lorem, porttitor ut, interdum et, lobortis a, lectus. Phasellus vitae est at massa luctus iaculis. In tincidunt.</p>\r\n\r\n<p>Integer fermentum elit in tellus. Integer ligula ipsum, gravida aliquet, fringilla non, interdum eget, ipsum. Praesent id dolor non erat viverra volutpat. Fusce tellus libero, luctus adipiscing, tincidunt vel, egestas vitae, eros. Vestibulum mollis, est id rhoncus volutpat, dolor velit tincidunt neque, vitae pellentesque ante sem eu nisl. Donec facilisis, magna eget elementum pellentesque, augue arcu aliquet eros, eget convallis mauris ante quis magna. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Aenean et libero. Nam aliquam. Quisque vitae tortor id neque dignissim laoreet. Duis eu ante. Integer at sapien. Praesent sed nisl tempor est pulvinar tristique. Maecenas non lorem quis mi laoreet adipiscing. Sed ac arcu. Sed tincidunt libero eu dolor. Cras pharetra posuere eros. Donec ac eros id diam tempor faucibus. Fusce feugiat consequat nulla. Vestibulum tincidunt vulputate ipsum.</p>\r\n\r\n<p>Nullam eget neque. Nullam imperdiet venenatis ligula. Integer a leo. Nunc consectetur. Maecenas sem. Proin vulputate, massa vel volutpat laoreet, purus erat pretium ligula, eget varius arcu nibh sed libero. Fusce ante. Nullam interdum aliquet metus. Ut ultrices vestibulum tellus. Praesent quis erat. Nam id turpis sit amet neque cursus luctus. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Quisque id tortor. In vitae sapien. Nunc quis tellus.</p>', 1, 5, 0, 42, '2010-07-21 21:33:43', 63, '', '2010-07-29 03:45:40', 63, 0, '0000-00-00 00:00:00', '2010-07-21 21:33:43', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 0, 0, 11, '', '', 0, 2, 'robots=\nauthor='),
(123, 'Medal of Honor', 'medal-of-honor', '', '<img src="images/stories/demo/roknewspager/review12.jpg" class="floatleft rt-image" alt="Image" width="116" height="160"/>\r\n<p>Leaving the WWII theatre for the...</p>\r\n\r\n', '\r\n<p>In erat. Pellentesque erat. Mauris vehicula vestibulum justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nulla pulvinar est. Integer urna. Pellentesque pulvinar dui a magna. Nulla facilisi. Proin imperdiet. Aliquam ornare, metus vitae gravida dignissim, nisi nisl ultricies felis, ac tristique enim pede eget elit. Integer non erat nec turpis sollicitudin malesuada. Vestibulum dapibus. Nulla facilisi. Nulla iaculis, leo sit amet mollis luctus, sapien eros consectetur dolor, eu faucibus elit nibh eu nibh. Maecenas lacus pede, lobortis non, rhoncus id, tristique a, mi. Cras auctor libero vitae sem vestibulum euismod. Nunc fermentum.</p>\r\n\r\n<p>Mauris lobortis. Aliquam lacinia purus. Pellentesque magna. Mauris euismod metus nec tortor. Phasellus elementum, quam a euismod imperdiet, ligula felis faucibus enim, eu malesuada nunc felis sed turpis. Morbi convallis luctus tortor. Integer bibendum lacinia velit. Suspendisse mi lorem, porttitor ut, interdum et, lobortis a, lectus. Phasellus vitae est at massa luctus iaculis. In tincidunt.</p>\r\n\r\n<p>Integer fermentum elit in tellus. Integer ligula ipsum, gravida aliquet, fringilla non, interdum eget, ipsum. Praesent id dolor non erat viverra volutpat. Fusce tellus libero, luctus adipiscing, tincidunt vel, egestas vitae, eros. Vestibulum mollis, est id rhoncus volutpat, dolor velit tincidunt neque, vitae pellentesque ante sem eu nisl. Donec facilisis, magna eget elementum pellentesque, augue arcu aliquet eros, eget convallis mauris ante quis magna. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Aenean et libero. Nam aliquam. Quisque vitae tortor id neque dignissim laoreet. Duis eu ante. Integer at sapien. Praesent sed nisl tempor est pulvinar tristique. Maecenas non lorem quis mi laoreet adipiscing. Sed ac arcu. Sed tincidunt libero eu dolor. Cras pharetra posuere eros. Donec ac eros id diam tempor faucibus. Fusce feugiat consequat nulla. Vestibulum tincidunt vulputate ipsum.</p>\r\n\r\n<p>Nullam eget neque. Nullam imperdiet venenatis ligula. Integer a leo. Nunc consectetur. Maecenas sem. Proin vulputate, massa vel volutpat laoreet, purus erat pretium ligula, eget varius arcu nibh sed libero. Fusce ante. Nullam interdum aliquet metus. Ut ultrices vestibulum tellus. Praesent quis erat. Nam id turpis sit amet neque cursus luctus. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Quisque id tortor. In vitae sapien. Nunc quis tellus.</p>', 1, 5, 0, 42, '2010-07-21 21:33:23', 63, '', '2010-07-29 03:47:23', 63, 0, '0000-00-00 00:00:00', '2010-07-21 21:33:23', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 0, 0, 12, '', '', 0, 2, 'robots=\nauthor='),
(125, 'Important Featured Story', 'important-featured-story', '', '<img src="images/stories/demo/rokstories/rokstories1.jpg" alt="image" />\r\n\r\nPhasellus sit amet odio eros. Ut sagittis metus volutpat eros bibendum accumsan. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. In scelerisque aliquam tincidunt. Duis quis dui ac augue hendrerit elementum. Phasellus risus mauris, volutpat eget molestie vel, rhoncus eu lorem. Morbi a nisi quam.\r\n<br /><br />', '', 1, 5, 0, 37, '2009-06-11 06:12:23', 62, '', '2010-07-30 18:32:20', 63, 0, '0000-00-00 00:00:00', '2009-06-11 06:12:23', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', 1, 0, 4, '', '', 0, 0, 'robots=\nauthor=');

-- --------------------------------------------------------

--
-- Table structure for table `#__content_frontpage`
--

DROP TABLE IF EXISTS `#__content_frontpage`;
CREATE TABLE IF NOT EXISTS `#__content_frontpage` (
  `content_id` int(11) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`content_id`)
);

--
-- Dumping data for table `#__content_frontpage`
--

INSERT INTO `#__content_frontpage` (`content_id`, `ordering`) VALUES
(78, 1);

-- --------------------------------------------------------

--
-- Table structure for table `#__content_rating`
--

DROP TABLE IF EXISTS `#__content_rating`;
CREATE TABLE IF NOT EXISTS `#__content_rating` (
  `content_id` int(11) NOT NULL DEFAULT '0',
  `rating_sum` int(11) unsigned NOT NULL DEFAULT '0',
  `rating_count` int(11) unsigned NOT NULL DEFAULT '0',
  `lastip` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`content_id`)
);

--
-- Dumping data for table `#__content_rating`
--

INSERT INTO `#__content_rating` (`content_id`, `rating_sum`, `rating_count`, `lastip`) VALUES
(87, 5, 1, '70.237.140.111'),
(86, 4, 1, '70.237.140.111'),
(84, 3, 1, '70.237.140.111'),
(85, 4, 1, '70.237.140.111'),
(104, 3, 1, '70.230.188.57'),
(105, 4, 1, '70.230.188.57'),
(106, 1, 1, '70.230.188.57'),
(107, 2, 1, '70.230.188.57'),
(108, 3, 1, '70.230.188.57'),
(109, 2, 1, '70.230.188.57'),
(110, 4, 1, '70.230.188.57'),
(111, 1, 1, '70.230.188.57'),
(112, 5, 1, '70.230.188.57'),
(113, 4, 1, '70.230.188.57'),
(114, 4, 1, '70.230.188.57'),
(115, 2, 1, '70.230.188.57'),
(116, 4, 1, '70.230.188.57'),
(117, 1, 1, '70.230.188.57'),
(118, 3, 1, '70.230.188.57'),
(119, 4, 1, '70.230.188.57'),
(120, 3, 1, '70.230.188.57'),
(121, 2, 1, '70.230.188.57'),
(122, 1, 1, '70.230.188.57'),
(123, 5, 1, '70.230.188.57');

-- --------------------------------------------------------

--
-- Table structure for table `#__core_log_items`
--

DROP TABLE IF EXISTS `#__core_log_items`;
CREATE TABLE IF NOT EXISTS `#__core_log_items` (
  `time_stamp` date NOT NULL DEFAULT '0000-00-00',
  `item_table` varchar(50) NOT NULL DEFAULT '',
  `item_id` int(11) unsigned NOT NULL DEFAULT '0',
  `hits` int(11) unsigned NOT NULL DEFAULT '0'
);

--
-- Dumping data for table `#__core_log_items`
--


-- --------------------------------------------------------

--
-- Table structure for table `#__core_log_searches`
--

DROP TABLE IF EXISTS `#__core_log_searches`;
CREATE TABLE IF NOT EXISTS `#__core_log_searches` (
  `search_term` varchar(128) NOT NULL DEFAULT '',
  `hits` int(11) unsigned NOT NULL DEFAULT '0'
);

--
-- Dumping data for table `#__core_log_searches`
--


-- --------------------------------------------------------

--
-- Table structure for table `#__groups`
--

DROP TABLE IF EXISTS `#__groups`;
CREATE TABLE IF NOT EXISTS `#__groups` (
  `id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `name` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
);

--
-- Dumping data for table `#__groups`
--

INSERT INTO `#__groups` (`id`, `name`) VALUES
(0, 'Public'),
(1, 'Registered'),
(2, 'Special');

-- --------------------------------------------------------

--
-- Table structure for table `#__menu`
--

DROP TABLE IF EXISTS `#__menu`;
CREATE TABLE IF NOT EXISTS `#__menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menutype` varchar(75) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `alias` varchar(255) NOT NULL DEFAULT '',
  `link` text,
  `type` varchar(50) NOT NULL DEFAULT '',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `parent` int(11) unsigned NOT NULL DEFAULT '0',
  `componentid` int(11) unsigned NOT NULL DEFAULT '0',
  `sublevel` int(11) DEFAULT '0',
  `ordering` int(11) DEFAULT '0',
  `checked_out` int(11) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `pollid` int(11) NOT NULL DEFAULT '0',
  `browserNav` tinyint(4) DEFAULT '0',
  `access` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `utaccess` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `params` text NOT NULL,
  `lft` int(11) unsigned NOT NULL DEFAULT '0',
  `rgt` int(11) unsigned NOT NULL DEFAULT '0',
  `home` int(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `componentid` (`componentid`,`menutype`,`published`,`access`),
  KEY `menutype` (`menutype`)
);

--
-- Dumping data for table `#__menu`
--

INSERT INTO `#__menu` (`id`, `menutype`, `name`, `alias`, `link`, `type`, `published`, `parent`, `componentid`, `sublevel`, `ordering`, `checked_out`, `checked_out_time`, `pollid`, `browserNav`, `access`, `utaccess`, `params`, `lft`, `rgt`, `home`) VALUES
(1, 'mainmenu', 'Home', 'home', 'index.php?option=com_content&view=frontpage', 'component', 1, 0, 20, 0, 5, 0, '0000-00-00 00:00:00', 0, 0, 0, 3, 'num_leading_articles=1\nnum_intro_articles=0\nnum_columns=1\nnum_links=0\norderby_pri=\norderby_sec=front\nmulti_column_order=1\nshow_pagination=2\nshow_pagination_results=1\nshow_feed_link=1\nshow_noauth=0\nshow_title=1\nlink_titles=0\nshow_intro=1\nshow_section=0\nlink_section=0\nshow_category=0\nlink_category=0\nshow_author=1\nshow_create_date=1\nshow_modify_date=1\nshow_item_navigation=0\nshow_readmore=0\nshow_vote=0\nshow_icons=0\nshow_pdf_icon=0\nshow_print_icon=0\nshow_email_icon=0\nshow_hits=1\nfeed_summary=\nfusion_item_subtext=\nfusion_customimage=icon-no1.png\nfusion_customclass=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=Zephyr - August 2010 Template Demo\nshow_page_title=0\npageclass_sfx=zephyr-home\nmenu_image=-1\nsecure=0\n\n', 0, 0, 1),
(420, 'mainmenu', 'Color Chooser', 'color-chooser', 'index.php?Itemid=55', 'menulink', 1, 62, 0, 1, 8, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_item=55\nfusion_item_subtext=\nfusion_customimage=\nfusion_customclass=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(421, 'mainmenu', 'Gantry Documentation', 'gantry-documentation', 'http://gantry-framework.org/', 'url', 1, 62, 0, 1, 9, 0, '0000-00-00 00:00:00', 0, 1, 0, 0, 'menu_image=-1\nfusion_item_subtext=\nfusion_customimage=\nfusion_customclass=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(11, 'othermenu', 'Joomla! Home', 'joomla-home', 'http://www.joomla.org', 'url', 1, 0, 0, 0, 1, 0, '0000-00-00 00:00:00', 0, 0, 0, 3, 'menu_image=-1\n\n', 0, 0, 0),
(12, 'othermenu', 'Joomla! Forums', 'joomla-forums', 'http://forum.joomla.org', 'url', 1, 0, 0, 0, 2, 0, '0000-00-00 00:00:00', 0, 0, 0, 3, 'menu_image=-1\n\n', 0, 0, 0),
(13, 'othermenu', 'Joomla! Documentation', 'joomla-documentation', 'http://docs.joomla.org', 'url', 1, 0, 0, 0, 3, 0, '0000-00-00 00:00:00', 0, 0, 0, 3, 'menu_image=-1\n\n', 0, 0, 0),
(14, 'othermenu', 'Joomla! Community', 'joomla-community', 'http://community.joomla.org', 'url', 1, 0, 0, 0, 4, 0, '0000-00-00 00:00:00', 0, 0, 0, 3, 'menu_image=-1\n\n', 0, 0, 0),
(15, 'othermenu', 'Joomla! Magazine', 'joomla-community-magazine', 'http://magazine.joomla.org/', 'url', 1, 0, 0, 0, 5, 0, '0000-00-00 00:00:00', 0, 0, 0, 3, 'menu_image=-1\n\n', 0, 0, 0),
(16, 'othermenu', 'OSM Home', 'osm-home', 'http://www.opensourcematters.org', 'url', 1, 0, 0, 0, 6, 0, '0000-00-00 00:00:00', 0, 0, 0, 6, 'menu_image=-1\n\n', 0, 0, 0),
(17, 'othermenu', 'Administrator', 'administrator', 'administrator/', 'url', 1, 0, 0, 0, 7, 0, '0000-00-00 00:00:00', 0, 0, 0, 3, 'menu_image=-1\n\n', 0, 0, 0),
(18, 'topmenu', 'News', 'news', 'index.php?option=com_newsfeeds&view=newsfeed&id=1&feedid=1', 'component', 1, 0, 11, 0, 3, 0, '0000-00-00 00:00:00', 0, 0, 0, 3, 'show_page_title=1\npage_title=News\npageclass_sfx=\nmenu_image=-1\nsecure=0\nshow_headings=1\nshow_name=1\nshow_articles=1\nshow_link=1\nshow_other_cats=1\nshow_cat_description=1\nshow_cat_items=1\nshow_feed_image=1\nshow_feed_description=1\nshow_item_description=1\nfeed_word_count=0\n\n', 0, 0, 0),
(20, 'usermenu', 'Your Details', 'your-details', 'index.php?option=com_user&view=user&task=edit', 'component', 1, 0, 14, 0, 1, 0, '0000-00-00 00:00:00', 0, 0, 1, 3, '', 0, 0, 0),
(24, 'usermenu', 'Logout', 'logout', 'index.php?option=com_user&view=login', 'component', 1, 0, 14, 0, 4, 0, '0000-00-00 00:00:00', 0, 0, 1, 3, '', 0, 0, 0),
(38, 'keyconcepts', 'Content Layouts', 'content-layouts', 'index.php?option=com_content&view=article&id=24', 'component', 1, 0, 20, 0, 2, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'pageclass_sfx=\nmenu_image=-1\nsecure=0\nshow_noauth=0\nlink_titles=0\nshow_intro=1\nshow_section=0\nlink_section=0\nshow_category=0\nlink_category=0\nshow_author=1\nshow_create_date=1\nshow_modify_date=1\nshow_item_navigation=0\nshow_readmore=1\nshow_vote=0\nshow_icons=1\nshow_pdf_icon=1\nshow_print_icon=1\nshow_email_icon=1\nshow_hits=1\n\n', 0, 0, 0),
(27, 'mainmenu', 'J Stuff', 'j-stuff', 'index.php?option=com_content&view=article&id=19', 'component', 1, 0, 20, 0, 10, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=0\nshow_title=\nlink_titles=0\nshow_intro=1\nshow_section=0\nlink_section=0\nshow_category=0\nlink_category=0\nshow_author=1\nshow_create_date=1\nshow_modify_date=1\nshow_item_navigation=0\nshow_readmore=1\nshow_vote=0\nshow_icons=1\nshow_pdf_icon=1\nshow_print_icon=1\nshow_email_icon=1\nshow_hits=1\nfeed_summary=\nfusion_item_subtext=\nfusion_customimage=icon-no6.png\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(28, 'topmenu', 'About Joomla!', 'about-joomla', 'index.php?option=com_content&view=article&id=25', 'component', 1, 0, 20, 0, 1, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'pageclass_sfx=\nmenu_image=-1\nsecure=0\nshow_noauth=0\nlink_titles=0\nshow_intro=1\nshow_section=0\nlink_section=0\nshow_category=0\nlink_category=0\nshow_author=1\nshow_create_date=1\nshow_modify_date=1\nshow_item_navigation=0\nshow_readmore=1\nshow_vote=0\nshow_icons=1\nshow_pdf_icon=1\nshow_print_icon=1\nshow_email_icon=1\nshow_hits=1\n\n', 0, 0, 0),
(29, 'topmenu', 'Features', 'features', 'index.php?option=com_content&view=article&id=22', 'component', 1, 0, 20, 0, 2, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'pageclass_sfx=\nmenu_image=-1\nsecure=0\nshow_noauth=0\nlink_titles=0\nshow_intro=1\nshow_section=0\nlink_section=0\nshow_category=0\nlink_category=0\nshow_author=1\nshow_create_date=1\nshow_modify_date=1\nshow_item_navigation=0\nshow_readmore=1\nshow_vote=0\nshow_icons=1\nshow_pdf_icon=1\nshow_print_icon=1\nshow_email_icon=1\nshow_hits=1\n\n', 0, 0, 0),
(30, 'topmenu', 'The Community', 'the-community', 'index.php?option=com_content&view=article&id=27', 'component', 1, 0, 20, 0, 4, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'pageclass_sfx=\nmenu_image=-1\nsecure=0\nshow_noauth=0\nlink_titles=0\nshow_intro=1\nshow_section=0\nlink_section=0\nshow_category=0\nlink_category=0\nshow_author=1\nshow_create_date=1\nshow_modify_date=1\nshow_item_navigation=0\nshow_readmore=1\nshow_vote=0\nshow_icons=1\nshow_pdf_icon=1\nshow_print_icon=1\nshow_email_icon=1\nshow_hits=1\n\n', 0, 0, 0),
(40, 'keyconcepts', 'Extensions', 'extensions', 'index.php?option=com_content&view=article&id=26', 'component', 1, 0, 20, 0, 1, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'pageclass_sfx=\nmenu_image=-1\nsecure=0\nshow_noauth=0\nlink_titles=0\nshow_intro=1\nshow_section=0\nlink_section=0\nshow_category=0\nlink_category=0\nshow_author=1\nshow_create_date=1\nshow_modify_date=1\nshow_item_navigation=0\nshow_readmore=1\nshow_vote=0\nshow_icons=1\nshow_pdf_icon=1\nshow_print_icon=1\nshow_email_icon=1\nshow_hits=1\n\n', 0, 0, 0),
(37, 'mainmenu', 'Section Layout', 'section-layout', 'index.php?option=com_content&view=section&id=4', 'component', 1, 27, 20, 1, 1, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_description=0\nshow_description_image=0\nshow_categories=1\nshow_empty_categories=0\nshow_cat_num_articles=1\nshow_category_description=1\norderby=\norderby_sec=\nshow_feed_link=1\nshow_noauth=0\nshow_title=1\nlink_titles=0\nshow_intro=1\nshow_section=0\nlink_section=0\nshow_category=0\nlink_category=0\nshow_author=1\nshow_create_date=1\nshow_modify_date=1\nshow_item_navigation=0\nshow_readmore=1\nshow_vote=0\nshow_icons=1\nshow_pdf_icon=1\nshow_print_icon=1\nshow_email_icon=1\nshow_hits=1\nfeed_summary=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(43, 'keyconcepts', 'Example Pages', 'example-pages', 'index.php?option=com_content&view=article&id=43', 'component', 1, 0, 20, 0, 3, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'pageclass_sfx=\nmenu_image=-1\nsecure=0\nshow_noauth=0\nlink_titles=0\nshow_intro=1\nshow_section=0\nlink_section=0\nshow_category=0\nlink_category=0\nshow_author=1\nshow_create_date=1\nshow_modify_date=1\nshow_item_navigation=0\nshow_readmore=1\nshow_vote=0\nshow_icons=1\nshow_pdf_icon=1\nshow_print_icon=1\nshow_email_icon=1\nshow_hits=1\n\n', 0, 0, 0),
(44, 'ExamplePages', 'Section Blog', 'section-blog', 'index.php?option=com_content&view=section&layout=blog&id=3', 'component', 1, 0, 20, 0, 1, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_page_title=1\npage_title=Example of Section Blog layout (FAQ section)\nshow_description=0\nshow_description_image=0\nnum_leading_articles=1\nnum_intro_articles=4\nnum_columns=2\nnum_links=4\nshow_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\norderby_pri=\norderby_sec=\nshow_pagination=2\nshow_pagination_results=1\nshow_noauth=0\nlink_titles=0\nshow_intro=1\nshow_section=0\nlink_section=0\nshow_category=0\nlink_category=0\nshow_author=1\nshow_create_date=1\nshow_modify_date=1\nshow_item_navigation=0\nshow_readmore=1\nshow_vote=0\nshow_icons=1\nshow_pdf_icon=1\nshow_print_icon=1\nshow_email_icon=1\nshow_hits=1\n\n', 0, 0, 0),
(45, 'ExamplePages', 'Section Table', 'section-table', 'index.php?option=com_content&view=section&id=3', 'component', 1, 0, 20, 0, 2, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_page_title=1\npage_title=Example of Table Blog layout (FAQ section)\nshow_description=0\nshow_description_image=0\nshow_categories=1\nshow_empty_categories=0\nshow_cat_num_articles=1\nshow_category_description=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\norderby=\nshow_noauth=0\nshow_title=1\nnlink_titles=0\nshow_intro=1\nshow_section=0\nlink_section=0\nshow_category=0\nlink_category=0\nshow_author=1\nshow_create_date=1\nshow_modify_date=1\nshow_item_navigation=0\nshow_readmore=1\nshow_vote=0\nshow_icons=1\nshow_pdf_icon=1\nshow_print_icon=1\nshow_email_icon=1\nshow_hits=1\n\n', 0, 0, 0),
(46, 'ExamplePages', 'Category Blog', 'categoryblog', 'index.php?option=com_content&view=category&layout=blog&id=31', 'component', 1, 0, 20, 0, 3, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_page_title=1\npage_title=Example of Category Blog layout (FAQs/General category)\nshow_description=0\nshow_description_image=0\nnum_leading_articles=1\nnum_intro_articles=4\nnum_columns=2\nnum_links=4\nshow_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\norderby_pri=\norderby_sec=\nshow_pagination=2\nshow_pagination_results=1\nshow_noauth=0\nlink_titles=0\nshow_intro=1\nshow_section=0\nlink_section=0\nshow_category=0\nlink_category=0\nshow_author=1\nshow_create_date=1\nshow_modify_date=1\nshow_item_navigation=0\nshow_readmore=1\nshow_vote=0\nshow_icons=1\nshow_pdf_icon=1\nshow_print_icon=1\nshow_email_icon=1\nshow_hits=1\n\n', 0, 0, 0),
(47, 'ExamplePages', 'Category Table', 'category-table', 'index.php?option=com_content&view=category&id=32', 'component', 1, 0, 20, 0, 4, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_page_title=1\npage_title=Example of Category Table layout (FAQs/Languages category)\nshow_headings=1\nshow_date=0\ndate_format=\nfilter=1\nfilter_type=title\npageclass_sfx=\nmenu_image=-1\nsecure=0\norderby_sec=\nshow_pagination=1\nshow_pagination_limit=1\nshow_noauth=0\nshow_title=1\nlink_titles=0\nshow_intro=1\nshow_section=0\nlink_section=0\nshow_category=0\nlink_category=0\nshow_author=1\nshow_create_date=1\nshow_modify_date=1\nshow_item_navigation=0\nshow_readmore=1\nshow_vote=0\nshow_icons=1\nshow_pdf_icon=1\nshow_print_icon=1\nshow_email_icon=1\nshow_hits=1\n\n', 0, 0, 0),
(50, 'mainmenu', 'Category Blog', 'category-blog', 'index.php?option=com_content&view=category&layout=blog&id=1', 'component', 1, 27, 20, 1, 2, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_description=0\nshow_description_image=0\nnum_leading_articles=1\nnum_intro_articles=2\nnum_columns=1\nnum_links=4\norderby_pri=\norderby_sec=\nmulti_column_order=0\nshow_pagination=2\nshow_pagination_results=1\nshow_feed_link=1\nshow_noauth=0\nshow_title=1\nlink_titles=0\nshow_intro=1\nshow_section=0\nlink_section=0\nshow_category=0\nlink_category=0\nshow_author=1\nshow_create_date=1\nshow_modify_date=1\nshow_item_navigation=0\nshow_readmore=1\nshow_vote=0\nshow_icons=1\nshow_pdf_icon=1\nshow_print_icon=1\nshow_email_icon=1\nshow_hits=1\nfeed_summary=\nfusion_item_subtext=\nfusion_columns=1\nfusion_customimage=\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=The News\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(51, 'usermenu', 'Submit an Article', 'submit-an-article', 'index.php?option=com_content&view=article&layout=form', 'component', 1, 0, 20, 0, 2, 0, '0000-00-00 00:00:00', 0, 0, 2, 0, '', 0, 0, 0),
(52, 'usermenu', 'Submit a Web Link', 'submit-a-web-link', 'index.php?option=com_weblinks&view=weblink&layout=form', 'component', 1, 0, 4, 0, 3, 0, '0000-00-00 00:00:00', 0, 0, 2, 0, '', 0, 0, 0),
(78, 'mainmenu', 'RokStories', 'rokstories', 'index.php?Itemid=61', 'menulink', 1, 210, 0, 2, 4, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_item=61\nfusion_item_subtext=\nfusion_customimage=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(53, 'mainmenu', 'Features', 'features', 'index.php?option=com_content&view=article&id=46', 'component', 1, 0, 20, 0, 6, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\nfusion_item_subtext=\nfusion_customimage=icon-no2.png\nfusion_customclass=\nfusion_columns=3\nfusion_distribution=even\nfusion_dropdown_width=620\nfusion_column_widths=160,160\nfusion_children_group=0\nfusion_children_type=menuitems\nfusion_modules=16\nfusion_module_positions=sidebar-a\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(54, 'mainmenu', 'Gantry Features', 'gantry-features', 'index.php?option=com_content&view=article&id=47', 'component', 1, 53, 20, 1, 3, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\nfusion_item_subtext=\nfusion_customimage=icon-crank.png\nfusion_customclass=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=1\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(55, 'mainmenu', 'Color Chooser', 'color-chooser', 'index.php?option=com_content&view=article&id=63', 'component', 1, 171, 20, 2, 1, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\nfusion_item_subtext=\nfusion_customimage=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(56, 'mainmenu', 'Module Variations', 'module-variations', 'index.php?option=com_content&view=article&id=48', 'component', 1, 171, 20, 2, 4, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\nfusion_item_subtext=\nfusion_customimage=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(57, 'mainmenu', 'Module Positions', 'module-positions', 'index.php?option=com_content&view=article&id=49', 'component', 1, 171, 20, 2, 5, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\nfusion_item_subtext=\nfusion_customimage=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(58, 'mainmenu', 'Typography', 'typography', 'index.php?Itemid=59', 'menulink', 1, 171, 0, 2, 3, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_item=59\nfusion_item_subtext=\nfusion_customimage=-1\nfusion_customclass=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(422, 'mainmenu', 'Preset 9', 'preset-9', '?presets=preset9', 'url', 1, 69, 0, 1, 9, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_image=-1\nfusion_item_subtext=\nfusion_customimage=preset9.png\nfusion_customclass=rt-style\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(59, 'mainmenu', 'HTML Examples', 'html-examples', 'index.php?option=com_content&view=article&id=51', 'component', 1, 58, 20, 3, 1, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(60, 'mainmenu', 'RokCandy Examples', 'rokcandy-examples', 'index.php?option=com_content&view=article&id=52', 'component', 1, 58, 20, 3, 2, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\nfusion_item_subtext=\nfusion_columns=1\nfusion_customimage=\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(61, 'mainmenu', 'Extensions', 'extensions', 'index.php?option=com_content&view=article&id=53', 'component', 1, 0, 20, 0, 7, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\nfusion_item_subtext=\nfusion_customimage=icon-no3.png\nfusion_customclass=\nfusion_columns=2\nfusion_distribution=even\nfusion_dropdown_width=320\nfusion_column_widths=160\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(62, 'mainmenu', 'Tutorials', 'tutorials', 'index.php?option=com_content&view=article&id=54', 'component', 1, 0, 20, 0, 8, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\nfusion_item_subtext=\nfusion_customimage=icon-no4.png\nfusion_customclass=\nfusion_columns=2\nfusion_distribution=even\nfusion_dropdown_width=300\nfusion_column_widths=140,160\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(63, 'mainmenu', 'Installation', 'installation', 'index.php?option=com_content&view=article&id=55', 'component', 1, 62, 20, 1, 1, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\nfusion_item_subtext=\nfusion_customimage=\nfusion_customclass=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(64, 'mainmenu', 'RocketLauncher', 'rocketlauncher', 'index.php?option=com_content&view=article&id=56', 'component', 1, 62, 20, 1, 2, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(65, 'mainmenu', 'Style Control', 'style-control', 'index.php?option=com_content&view=article&id=57', 'component', 1, 62, 20, 1, 7, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\nfusion_item_subtext=\nfusion_customimage=\nfusion_customclass=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(66, 'mainmenu', 'Menu Options', 'menu-options', 'index.php?option=com_content&view=article&id=58', 'component', 1, 62, 20, 1, 4, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\nfusion_item_subtext=\nfusion_customimage=\nfusion_customclass=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(67, 'mainmenu', 'Logo Editing', 'logo-editing', 'index.php?option=com_content&view=article&id=59', 'component', 1, 62, 20, 1, 3, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(68, 'mainmenu', 'Using Typography', 'using-typography', 'index.php?option=com_content&view=article&id=60', 'component', 1, 62, 20, 1, 6, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(69, 'mainmenu', 'Styles', 'styles', 'index.php?option=com_content&view=article&id=61', 'component', 1, 0, 20, 0, 9, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\nfusion_item_subtext=\nfusion_customimage=icon-no5.png\nfusion_customclass=\nfusion_columns=4\nfusion_distribution=even\nfusion_dropdown_width=360\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(70, 'mainmenu', 'Menu Icons', 'menu-icons', 'index.php?Itemid=66', 'menulink', 1, 172, 0, 2, 2, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_item=66\nfusion_item_subtext=\nfusion_customimage=-1\nfusion_columns=2\nfusion_distribution=even\nfusion_dropdown_width=360\nfusion_column_widths=180,180\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(71, 'mainmenu', 'Child Items', 'child-items', 'index.php?option=com_content&view=article&id=62', 'component', 1, 172, 20, 2, 1, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\nfusion_item_subtext=\nfusion_customimage=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(72, 'mainmenu', 'Web Links', 'web-links', 'index.php?option=com_weblinks&view=category&id=2', 'component', 1, 27, 4, 1, 3, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_feed_link=1\nshow_comp_description=\ncomp_description=\nshow_link_hits=\nshow_link_description=\nshow_other_cats=\nshow_headings=\ntarget=\nlink_icons=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(73, 'mainmenu', 'Contact Us', 'contact-us', 'index.php?option=com_contact&view=contact&id=1', 'component', 1, 27, 7, 1, 4, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_contact_list=0\nshow_category_crumb=0\ncontact_icons=\nicon_address=\nicon_email=\nicon_telephone=\nicon_mobile=\nicon_fax=\nicon_misc=\nshow_headings=\nshow_position=\nshow_email=\nshow_telephone=\nshow_mobile=\nshow_fax=\nallow_vcard=\nbanned_email=\nbanned_subject=\nbanned_text=\nvalidate_session=\ncustom_reply=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(74, 'mainmenu', 'Member Access', 'member-access', 'index.php?option=com_user&view=login', 'component', 1, 27, 14, 1, 5, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_login_title=1\nheader_login=\nlogin=\nlogin_message=0\ndescription_login=0\ndescription_login_text=\nimage_login=\nimage_login_align=right\nshow_logout_title=1\nheader_logout=\nlogout=\nlogout_message=1\ndescription_logout=1\ndescription_logout_text=\nimage_logout=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(75, 'mainmenu', 'Wrapper', 'wrapper', 'index.php?option=com_wrapper&view=wrapper', 'component', 1, 27, 17, 1, 6, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'url=http://www.google.com\nscrolling=auto\nwidth=100%\nheight=600\nheight_auto=0\nadd_scheme=1\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(76, 'mainmenu', 'RokTabs', 'roktabs', 'index.php?Itemid=61', 'menulink', 1, 210, 0, 2, 2, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_item=61\nfusion_item_subtext=\nfusion_customimage=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(77, 'mainmenu', 'RokAjaxSearch', 'rokajaxsearch', 'index.php?Itemid=61', 'menulink', 1, 210, 0, 2, 3, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_item=61\nfusion_item_subtext=\nfusion_customimage=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(79, 'mainmenu', 'RokNavMenu', 'roknavmenu', 'index.php?Itemid=61', 'menulink', 1, 211, 0, 2, 5, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_item=61\nfusion_item_subtext=\nfusion_customimage=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(80, 'mainmenu', 'RokBox', 'rokbox', 'index.php?Itemid=61', 'menulink', 1, 211, 0, 2, 1, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_item=61\nfusion_item_subtext=\nfusion_customimage=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(81, 'mainmenu', 'RokGZipper', 'rokgzipper', 'index.php?Itemid=61', 'menulink', 1, 211, 0, 2, 2, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_item=61\nfusion_item_subtext=\nfusion_customimage=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(82, 'mainmenu', 'RokCandy', 'rokcandy', 'index.php?Itemid=61', 'menulink', 1, 211, 0, 2, 3, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_item=61\nfusion_item_subtext=\nfusion_customimage=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(83, 'mainmenu', 'RokPad', 'rokpad', 'index.php?Itemid=61', 'menulink', 1, 211, 0, 2, 4, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_item=61\nfusion_item_subtext=\nfusion_customimage=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(84, 'mainmenu', 'Child Item', 'child-item-84', 'index.php?option=com_content&view=article&id=62', 'component', 1, 71, 20, 3, 1, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\nfusion_item_subtext=Single Column Example\nfusion_customimage=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(85, 'mainmenu', 'Child Item', 'child-item-85', 'index.php?option=com_content&view=article&id=62', 'component', 1, 84, 20, 4, 3, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(86, 'mainmenu', 'Child Item', 'child-item-86', 'index.php?option=com_content&view=article&id=62', 'component', 1, 85, 20, 5, 3, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(87, 'mainmenu', 'Child Item', 'child-item-87', 'index.php?option=com_content&view=article&id=62', 'component', 1, 86, 20, 6, 1, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(88, 'mainmenu', 'Child Item', 'child-item-87', 'index.php?option=com_content&view=article&id=62', 'component', 1, 86, 20, 6, 2, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(89, 'mainmenu', 'Child Item', 'child-item-89', 'index.php?option=com_content&view=article&id=62', 'component', 1, 86, 20, 6, 3, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(90, 'mainmenu', 'Child Item', 'child-item-90', 'index.php?option=com_content&view=article&id=62', 'component', 1, 86, 20, 6, 4, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(91, 'mainmenu', 'Child Item', 'child-item-86', 'index.php?option=com_content&view=article&id=62', 'component', 1, 85, 20, 5, 2, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(92, 'mainmenu', 'Child Item', 'child-item-92', 'index.php?option=com_content&view=article&id=62', 'component', 1, 85, 20, 5, 1, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(93, 'mainmenu', 'Child Item', 'child-item-93', 'index.php?option=com_content&view=article&id=62', 'component', 1, 85, 20, 5, 4, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(94, 'mainmenu', 'Child Item', 'child-item-94', 'index.php?option=com_content&view=article&id=62', 'component', 1, 84, 20, 4, 2, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(95, 'mainmenu', 'Child Item', 'child-item-95', 'index.php?option=com_content&view=article&id=62', 'component', 1, 84, 20, 4, 1, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(96, 'mainmenu', 'Child Item', 'child-item-96', 'index.php?option=com_content&view=article&id=62', 'component', 1, 84, 20, 4, 4, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(97, 'mainmenu', 'Child Item', 'child-item-97', 'index.php?option=com_content&view=article&id=62', 'component', 1, 71, 20, 3, 2, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\nfusion_item_subtext=Dual Column Example\nfusion_customimage=\nfusion_columns=2\nfusion_distribution=inorder\nfusion_dropdown_width=320\nfusion_column_widths=160,160\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(98, 'mainmenu', 'Child Item', 'child-item-98', 'index.php?option=com_content&view=article&id=62', 'component', 1, 71, 20, 3, 4, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\nfusion_item_subtext=Quad Column Example\nfusion_customimage=\nfusion_customclass=\nfusion_columns=4\nfusion_distribution=even\nfusion_dropdown_width=600\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(99, 'mainmenu', 'Child Item', 'child-item-99', 'index.php?option=com_content&view=article&id=62', 'component', 1, 98, 20, 4, 1, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\nfusion_item_subtext=\nfusion_customimage=\nfusion_customclass=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(100, 'mainmenu', 'Child Item', 'child-item-100', 'index.php?option=com_content&view=article&id=62', 'component', 1, 97, 20, 4, 1, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(101, 'mainmenu', 'Child Item', 'child-item-101', 'index.php?option=com_content&view=article&id=62', 'component', 1, 97, 20, 4, 2, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(102, 'mainmenu', 'Child Item', 'child-item-102', 'index.php?option=com_content&view=article&id=62', 'component', 1, 97, 20, 4, 3, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(103, 'mainmenu', 'Child Item', 'child-item-103', 'index.php?option=com_content&view=article&id=62', 'component', 1, 97, 20, 4, 4, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(104, 'mainmenu', 'Child Item', 'child-item-104', 'index.php?option=com_content&view=article&id=62', 'component', 1, 97, 20, 4, 5, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(105, 'mainmenu', 'Child Item', 'child-item-105', 'index.php?option=com_content&view=article&id=62', 'component', 1, 97, 20, 4, 7, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\nfusion_item_subtext=Single Column Example\nfusion_customimage=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(106, 'mainmenu', 'Child Item', 'child-item-106', 'index.php?option=com_content&view=article&id=62', 'component', 1, 97, 20, 4, 6, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(107, 'mainmenu', 'Child Item', 'child-item-107', 'index.php?option=com_content&view=article&id=62', 'component', 1, 97, 20, 4, 8, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(108, 'mainmenu', 'Child Item', 'child-item-108', 'index.php?option=com_content&view=article&id=62', 'component', 1, 105, 20, 5, 1, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(109, 'mainmenu', 'Child Item', 'child-item-109', 'index.php?option=com_content&view=article&id=62', 'component', 1, 105, 20, 5, 2, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(110, 'mainmenu', 'Child Item', 'child-item-110', 'index.php?option=com_content&view=article&id=62', 'component', 1, 105, 20, 5, 3, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(111, 'mainmenu', 'Child Item', 'child-item-111', 'index.php?option=com_content&view=article&id=62', 'component', 1, 105, 20, 5, 4, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0);
INSERT INTO `#__menu` (`id`, `menutype`, `name`, `alias`, `link`, `type`, `published`, `parent`, `componentid`, `sublevel`, `ordering`, `checked_out`, `checked_out_time`, `pollid`, `browserNav`, `access`, `utaccess`, `params`, `lft`, `rgt`, `home`) VALUES
(112, 'mainmenu', 'Add Icon', 'add-icon', '', 'separator', 1, 70, 0, 3, 1, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_image=-1\nfusion_item_subtext=\nfusion_columns=1\nfusion_customimage=icon-add.png\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(113, 'mainmenu', 'Arrow Icon', 'arrow-icon', '', 'separator', 1, 70, 0, 3, 2, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_image=-1\nfusion_item_subtext=\nfusion_columns=1\nfusion_customimage=icon-arrow.png\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(114, 'mainmenu', 'Briefcase Icon', 'briefcase-icon', '', 'separator', 1, 70, 0, 3, 4, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_image=-1\nfusion_item_subtext=\nfusion_columns=1\nfusion_customimage=icon-briefcase.png\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(115, 'mainmenu', 'Calendar Icon', 'calendar-icon', '', 'separator', 1, 70, 0, 3, 5, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_image=-1\nfusion_item_subtext=\nfusion_columns=1\nfusion_customimage=icon-calendar.png\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(116, 'mainmenu', 'Check Icon', 'check-icon', '', 'separator', 1, 70, 0, 3, 6, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_image=-1\nfusion_item_subtext=\nfusion_columns=1\nfusion_customimage=icon-check.png\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(117, 'mainmenu', 'Crank Icon', 'crank-icon', '', 'separator', 1, 70, 0, 3, 7, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_image=-1\nfusion_item_subtext=\nfusion_columns=1\nfusion_customimage=icon-crank.png\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(118, 'mainmenu', 'Delete Icon', 'delete-icon', '', 'separator', 1, 70, 0, 3, 8, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_image=-1\nfusion_item_subtext=\nfusion_columns=1\nfusion_customimage=icon-delete.png\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(119, 'mainmenu', 'Docs Icon', 'docs-icon', '', 'separator', 1, 70, 0, 3, 9, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_image=-1\nfusion_item_subtext=\nfusion_columns=1\nfusion_customimage=icon-docs.png\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(120, 'mainmenu', 'Email Icon', 'email-icon', '', 'separator', 1, 70, 0, 3, 10, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_image=-1\nfusion_item_subtext=\nfusion_columns=1\nfusion_customimage=icon-email.png\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(121, 'mainmenu', 'Home Icon', 'home-icon', '', 'separator', 1, 70, 0, 3, 11, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_image=-1\nfusion_item_subtext=\nfusion_columns=1\nfusion_customimage=icon-home.png\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(122, 'mainmenu', 'Key Icon', 'key-icon', '', 'separator', 1, 70, 0, 3, 12, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_image=-1\nfusion_item_subtext=\nfusion_columns=1\nfusion_customimage=icon-key.png\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(123, 'mainmenu', 'Lock Icon', 'lock-icon', '', 'separator', 1, 70, 0, 3, 13, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_image=-1\nfusion_item_subtext=\nfusion_columns=1\nfusion_customimage=icon-key1.png\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(124, 'mainmenu', 'Minus Icon', 'minus-icon', '', 'separator', 1, 70, 0, 3, 14, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_image=-1\nfusion_item_subtext=\nfusion_columns=1\nfusion_customimage=icon-minus.png\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(125, 'mainmenu', 'Monitor Icon', 'monitor-icon', '', 'separator', 1, 70, 0, 3, 15, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_image=-1\nfusion_item_subtext=\nfusion_columns=1\nfusion_customimage=icon-monitor.png\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(126, 'mainmenu', 'Notes Icon', 'notes-icon', '', 'separator', 1, 70, 0, 3, 16, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_image=-1\nfusion_item_subtext=\nfusion_columns=1\nfusion_customimage=icon-notes.png\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(127, 'mainmenu', 'Post Icon', 'post-icon', '', 'separator', 1, 70, 0, 3, 17, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_image=-1\nfusion_item_subtext=\nfusion_columns=1\nfusion_customimage=icon-post.png\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(128, 'mainmenu', 'Printer Icon', 'printer-icon', '', 'separator', 1, 70, 0, 3, 18, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_image=-1\nfusion_item_subtext=\nfusion_columns=1\nfusion_customimage=icon-printer.png\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(129, 'mainmenu', 'RSS Icon', 'rss-icon', '', 'separator', 1, 70, 0, 3, 19, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_image=-1\nfusion_item_subtext=\nfusion_columns=1\nfusion_customimage=icon-rss.png\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(130, 'mainmenu', 'Unlock Icon', 'unlock-icon', '', 'separator', 1, 70, 0, 3, 20, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_image=-1\nfusion_item_subtext=\nfusion_columns=1\nfusion_customimage=icon-key2.png\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(131, 'mainmenu', 'Warning Icon', 'warning-icon', '', 'separator', 1, 70, 0, 3, 21, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_image=-1\nfusion_item_subtext=\nfusion_columns=1\nfusion_customimage=icon-warning.png\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(132, 'mainmenu', 'Write Icon', 'write-icon', '', 'separator', 1, 70, 0, 3, 22, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_image=-1\nfusion_item_subtext=\nfusion_columns=1\nfusion_customimage=icon-write.png\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(133, 'mainmenu', 'Arrow2 Icon', 'arrow2-icon', '', 'separator', 1, 70, 0, 3, 3, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_image=-1\nfusion_item_subtext=\nfusion_columns=1\nfusion_customimage=icon-arrow2.png\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(134, 'mainmenu', 'Using Typography', 'using-typography', 'index.php?Itemid=68', 'menulink', 1, 58, 0, 3, 3, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_item=68\nfusion_item_subtext=\nfusion_columns=1\nfusion_customimage=\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(135, 'mainmenu', 'Preset 1', 'preset-1', '?presets=preset1', 'url', 1, 69, 0, 1, 1, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_image=-1\nfusion_item_subtext=\nfusion_customimage=preset1.png\nfusion_customclass=rt-style\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(136, 'mainmenu', 'Preset 2', 'preset-2', '?presets=preset2', 'url', 1, 69, 0, 1, 2, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_image=-1\nfusion_item_subtext=\nfusion_customimage=preset2.png\nfusion_customclass=rt-style\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(137, 'mainmenu', 'Preset 4', 'preset-4', '?presets=preset4', 'url', 1, 69, 0, 1, 4, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_image=-1\nfusion_item_subtext=\nfusion_customimage=preset4.png\nfusion_customclass=rt-style\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(138, 'mainmenu', 'Preset 3', 'preset-3', '?presets=preset3', 'url', 1, 69, 0, 1, 3, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_image=-1\nfusion_item_subtext=\nfusion_customimage=preset3.png\nfusion_customclass=rt-style\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(139, 'mainmenu', 'Preset 5', 'preset-5', '?presets=preset5', 'url', 1, 69, 0, 1, 5, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_image=-1\nfusion_item_subtext=\nfusion_customimage=preset5.png\nfusion_customclass=rt-style\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(140, 'mainmenu', 'Preset 6', 'preset-6', '?presets=preset6', 'url', 1, 69, 0, 1, 6, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_image=-1\nfusion_item_subtext=\nfusion_customimage=preset6.png\nfusion_customclass=rt-style\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(141, 'mainmenu', 'Preset 7', 'preset-7', '?presets=preset7', 'url', 1, 69, 0, 1, 7, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_image=-1\nfusion_item_subtext=\nfusion_customimage=preset7.png\nfusion_customclass=rt-style\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(142, 'mainmenu', 'Preset 8', 'preset-8', '?presets=preset8', 'url', 1, 69, 0, 1, 8, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_image=-1\nfusion_item_subtext=\nfusion_customimage=preset8.png\nfusion_customclass=rt-style\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(143, 'mainmenu', 'RokQuickCart', 'rokquickcart', 'index.php?Itemid=61', 'menulink', 1, 210, 0, 2, 1, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_item=61\nfusion_item_subtext=\nfusion_customimage=\nfusion_customclass=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(144, 'mainmenu', 'JomSocial', 'jomsocial', 'index.php?option=com_community&view=frontpage', 'component', -2, 0, 42, 1, 1, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'fusion_item_subtext=\nfusion_columns=1\nfusion_customimage=\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(145, 'mainmenu', '3rd Party', '3rd-party', 'index.php?option=com_content&view=article&id=82', 'component', 1, 0, 20, 0, 11, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\nfusion_item_subtext=\nfusion_customimage=icon-no7.png\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(146, 'mainmenu', 'K2', 'k2', 'index.php?option=com_k2&view=itemlist&layout=category&task=category&id=5', 'component', -2, 0, 57, 1, 4, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'categories=5\nfeedLink=1\nfusion_item_subtext=\nfusion_columns=1\nfusion_customimage=\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(147, 'mainmenu', 'Tienda', 'tienda', 'index.php?option=com_tienda&view=products&filter_category=1', 'component', -2, 0, 56, 1, 3, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'fusion_item_subtext=\nfusion_columns=1\nfusion_customimage=\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(148, 'mainmenu', 'JComments', 'jcomments', 'index.php?option=com_content&view=article&id=83', 'component', -2, 0, 20, 1, 2, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\nfusion_item_subtext=\nfusion_columns=1\nfusion_customimage=\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(187, 'mainmenu', 'Child Item', 'child-item-187', 'index.php?option=com_content&view=article&id=62', 'component', 1, 89, 20, 7, 1, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\nfusion_item_subtext=\nfusion_customimage=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(171, 'mainmenu', 'Template Features', 'template-features', 'index.php?Itemid=53', 'menulink', 1, 53, 0, 1, 1, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_item=53\nfusion_item_subtext=\nfusion_customimage=icon-check.png\nfusion_customclass=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=1\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(170, 'mainmenu', 'Dropdown Poll', 'dropdown-poll', 'index.php?option=com_poll&view=poll&id=15', 'component', 1, 0, 10, 0, 12, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'fusion_item_subtext=\nfusion_customimage=icon-no8.png\nfusion_customclass=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=200\nfusion_column_widths=200\nfusion_children_group=0\nfusion_children_type=modulepos\nfusion_modules=162\nfusion_module_positions=menu-poll\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(172, 'mainmenu', 'Menu Examples', 'menu-examples', '', 'separator', 1, 53, 0, 1, 2, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_image=-1\nfusion_item_subtext=\nfusion_customimage=icon-home.png\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=1\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(173, 'mainmenu', 'Advertisement', 'advertisement', '', 'separator', 1, 53, 0, 1, 4, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_image=-1\nfusion_item_subtext=\nfusion_customimage=\nfusion_customclass=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=1\nfusion_children_type=modulepos\nfusion_modules=157\nfusion_module_positions=menu1\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(174, 'mainmenu', 'Child Item', 'child-item-97', 'index.php?option=com_content&view=article&id=62', 'component', 1, 71, 20, 3, 3, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\nfusion_item_subtext=Triple Column Example\nfusion_customimage=\nfusion_columns=3\nfusion_distribution=inorder\nfusion_dropdown_width=480\nfusion_column_widths=160,160,160\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(175, 'mainmenu', 'Child Item', 'child-item-100', 'index.php?option=com_content&view=article&id=62', 'component', 1, 174, 20, 4, 1, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(176, 'mainmenu', 'Child Item', 'child-item-101', 'index.php?option=com_content&view=article&id=62', 'component', 1, 174, 20, 4, 2, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(177, 'mainmenu', 'Child Item', 'child-item-102', 'index.php?option=com_content&view=article&id=62', 'component', 1, 174, 20, 4, 3, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(178, 'mainmenu', 'Child Item', 'child-item-103', 'index.php?option=com_content&view=article&id=62', 'component', 1, 174, 20, 4, 4, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(179, 'mainmenu', 'Child Item', 'child-item-104', 'index.php?option=com_content&view=article&id=62', 'component', 1, 174, 20, 4, 5, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(180, 'mainmenu', 'Child Item', 'child-item-105', 'index.php?option=com_content&view=article&id=62', 'component', 1, 174, 20, 4, 8, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\nfusion_item_subtext=Single Column Example\nfusion_customimage=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(181, 'mainmenu', 'Child Item', 'child-item-106', 'index.php?option=com_content&view=article&id=62', 'component', 1, 174, 20, 4, 7, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(182, 'mainmenu', 'Child Item', 'child-item-107', 'index.php?option=com_content&view=article&id=62', 'component', 1, 174, 20, 4, 6, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(183, 'mainmenu', 'Child Item', 'child-item-108', 'index.php?option=com_content&view=article&id=62', 'component', 1, 180, 20, 5, 1, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(184, 'mainmenu', 'Child Item', 'child-item-109', 'index.php?option=com_content&view=article&id=62', 'component', 1, 180, 20, 5, 2, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(185, 'mainmenu', 'Child Item', 'child-item-110', 'index.php?option=com_content&view=article&id=62', 'component', 1, 180, 20, 5, 3, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(186, 'mainmenu', 'Child Item', 'child-item-111', 'index.php?option=com_content&view=article&id=62', 'component', 1, 180, 20, 5, 4, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(188, 'mainmenu', 'Child Item', 'child-item-188', 'index.php?option=com_content&view=article&id=62', 'component', 1, 89, 20, 7, 2, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\nfusion_item_subtext=\nfusion_customimage=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(189, 'mainmenu', 'Child Item', 'child-item-189', 'index.php?option=com_content&view=article&id=62', 'component', 1, 89, 20, 7, 3, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\nfusion_item_subtext=\nfusion_customimage=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(190, 'mainmenu', 'Child Item', 'child-item-190', 'index.php?option=com_content&view=article&id=62', 'component', 1, 89, 20, 7, 4, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\nfusion_item_subtext=\nfusion_customimage=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(191, 'mainmenu', 'Child Item', 'child-item-191', 'index.php?option=com_content&view=article&id=62', 'component', 1, 110, 20, 6, 1, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\nfusion_item_subtext=\nfusion_customimage=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(192, 'mainmenu', 'Child Item', 'child-item-192', 'index.php?option=com_content&view=article&id=62', 'component', 1, 110, 20, 6, 2, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\nfusion_item_subtext=\nfusion_customimage=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(193, 'mainmenu', 'Child Item', 'child-item-193', 'index.php?option=com_content&view=article&id=62', 'component', 1, 110, 20, 6, 3, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\nfusion_item_subtext=\nfusion_customimage=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(194, 'mainmenu', 'Child Item', 'child-item-194', 'index.php?option=com_content&view=article&id=62', 'component', 1, 110, 20, 6, 4, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\nfusion_item_subtext=\nfusion_customimage=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(203, 'mainmenu', 'Google Web Fonts', 'google-web-fonts', 'index.php?Itemid=54', 'menulink', 1, 54, 0, 2, 2, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_item=54\nfusion_item_subtext=\nfusion_customimage=\nfusion_customclass=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(195, 'mainmenu', 'Child Item', 'child-item-195', 'index.php?option=com_content&view=article&id=62', 'component', 1, 174, 20, 4, 9, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\nfusion_item_subtext=\nfusion_customimage=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(196, 'mainmenu', 'Child Item', 'child-item-196', 'index.php?option=com_content&view=article&id=62', 'component', 1, 185, 20, 6, 1, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\nfusion_item_subtext=\nfusion_customimage=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(197, 'mainmenu', 'Child Item', 'child-item-197', 'index.php?option=com_content&view=article&id=62', 'component', 1, 185, 20, 6, 2, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\nfusion_item_subtext=\nfusion_customimage=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(198, 'mainmenu', 'Child Item', 'child-item-198', 'index.php?option=com_content&view=article&id=62', 'component', 1, 185, 20, 6, 3, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\nfusion_item_subtext=\nfusion_customimage=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(199, 'mainmenu', 'Child Item', 'child-item-199', 'index.php?option=com_content&view=article&id=62', 'component', 1, 185, 20, 6, 4, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\nfusion_item_subtext=\nfusion_customimage=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(200, 'mainmenu', 'RokNewsPager', 'roknewspager', 'index.php?Itemid=61', 'menulink', 1, 210, 0, 2, 5, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_item=61\nfusion_item_subtext=\nfusion_customimage=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(201, 'mainmenu', 'Fusion with MegaMenu', 'fusion-with-megamenu', 'index.php?Itemid=214', 'menulink', 1, 171, 0, 2, 2, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_item=214\nfusion_item_subtext=\nfusion_customimage=-1\nfusion_customclass=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(202, 'mainmenu', 'iPhone Theme', 'iphone-theme', 'index.php?Itemid=54', 'menulink', 1, 54, 0, 2, 1, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_item=54\nfusion_item_subtext=\nfusion_customimage=\nfusion_customclass=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(204, 'mainmenu', 'Image Smart Loading', 'image-smart-loading', 'index.php?Itemid=54', 'menulink', 1, 54, 0, 2, 3, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_item=54\nfusion_item_subtext=\nfusion_customimage=\nfusion_customclass=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(205, 'mainmenu', 'Ajax Article Loading', 'ajax-article-loading', 'index.php?Itemid=54', 'menulink', 1, 54, 0, 2, 4, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_item=54\nfusion_item_subtext=\nfusion_customimage=\nfusion_customclass=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(206, 'mainmenu', '960 Grid System', '960-grid-system', 'index.php?Itemid=54', 'menulink', 1, 54, 0, 2, 8, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_item=54\nfusion_item_subtext=\nfusion_customimage=\nfusion_customclass=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(207, 'mainmenu', 'Intuitive Interface', 'intuitive-interface', 'index.php?Itemid=54', 'menulink', 1, 54, 0, 2, 9, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_item=54\nfusion_item_subtext=\nfusion_customimage=\nfusion_customclass=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(208, 'mainmenu', 'Per Menu Configuration', 'per-menu-configuration', 'index.php?Itemid=54', 'menulink', 1, 54, 0, 2, 5, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_item=54\nfusion_item_subtext=\nfusion_customimage=\nfusion_customclass=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(209, 'mainmenu', 'RTL Support', 'rtl-support', 'index.php?Itemid=54', 'menulink', 1, 54, 0, 2, 10, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_item=54\nfusion_item_subtext=\nfusion_customimage=\nfusion_customclass=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(210, 'mainmenu', 'Styled Extensions', 'styled-extensions', '', 'separator', 1, 61, 0, 1, 1, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_image=-1\nfusion_item_subtext=\nfusion_customimage=\nfusion_customclass=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=1\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(211, 'mainmenu', 'Included Extensions', 'included-extensions', '', 'separator', 1, 61, 0, 1, 2, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_image=-1\nfusion_item_subtext=\nfusion_customimage=\nfusion_customclass=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=1\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(214, 'mainmenu', 'Fusion Menu', 'fusion-menu', 'index.php?option=com_content&view=article&id=100', 'component', 1, 62, 20, 1, 5, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\nfusion_item_subtext=\nfusion_customimage=\nfusion_customclass=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(215, 'mainmenu', 'Child Item', 'child-item-215', 'index.php?option=com_content&view=article&id=62', 'component', 1, 98, 20, 4, 2, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\nfusion_item_subtext=\nfusion_customimage=\nfusion_customclass=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(216, 'mainmenu', 'Child Item', 'child-item-216', 'index.php?option=com_content&view=article&id=62', 'component', 1, 98, 20, 4, 3, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\nfusion_item_subtext=\nfusion_customimage=\nfusion_customclass=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(217, 'mainmenu', 'Child Item', 'child-item-217', 'index.php?option=com_content&view=article&id=62', 'component', 1, 98, 20, 4, 4, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\nfusion_item_subtext=\nfusion_customimage=\nfusion_customclass=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(218, 'mainmenu', 'Child Item', 'child-item-218', 'index.php?option=com_content&view=article&id=62', 'component', 1, 98, 20, 4, 5, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\nfusion_item_subtext=\nfusion_customimage=\nfusion_customclass=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(219, 'mainmenu', 'Child Item', 'child-item-219', 'index.php?option=com_content&view=article&id=62', 'component', 1, 98, 20, 4, 6, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\nfusion_item_subtext=\nfusion_customimage=\nfusion_customclass=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(220, 'mainmenu', 'Child Item', 'child-item-220', 'index.php?option=com_content&view=article&id=62', 'component', 1, 98, 20, 4, 7, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\nfusion_item_subtext=\nfusion_customimage=\nfusion_customclass=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(221, 'mainmenu', 'Child Item', 'child-item-221', 'index.php?option=com_content&view=article&id=62', 'component', 1, 98, 20, 4, 8, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\nfusion_item_subtext=\nfusion_customimage=\nfusion_customclass=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(222, 'mainmenu', 'Child Item', 'child-item-222', 'index.php?option=com_content&view=article&id=62', 'component', 1, 98, 20, 4, 9, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\nfusion_item_subtext=\nfusion_customimage=\nfusion_customclass=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(223, 'mainmenu', 'Child Item', 'child-item-223', 'index.php?option=com_content&view=article&id=62', 'component', 1, 98, 20, 4, 10, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\nfusion_item_subtext=\nfusion_customimage=\nfusion_customclass=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(224, 'mainmenu', 'Child Item', 'child-item-224', 'index.php?option=com_content&view=article&id=62', 'component', 1, 98, 20, 4, 11, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\nfusion_item_subtext=Single Column Example\nfusion_customimage=\nfusion_customclass=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(225, 'mainmenu', 'Child Item', 'child-item-225', 'index.php?option=com_content&view=article&id=62', 'component', 1, 98, 20, 4, 12, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\nfusion_item_subtext=\nfusion_customimage=\nfusion_customclass=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(425, 'mainmenu', 'Preset 12', 'preset-12', '?presets=preset12', 'url', 1, 69, 0, 1, 12, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_image=-1\nfusion_item_subtext=\nfusion_customimage=preset12.png\nfusion_customclass=rt-style\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(423, 'mainmenu', 'Preset 10', 'preset-10', '?presets=preset10', 'url', 1, 69, 0, 1, 10, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_image=-1\nfusion_item_subtext=\nfusion_customimage=preset10.png\nfusion_customclass=rt-style\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(424, 'mainmenu', 'Preset 11', 'preset-11', '?presets=preset11', 'url', 1, 69, 0, 1, 11, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_image=-1\nfusion_item_subtext=\nfusion_customimage=preset11.png\nfusion_customclass=rt-style\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0);
INSERT INTO `#__menu` (`id`, `menutype`, `name`, `alias`, `link`, `type`, `published`, `parent`, `componentid`, `sublevel`, `ordering`, `checked_out`, `checked_out_time`, `pollid`, `browserNav`, `access`, `utaccess`, `params`, `lft`, `rgt`, `home`) VALUES
(418, 'mainmenu', 'Tableless Overrides', 'tableless-overrides', 'index.php?Itemid=54', 'menulink', 1, 54, 0, 2, 7, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_item=54\nfusion_item_subtext=\nfusion_customimage=\nfusion_customclass=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(419, 'mainmenu', 'Module Example', 'module-example', '', 'separator', 1, 172, 0, 2, 3, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_image=-1\nfusion_item_subtext=\nfusion_customimage=\nfusion_customclass=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=220\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=modulepos\nfusion_modules=162\nfusion_module_positions=menu-mod\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(417, 'mainmenu', 'Child Item', 'child-item-417', 'index.php?option=com_content&view=article&id=62', 'component', 1, 224, 20, 5, 4, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\nfusion_item_subtext=\nfusion_customimage=\nfusion_customclass=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(416, 'mainmenu', 'Child Item', 'child-item-416', 'index.php?option=com_content&view=article&id=62', 'component', 1, 224, 20, 5, 3, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\nfusion_item_subtext=\nfusion_customimage=\nfusion_customclass=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(415, 'mainmenu', 'Child Item', 'child-item-415', 'index.php?option=com_content&view=article&id=62', 'component', 1, 224, 20, 5, 2, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\nfusion_item_subtext=\nfusion_customimage=\nfusion_customclass=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0),
(413, 'mainmenu', 'Built-in GZip Caching', 'built-in-gzip-caching', 'index.php?Itemid=54', 'menulink', 1, 54, 0, 2, 6, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'menu_item=54\nfusion_item_subtext=\nfusion_customimage=\nfusion_customclass=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\n\n', 0, 0, 0),
(414, 'mainmenu', 'Child Item', 'child-item-414', 'index.php?option=com_content&view=article&id=62', 'component', 1, 224, 20, 5, 1, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\nfusion_item_subtext=\nfusion_customimage=\nfusion_customclass=\nfusion_columns=1\nfusion_distribution=even\nfusion_dropdown_width=\nfusion_column_widths=\nfusion_children_group=0\nfusion_children_type=menuitems\nsplitmenu_item_subtext=\nsuckerfish_item_subtext=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `#__menu_types`
--

DROP TABLE IF EXISTS `#__menu_types`;
CREATE TABLE IF NOT EXISTS `#__menu_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `menutype` varchar(75) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `description` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `menutype` (`menutype`)
);

--
-- Dumping data for table `#__menu_types`
--

INSERT INTO `#__menu_types` (`id`, `menutype`, `title`, `description`) VALUES
(1, 'mainmenu', 'Main Menu', 'The main menu for the site'),
(2, 'usermenu', 'User Menu', 'A Menu for logged in Users'),
(3, 'topmenu', 'Top Menu', 'Top level navigation'),
(4, 'othermenu', 'Resources', 'Additional links'),
(5, 'ExamplePages', 'Example Pages', 'Example Pages'),
(6, 'keyconcepts', 'Key Concepts', 'This describes some critical information for new Users.');

-- --------------------------------------------------------

--
-- Table structure for table `#__messages`
--

DROP TABLE IF EXISTS `#__messages`;
CREATE TABLE IF NOT EXISTS `#__messages` (
  `message_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id_from` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id_to` int(10) unsigned NOT NULL DEFAULT '0',
  `folder_id` int(10) unsigned NOT NULL DEFAULT '0',
  `date_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `state` int(11) NOT NULL DEFAULT '0',
  `priority` int(1) unsigned NOT NULL DEFAULT '0',
  `subject` text NOT NULL,
  `message` text NOT NULL,
  PRIMARY KEY (`message_id`),
  KEY `useridto_state` (`user_id_to`,`state`)
);

--
-- Dumping data for table `#__messages`
--


-- --------------------------------------------------------

--
-- Table structure for table `#__messages_cfg`
--

DROP TABLE IF EXISTS `#__messages_cfg`;
CREATE TABLE IF NOT EXISTS `#__messages_cfg` (
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `cfg_name` varchar(100) NOT NULL DEFAULT '',
  `cfg_value` varchar(255) NOT NULL DEFAULT '',
  UNIQUE KEY `idx_user_var_name` (`user_id`,`cfg_name`)
);

--
-- Dumping data for table `#__messages_cfg`
--


-- --------------------------------------------------------

--
-- Table structure for table `#__migration_backlinks`
--

DROP TABLE IF EXISTS `#__migration_backlinks`;
CREATE TABLE IF NOT EXISTS `#__migration_backlinks` (
  `itemid` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `url` text NOT NULL,
  `sefurl` text NOT NULL,
  `newurl` text NOT NULL,
  PRIMARY KEY (`itemid`)
);

--
-- Dumping data for table `#__migration_backlinks`
--


-- --------------------------------------------------------

--
-- Table structure for table `#__modules`
--

DROP TABLE IF EXISTS `#__modules`;
CREATE TABLE IF NOT EXISTS `#__modules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` text NOT NULL,
  `content` text NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  `position` varchar(50) DEFAULT NULL,
  `checked_out` int(11) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `module` varchar(50) DEFAULT NULL,
  `numnews` int(11) NOT NULL DEFAULT '0',
  `access` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `showtitle` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `params` text NOT NULL,
  `iscore` tinyint(4) NOT NULL DEFAULT '0',
  `client_id` tinyint(4) NOT NULL DEFAULT '0',
  `control` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `published` (`published`,`access`),
  KEY `newsfeeds` (`module`,`published`)
);

--
-- Dumping data for table `#__modules`
--

INSERT INTO `#__modules` (`id`, `title`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `published`, `module`, `numnews`, `access`, `showtitle`, `params`, `iscore`, `client_id`, `control`) VALUES
(2, 'Login', '', 1, 'login', 0, '0000-00-00 00:00:00', 1, 'mod_login', 0, 0, 1, '', 1, 1, ''),
(3, 'Popular', '', 3, 'cpanel', 0, '0000-00-00 00:00:00', 1, 'mod_popular', 0, 2, 1, '', 0, 1, ''),
(4, 'Recent added Articles', '', 4, 'cpanel', 0, '0000-00-00 00:00:00', 1, 'mod_latest', 0, 2, 1, 'ordering=c_dsc\nuser_id=0\ncache=0\n\n', 0, 1, ''),
(5, 'Menu Stats', '', 5, 'cpanel', 0, '0000-00-00 00:00:00', 1, 'mod_stats', 0, 2, 1, '', 0, 1, ''),
(6, 'Unread Messages', '', 1, 'header', 0, '0000-00-00 00:00:00', 1, 'mod_unread', 0, 2, 1, '', 1, 1, ''),
(7, 'Online Users', '', 2, 'header', 0, '0000-00-00 00:00:00', 1, 'mod_online', 0, 2, 1, '', 1, 1, ''),
(8, 'Toolbar', '', 1, 'toolbar', 0, '0000-00-00 00:00:00', 1, 'mod_toolbar', 0, 2, 1, '', 1, 1, ''),
(9, 'Quick Icons', '', 1, 'icon', 0, '0000-00-00 00:00:00', 1, 'mod_quickicon', 0, 2, 1, '', 1, 1, ''),
(10, 'Logged in Users', '', 2, 'cpanel', 0, '0000-00-00 00:00:00', 1, 'mod_logged', 0, 2, 1, '', 0, 1, ''),
(11, 'Footer', '', 0, 'footer', 0, '0000-00-00 00:00:00', 1, 'mod_footer', 0, 0, 1, '', 1, 1, ''),
(12, 'Admin Menu', '', 1, 'menu', 0, '0000-00-00 00:00:00', 1, 'mod_menu', 0, 2, 1, '', 0, 1, ''),
(13, 'Admin SubMenu', '', 1, 'submenu', 0, '0000-00-00 00:00:00', 1, 'mod_submenu', 0, 2, 1, '', 0, 1, ''),
(14, 'User Status', '', 1, 'status', 0, '0000-00-00 00:00:00', 1, 'mod_status', 0, 2, 1, '', 0, 1, ''),
(15, 'Title', '', 1, 'title', 0, '0000-00-00 00:00:00', 1, 'mod_title', 0, 2, 1, '', 0, 1, ''),
(16, 'Site Poll', '', 15, 'sidebar-a', 0, '0000-00-00 00:00:00', 1, 'mod_poll', 0, 0, 1, 'id=14\nmoduleclass_sfx=box12 title5\ncache=1\ncache_time=900\n\n', 0, 0, ''),
(17, 'User Menu', '', 3, 'left', 0, '0000-00-00 00:00:00', 1, 'mod_mainmenu', 0, 1, 1, 'menutype=usermenu\nmoduleclass_sfx=_menu\ncache=1', 1, 0, ''),
(19, 'Latest Items', '', 0, 'maintop-a', 0, '0000-00-00 00:00:00', 1, 'mod_latestnews', 0, 0, 1, 'count=5\nordering=c_dsc\nuser_id=0\nshow_front=1\nsecid=3\ncatid=\nmoduleclass_sfx=\ncache=1\ncache_time=900\n\n', 1, 0, ''),
(52, 'Top E', '<p>The <a href="javascript:void(0);">Top-e</a> position, <em>using</em> its <strong>default</strong> module styling.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 1, 'top-e', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=\n\n', 0, 0, ''),
(21, 'Who''s Online', '', 27, 'sidebar-a', 0, '0000-00-00 00:00:00', 1, 'mod_whosonline', 0, 0, 1, 'cache=0\nshowmode=0\nmoduleclass_sfx=title6\n\n', 0, 0, ''),
(22, 'Popular Items', '', 0, 'maintop-b', 0, '0000-00-00 00:00:00', 1, 'mod_mostread', 0, 0, 1, 'moduleclass_sfx=\nshow_front=1\ncount=5\ncatid=\nsecid=3\ncache=1\ncache_time=900\n\n', 0, 0, ''),
(25, 'Newsflash', '', 0, 'mainbottom-a', 0, '0000-00-00 00:00:00', 1, 'mod_newsflash', 0, 0, 1, 'catid=3\nlayout=default\nimage=0\nlink_titles=\nshowLastSeparator=1\nreadmore=0\nitem_title=0\nitems=\nmoduleclass_sfx=\ncache=0\ncache_time=900\n\n', 0, 0, ''),
(51, 'Top D', '<p>The <a href="javascript:void(0);">Top-d</a> position, <em>using</em> its <strong>default</strong> module styling.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 1, 'top-d', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=\n\n', 0, 0, ''),
(50, 'Top C', '<p>The <a href="javascript:void(0);">Top-c</a> position, <em>using</em> its <strong>default</strong> module styling.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 1, 'top-c', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=\n\n', 0, 0, ''),
(48, 'Top A', '<p>The <a href="javascript:void(0);">Top-a</a> position, <em>using</em> its <strong>default</strong> module styling.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 1, 'top-a', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=\n\n', 0, 0, ''),
(49, 'Top B', '<p>The <a href="javascript:void(0);">Top-b</a> position, <em>using</em> its <strong>default</strong> module styling.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 1, 'top-b', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=\n\n', 0, 0, ''),
(35, 'Breadcrumbs', '', 0, 'breadcrumb', 0, '0000-00-00 00:00:00', 1, 'mod_breadcrumbs', 0, 0, 1, 'showHome=1\nhomeText=Home\nshowLast=1\nseparator=\nmoduleclass_sfx=\ncache=0\n\n', 1, 0, ''),
(41, 'Welcome to Joomla!', '<div style="padding: 5px">  <p>   Congratulations on choosing Joomla! as your content management system. To   help you get started, check out these excellent resources for securing your   server and pointers to documentation and other helpful resources. </p> <p>   <strong>Security</strong><br /> </p> <p>   On the Internet, security is always a concern. For that reason, you are   encouraged to subscribe to the   <a href="http://feedburner.google.com/fb/a/mailverify?uri=JoomlaSecurityNews" target="_blank">Joomla!   Security Announcements</a> for the latest information on new Joomla! releases,   emailed to you automatically. </p> <p>   If this is one of your first Web sites, security considerations may   seem complicated and intimidating. There are three simple steps that go a long   way towards securing a Web site: (1) regular backups; (2) prompt updates to the   <a href="http://www.joomla.org/download.html" target="_blank">latest Joomla! release;</a> and (3) a <a href="http://docs.joomla.org/Security_Checklist_2_-_Hosting_and_Server_Setup" target="_blank" title="good Web host">good Web host</a>. There are many other important security considerations that you can learn about by reading the <a href="http://docs.joomla.org/Category:Security_Checklist" target="_blank" title="Joomla! Security Checklist">Joomla! Security Checklist</a>. </p> <p>If you believe your Web site was attacked, or you think you have discovered a security issue in Joomla!, please do not post it in the Joomla! forums. Publishing this information could put other Web sites at risk. Instead, report possible security vulnerabilities to the <a href="http://developer.joomla.org/security/contact-the-team.html" target="_blank" title="Joomla! Security Task Force">Joomla! Security Task Force</a>.</p><p><strong>Learning Joomla!</strong> </p> <p>   A good place to start learning Joomla! is the   "<a href="http://docs.joomla.org/beginners" target="_blank">Absolute Beginner''s   Guide to Joomla!.</a>" There, you will find a Quick Start to Joomla!   <a href="http://help.joomla.org/ghop/feb2008/task048/joomla_15_quickstart.pdf" target="_blank">guide</a>   and <a href="http://help.joomla.org/ghop/feb2008/task167/index.html" target="_blank">video</a>,   amongst many other tutorials. The   <a href="http://community.joomla.org/magazine/view-all-issues.html" target="_blank">Joomla!   Community Magazine</a> also has   <a href="http://community.joomla.org/magazine/article/522-introductory-learning-joomla-using-sample-data.html" target="_blank">articles   for new learners</a> and experienced users, alike. A great place to look for   answers is the   <a href="http://docs.joomla.org/Category:FAQ" target="_blank">Frequently Asked   Questions (FAQ)</a>. If you are stuck on a particular screen in the   Administrator (which is where you are now), try clicking the Help toolbar   button to get assistance specific to that page. </p> <p>   If you still have questions, please feel free to use the   <a href="http://forum.joomla.org/" target="_blank">Joomla! Forums.</a> The forums   are an incredibly valuable resource for all levels of Joomla! users. Before   you post a question, though, use the forum search (located at the top of each   forum page) to see if the question has been asked and answered. </p> <p>   <strong>Getting Involved</strong> </p> <p>   <a name="twjs" title="twjs"></a> If you want to help make Joomla! better, consider getting   involved. There are   <a href="http://www.joomla.org/about-joomla/contribute-to-joomla.html" target="_blank">many ways   you can make a positive difference.</a> Have fun using Joomla!.</p></div>', 0, 'cpanel', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 2, 1, 'moduleclass_sfx=\n\n', 1, 1, ''),
(42, 'Joomla! Security Newsfeed', '', 6, 'cpanel', 0, '0000-00-00 00:00:00', 1, 'mod_feed', 0, 0, 1, 'cache=1\ncache_time=15\nmoduleclass_sfx=\nrssurl=http://feeds.joomla.org/JoomlaSecurityNews\nrssrtl=0\nrsstitle=1\nrssdesc=0\nrssimage=1\nrssitems=1\nrssitemdesc=1\nword_count=0\n\n', 0, 1, ''),
(43, 'RokAjaxSearch', '', 0, 'utility-c', 0, '0000-00-00 00:00:00', 1, 'mod_rokajaxsearch', 0, 0, 0, 'moduleclass_sfx=\nsearch_page=index.php?option=com_search&view=search&tmpl=component\nadv_search_page=index.php?option=com_search&view=search\ninclude_css=0\ntheme=dark\nsearchphrase=any\nordering=newest\nlimit=10\nperpage=3\nwebsearch=0\nblogsearch=0\nimagesearch=0\nvideosearch=0\nwebsearch_api=\nshow_pagination=1\nsafesearch=MODERATE\nimage_size=MEDIUM\nshow_estimated=1\nhide_divs=\ninclude_link=1\nshow_description=1\ninclude_category=1\nshow_readmore=1\n\n', 0, 0, ''),
(45, 'Recent Reviews', '', 0, 'sidebar-b', 0, '0000-00-00 00:00:00', 1, 'mod_roknewspager', 0, 0, 1, 'load_css=1\ntheme=dark\ncontent_type=joomla\nsecid=5\ncatid=42\nshow_front=1\narticle_count=4\nshow_accordion=0\nshow_paging=1\nmaxpages=8\nshow_title=1\nshow_thumbnails=1\nthumb_width=79\nthumbnail_link=1\nshow_overlay=1\noverlay=-1\nshow_ratings=1\nshow_readmore=0\nreadmore_text=Read More...\nitemsOrdering=order\nshow_preview_text=1\nstrip_tags=a,br,strong,em\npreview_count=200\nshow_comment_count=0\nshow_author=0\nshow_published_date=0\nautoupdate=0\nautoupdate_delay=5000\nmoduleclass_sfx=box2 title1\ncache=0\nmodule_ident=id\ncache_time=900\n\n', 0, 0, ''),
(46, 'RokStories Sample', '', 0, 'showcase-a', 0, '0000-00-00 00:00:00', 1, 'mod_rokstories', 0, 0, 1, 'moduleclass_sfx=\nload_css=1\nlayout_type=layout1\ncontent_type=joomla\nsecid=0\ncatid=37\nshow_front=1\narticle_count=4\nitemsOrdering=order\nstrip_tags=a,i,br\ncontent_position=right\nshow_article_title=1\nshow_created_date=0\nshow_article=1\nshow_article_link=1\nlegacy_readmore=0\nthumb_width=90\nstart_width=auto\nuser_id=0\nstart_element=0\nthumbs_opacity=0.3\nfixed_height=0\nmouse_type=click\nautoplay=0\nautoplay_delay=5000\nshow_label_article_title=1\nshow_arrows=1\narrows_placement=inside\nshow_thumbs=0\nfixed_thumb=1\nlink_titles=0\nlink_labels=0\nlink_images=0\nshow_mask=1\nmask_desc_dir=topdown\nmask_imgs_dir=bottomup\nleft_offset_x=-40\nleft_offset_y=-100\nright_offset_x=-30\nright_offset_y=-100\nleft_f_offset_x=-40\nleft_f_offset_y=-100\nright_f_offset_x=-30\nright_f_offset_y=-100\ncache=0\nmodule_cache=1\ncache_time=900\n\n', 0, 0, ''),
(118, 'Popular Features', '<ul class="menu">\r\n	<li><a href="index.php?option=com_content&amp;view=article&amp;id=53&amp;Itemid=61">New RokStories Style</a></li>	\r\n	<li><a href="index.php?option=com_content&amp;view=article&amp;id=47&amp;Itemid=54">RTL Support</a></li>\r\n	<li><a href="index.php?option=com_content&amp;view=article&amp;id=47&amp;Itemid=54">iPhone Compatible</a></li>\r\n	<li><a href="index.php?option=com_content&amp;view=article&amp;id=47&amp;Itemid=54">Smart Loading</a></li>	\r\n</ul>\r\n<br />\r\n<a href="index.php?option=com_content&amp;view=article&amp;id=46&amp;Itemid=53" class="readon"><span>More Features</span></a>', 2, 'sidebar-a', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=box12 title3\n\n', 0, 0, ''),
(155, 'New Releases', '', 19, 'sidebar-a', 0, '0000-00-00 00:00:00', 1, 'mod_roktabs', 0, 0, 1, 'style=base\ncontent_type=joomla\nsecid=0\ncatid=43\nshow_front=1\nitemsOrdering=order\nwidth=190\ntabs_count=0\nduration=600\ntransition_type=scrolling\ntransition_fx=Quad.easeInOut\nlinksMargins=1\ntabs_position=bottom\ntabs_event=click\ntabs_title=content\ntabs_incremental=Tab\ntabs_hideh6=0\ntabs_showicons=0\ntabs_iconside=left\ntabs_iconpath=__module__/images\ntabs_icon=icon_home.gif,icon_security.gif,icon_comment.gif,icon_world.gif,icon_note.gif\nautoplay=0\nautoplay_delay=2000\nmoduleclass_sfx=box9 box1 title5\ncache=0\nmodule_cache=1\ncache_time=900\n\n', 0, 0, ''),
(121, 'RokTabs Sample', '', 8, 'sidebar-a', 0, '0000-00-00 00:00:00', 1, 'mod_roktabs', 0, 0, 1, 'style=base\ncontent_type=joomla\nsecid=0\ncatid=40\nshow_front=1\nitemsOrdering=order\nwidth=190\ntabs_count=0\nduration=600\ntransition_type=scrolling\ntransition_fx=Quad.easeInOut\nlinksMargins=1\ntabs_position=top\ntabs_event=click\ntabs_title=content\ntabs_incremental=Tab\ntabs_hideh6=1\ntabs_showicons=0\ntabs_iconside=left\ntabs_iconpath=__module__/images\ntabs_icon=icon_home.gif,icon_security.gif,icon_comment.gif,icon_world.gif,icon_note.gif\nautoplay=0\nautoplay_delay=2000\nmoduleclass_sfx=box8\ncache=0\nmodule_cache=1\ncache_time=900\n\n', 0, 0, ''),
(53, 'Top F', '<p>The <a href="javascript:void(0);">Top-f</a> position, <em>using</em> its <strong>default</strong> module styling.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 2, 'top-f', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=\n\n', 0, 0, ''),
(54, 'Feature A', '<p>The <a href="javascript:void(0);">Feature-a</a> position, <em>using</em> the <strong>box7</strong> module class suffix.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 0, 'feature-a', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=box7\n\n', 0, 0, ''),
(55, 'Feature B', '<p>The <a href="javascript:void(0);">Feature-b</a> position, <em>using</em> the <strong>box8</strong> module class suffix.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 0, 'feature-b', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=box8\n\n', 0, 0, ''),
(56, 'Feature C', '<p>The <a href="javascript:void(0);">Feature-c</a> position, <em>using</em> the <strong>box9</strong> module class suffix.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 0, 'feature-c', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=box9\n\n', 0, 0, ''),
(57, 'Feature D', '<p>The <a href="javascript:void(0);">Feature-d</a> position, <em>using</em> the <strong>box10</strong> module class suffix.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 0, 'feature-d', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=box10\n\n', 0, 0, ''),
(58, 'Feature E', '<p>The <a href="javascript:void(0);">Feature-e</a> position, <em>using</em> the <strong>box11</strong> module class suffix.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 0, 'feature-e', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=box11\n\n', 0, 0, ''),
(59, 'Feature F', '<p>The <a href="javascript:void(0);">Feature-f</a> position, <em>using</em> the <strong>box12</strong> module class suffix.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 0, 'feature-f', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=box12\n\n', 0, 0, ''),
(60, 'Showcase A', '<p>The <a href="javascript:void(0);">Showcase-a</a> position, <em>using</em> the <strong>box1</strong> module class suffix.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 0, 'showcase-a', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=box1\n\n', 0, 0, ''),
(61, 'Showcase B', '<p>The <a href="javascript:void(0);">Showcase-b</a> position, <em>using</em> the <strong>box2</strong> module class suffix.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 0, 'showcase-b', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=box2\n\n', 0, 0, ''),
(62, 'Showcase C', '<p>The <a href="javascript:void(0);">Showcase-c</a> position, <em>using</em> the <strong>box3</strong> module class suffix.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 0, 'showcase-c', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=box3\n\n', 0, 0, ''),
(63, 'Showcase D', '<p>The <a href="javascript:void(0);">Showcase-d</a> position, <em>using</em> the <strong>box4</strong> module class suffix.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 0, 'showcase-d', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=box4\n\n', 0, 0, ''),
(64, 'Showcase F', '<p>The <a href="javascript:void(0);">Showcase-f</a> position, <em>using</em> the <strong>box6</strong> module class suffix.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 0, 'showcase-f', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=box6\n\n', 0, 0, ''),
(65, 'Showcase E', '<p>The <a href="javascript:void(0);">Showcase-e</a> position, <em>using</em> the <strong>box5</strong> module class suffix.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 0, 'showcase-e', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=box5\n\n', 0, 0, ''),
(66, 'MainTop A', '<p>The <a href="javascript:void(0);">MainTop-a</a> position, <em>using</em> the <strong>title1</strong> module class suffix.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 0, 'maintop-a', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=title1\n\n', 0, 0, ''),
(67, 'MainTop B', '<p>The <a href="javascript:void(0);">MainTop-b</a> position, <em>using</em> the <strong>title2</strong> module class suffix.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 0, 'maintop-b', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=title2\n\n', 0, 0, ''),
(68, 'MainTop D', '<p>The <a href="javascript:void(0);">MainTop-d</a> position, <em>using</em> the <strong>title4</strong> module class suffix.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 0, 'maintop-d', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=title4\n\n', 0, 0, ''),
(69, 'MainTop C', '<p>The <a href="javascript:void(0);">MainTop-c</a> position, <em>using</em> the <strong>title3</strong> module class suffix.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 0, 'maintop-c', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=title3\n\n', 0, 0, ''),
(70, 'MainTop F', '<p>The <a href="javascript:void(0);">MainTop-f</a> position, <em>using</em> the <strong>title6</strong> module class suffix.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 0, 'maintop-f', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=title6\n\n', 0, 0, ''),
(71, 'MainTop E', '<p>The <a href="javascript:void(0);">MainTop-e</a> position, <em>using</em> the <strong>title5</strong> module class suffix.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 0, 'maintop-e', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=title5\n\n', 0, 0, ''),
(72, 'MainBottom A', '<p>The <a href="javascript:void(0);">MainBottom-a</a> position, <em>using</em> the <strong>box12 title1</strong> module class suffix.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 2, 'mainbottom-a', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=box12 title1\n\n', 0, 0, ''),
(73, 'MainBottom B', '<p>The <a href="javascript:void(0);">MainBottom-b</a> position, <em>using</em> the <strong>box11 title2</strong> module class suffix.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 0, 'mainbottom-b', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=box11 title2\n\n', 0, 0, ''),
(76, 'MainBottom F', '<p>The <a href="javascript:void(0);">MainBottom-f</a> module position, <em>using</em> the <strong>box9 title4</strong> module class suffix.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 0, 'mainbottom-f', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=box9 title4\n\n', 0, 0, ''),
(77, 'MainBottom E', '<p>The <a href="javascript:void(0);">MainBottom-e</a> position, <em>using</em> the <strong>box10 title3</strong> module class suffix.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 0, 'mainbottom-e', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=box10 title3\n\n', 0, 0, ''),
(78, 'Bottom A', '<p>The <a href="javascript:void(0);">Bottom-a</a> position, <em>using</em> the <strong>box8 title5</strong> module class suffix.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 0, 'bottom-a', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=box8 title5\n\n', 0, 0, ''),
(79, 'Bottom B', '<p>The <a href="javascript:void(0);">Bottom-b</a> position, <em>using</em> the <strong>box7 title6</strong> module class suffix.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 0, 'bottom-b', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=box7 title6\n\n', 0, 0, ''),
(80, 'Bottom D', '<p>The <a href="javascript:void(0);">Bottom-d</a> position, <em>using</em> the <strong>box5 title2</strong> module class suffix.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 2, 'bottom-d', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=box5 title2\n\n', 0, 0, ''),
(81, 'Bottom C', '<p>The <a href="javascript:void(0);">Bottom-c</a> position, <em>using</em> the <strong>box6 title1</strong> module class suffix.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 2, 'bottom-c', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=box6 title1\n\n', 0, 0, ''),
(82, 'Bottom F', '<p>The <a href="javascript:void(0);">Bottom-f</a> position, <em>using</em> the <strong>box3 title4</strong> module class suffix.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 0, 'bottom-f', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=box3 title4\n\n', 0, 0, ''),
(83, 'Bottom E', '<p>The <a href="javascript:void(0);">Bottom-e</a> position, <em>using</em> the <strong>box4 title3</strong> module class suffix.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 0, 'bottom-e', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=box4 title3\n\n', 0, 0, ''),
(90, 'Copyright Module Position - Default Styling', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vestibulum at sem ut ipsum vestibulum euismod. Mauris et massa porta leo facilisis feugiat. Suspendisse id neque a sem facilisis blandit. Aliquam sem leo, commodo ut, rutrum auctor, iaculis nec, eros. Aenean massa. Mauris tincidunt. Vivamus consectetur, tortor sit amet dictum sagittis, urna lectus dapibus metus, ut congue ligula odio sed nunc. Suspendisse potenti.', 1, 'copyright', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=\n\n', 0, 0, ''),
(92, 'Header B', '<p>The <a href="javascript:void(0);">Header-b</a> position, <em>using</em> its <strong>default</strong> module styling.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 1, 'header-b', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=\n\n', 0, 0, ''),
(95, 'Header F', '<p>The <a href="javascript:void(0);">Header-f</a> position, <em>using</em> its <strong>default</strong> module styling.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 2, 'header-f', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=\n\n', 0, 0, ''),
(103, 'Sidebar A', '<p>The <a href="javascript:void(0);">Sidebar-a</a> position, <em>using</em> the <strong>box1 title1</strong> module class suffix.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 9, 'sidebar-a', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=box1 title1\n\n', 0, 0, ''),
(171, 'Sidebar A', '<p>The <a href="javascript:void(0);">Sidebar-a</a> position, <em>using</em> the <strong>box9 title3</strong> module class suffix.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 13, 'sidebar-a', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=box9 title3\n\n', 0, 0, ''),
(104, 'Sidebar B', '<p>The <a href="javascript:void(0);">Sidebar-b</a> position, <em>using</em> the <strong>box10 title4</strong> module class suffix.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 8, 'sidebar-b', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=box10 title4\n\n', 0, 0, ''),
(173, 'Sidebar C', '<p>The <a href="javascript:void(0);">Sidebar-c</a> position, <em>using</em> the <strong>lowercase</strong> module class suffix.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 2, 'sidebar-c', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=lowercase\n\n', 0, 0, ''),
(105, 'Sidebar C', '<p>The <a href="javascript:void(0);">Sidebar-c</a> position, <em>using</em> the <strong>box5 title5</strong> module class suffix.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 1, 'sidebar-c', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=box5 title5\n\n', 0, 0, ''),
(174, 'Sidebar C', '<p>The <a href="javascript:void(0);">Sidebar-c</a> position, <em>using</em> the <strong>box8 title2 uppercase</strong> module class suffix.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 3, 'sidebar-c', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=box8 title2 uppercase\n\n', 0, 0, ''),
(106, 'Content Top A', '<p>The <a href="javascript:void(0);">Content-Top-a</a> position, <em>using</em> the <strong>box3 title3</strong> module class suffix.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 0, 'content-top-a', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=box3 title3\n\n', 0, 0, ''),
(107, 'Content Top C', '<p>The <a href="javascript:void(0);">Content-Top-c</a> position, <em>using</em> the <strong>box4 title4</strong> module class suffix.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 0, 'content-top-c', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=box4 title4\n\n', 0, 0, ''),
(108, 'Content Bottom A', '<p>The <a href="javascript:void(0);">Content-Bottom-a</a> position, <em>using</em> the <strong>box11 title5</strong> module class suffix.</p>\r\n<p>Lorem ipsum <strong>dolor sit amet</strong>, consectetur <em>adipiscing elit</em>.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 3, 'content-bottom-a', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=box11 title5\n\n', 0, 0, ''),
(109, 'Content Bottom C', '<p>The <a href="javascript:void(0);">Content-Bottom-c</a> module position, <em>using</em> its <strong>default</strong> module styling.</p>\r\n<p>Lorem ipsum <strong>dolor sit amet</strong>, consectetur <em>adipiscing elit</em>.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 0, 'content-bottom-c', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=\n\n', 0, 0, ''),
(110, 'Sidebar B', '<p>The <a href="javascript:void(0);">Sidebar-b</a> position, <em>using</em> the <strong>box2 title2</strong> module class suffix.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 4, 'sidebar-b', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=box2 title2\n\n', 0, 0, ''),
(111, 'Sidebar B', '<p>The <a href="javascript:void(0);">Sidebar-b</a> position, <em>using</em> its <strong>default</strong> module styling.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 6, 'sidebar-b', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=\n\n', 0, 0, ''),
(112, 'Sidebar C', '<p>The <a href="javascript:void(0);">Sidebar-c</a> position, <em>using</em> the <strong>box12 title6</strong> module class suffix.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 4, 'sidebar-c', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=box12 title6\n\n', 0, 0, ''),
(114, 'iPhone Support', '<p>Gantry has support for the iPhone, providing you with versatile options to control how the template is loaded in the iPhone browser.</p>\r\n<div class="note"><div class="typo-icon">Control all iPhone settings from <strong>Admin → Extensions → Template Manager → rt_zephyr_j15 → iPhone Settings</strong></div></div>\r\n<a rel="rokbox[320 480](iphone)" title="iPhone Preview :: Full View" href="images/stories/demo/gantry/iphone3-large.jpg">\r\n	<img src="images/stories/demo/gantry/iphone3.jpg" alt="iPhone" width="115" height="144" class="rt-image floatleft" />\r\n</a>\r\n<a rel="rokbox[320 480](iphone)" title="iPhone Preview :: Mobile View" href="images/stories/demo/gantry/iphone2-large.jpg">\r\n	<img src="images/stories/demo/gantry/iphone2.jpg" alt="iPhone" width="115" height="144" class="rt-image floatleftlast" />\r\n</a>\r\n<a rel="rokbox[320 480](iphone)" title="iPhone Preview :: Menu View" href="images/stories/demo/gantry/iphone3-large.jpg">\r\n	<img src="images/stories/demo/gantry/iphone4.jpg" alt="iPhone" width="115" height="144" class="rt-image floatleft" />\r\n</a>\r\n<a rel="rokbox[320 480](iphone)" title="iPhone Preview :: Menu View" href="images/stories/demo/gantry/iphone3-large.jpg">\r\n	<img src="images/stories/demo/gantry/iphone5.jpg" alt="iPhone" width="115" height="144" class="rt-image floatleftlast" />\r\n</a>\r\n<a rel="rokbox[487 498](iphone)" title="Gantry Administrator :: iPhone/iPod Settings" href="images/stories/demo/gantry/iphone1-large.jpg">\r\n	<img src="images/stories/demo/gantry/iphone1.jpg" alt="iPhone" width="260" height="144" class="rt-image" />\r\n</a>', 4, 'sidebar-a', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=box2 title5\n\n', 0, 0, ''),
(169, 'Menu Module', '<p>This is an example of a module being displayed inside the menu <strong>dropdowns</strong>. This feature can display any <strong>module</strong> or module <strong>position</strong>, allowing for <strong>multiple</strong> modules in the same dropdown.</p>\r\n<p><a href="index.php?option=com_content&amp;view=article&amp;id=100&amp;Itemid=214" class="readon"><span>Read More</span></a></p>', 0, 'menu-mod', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=\n\n', 0, 0, ''),
(115, 'Google Web Fonts', '<p><strong>Google Web Fonts Directory </strong>is a service from <strong>Google</strong> to load <strong>Custom Fonts</strong> onto your site.</p>\r\n\r\n<div class="notice"><div class="typo-icon">Preview all available Google fonts from the Google Font Directory located <a target="_blank" href="http://code.google.com/webfonts">here</a></div></div>\r\n\r\n<img width="260" height="144" alt="Google Web Fonts" src="images/stories/demo/gantry/google1.jpg" class="rt-image" />', 3, 'sidebar-a', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=box2 title5\n\n', 0, 0, ''),
(172, 'Sidebar A', '<p>The <a href="javascript:void(0);">Sidebar-a</a> position, <em>using</em> its <strong>default</strong> module styling.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 11, 'sidebar-a', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=\n\n', 0, 0, ''),
(117, 'FP RokStories', '', 2, 'showcase-a', 0, '0000-00-00 00:00:00', 1, 'mod_rokstories', 0, 0, 0, 'moduleclass_sfx=rt-rokstories\nload_css=1\nlayout_type=layout1\ncontent_type=joomla\nsecid=0\ncatid=38\nshow_front=1\narticle_count=6\nitemsOrdering=order\nstrip_tags=a,i,br\ncontent_position=right\nshow_article_title=1\nshow_created_date=0\nshow_article=1\nshow_article_link=1\nlegacy_readmore=0\nthumb_width=130\nstart_width=auto\nuser_id=0\nstart_element=0\nthumbs_opacity=0.3\nfixed_height=0\nmouse_type=click\nautoplay=0\nautoplay_delay=5000\nshow_label_article_title=1\nshow_arrows=1\narrows_placement=inside\nshow_thumbs=0\nfixed_thumb=1\nlink_titles=0\nlink_labels=0\nlink_images=0\nshow_mask=1\nmask_desc_dir=topdown\nmask_imgs_dir=bottomup\nleft_offset_x=-40\nleft_offset_y=-100\nright_offset_x=-30\nright_offset_y=-100\nleft_f_offset_x=-40\nleft_f_offset_y=-100\nright_f_offset_x=-30\nright_f_offset_y=-100\ncache=0\nmodule_cache=1\ncache_time=900\n\n', 0, 0, ''),
(125, 'FP MainBottom A', '<div class="image-block-surround"><img src="images/stories/demo/frontpage/roktabs-example2.jpg" alt="image" class="image-block" /></div>\r\n<div class="module-title"><h3 class="title">Template/Gantry RTL Support</h3></div>\r\n<p>Zephyr has full <strong>RTL</strong> support, ranging from stylistic elements such as typography, to the <strong>Gantry Framework</strong> itself.</p>\r\n<a class="readon" href="index.php?direction=rtl"><span>Preview RTL</span></a>', 3, 'mainbottom-a', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 0, 'moduleclass_sfx=box3\n\n', 0, 0, ''),
(128, 'FP MainBottom C', '<div class="image-block-surround"><img src="images/stories/demo/frontpage/roktabs-example3.jpg" alt="image" class="image-block" /></div>\r\n<div class="module-title"><h3 class="title">72 Module Suffix Combos</h3></div>\r\n<p><strong>Combine</strong> the 12 Box suffixes with the 6 Title suffixes to create a series of up to <strong>72</strong> different stylistic module <strong>variations</strong>.</p>\r\n<a href="index.php?option=com_content&amp;view=article&amp;id=48&amp;Itemid=56" class="readon"><span>Read More</span></a>', 0, 'mainbottom-c', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 0, 'moduleclass_sfx=box3\n\n', 0, 0, ''),
(129, 'Contact Info', '<ul class="bullet-1">\r\n	<li>Zephyr Developers Inc.</li>\r\n	<li>9090 Cascade Boulevard,</li>\r\n	<li>Miami, Florida, 23490, USA</li>\r\n	<li><strong>Tel:</strong> (555) 555-55555</li>\r\n</ul>', 2, 'bottom-a', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=\n\n', 0, 0, ''),
(130, 'Demo Information', '<ul class="bullet-1">\r\n    <li>All sample content is for demo purposes only, intended to exemplify a live site. All images and materials are the copyright of their respective owners.</li>\r\n    <li>Additionally, this demo, in a modified form for distribution purposes, is available for download in the RocketLauncher format.</li>\r\n</ul>', 0, 'bottom-b', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=\n\n', 0, 0, ''),
(131, 'Help Center', '<ul class="bullet-1">\r\n	<li><a href="index.php?option=com_content&amp;view=article&amp;id=54&amp;Itemid=62">Frequently Asked Questions</a></li>\r\n	<li><a href="index.php?option=com_content&amp;view=article&amp;id=54&amp;Itemid=62">Written Documentation</a></li>\r\n	<li><a href="index.php?option=com_content&amp;view=article&amp;id=54&amp;Itemid=62">Video Guides &amp; Aids</a></li>\r\n	<li><a href="index.php?option=com_content&amp;view=article&amp;id=54&amp;Itemid=62">Member Support Forum</a></li>\r\n</ul>', 0, 'bottom-c', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=\n\n', 0, 0, ''),
(135, 'Member Login', '', 2, 'header-b', 0, '0000-00-00 00:00:00', 1, 'mod_login', 0, 0, 0, 'cache=0\nmoduleclass_sfx=\npretext=\nposttext=\nlogin=\nlogout=\ngreeting=1\nname=0\nusesecure=0\n\n', 0, 0, ''),
(136, 'Font Examples', '<p class="font-family-helvetica">This is the <em class="bold">Helvetica</em> font. Lorem ipsum dolor sit amet. Donec sit amet nibh. Vivamus non arcu.</p>\r\n<p class="font-family-georgia">This is the <em class="bold">Georgia</em> font. Lorem ipsum dolor sit amet. Donec sit amet nibh. Vivamus non arcu.</p>\r\n<p class="font-family-geneva">This is the <em class="bold">Geneva</em> font. Lorem ipsum dolor sit amet. Donec sit amet nibh. Vivamus non arcu.</p>\r\n<p class="font-family-lucida">This is the <em class="bold">Lucida</em> font. Lorem ipsum dolor sit amet. Donec sit amet nibh. Vivamus non arcu.</p>\r\n<p class="font-family-optima">This is the <em class="bold">Optima</em> font. Lorem ipsum dolor sit amet. Donec sit amet nibh. Vivamus non arcu.</p>\r\n<p class="font-family-palatino">This is the <em class="bold">Palatino</em> font. Lorem ipsum dolor sit amet. Donec sit amet nibh. Vivamus non arcu.</p>\r\n<p class="font-family-trebuchet">This is the <em class="bold">Trebuchet</em> font. Lorem ipsum dolor sit amet. Donec sit amet nibh. Vivamus non arcu.</p>\r\n<p class="font-family-enigmatic"><span class="title">This is the Enigmatic font. Lorem ipsum dolor sit amet. Donec sit amet nibh. Vivamus non arcu.</span></p>', 7, 'sidebar-a', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=\n\n', 0, 0, ''),
(158, 'Fusion with MegaMenu', '<div class="image-block-surround floatright">\r\n	<img width="150" height="122" class="image-block" alt="image" src="images/stories/demo/frontpage/roktabs-example1.jpg" /><br /><br />\r\n<a href="index.php?option=com_content&amp;view=article&amp;id=100&amp;Itemid=214" class="readon rt-fusion-readon"><span>More Information</span></a>\r\n</div>\r\n\r\n<div class="module-title"><h2 class="title">Fusion with MegaMenu</h2></div>\r\n\r\n<p>In Zephyr, Fusion Menu has been extended with the following features:</p>\r\n\r\n<ul class="bullet-check">\r\n	<li>Triple / Quad Column Mode</li>\r\n	<li>Child Items Menu Grouping</li>\r\n	<li>Column Width Control</li>\r\n	<li>Load Modules / Positions in Items</li>\r\n</ul>', 2, 'content-top-a', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 0, 'moduleclass_sfx=box8 nomarginbottom\n\n', 0, 0, ''),
(157, 'Menu Poll', '', 0, 'menu-poll', 0, '0000-00-00 00:00:00', 1, 'mod_poll', 0, 0, 0, 'id=15\nmoduleclass_sfx=\ncache=0\ncache_time=900\n\n', 0, 0, ''),
(160, 'FP CB A', '<img src="images/stories/demo/frontpage/banner1.jpg" alt="image" width="420" height="150" class="rt-image"/>', 0, 'content-bottom-a', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 0, 'moduleclass_sfx=box3\n\n', 0, 0, ''),
(163, 'Menu Ad 1', '<img src="images/stories/demo/menu/menu-ad1.jpg" alt="image" class="rt-image"/>', 0, 'menu1', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 0, 'moduleclass_sfx=\n\n', 0, 0, ''),
(168, 'Popup Module', '<p>This is the <strong>Popup Module</strong> feature. Assign any module to the <strong>popup</strong> module position, and ensure that the Popup Feature is enabled in the Gantry Administrator.</p>\r\n\r\n<p>You can configure its height and width from the Gantry Administrator.</p>\r\n\r\n[readon2 url="index.php?option=com_content&amp;view=article&amp;id=47&amp;Itemid=54"]More Information[/readon2]', 0, 'popup', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=\n\n', 0, 0, ''),
(165, 'FP RokIntroScroller', '', 0, 'feature-a', 0, '0000-00-00 00:00:00', 1, 'mod_rokintroscroller', 0, 0, 0, 'moduleclass_sfx=\nshow_title=1\nlink_title=0\nshow_front=1\ncount=8\nitemsOrdering=order\ncatid=44\nsecid=0\nshow_readmore=0\nreadmore=Read More\nduration=800\nitems_per_click=4\npreview_count=300\narrows_opacity=0.35\ncache=0\nmodule_cache=1\ncache_time=900\n\n', 0, 0, ''),
(175, 'Sidebar A', '<p>The <a href="javascript:void(0);">Sidebar-a</a> position, <em>using</em> the <strong>box6 title6</strong> module class suffix.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 12, 'sidebar-a', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=box6 title6\n\n', 0, 0, ''),
(176, 'Sidebar B', '<p>The <a href="javascript:void(0);">Sidebar-b</a> position, <em>using</em> the <strong>box7 title1</strong> module class suffix.</p>\r\n<p><a class="readon" href="javascript:void(0);"><span>More</span></a></p>', 7, 'sidebar-b', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=box7 title1\n\n', 0, 0, ''),
(186, 'RocketLauncher', '<ul class="bullet-star">\r\n	<li>\r\n		Replicate this demo with RocketLauncher, inclusive of the template and content.<br /><br />\r\n		[readon url="index.php?option=com_content&view=article&amp;id=56&amp;Itemid=64"]More Information[/readon]\r\n	</li>\r\n</ul>', 27, 'sidebar-a', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=title6\n\n', 0, 0, ''),
(177, 'RokNewsPager Sample', '', 10, 'sidebar-a', 0, '0000-00-00 00:00:00', 1, 'mod_roknewspager', 0, 0, 1, 'load_css=1\ntheme=dark\ncontent_type=joomla\nsecid=5\ncatid=42\nshow_front=1\narticle_count=2\nshow_accordion=0\nshow_paging=1\nmaxpages=6\nshow_title=1\nshow_thumbnails=1\nthumb_width=79\nthumbnail_link=1\nshow_overlay=1\noverlay=-1\nshow_ratings=1\nshow_readmore=0\nreadmore_text=Read More...\nitemsOrdering=order\nshow_preview_text=1\nstrip_tags=a,br,strong,em\npreview_count=200\nshow_comment_count=0\nshow_author=0\nshow_published_date=0\nautoupdate=0\nautoupdate_delay=5000\nmoduleclass_sfx=title6 box8\ncache=0\nmodule_ident=id\ncache_time=900\n\n', 0, 0, ''),
(178, 'System Requirements', '<p>The following are required for Zephyr to operate fully:</p>\r\n\r\n<ul class="bullet-check">\r\n	<li>Joomla 1.5.x <em>(latest version)</em></li>	\r\n	<li>Gantry v3.0.6 <em>or higher</em></li>\r\n	<li>PHP 5.2 <em>or higher</em></li>	\r\n	<li>RokNavMenu Module</li>\r\n</ul>', 1, 'sidebar-a', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=title6 box8\n\n', 0, 0, ''),
(179, 'Video: Installation', '<div class="media"><div class="typo-icon">\r\n<a href="http://www.rockettheme.com/video/joomla15/template-installation-joomla15.mov" title="Video Tutorial :: Joomla Template Installation Video Tutorial" rel="rokbox[800 620]"><img width="130" height="86" class="rt-image" alt="Image" src="images/stories/demo/general/video-thumb.jpg" /></a>\r\n<br />\r\n<a href="http://www.rockettheme.com/video/joomla15/template-installation-joomla15.mov" title="Video Tutorial :: Joomla Template Installation Video Tutorial" rel="rokbox[800 620]">Template Installation</a>\r\n</div></div>', 22, 'sidebar-a', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=box12 title5 flushbottom\n\n', 0, 0, ''),
(180, 'Video: RocketLauncher', '<div class="media"><div class="typo-icon">\r\n<a rel="rokbox[503 356]" title="Video Tutorial :: Joomla RocketLauncher Installation Video Tutorial" href="http://www.rockettheme.com/video/joomla15/installing-rocketlauncher-joomla15.mov">\r\n	<img width="130" height="86" class="rt-image" alt="Image" src="images/stories/demo/general/video-thumb.jpg" />\r\n</a><br />\r\n<a rel="rokbox[503 356]" title="Video Tutorial :: Joomla RocketLauncher Installation Video Tutorial" href="http://www.rockettheme.com/video/joomla15/installing-rocketlauncher-joomla15.mov">RocketLauncher</a>\r\n</div></div>', 23, 'sidebar-a', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=box12 title5 flushbottom\n\n', 0, 0, ''),
(181, 'Video: Logo Editing', '<div class="media"><div class="typo-icon">\r\n<a rel="rokbox[504 306]" title="Video Tutorial :: Zephyr Logo Editing Video Tutorial" href="http://demo.rockettheme.com/aug10/video/logo.mov">\r\n	<img width="130" height="86" class="rt-image" alt="Image" src="images/stories/demo/general/video-thumb.jpg" />\r\n</a><br />\r\n<a rel="rokbox[504 306]" title="Video Tutorial :: Zephyr Logo Editing Video Tutorial" href="http://demo.rockettheme.com/aug10/video/logo.mov">Logo Editing</a>\r\n</div></div>', 24, 'sidebar-a', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=box12 title5 flushbottom\n\n', 0, 0, ''),
(182, 'Video: Menu Setup', '<div class="media"><div class="typo-icon">\r\n<a rel="rokbox[504 336]" title="Video Tutorial :: Joomla Menu Setup Video Tutorial" href="http://www.rockettheme.com/video/joomla15/menu-configuration-joomla15.mov">\r\n	<img width="130" height="86" class="rt-image" alt="Image" src="images/stories/demo/general/video-thumb.jpg" />\r\n</a><br />\r\n<a rel="rokbox[504 336]" title="Video Tutorial :: Joomla Menu Setup Video Tutorial" href="http://www.rockettheme.com/video/joomla15/menu-configuration-joomla15.mov">Menu Setup Video</a>\r\n</div></div>', 25, 'sidebar-a', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=box12 title5 flushbottom\n\n', 0, 0, ''),
(183, 'Video: Typography', '<div class="media"><div class="typo-icon">\r\n<a rel="rokbox[540 380]" title="Video Tutorial :: Joomla Using Typography Video Tutorial" href="http://www.rockettheme.com/video/joomla15/using-typography-joomla15.mov">\r\n	<img width="130" height="86" class="rt-image" alt="Image" src="images/stories/demo/general/video-thumb.jpg" />\r\n</a><br />\r\n<a rel="rokbox[540 380]" title="Video Tutorial :: Joomla Using Typography Video Tutorial" href="http://www.rockettheme.com/video/joomla15/using-typography-joomla15.mov">Typography</a>\r\n</div></div>', 26, 'sidebar-a', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=box12 title5 flushbottom\n\n', 0, 0, ''),
(184, 'Further Guides', '<p>Below is a selection of relevant forum tutorials:</p>\r\n\r\n<ul class="bullet-notes">\r\n	<li><a href="http://www.rockettheme.com/forum/index.php?t=20046&amp;rb_v=viewtopic" target="_blank">Uploading RocketLauncher to your Server Root</a></li>\r\n	<li><a href="http://www.rockettheme.com/forum/index.php?f=106&amp;t=64695&amp;rb_v=viewtopic#p335309" target="_blank">Updating RocketLauncher / Joomla on a Mac</a></li>\r\n</ul>', 28, 'sidebar-a', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=title6\n\n', 0, 0, ''),
(185, 'RocketTheme Addons', '<a href="index.php?option=com_content&amp;view=article&amp;id=53&amp;Itemid=61"><img width="180" height="120" class="rt-image" alt="Image" src="images/stories/demo/general/extensions.jpg" /></a>', 20, 'sidebar-a', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=box12 title5 flushbottom\n\n', 0, 0, ''),
(187, 'Multi-Column Menu', '<p>If you use <em class="bold2">2,3 or 4</em> columns in <strong>Fusion</strong>, you will need to increase the <strong>Drop-Down Width (px)</strong> value in the menu item settings.</p> \r\n[readon url="index.php?option=com_content&amp;view=article&amp;id=100&amp;Itemid=214"]More Information[/readon]', 28, 'sidebar-a', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=box2\n\n', 0, 0, ''),
(188, 'Videos: Gantry', '<div class="media"><div class="typo-icon">\r\n<a href="http://www.gantry-framework.org/documentation"><img width="130" height="86" class="rt-image" alt="Image" src="images/stories/demo/general/video-thumb.jpg" /></a>\r\n<br />\r\n<a href="http://www.gantry-framework.org/documentation">Gantry Documentation</a>\r\n</div></div>', 20, 'sidebar-a', 0, '0000-00-00 00:00:00', 1, 'mod_custom', 0, 0, 1, 'moduleclass_sfx=box12 title5 flushbottom\n\n', 0, 0, '');

-- --------------------------------------------------------

--
-- Table structure for table `#__modules_menu`
--

DROP TABLE IF EXISTS `#__modules_menu`;
CREATE TABLE IF NOT EXISTS `#__modules_menu` (
  `moduleid` int(11) NOT NULL DEFAULT '0',
  `menuid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`moduleid`,`menuid`)
);

--
-- Dumping data for table `#__modules_menu`
--

INSERT INTO `#__modules_menu` (`moduleid`, `menuid`) VALUES
(16, 50),
(16, 72),
(16, 73),
(17, 0),
(19, 27),
(19, 37),
(19, 50),
(19, 72),
(19, 73),
(19, 74),
(21, 27),
(21, 50),
(21, 72),
(21, 73),
(21, 74),
(22, 27),
(22, 37),
(22, 50),
(22, 72),
(22, 73),
(22, 74),
(25, 27),
(25, 37),
(25, 50),
(25, 72),
(25, 73),
(25, 74),
(35, 56),
(43, 0),
(45, 1),
(46, 61),
(46, 76),
(46, 77),
(46, 78),
(46, 79),
(46, 80),
(46, 81),
(46, 82),
(46, 83),
(48, 56),
(49, 56),
(50, 56),
(51, 56),
(52, 56),
(53, 56),
(54, 56),
(55, 56),
(56, 56),
(57, 56),
(58, 56),
(59, 56),
(60, 56),
(61, 56),
(62, 56),
(63, 56),
(64, 56),
(65, 56),
(66, 56),
(67, 56),
(68, 56),
(69, 56),
(70, 56),
(71, 56),
(72, 56),
(73, 56),
(76, 56),
(77, 56),
(78, 56),
(79, 56),
(80, 56),
(81, 56),
(82, 56),
(83, 56),
(90, 56),
(92, 56),
(95, 56),
(103, 56),
(104, 56),
(105, 56),
(106, 56),
(107, 56),
(108, 56),
(109, 56),
(110, 56),
(111, 56),
(112, 56),
(114, 54),
(115, 54),
(117, 1),
(118, 1),
(121, 61),
(125, 1),
(128, 1),
(129, 1),
(129, 11),
(129, 12),
(129, 13),
(129, 14),
(129, 15),
(129, 16),
(129, 17),
(129, 18),
(129, 20),
(129, 24),
(129, 27),
(129, 28),
(129, 29),
(129, 30),
(129, 37),
(129, 38),
(129, 40),
(129, 43),
(129, 44),
(129, 45),
(129, 46),
(129, 47),
(129, 50),
(129, 51),
(129, 52),
(129, 53),
(129, 54),
(129, 55),
(129, 57),
(129, 58),
(129, 59),
(129, 60),
(129, 61),
(129, 62),
(129, 63),
(129, 64),
(129, 65),
(129, 66),
(129, 67),
(129, 68),
(129, 69),
(129, 70),
(129, 71),
(129, 72),
(129, 73),
(129, 74),
(129, 75),
(129, 76),
(129, 77),
(129, 78),
(129, 79),
(129, 80),
(129, 81),
(129, 82),
(129, 83),
(129, 84),
(129, 85),
(129, 86),
(129, 87),
(129, 88),
(129, 89),
(129, 90),
(129, 91),
(129, 92),
(129, 93),
(129, 94),
(129, 95),
(129, 96),
(129, 97),
(129, 98),
(129, 99),
(129, 100),
(129, 101),
(129, 102),
(129, 103),
(129, 104),
(129, 105),
(129, 106),
(129, 107),
(129, 108),
(129, 109),
(129, 110),
(129, 111),
(129, 112),
(129, 113),
(129, 114),
(129, 115),
(129, 116),
(129, 117),
(129, 118),
(129, 119),
(129, 120),
(129, 121),
(129, 122),
(129, 123),
(129, 124),
(129, 125),
(129, 126),
(129, 127),
(129, 128),
(129, 129),
(129, 130),
(129, 131),
(129, 132),
(129, 133),
(129, 134),
(129, 135),
(129, 136),
(129, 137),
(129, 138),
(129, 139),
(129, 140),
(129, 141),
(129, 142),
(129, 143),
(129, 144),
(129, 145),
(129, 146),
(129, 147),
(129, 148),
(129, 170),
(129, 171),
(129, 172),
(129, 173),
(129, 174),
(129, 175),
(129, 176),
(129, 177),
(129, 178),
(129, 179),
(129, 180),
(129, 181),
(129, 182),
(129, 183),
(129, 184),
(129, 185),
(129, 186),
(129, 187),
(129, 188),
(129, 189),
(129, 190),
(129, 191),
(129, 192),
(129, 193),
(129, 194),
(129, 195),
(129, 196),
(129, 197),
(129, 198),
(129, 199),
(129, 200),
(129, 201),
(129, 202),
(129, 203),
(129, 204),
(129, 205),
(129, 206),
(129, 207),
(129, 208),
(129, 209),
(129, 210),
(129, 211),
(129, 214),
(129, 215),
(129, 216),
(129, 217),
(129, 218),
(129, 219),
(129, 220),
(129, 221),
(129, 222),
(129, 223),
(129, 224),
(129, 225),
(129, 413),
(129, 414),
(129, 415),
(129, 416),
(129, 417),
(129, 418),
(129, 419),
(129, 420),
(129, 421),
(130, 1),
(130, 11),
(130, 12),
(130, 13),
(130, 14),
(130, 15),
(130, 16),
(130, 17),
(130, 18),
(130, 20),
(130, 24),
(130, 27),
(130, 28),
(130, 29),
(130, 30),
(130, 37),
(130, 38),
(130, 40),
(130, 43),
(130, 44),
(130, 45),
(130, 46),
(130, 47),
(130, 50),
(130, 51),
(130, 52),
(130, 53),
(130, 54),
(130, 55),
(130, 57),
(130, 58),
(130, 59),
(130, 60),
(130, 61),
(130, 62),
(130, 63),
(130, 64),
(130, 65),
(130, 66),
(130, 67),
(130, 68),
(130, 69),
(130, 70),
(130, 71),
(130, 72),
(130, 73),
(130, 74),
(130, 75),
(130, 76),
(130, 77),
(130, 78),
(130, 79),
(130, 80),
(130, 81),
(130, 82),
(130, 83),
(130, 84),
(130, 85),
(130, 86),
(130, 87),
(130, 88),
(130, 89),
(130, 90),
(130, 91),
(130, 92),
(130, 93),
(130, 94),
(130, 95),
(130, 96),
(130, 97),
(130, 98),
(130, 99),
(130, 100),
(130, 101),
(130, 102),
(130, 103),
(130, 104),
(130, 105),
(130, 106),
(130, 107),
(130, 108),
(130, 109),
(130, 110),
(130, 111),
(130, 112),
(130, 113),
(130, 114),
(130, 115),
(130, 116),
(130, 117),
(130, 118),
(130, 119),
(130, 120),
(130, 121),
(130, 122),
(130, 123),
(130, 124),
(130, 125),
(130, 126),
(130, 127),
(130, 128),
(130, 129),
(130, 130),
(130, 131),
(130, 132),
(130, 133),
(130, 134),
(130, 135),
(130, 136),
(130, 137),
(130, 138),
(130, 139),
(130, 140),
(130, 141),
(130, 142),
(130, 143),
(130, 144),
(130, 145),
(130, 146),
(130, 147),
(130, 148),
(130, 170),
(130, 171),
(130, 172),
(130, 173),
(130, 174),
(130, 175),
(130, 176),
(130, 177),
(130, 178),
(130, 179),
(130, 180),
(130, 181),
(130, 182),
(130, 183),
(130, 184),
(130, 185),
(130, 186),
(130, 187),
(130, 188),
(130, 189),
(130, 190),
(130, 191),
(130, 192),
(130, 193),
(130, 194),
(130, 195),
(130, 196),
(130, 197),
(130, 198),
(130, 199),
(130, 200),
(130, 201),
(130, 202),
(130, 203),
(130, 204),
(130, 205),
(130, 206),
(130, 207),
(130, 208),
(130, 209),
(130, 210),
(130, 211),
(130, 214),
(130, 215),
(130, 216),
(130, 217),
(130, 218),
(130, 219),
(130, 220),
(130, 221),
(130, 222),
(130, 223),
(130, 224),
(130, 225),
(130, 413),
(130, 414),
(130, 415),
(130, 416),
(130, 417),
(130, 418),
(130, 419),
(130, 420),
(130, 421),
(131, 1),
(131, 11),
(131, 12),
(131, 13),
(131, 14),
(131, 15),
(131, 16),
(131, 17),
(131, 18),
(131, 20),
(131, 24),
(131, 27),
(131, 28),
(131, 29),
(131, 30),
(131, 37),
(131, 38),
(131, 40),
(131, 43),
(131, 44),
(131, 45),
(131, 46),
(131, 47),
(131, 50),
(131, 51),
(131, 52),
(131, 53),
(131, 54),
(131, 55),
(131, 57),
(131, 58),
(131, 59),
(131, 60),
(131, 61),
(131, 62),
(131, 63),
(131, 64),
(131, 65),
(131, 66),
(131, 67),
(131, 68),
(131, 69),
(131, 70),
(131, 71),
(131, 72),
(131, 73),
(131, 74),
(131, 75),
(131, 76),
(131, 77),
(131, 78),
(131, 79),
(131, 80),
(131, 81),
(131, 82),
(131, 83),
(131, 84),
(131, 85),
(131, 86),
(131, 87),
(131, 88),
(131, 89),
(131, 90),
(131, 91),
(131, 92),
(131, 93),
(131, 94),
(131, 95),
(131, 96),
(131, 97),
(131, 98),
(131, 99),
(131, 100),
(131, 101),
(131, 102),
(131, 103),
(131, 104),
(131, 105),
(131, 106),
(131, 107),
(131, 108),
(131, 109),
(131, 110),
(131, 111),
(131, 112),
(131, 113),
(131, 114),
(131, 115),
(131, 116),
(131, 117),
(131, 118),
(131, 119),
(131, 120),
(131, 121),
(131, 122),
(131, 123),
(131, 124),
(131, 125),
(131, 126),
(131, 127),
(131, 128),
(131, 129),
(131, 130),
(131, 131),
(131, 132),
(131, 133),
(131, 134),
(131, 135),
(131, 136),
(131, 137),
(131, 138),
(131, 139),
(131, 140),
(131, 141),
(131, 142),
(131, 143),
(131, 144),
(131, 145),
(131, 146),
(131, 147),
(131, 148),
(131, 170),
(131, 171),
(131, 172),
(131, 173),
(131, 174),
(131, 175),
(131, 176),
(131, 177),
(131, 178),
(131, 179),
(131, 180),
(131, 181),
(131, 182),
(131, 183),
(131, 184),
(131, 185),
(131, 186),
(131, 187),
(131, 188),
(131, 189),
(131, 190),
(131, 191),
(131, 192),
(131, 193),
(131, 194),
(131, 195),
(131, 196),
(131, 197),
(131, 198),
(131, 199),
(131, 200),
(131, 201),
(131, 202),
(131, 203),
(131, 204),
(131, 205),
(131, 206),
(131, 207),
(131, 208),
(131, 209),
(131, 210),
(131, 211),
(131, 214),
(131, 215),
(131, 216),
(131, 217),
(131, 218),
(131, 219),
(131, 220),
(131, 221),
(131, 222),
(131, 223),
(131, 224),
(131, 225),
(131, 413),
(131, 414),
(131, 415),
(131, 416),
(131, 417),
(131, 418),
(131, 419),
(131, 420),
(131, 421),
(135, 1),
(135, 11),
(135, 12),
(135, 13),
(135, 14),
(135, 15),
(135, 16),
(135, 17),
(135, 18),
(135, 20),
(135, 24),
(135, 27),
(135, 28),
(135, 29),
(135, 30),
(135, 37),
(135, 38),
(135, 40),
(135, 43),
(135, 44),
(135, 45),
(135, 46),
(135, 47),
(135, 50),
(135, 51),
(135, 52),
(135, 53),
(135, 54),
(135, 55),
(135, 57),
(135, 58),
(135, 59),
(135, 60),
(135, 61),
(135, 62),
(135, 63),
(135, 64),
(135, 65),
(135, 66),
(135, 67),
(135, 68),
(135, 69),
(135, 70),
(135, 71),
(135, 72),
(135, 73),
(135, 74),
(135, 75),
(135, 76),
(135, 77),
(135, 78),
(135, 79),
(135, 80),
(135, 81),
(135, 82),
(135, 83),
(135, 84),
(135, 85),
(135, 86),
(135, 87),
(135, 88),
(135, 89),
(135, 90),
(135, 91),
(135, 92),
(135, 93),
(135, 94),
(135, 95),
(135, 96),
(135, 97),
(135, 98),
(135, 99),
(135, 100),
(135, 101),
(135, 102),
(135, 103),
(135, 104),
(135, 105),
(135, 106),
(135, 107),
(135, 108),
(135, 109),
(135, 110),
(135, 111),
(135, 112),
(135, 113),
(135, 114),
(135, 115),
(135, 116),
(135, 117),
(135, 118),
(135, 119),
(135, 120),
(135, 121),
(135, 122),
(135, 123),
(135, 124),
(135, 125),
(135, 126),
(135, 127),
(135, 128),
(135, 129),
(135, 130),
(135, 131),
(135, 132),
(135, 133),
(135, 134),
(135, 135),
(135, 136),
(135, 137),
(135, 138),
(135, 139),
(135, 140),
(135, 141),
(135, 142),
(135, 143),
(135, 144),
(135, 145),
(135, 146),
(135, 147),
(135, 148),
(135, 170),
(135, 171),
(135, 172),
(135, 173),
(135, 174),
(135, 175),
(135, 176),
(135, 177),
(135, 178),
(135, 179),
(135, 180),
(135, 181),
(135, 182),
(135, 183),
(135, 184),
(135, 185),
(135, 186),
(135, 187),
(135, 188),
(135, 189),
(135, 190),
(135, 191),
(135, 192),
(135, 193),
(135, 194),
(135, 195),
(135, 196),
(135, 197),
(135, 198),
(135, 199),
(135, 200),
(135, 201),
(135, 202),
(135, 203),
(135, 204),
(135, 205),
(135, 206),
(135, 207),
(135, 208),
(135, 209),
(135, 210),
(135, 211),
(135, 214),
(135, 215),
(135, 216),
(135, 217),
(135, 218),
(135, 219),
(135, 220),
(135, 221),
(135, 222),
(135, 223),
(135, 224),
(135, 225),
(135, 413),
(135, 414),
(135, 415),
(135, 416),
(135, 417),
(136, 59),
(136, 60),
(155, 1),
(157, 0),
(158, 1),
(160, 1),
(163, 0),
(165, 1),
(166, 0),
(168, 0),
(169, 0),
(171, 56),
(172, 56),
(173, 56),
(174, 56),
(175, 56),
(176, 56),
(177, 61),
(178, 11),
(178, 12),
(178, 13),
(178, 14),
(178, 15),
(178, 16),
(178, 17),
(178, 18),
(178, 20),
(178, 24),
(178, 27),
(178, 28),
(178, 29),
(178, 30),
(178, 37),
(178, 38),
(178, 40),
(178, 43),
(178, 44),
(178, 45),
(178, 46),
(178, 47),
(178, 50),
(178, 51),
(178, 52),
(178, 53),
(178, 55),
(178, 57),
(178, 58),
(178, 59),
(178, 60),
(178, 62),
(178, 63),
(178, 64),
(178, 65),
(178, 66),
(178, 67),
(178, 68),
(178, 69),
(178, 70),
(178, 71),
(178, 72),
(178, 73),
(178, 74),
(178, 84),
(178, 85),
(178, 86),
(178, 87),
(178, 88),
(178, 89),
(178, 90),
(178, 91),
(178, 92),
(178, 93),
(178, 94),
(178, 95),
(178, 96),
(178, 97),
(178, 98),
(178, 99),
(178, 100),
(178, 101),
(178, 102),
(178, 103),
(178, 104),
(178, 105),
(178, 106),
(178, 107),
(178, 108),
(178, 109),
(178, 110),
(178, 111),
(178, 112),
(178, 113),
(178, 114),
(178, 115),
(178, 116),
(178, 117),
(178, 118),
(178, 119),
(178, 120),
(178, 121),
(178, 122),
(178, 123),
(178, 124),
(178, 125),
(178, 126),
(178, 127),
(178, 128),
(178, 129),
(178, 130),
(178, 131),
(178, 132),
(178, 133),
(178, 134),
(178, 135),
(178, 136),
(178, 137),
(178, 138),
(178, 139),
(178, 140),
(178, 141),
(178, 142),
(178, 143),
(178, 145),
(178, 147),
(178, 148),
(178, 170),
(178, 171),
(178, 172),
(178, 174),
(178, 175),
(178, 176),
(178, 177),
(178, 178),
(178, 179),
(178, 180),
(178, 181),
(178, 182),
(178, 183),
(178, 184),
(178, 185),
(178, 186),
(178, 187),
(178, 188),
(178, 189),
(178, 190),
(178, 191),
(178, 192),
(178, 193),
(178, 194),
(178, 195),
(178, 196),
(178, 197),
(178, 198),
(178, 199),
(178, 214),
(178, 215),
(178, 216),
(178, 217),
(178, 218),
(178, 219),
(178, 220),
(178, 221),
(178, 222),
(178, 223),
(178, 224),
(178, 225),
(178, 414),
(178, 415),
(178, 416),
(178, 417),
(178, 419),
(179, 63),
(180, 64),
(181, 67),
(182, 66),
(182, 214),
(183, 58),
(183, 59),
(183, 60),
(183, 68),
(183, 134),
(184, 64),
(185, 145),
(186, 53),
(186, 55),
(186, 57),
(186, 58),
(186, 59),
(186, 60),
(186, 62),
(186, 63),
(186, 65),
(186, 66),
(186, 67),
(186, 68),
(186, 69),
(186, 71),
(186, 84),
(186, 85),
(186, 86),
(186, 87),
(186, 88),
(186, 89),
(186, 90),
(186, 91),
(186, 92),
(186, 93),
(186, 94),
(186, 95),
(186, 96),
(186, 97),
(186, 98),
(186, 99),
(186, 100),
(186, 101),
(186, 102),
(186, 103),
(186, 104),
(186, 105),
(186, 106),
(186, 107),
(186, 108),
(186, 109),
(186, 110),
(186, 111),
(186, 134),
(186, 171),
(186, 174),
(186, 175),
(186, 176),
(186, 177),
(186, 178),
(186, 179),
(186, 180),
(186, 181),
(186, 182),
(186, 183),
(186, 184),
(186, 185),
(186, 186),
(186, 187),
(186, 188),
(186, 189),
(186, 190),
(186, 191),
(186, 192),
(186, 193),
(186, 194),
(186, 195),
(186, 196),
(186, 197),
(186, 198),
(186, 199),
(186, 214),
(186, 215),
(186, 216),
(186, 217),
(186, 218),
(186, 219),
(186, 220),
(186, 221),
(186, 222),
(186, 223),
(186, 224),
(186, 225),
(186, 414),
(186, 415),
(186, 416),
(186, 417),
(186, 420),
(187, 53),
(187, 55),
(187, 57),
(187, 58),
(187, 59),
(187, 60),
(187, 62),
(187, 63),
(187, 65),
(187, 66),
(187, 67),
(187, 68),
(187, 69),
(187, 71),
(187, 84),
(187, 85),
(187, 86),
(187, 87),
(187, 88),
(187, 89),
(187, 90),
(187, 91),
(187, 92),
(187, 93),
(187, 94),
(187, 95),
(187, 96),
(187, 97),
(187, 98),
(187, 99),
(187, 100),
(187, 101),
(187, 102),
(187, 103),
(187, 104),
(187, 105),
(187, 106),
(187, 107),
(187, 108),
(187, 109),
(187, 110),
(187, 111),
(187, 134),
(187, 135),
(187, 136),
(187, 137),
(187, 138),
(187, 139),
(187, 140),
(187, 141),
(187, 142),
(187, 171),
(187, 174),
(187, 175),
(187, 176),
(187, 177),
(187, 178),
(187, 179),
(187, 180),
(187, 181),
(187, 182),
(187, 183),
(187, 184),
(187, 185),
(187, 186),
(187, 187),
(187, 188),
(187, 189),
(187, 190),
(187, 191),
(187, 192),
(187, 193),
(187, 194),
(187, 195),
(187, 196),
(187, 197),
(187, 198),
(187, 199),
(187, 214),
(187, 215),
(187, 216),
(187, 217),
(187, 218),
(187, 219),
(187, 220),
(187, 221),
(187, 222),
(187, 223),
(187, 224),
(187, 225),
(187, 414),
(187, 415),
(187, 416),
(187, 417),
(187, 420),
(187, 421),
(187, 422),
(187, 423),
(187, 424),
(187, 425),
(188, 53),
(188, 55),
(188, 57),
(188, 65),
(188, 69),
(188, 171),
(188, 420);

-- --------------------------------------------------------

--
-- Table structure for table `#__newsfeeds`
--

DROP TABLE IF EXISTS `#__newsfeeds`;
CREATE TABLE IF NOT EXISTS `#__newsfeeds` (
  `catid` int(11) NOT NULL DEFAULT '0',
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `alias` varchar(255) NOT NULL DEFAULT '',
  `link` text NOT NULL,
  `filename` varchar(200) DEFAULT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `numarticles` int(11) unsigned NOT NULL DEFAULT '1',
  `cache_time` int(11) unsigned NOT NULL DEFAULT '3600',
  `checked_out` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `rtl` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `published` (`published`),
  KEY `catid` (`catid`)
);

--
-- Dumping data for table `#__newsfeeds`
--

INSERT INTO `#__newsfeeds` (`catid`, `id`, `name`, `alias`, `link`, `filename`, `published`, `numarticles`, `cache_time`, `checked_out`, `checked_out_time`, `ordering`, `rtl`) VALUES
(4, 1, 'Joomla! Announcements', 'joomla-official-news', 'http://feeds.joomla.org/JoomlaAnnouncements', '', 1, 5, 3600, 0, '0000-00-00 00:00:00', 1, 0),
(4, 2, 'Joomla! Core Team Blog', 'joomla-core-team-blog', 'http://feeds.joomla.org/JoomlaCommunityCoreTeamBlog', '', 1, 5, 3600, 0, '0000-00-00 00:00:00', 2, 0),
(4, 3, 'Joomla! Community Magazine', 'joomla-community-magazine', 'http://feeds.joomla.org/JoomlaMagazine', '', 1, 20, 3600, 0, '0000-00-00 00:00:00', 3, 0),
(4, 4, 'Joomla! Developer News', 'joomla-developer-news', 'http://feeds.joomla.org/JoomlaDeveloper', '', 1, 5, 3600, 0, '0000-00-00 00:00:00', 4, 0),
(4, 5, 'Joomla! Security News', 'joomla-security-news', 'http://feeds.joomla.org/JoomlaSecurityNews', '', 1, 5, 3600, 0, '0000-00-00 00:00:00', 5, 0),
(5, 6, 'Free Software Foundation Blogs', 'free-software-foundation-blogs', 'http://www.fsf.org/blogs/RSS', NULL, 1, 5, 3600, 0, '0000-00-00 00:00:00', 4, 0),
(5, 7, 'Free Software Foundation', 'free-software-foundation', 'http://www.fsf.org/news/RSS', NULL, 1, 5, 3600, 0, '0000-00-00 00:00:00', 3, 0),
(5, 8, 'Software Freedom Law Center Blog', 'software-freedom-law-center-blog', 'http://www.softwarefreedom.org/feeds/blog/', NULL, 1, 5, 3600, 0, '0000-00-00 00:00:00', 2, 0),
(5, 9, 'Software Freedom Law Center News', 'software-freedom-law-center', 'http://www.softwarefreedom.org/feeds/news/', NULL, 1, 5, 3600, 0, '0000-00-00 00:00:00', 1, 0),
(5, 10, 'Open Source Initiative Blog', 'open-source-initiative-blog', 'http://www.opensource.org/blog/feed', NULL, 1, 5, 3600, 0, '0000-00-00 00:00:00', 5, 0),
(6, 11, 'PHP News and Announcements', 'php-news-and-announcements', 'http://www.php.net/feed.atom', NULL, 1, 5, 3600, 0, '0000-00-00 00:00:00', 1, 0),
(6, 12, 'Planet MySQL', 'planet-mysql', 'http://www.planetmysql.org/rss20.xml', NULL, 1, 5, 3600, 0, '0000-00-00 00:00:00', 2, 0),
(6, 13, 'Linux Foundation Announcements', 'linux-foundation-announcements', 'http://www.linuxfoundation.org/press/rss20.xml', NULL, 1, 5, 3600, 0, '0000-00-00 00:00:00', 3, 0),
(6, 14, 'Mootools Blog', 'mootools-blog', 'http://feeds.feedburner.com/mootools-blog', NULL, 1, 5, 3600, 0, '0000-00-00 00:00:00', 4, 0);

-- --------------------------------------------------------

--
-- Table structure for table `#__plugins`
--

DROP TABLE IF EXISTS `#__plugins`;
CREATE TABLE IF NOT EXISTS `#__plugins` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '',
  `element` varchar(100) NOT NULL DEFAULT '',
  `folder` varchar(100) NOT NULL DEFAULT '',
  `access` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `published` tinyint(3) NOT NULL DEFAULT '0',
  `iscore` tinyint(3) NOT NULL DEFAULT '0',
  `client_id` tinyint(3) NOT NULL DEFAULT '0',
  `checked_out` int(11) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `params` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_folder` (`published`,`client_id`,`access`,`folder`)
);

--
-- Dumping data for table `#__plugins`
--

INSERT INTO `#__plugins` (`id`, `name`, `element`, `folder`, `access`, `ordering`, `published`, `iscore`, `client_id`, `checked_out`, `checked_out_time`, `params`) VALUES
(1, 'Authentication - Joomla', 'joomla', 'authentication', 0, 1, 1, 1, 0, 0, '0000-00-00 00:00:00', ''),
(2, 'Authentication - LDAP', 'ldap', 'authentication', 0, 2, 0, 1, 0, 0, '0000-00-00 00:00:00', 'host=\nport=389\nuse_ldapV3=0\nnegotiate_tls=0\nno_referrals=0\nauth_method=bind\nbase_dn=\nsearch_string=\nusers_dn=\nusername=\npassword=\nldap_fullname=fullName\nldap_email=mail\nldap_uid=uid\n\n'),
(3, 'Authentication - GMail', 'gmail', 'authentication', 0, 4, 0, 0, 0, 0, '0000-00-00 00:00:00', ''),
(4, 'Authentication - OpenID', 'openid', 'authentication', 0, 3, 0, 0, 0, 0, '0000-00-00 00:00:00', ''),
(5, 'User - Joomla!', 'joomla', 'user', 0, 0, 1, 0, 0, 0, '0000-00-00 00:00:00', 'autoregister=1\n\n'),
(6, 'Search - Content', 'content', 'search', 0, 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 'search_limit=50\nsearch_content=1\nsearch_uncategorised=1\nsearch_archived=1\n\n'),
(7, 'Search - Contacts', 'contacts', 'search', 0, 3, 1, 1, 0, 0, '0000-00-00 00:00:00', 'search_limit=50\n\n'),
(8, 'Search - Categories', 'categories', 'search', 0, 4, 1, 0, 0, 0, '0000-00-00 00:00:00', 'search_limit=50\n\n'),
(9, 'Search - Sections', 'sections', 'search', 0, 5, 1, 0, 0, 0, '0000-00-00 00:00:00', 'search_limit=50\n\n'),
(10, 'Search - Newsfeeds', 'newsfeeds', 'search', 0, 6, 1, 0, 0, 0, '0000-00-00 00:00:00', 'search_limit=50\n\n'),
(11, 'Search - Weblinks', 'weblinks', 'search', 0, 2, 1, 1, 0, 0, '0000-00-00 00:00:00', 'search_limit=50\n\n'),
(12, 'Content - Pagebreak', 'pagebreak', 'content', 0, 10000, 1, 1, 0, 0, '0000-00-00 00:00:00', 'enabled=1\ntitle=1\nmultipage_toc=1\nshowall=1\n\n'),
(13, 'Content - Rating', 'vote', 'content', 0, 4, 1, 1, 0, 0, '0000-00-00 00:00:00', ''),
(14, 'Content - Email Cloaking', 'emailcloak', 'content', 0, 5, 1, 0, 0, 0, '0000-00-00 00:00:00', 'mode=1\n\n'),
(15, 'Content - Code Hightlighter (GeSHi)', 'geshi', 'content', 0, 5, 0, 0, 0, 0, '0000-00-00 00:00:00', ''),
(16, 'Content - Load Module', 'loadmodule', 'content', 0, 6, 1, 0, 0, 0, '0000-00-00 00:00:00', 'enabled=1\nstyle=0\n\n'),
(17, 'Content - Page Navigation', 'pagenavigation', 'content', 0, 2, 1, 1, 0, 0, '0000-00-00 00:00:00', 'position=1\n\n'),
(18, 'Editor - No Editor', 'none', 'editors', 0, 0, 1, 1, 0, 0, '0000-00-00 00:00:00', ''),
(19, 'Editor - TinyMCE', 'tinymce', 'editors', 0, 0, 1, 1, 0, 0, '0000-00-00 00:00:00', 'mode=advanced\nskin=0\ncompressed=0\ncleanup_startup=0\ncleanup_save=2\nentity_encoding=raw\nlang_mode=0\nlang_code=en\ntext_direction=ltr\ncontent_css=1\ncontent_css_custom=\nrelative_urls=1\nnewlines=0\ninvalid_elements=applet\nextended_elements=\ntoolbar=top\ntoolbar_align=left\nhtml_height=550\nhtml_width=750\nelement_path=1\nfonts=1\npaste=1\nsearchreplace=1\ninsertdate=1\nformat_date=%Y-%m-%d\ninserttime=1\nformat_time=%H:%M:%S\ncolors=1\ntable=1\nsmilies=1\nmedia=1\nhr=1\ndirectionality=1\nfullscreen=1\nstyle=1\nlayer=1\nxhtmlxtras=1\nvisualchars=1\nnonbreaking=1\ntemplate=0\nadvimage=1\nadvlink=1\nautosave=1\ncontextmenu=1\ninlinepopups=1\nsafari=1\ncustom_plugin=\ncustom_button=\n\n'),
(20, 'Editor - XStandard Lite 2.0', 'xstandard', 'editors', 0, 0, 0, 1, 0, 0, '0000-00-00 00:00:00', ''),
(21, 'Editor Button - Image', 'image', 'editors-xtd', 0, 0, 1, 0, 0, 0, '0000-00-00 00:00:00', ''),
(22, 'Editor Button - Pagebreak', 'pagebreak', 'editors-xtd', 0, 0, 1, 0, 0, 0, '0000-00-00 00:00:00', ''),
(23, 'Editor Button - Readmore', 'readmore', 'editors-xtd', 0, 0, 1, 0, 0, 0, '0000-00-00 00:00:00', ''),
(24, 'XML-RPC - Joomla', 'joomla', 'xmlrpc', 0, 7, 0, 1, 0, 0, '0000-00-00 00:00:00', ''),
(25, 'XML-RPC - Blogger API', 'blogger', 'xmlrpc', 0, 7, 0, 1, 0, 0, '0000-00-00 00:00:00', 'catid=1\nsectionid=0\n\n'),
(27, 'System - SEF', 'sef', 'system', 0, 1, 1, 0, 0, 0, '0000-00-00 00:00:00', ''),
(28, 'System - Debug', 'debug', 'system', 0, 2, 1, 0, 0, 0, '0000-00-00 00:00:00', 'queries=1\nmemory=1\nlangauge=1\n\n'),
(29, 'System - Legacy', 'legacy', 'system', 0, 3, 0, 1, 0, 0, '0000-00-00 00:00:00', 'route=0\n\n'),
(30, 'System - Cache', 'cache', 'system', 0, 4, 0, 1, 0, 0, '0000-00-00 00:00:00', 'browsercache=0\ncachetime=15\n\n'),
(31, 'System - Log', 'log', 'system', 0, 5, 0, 1, 0, 0, '0000-00-00 00:00:00', ''),
(32, 'System - Remember Me', 'remember', 'system', 0, 6, 1, 1, 0, 0, '0000-00-00 00:00:00', ''),
(33, 'System - Backlink', 'backlink', 'system', 0, 7, 0, 1, 0, 0, '0000-00-00 00:00:00', ''),
(34, 'System - Mootools Upgrade', 'mtupgrade', 'system', 0, 8, 0, 1, 0, 0, '0000-00-00 00:00:00', ''),
(35, 'System - RokCandy', 'rokcandy_system', 'system', 0, 0, 1, 1, 0, 0, '0000-00-00 00:00:00', ''),
(36, 'Button - RokCandy', 'rokcandy_button', 'editors-xtd', 0, 0, 1, 1, 0, 0, '0000-00-00 00:00:00', ''),
(37, 'RokNavMenu - Boost', 'boost', 'roknavmenu', 0, 0, 1, 1, 0, 0, '0000-00-00 00:00:00', ''),
(38, 'RokNavMenu - Extended Link', 'extendedlink', 'roknavmenu', 0, 0, 1, 1, 0, 0, '0000-00-00 00:00:00', ''),
(39, 'Content - RokBox', 'rokbox', 'content', 0, 0, 1, 0, 0, 0, '0000-00-00 00:00:00', 'thumb_ext=_thumb\nthumb_class=album\nthumb_dir=cache\nthumb_width=150\nthumb_height=100\nthumb_quality=90\n'),
(40, 'Editor - RokPad', 'rokpad', 'editors', 0, 0, 1, 0, 0, 0, '0000-00-00 00:00:00', '@spacer=<div id="parser-type"   style="font-weight:normal;font-size:12px;color:#fff;padding:4px;margin:0;background:#666;">Parser Type</div>\nrokpad-parser=xhtmlmixed\nrokpad-tidylevel=XHTML 1.0 Transitional\nrokpad-show-formatter=1\n@spacer=<div id="editor-parameters"   style="font-weight:normal;font-size:12px;color:#fff;padding:4px;margin:0;background:#666;">Editor Parameters</div>\nrokpad-height=350\nrokpad-passdelay=200\nrokpad-passtime=50\nrokpad-linenumberdelay=200\nrokpad-linenumbertime=50\nrokpad-continuous=500\nrokpad-matchparens=1\nrokpad-history=50\nrokpad-history-delay=800\nrokpad-lineHandler=1\nrokpad-textwrapperHandler=1\nrokpad-indentunit=2\nrokpad-tabmode=indent\nrokpad-loadindent=1\n'),
(41, 'System - RokBox', 'rokbox', 'system', 0, 0, 1, 0, 0, 0, '0000-00-00 00:00:00', 'theme=dark\ncustom-theme=sample\ncustom-legacy=0\nwidth=640\nheight=460\ntransition=Quad.easeOut\nduration=200\nchase=40\neffect=quicksilver\nframe-border=20\ncontent-padding=0\narrows-height=35\ncaptions=1\ncaptionsDelay=800\nscrolling=0\nkeyEvents=1\noverlay_background=#000000\noverlay_opacity=0.85\noverlay_duration=200\noverlay_transition=Quad.easeInOut\nautoplay=true\nytautoplay=0\nythighquality=0\ncontroller=false\nbgcolor=#f3f3f3\nvimeoColor=00adef\nvimeoPortrait=0\nvimeoTitle=0\nvimeoFullScreen=1\nvimeoByline=0\n\n'),
(42, 'System - RokGantry Cache', 'rokgantrycache', 'system', 0, 0, 0, 0, 0, 0, '0000-00-00 00:00:00', ''),
(43, 'System - RokGZipper', 'rokgzipper', 'system', 0, 0, 0, 0, 0, 0, '0000-00-00 00:00:00', 'cache_time=900\nexpires_header_time=1440\nstrip_css=1\n');

-- --------------------------------------------------------

--
-- Table structure for table `#__polls`
--

DROP TABLE IF EXISTS `#__polls`;
CREATE TABLE IF NOT EXISTS `#__polls` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(255) NOT NULL DEFAULT '',
  `voters` int(9) NOT NULL DEFAULT '0',
  `checked_out` int(11) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `access` int(11) NOT NULL DEFAULT '0',
  `lag` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
);

--
-- Dumping data for table `#__polls`
--

INSERT INTO `#__polls` (`id`, `title`, `alias`, `voters`, `checked_out`, `checked_out_time`, `published`, `access`, `lag`) VALUES
(14, 'Joomla! is used for?', 'joomla-is-used-for', 12, 0, '0000-00-00 00:00:00', 1, 0, 86400),
(15, 'Best Fusion Feature', 'best-fusion-feature', 9, 0, '0000-00-00 00:00:00', 1, 0, 86400);

-- --------------------------------------------------------

--
-- Table structure for table `#__poll_data`
--

DROP TABLE IF EXISTS `#__poll_data`;
CREATE TABLE IF NOT EXISTS `#__poll_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pollid` int(11) NOT NULL DEFAULT '0',
  `text` text NOT NULL,
  `hits` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `pollid` (`pollid`,`text`(1))
);

--
-- Dumping data for table `#__poll_data`
--

INSERT INTO `#__poll_data` (`id`, `pollid`, `text`, `hits`) VALUES
(1, 14, 'Community Sites', 2),
(2, 14, 'Public Brand Sites', 3),
(3, 14, 'eCommerce', 1),
(4, 14, 'Blogs', 0),
(5, 14, 'Intranets', 0),
(6, 14, 'Photo and Media Sites', 3),
(7, 14, 'All of the Above!', 3),
(8, 14, '', 0),
(9, 14, '', 0),
(10, 14, '', 0),
(11, 14, '', 0),
(12, 14, '', 0),
(13, 15, 'Grouped Child Items', 0),
(14, 15, '1/2/3/4 Column Modes', 3),
(15, 15, 'Menu Modules/Positions', 5),
(16, 15, 'Column Width Controls', 0),
(17, 15, 'Menu Icon Support', 0),
(18, 15, 'Subtext Line', 1),
(19, 15, '', 0),
(20, 15, '', 0),
(21, 15, '', 0),
(22, 15, '', 0),
(23, 15, '', 0),
(24, 15, '', 0);

-- --------------------------------------------------------

--
-- Table structure for table `#__poll_date`
--

DROP TABLE IF EXISTS `#__poll_date`;
CREATE TABLE IF NOT EXISTS `#__poll_date` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `vote_id` int(11) NOT NULL DEFAULT '0',
  `poll_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `poll_id` (`poll_id`)
);

--
-- Dumping data for table `#__poll_date`
--

INSERT INTO `#__poll_date` (`id`, `date`, `vote_id`, `poll_id`) VALUES
(1, '2006-10-09 13:01:58', 1, 14),
(2, '2006-10-10 15:19:43', 7, 14),
(3, '2006-10-11 11:08:16', 7, 14),
(4, '2006-10-11 15:02:26', 2, 14),
(5, '2006-10-11 15:43:03', 7, 14),
(6, '2006-10-11 15:43:38', 7, 14),
(7, '2006-10-12 00:51:13', 2, 14),
(8, '2007-05-10 19:12:29', 3, 14),
(9, '2007-05-14 14:18:00', 6, 14),
(10, '2007-06-10 15:20:29', 6, 14),
(11, '2007-07-03 12:37:53', 2, 14),
(12, '2010-07-23 23:50:18', 15, 15),
(13, '2010-07-25 10:51:13', 15, 15),
(14, '2010-07-28 17:41:19', 6, 14),
(15, '2010-07-28 22:57:50', 14, 15),
(16, '2010-07-29 13:05:45', 14, 15),
(17, '2010-07-30 04:49:32', 15, 15),
(18, '2010-07-30 14:38:46', 15, 15),
(19, '2010-07-30 14:49:12', 18, 15),
(20, '2010-07-30 19:50:13', 15, 15),
(21, '2010-07-30 23:23:04', 14, 15);

-- --------------------------------------------------------

--
-- Table structure for table `#__poll_menu`
--

DROP TABLE IF EXISTS `#__poll_menu`;
CREATE TABLE IF NOT EXISTS `#__poll_menu` (
  `pollid` int(11) NOT NULL DEFAULT '0',
  `menuid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`pollid`,`menuid`)
);

--
-- Dumping data for table `#__poll_menu`
--


-- --------------------------------------------------------

--
-- Table structure for table `#__rokcandy`
--

DROP TABLE IF EXISTS `#__rokcandy`;
CREATE TABLE IF NOT EXISTS `#__rokcandy` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `catid` int(11) NOT NULL,
  `macro` text NOT NULL,
  `html` text NOT NULL,
  `published` tinyint(1) NOT NULL,
  `checked_out` int(11) NOT NULL,
  `checked_out_time` datetime NOT NULL,
  `ordering` int(11) NOT NULL,
  `params` text NOT NULL,
  PRIMARY KEY (`id`)
);

--
-- Dumping data for table `#__rokcandy`
--

INSERT INTO `#__rokcandy` (`id`, `catid`, `macro`, `html`, `published`, `checked_out`, `checked_out_time`, `ordering`, `params`) VALUES
(20, 35, '[code]{text}[/code]', '<code>{text}</code>', 1, 0, '0000-00-00 00:00:00', 7, ''),
(21, 35, '[i]{text}[/i]', '<em>{text}</em>', 1, 0, '0000-00-00 00:00:00', 6, ''),
(22, 35, '[b]{text}[/b]', '<strong>{text}</strong>', 1, 0, '0000-00-00 00:00:00', 5, ''),
(23, 35, '[h4]{text}[/h4]', '<h4>{text}</h4>', 1, 0, '0000-00-00 00:00:00', 4, ''),
(24, 35, '[h1]{text}[/h1]', '<h1>{text}</h1>', 1, 0, '0000-00-00 00:00:00', 1, ''),
(25, 35, '[h2]{text}[/h2]', '<h2>{text}</h2>', 1, 0, '0000-00-00 00:00:00', 2, ''),
(26, 35, '[h3]{text}[/h3]', '<h3>{text}</h3>', 1, 0, '0000-00-00 00:00:00', 3, '');

-- --------------------------------------------------------

--
-- Table structure for table `#__sections`
--

DROP TABLE IF EXISTS `#__sections`;
CREATE TABLE IF NOT EXISTS `#__sections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(255) NOT NULL DEFAULT '',
  `image` text NOT NULL,
  `scope` varchar(50) NOT NULL DEFAULT '',
  `image_position` varchar(30) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `access` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `count` int(11) NOT NULL DEFAULT '0',
  `params` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_scope` (`scope`)
);

--
-- Dumping data for table `#__sections`
--

INSERT INTO `#__sections` (`id`, `title`, `name`, `alias`, `image`, `scope`, `image_position`, `description`, `published`, `checked_out`, `checked_out_time`, `ordering`, `access`, `count`, `params`) VALUES
(1, 'News', '', 'news', 'articles.jpg', 'content', 'right', 'Select a news topic from the list below, then select a news article to read.', 1, 0, '0000-00-00 00:00:00', 3, 0, 2, ''),
(3, 'FAQs', '', 'faqs', 'key.jpg', 'content', 'left', 'From the list below choose one of our FAQs topics, then select an FAQ to read. If you have a question which is not in this section, please contact us.', 1, 0, '0000-00-00 00:00:00', 5, 0, 23, ''),
(4, 'About Joomla!', '', 'about-joomla', '', 'content', 'left', '', 1, 0, '0000-00-00 00:00:00', 2, 0, 14, ''),
(5, 'Demo Content', '', 'demo-content', '', 'content', 'left', '', 1, 0, '0000-00-00 00:00:00', 6, 0, 9, '');

-- --------------------------------------------------------

--
-- Table structure for table `#__session`
--

DROP TABLE IF EXISTS `#__session`;
CREATE TABLE IF NOT EXISTS `#__session` (
  `username` varchar(150) DEFAULT '',
  `time` varchar(14) DEFAULT '',
  `session_id` varchar(200) NOT NULL DEFAULT '0',
  `guest` tinyint(4) DEFAULT '1',
  `userid` int(11) DEFAULT '0',
  `usertype` varchar(50) DEFAULT '',
  `gid` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `client_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `data` longtext,
  PRIMARY KEY (`session_id`(64)),
  KEY `whosonline` (`guest`,`usertype`),
  KEY `userid` (`userid`),
  KEY `time` (`time`)
);

-- --------------------------------------------------------

--
-- Table structure for table `#__stats_agents`
--

DROP TABLE IF EXISTS `#__stats_agents`;
CREATE TABLE IF NOT EXISTS `#__stats_agents` (
  `agent` varchar(255) NOT NULL DEFAULT '',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `hits` int(11) unsigned NOT NULL DEFAULT '1'
);

--
-- Dumping data for table `#__stats_agents`
--


-- --------------------------------------------------------

--
-- Table structure for table `#__templates_menu`
--

DROP TABLE IF EXISTS `#__templates_menu`;
CREATE TABLE IF NOT EXISTS `#__templates_menu` (
  `template` varchar(255) NOT NULL DEFAULT '',
  `menuid` int(11) NOT NULL DEFAULT '0',
  `client_id` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`menuid`,`client_id`,`template`)
);

--
-- Dumping data for table `#__templates_menu`
--

INSERT INTO `#__templates_menu` (`template`, `menuid`, `client_id`) VALUES
('rt_zephyr_j15', 0, 0),
('khepri', 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `#__users`
--

DROP TABLE IF EXISTS `#__users`;
CREATE TABLE IF NOT EXISTS `#__users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `username` varchar(150) NOT NULL DEFAULT '',
  `email` varchar(100) NOT NULL DEFAULT '',
  `password` varchar(100) NOT NULL DEFAULT '',
  `usertype` varchar(25) NOT NULL DEFAULT '',
  `block` tinyint(4) NOT NULL DEFAULT '0',
  `sendEmail` tinyint(4) DEFAULT '0',
  `gid` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `registerDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `lastvisitDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `activation` varchar(100) NOT NULL DEFAULT '',
  `params` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `usertype` (`usertype`),
  KEY `idx_name` (`name`),
  KEY `gid_block` (`gid`,`block`),
  KEY `username` (`username`),
  KEY `email` (`email`)
);

-- --------------------------------------------------------

--
-- Table structure for table `#__weblinks`
--

DROP TABLE IF EXISTS `#__weblinks`;
CREATE TABLE IF NOT EXISTS `#__weblinks` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `catid` int(11) NOT NULL DEFAULT '0',
  `sid` int(11) NOT NULL DEFAULT '0',
  `title` varchar(250) NOT NULL DEFAULT '',
  `alias` varchar(255) NOT NULL DEFAULT '',
  `url` varchar(250) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `hits` int(11) NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `archived` tinyint(1) NOT NULL DEFAULT '0',
  `approved` tinyint(1) NOT NULL DEFAULT '1',
  `params` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `catid` (`catid`,`published`,`archived`)
);

--
-- Dumping data for table `#__weblinks`
--

INSERT INTO `#__weblinks` (`id`, `catid`, `sid`, `title`, `alias`, `url`, `description`, `date`, `hits`, `published`, `checked_out`, `checked_out_time`, `ordering`, `archived`, `approved`, `params`) VALUES
(1, 2, 0, 'Joomla!', 'joomla', 'http://www.joomla.org', 'Home of Joomla!', '2005-02-14 15:19:02', 3, 1, 0, '0000-00-00 00:00:00', 1, 0, 1, 'target=0'),
(2, 2, 0, 'php.net', 'php', 'http://www.php.net', 'The language that Joomla! is developed in', '2004-07-07 11:33:24', 6, 1, 0, '0000-00-00 00:00:00', 3, 0, 1, ''),
(3, 2, 0, 'MySQL', 'mysql', 'http://www.mysql.com', 'The database that Joomla! uses', '2004-07-07 10:18:31', 1, 1, 0, '0000-00-00 00:00:00', 5, 0, 1, ''),
(4, 2, 0, 'OpenSourceMatters', 'opensourcematters', 'http://www.opensourcematters.org', 'Home of OSM', '2005-02-14 15:19:02', 11, 1, 0, '0000-00-00 00:00:00', 2, 0, 1, 'target=0'),
(5, 2, 0, 'Joomla! - Forums', 'joomla-forums', 'http://forum.joomla.org', 'Joomla! Forums', '2005-02-14 15:19:02', 4, 1, 0, '0000-00-00 00:00:00', 4, 0, 1, 'target=0'),
(6, 2, 0, 'Ohloh Tracking of Joomla!', 'ohloh-tracking-of-joomla', 'http://www.ohloh.net/projects/20', 'Objective reports from Ohloh about Joomla''s development activity. Joomla! has some star developers with serious kudos.', '2007-07-19 09:28:31', 1, 1, 0, '0000-00-00 00:00:00', 6, 0, 1, 'target=0\n\n');
