<?php
/**
 * @package Gantry Template Framework - RocketTheme
 * @version 1.5.0 August 1, 2010
 * @author RocketTheme http://www.rockettheme.com
 * @copyright Copyright (C) 2007 - 2010 RocketTheme, LLC
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 only
 *
 * Gantry uses the Joomla Framework (http://www.joomla.org), a GNU/GPLv2 content management system
 *
 */
// no direct access
defined( '_JEXEC' ) or die( 'Restricted index access' );

// load and inititialize gantry class
require_once('lib/gantry/gantry.php');
$gantry->init();

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="<?php echo $gantry->language; ?>" lang="<?php echo $gantry->language;?>" >
<head>
	<?php 
		$gantry->displayHead();
		$gantry->addStyles(array('template.css','joomla.css','overlays.css','typography.css'));

		if ($gantry->get('articledetails') == 'layout3' && $gantry->browser->engine == 'trident') $gantry->addScript('gantry-ie-zindex.js');
		if ($gantry->get('fixedfooter')) $gantry->addScript('rt-fixedfooter.js');
		$gantry->addScript('rt-rokstories-thumb-scroller.js');
	?>
</head>
	<body <?php echo $gantry->displayBodyTag(array('bodyLevel')); ?>>
		<div id="rt-page-background" <?php echo $gantry->displayClassesByTag('rt-page-background'); ?>>
			<div class="rt-container">
				<?php /** Begin Drawer **/ if ($gantry->countModules('drawer')) : ?>
				<div id="rt-drawer">
					<?php echo $gantry->displayModules('drawer','standard','standard'); ?>
					<div class="clear"></div>
				</div>
				<?php /** End Drawer **/ endif; ?>
				<?php /** Begin Top **/ if ($gantry->countModules('top')) : ?>
				<div id="rt-top" <?php echo $gantry->displayClassesByTag('rt-header'); ?>>
					<?php echo $gantry->displayModules('top','standard','standard'); ?>
					<div class="clear"></div>
				</div>
				<?php /** End Top **/ endif; ?>
				<?php /** Begin Header **/ if ($gantry->countModules('header')) : ?>
				<div id="rt-header" <?php echo $gantry->displayClassesByTag('rt-header'); ?>>
					<?php echo $gantry->displayModules('header','standard','standard'); ?>
					<div class="clear"></div>
				</div>
				<?php /** End Header **/ endif; ?>
				<div id="rt-body-surround">
					<div class="rt-box-top"><div class="rt-box-top2"></div><div class="rt-box-top3"></div></div>
					<div class="rt-box-bg"><div class="rt-box-bg2"><div class="rt-box-bg3">
						<?php /** Begin Navigation **/ if ($gantry->countModules('navigation')) : ?>
						<div id="rt-navigation" <?php echo $gantry->displayClassesByTag('rt-navigation'); ?>>
							<?php echo $gantry->displayModules('navigation','basic','basic'); ?>
					    	<div class="clear"></div>
						</div>
						<div class="rt-shadowbar"></div>
						<?php /** End Navigation **/ endif; ?>
						<?php /** Begin Showcase **/ if ($gantry->countModules('showcase')) : ?>
						<div id="rt-showcase" <?php echo $gantry->displayClassesByTag('rt-showcase'); ?>>
							<?php echo $gantry->displayModules('showcase','standard','standard'); ?>
							<div class="clear"></div>
						</div>
						<div class="rt-shadowbar"></div>
						<?php /** End Showcase **/ endif; ?>
						<?php /** Begin Feature **/ if ($gantry->countModules('feature')) : ?>
						<div id="rt-feature" <?php echo $gantry->displayClassesByTag('rt-feature'); ?>>
							<?php echo $gantry->displayModules('feature','standard','standard'); ?>
							<div class="clear"></div>
						</div>
						<div class="rt-shadowbar"></div>
						<?php /** End Feature **/ endif; ?>
						<?php /** Begin Utility **/ if ($gantry->countModules('utility')) : ?>
						<div id="rt-utility" <?php echo $gantry->displayClassesByTag('rt-utility'); ?>>
							<?php echo $gantry->displayModules('utility','standard','standard'); ?>
							<div class="clear"></div>
						</div>
						<?php /** End Utility **/ endif; ?>
						<?php /** Begin Breadcrumbs **/ if ($gantry->countModules('breadcrumb')) : ?>
						<div id="rt-breadcrumbs" <?php echo $gantry->displayClassesByTag('rt-utility'); ?>>
							<?php echo $gantry->displayModules('breadcrumb','basic','breadcrumbs'); ?>
							<div class="clear"></div>
						</div>
						<?php /** End Breadcrumbs **/ endif; ?>
						<?php /** Begin Main Top **/ if ($gantry->countModules('maintop')) : ?>
						<div id="rt-maintop" <?php echo $gantry->displayClassesByTag('rt-utility'); ?>>
							<?php echo $gantry->displayModules('maintop','standard','standard'); ?>
							<div class="clear"></div>
						</div>
						<div class="rt-shadowbar"></div>
						<?php /** End Main Top **/ endif; ?>
						<?php /** Begin Main Body **/ ?>
						<div id="rt-main-overlay" <?php echo $gantry->displayClassesByTag('rt-main-overlay'); ?>>
					    	<?php echo $gantry->displayMainbody('mainbody','sidebar','standard','standard','standard','standard','standard'); ?>
						</div>
						<div class="rt-shadowbar"></div>
						<?php /** End Main Body **/ ?>
						<?php /** Begin Main Bottom **/ if ($gantry->countModules('mainbottom')) : ?>
						<div id="rt-mainbottom" <?php echo $gantry->displayClassesByTag('rt-utility'); ?>>
							<?php echo $gantry->displayModules('mainbottom','standard','standard'); ?>
							<div class="clear"></div>
						</div>
						<div class="rt-shadowbar"></div>
						<?php /** End Main Bottom **/ endif; ?>
					</div></div></div>
					<div class="rt-box-bottom"><div class="rt-box-bottom2"></div><div class="rt-box-bottom3"></div></div>
				</div>
				<div class="rt-shadowbar"></div>
				<?php /** Begin Bottom Section **/ if ($gantry->countModules('bottom') or $gantry->countModules('copyright')) : ?>
				<div id="rt-bottom-surround" <?php echo $gantry->displayClassesByTag('rt-bottom-surround'); ?>>
					<div class="rt-box-top"><div class="rt-box-top2"></div><div class="rt-box-top3"></div></div>
					<div class="rt-box-bg"><div class="rt-box-bg2"><div class="rt-box-bg3">
						<?php /** Begin Bottom **/ if ($gantry->countModules('bottom')) : ?>
						<div id="rt-bottom">
							<?php echo $gantry->displayModules('bottom','standard','standard'); ?>
							<div class="clear"></div>
						</div>
						<?php /** End Bottom **/ endif; ?>
						<?php /** Begin Copyright **/ if ($gantry->countModules('copyright')) : ?>
						<div id="rt-copyright">
							<?php echo $gantry->displayModules('copyright','standard','standard'); ?>
							<div class="clear"></div>
						</div>
						<?php /** End Copyright **/ endif; ?>
					</div></div></div>
					<div class="rt-box-bottom"><div class="rt-box-bottom2"></div><div class="rt-box-bottom3"></div></div>
				</div>
				<?php /** End Bottom Section **/ endif; ?>
				<?php /** Begin Debug **/ if ($gantry->countModules('debug')) : ?>
				<div id="rt-debug">
					<?php echo $gantry->displayModules('debug','standard','standard'); ?>
					<div class="clear"></div>
				</div>
				<?php /** End Debug **/ endif; ?>
			</div>
			<?php /** Begin Footer **/ if ($gantry->countModules('footer')) : ?>
			<div id="rt-footerbar" <?php echo $gantry->displayClassesByTag('rt-footerbar'); ?>>
				<div class="rt-container">
					<div id="rt-footer">
						<?php echo $gantry->displayModules('footer','standard','standard'); ?>
						<div class="clear"></div>
					</div>
				</div>
			</div>
			<?php if ($gantry->get('fixedfooter')==0) : ?>
			<div class="rt-shadowbar"></div>
			<?php endif; ?>
			<?php /** End Footer **/ endif; ?>
		</div>
		<?php /** Begin Popups **/ 
		echo $gantry->displayModules('popup','popup','popup');
		echo $gantry->displayModules('login','login','popup'); 
		/** End Popup s**/ ?>
		<?php /** Begin Analytics **/ if ($gantry->countModules('analytics')) : ?>
		<?php echo $gantry->displayModules('analytics','basic','basic'); ?>
		<?php /** End Analytics **/ endif; ?>
	</body>
</html>
<?php
$gantry->finalize();
?>