<?php
/**
 * @package   Zephyr Template - RocketTheme
 * @version   1.5.0 August 1, 2010
 * @author    RocketTheme http://www.rockettheme.com
 * @copyright Copyright (C) 2007 - 2010 RocketTheme, LLC
 * @license   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 only
 *
 * Rockettheme Zephyr Template uses the Joomla Framework (http://www.joomla.org), a GNU/GPLv2 content management system
 *
 */
defined('_JEXEC') or die('Restricted access'); 
$doc = &JFactory::getDocument();
JHTML::_('behavior.mootools');
$doc->addScript(JURI::Root(true) . '/modules/mod_rokintroscroller/rokintroscroller.js');
$doc->addScriptDeclaration("
window.addEvent((window.safari) ? 'load' : 'domready', function() {
	var rnu = new RokIntroScroller('rokintroscroller', {
		'arrows': {
			'effect': true,
			'opacity': ".$params->get('arrows_opacity', 0.35)."
		},
		'scroll': {
			'duration': ".$params->get('duration').",
			'itemsPerClick': ".$params->get('items_per_click', 2).",
			'transition': Fx.Transitions.Quad.easeOut
		}
	});
});");
?>

<!-- Content START -->
<div id="rokintroscroller" class="<?php echo $params->get('moduleclass_sfx'); ?>">
	<?php foreach ($list as $item) :  ?>
		<div class="scroller-item">
			<?php if ($params->get('show_title') == 1) :?>
				<div class="scroller-title">
					<?php if ($params->get('link_title') == 1) :?>
					<h2><a href="<?php echo $item->link; ?>"><?php echo $item->title; ?></a></h2>
					<?php else: ?>
					<h2><?php echo $item->title; ?></h2>
					<?php endif; ?>
				</div>
			<?php endif; ?>
			
           <?php echo $item->introtext; ?> 

           <?php if ($params->get('show_readmore') == 1) :?>
           <a href="<?php echo $item->link; ?>" class="readon3"><?php echo $params->get('readmore'); ?></a> 
           <?php endif; ?>
		</div>
	<?php endforeach; ?>	
</div>
<!-- Content END -->


