<?php
/**
 * @package		Gantry Template Framework - RocketTheme
 * @version		1.5.0 August 1, 2010
 * @author		RocketTheme http://www.rockettheme.com
 * @copyright 	Copyright (C) 2007 - 2010 RocketTheme, LLC
 * @license		http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 only
 *
 * Gantry uses the Joomla Framework (http://www.joomla.org), a GNU/GPLv2 content management system
 *
 */
defined('JPATH_BASE') or die();

gantry_import('core.gantryfeature');

class GantryFeatureStyleDeclaration extends GantryFeature {
    var $_feature_name = 'styledeclaration';

    function isEnabled() {
        global $gantry;
        $menu_enabled = $this->get('enabled');

        if (1 == (int)$menu_enabled) return true;
        return false;
    }

	function init() {
        global $gantry;

		// tooltips for articledetails layout3
		if ($gantry->get('articledetails') == 'layout3') $gantry->addScript('gantry-articledetails.js');

		//inline css for dynamic stuff
		$css = 'body {background:'.$gantry->get('page-background').';}'."\n";
		$css .= '.details-layout3 .rt-articleinfo {background-color:'.$gantry->get('page-background').';}'."\n";
		$css .= 'body, a:hover, #rt-popuplogin .inputbox {color:'.$gantry->get('page-text').';}'."\n";
		$css .= 'a, #rt-popuplogin .readon, #rt-popuplogin .readon .button, ul.roknewspager-numbers li.active {color:'.$gantry->get('page-link').';}'."\n";

		$css .= '#rt-header, #rt-header a:hover, #rt-header .title, #rt-header .inputbox, #rt-top, #rt-top a:hover, #rt-top .title, #rt-top .inputbox {color:'.$gantry->get('header-text').';}'."\n";
		$css .= '#rt-header a, #rt-header .title span, #rt-header .readon span, #rt-header .readon .button, #rt-top a, #rt-top .title span, #rt-top .readon span, #rt-top .readon .button, #rt-header ul.roknewspager-numbers li.active, #rt-top ul.roknewspager-numbers li.active {color:'.$gantry->get('header-link').';}'."\n";

		$css .= '#rt-navigation {background-color:'.$gantry->get('navigation-background').';}'."\n";
		$css .= '#rt-navigation, #rt-navigation .inputbox, .fusion-submenu-wrapper .readon .button, .fusion-submenu-wrapper .readon, #rt-navigation .fusion-submenu-wrapper .readon .button, #rt-navigation .fusion-submenu-wrapper .readon {color:'.$gantry->get('navigation-text').';}'."\n";
		$css .= '.title1 .title, .title2 .title, .title1 .module-title .title span, .title2 .module-title .title span {color:'.$gantry->get('navigation-text').' !important;}'."\n";
		$css .= '#rt-navigation .module-content a, #rt-navigation .readon .button {color:'.$gantry->get('navigation-link').';}'."\n";
		$css .= '.menutop li.active.root > .item, .menutop li.active.root.f-mainparent-itemfocus > .item, .menutop li.root:hover > .item, .menutop li.root.f-mainparent-itemfocus > .item, .menu-type-splitmenu .menutop li.active > .item, .menu-type-splitmenu .menutop li:hover > .item, .menutop .fusion-submenu-wrapper, .title2 .module-title {background-color:'.$gantry->get('navigation-link').';}'."\n";
		$css .= '.menutop li.root > .item, .menutop li > .item {color:'.$gantry->get('navigation-text').';}'."\n";
		$css .= 'body #idrops li.root-sub a, body #idrops li.root-sub span.separator, body #idrops li.root-sub.active a, body #idrops li.root-sub.active span.separator {color:'.$gantry->get('navigation-link').';}'."\n";

		$css .= '#rt-showcase, .title1 .module-title, .box7 .rt-block, .box10 .rt-block {background-color:'.$gantry->get('showcase-background').';}'."\n";
		$css .= '#rt-showcase, #rt-showcase a:hover, #rt-showcase .inputbox, #rt-showcase .created-date {color:'.$gantry->get('showcase-text').';}'."\n";
		$css .= '.box7, .box7 .title, .box7 a:hover, .box10, .box10 .title, .box10 a:hover {color:'.$gantry->get('showcase-text').' !important;}'."\n";
		$css .= '#rt-showcase a, #rt-showcase .readon .button, #rt-showcase .title span, #rt-showcase ul.roknewspager-numbers li.active {color:'.$gantry->get('showcase-link').';}'."\n";
		$css .= '.box7 a, .box7 .title span, .box7 .roktabs-links li.active span, .box7 ul.roknewspager-numbers li.active, .box10 a, .box10 .title span, .box7 .button, .box10 .button, .box10 .roktabs-links li.active span, .box10 ul.roknewspager-numbers li.active {color:'.$gantry->get('showcase-link').' !important;}'."\n";

		$css .= '#rt-feature, .box8 .rt-block, .box11 .rt-block, .title3 .module-title {background-color:'.$gantry->get('feature-background').';}'."\n";
		$css .= '#rt-feature, #rt-feature a:hover, #rt-feature .inputbox {color:'.$gantry->get('feature-text').';}'."\n";
		$css .= '.box8, .box8 .title, .box8 a:hover, .box11, .box11 .title, .box11 a:hover, .title3 .module-title .title {color:'.$gantry->get('feature-text').' !important;}'."\n";
		$css .= '#rt-feature a, #rt-feature .readon .button, #rt-feature .title span, #rt-feature ul.roknewspager-numbers li.active {color:'.$gantry->get('feature-link').';}'."\n";
		$css .= '.box8 a, .box8 .title span, .box8 .button, .box8 .roktabs-links li.active span, .box8 ul.roknewspager-numbers li.active, .box11 a, .box11 .title span, .box11 .button, .box11 .roktabs-links li.active span, .box11 ul.roknewspager-numbers li.active, .title3 .module-title .title span {color:'.$gantry->get('feature-link').' !important;}'."\n";

		$css .= 'body #roksearch_results {background:'.$gantry->get('body-background').';}'."\n";
		$css .= '.rt-main-inner {background-color:'.$gantry->get('body-background').';}'."\n";
		$css .= '#rt-main, legend, #rokajaxsearch .inputbox, #rt-mainbody .inputbox, #rt-mainbody input#email, #rt-mainbody input#name, #rt-mainbody input#username, #rt-mainbody input#password, #rt-mainbody input#password2, #rt-mainbody input#passwd, #rt-main a:hover {color:'.$gantry->get('body-text').';}'."\n";
		$css .= '.roktabs-links li.active span, .heading1, #rt-main .readon .button, #rt-main ul.roknewspager-numbers li.active {color:'.$gantry->get('body-link').';}'."\n";

		$css .= '#rt-bottom-surround, .box9 .rt-block, .box12 .rt-block {background-color:'.$gantry->get('bottom-background').';}'."\n";
		$css .= '#rt-bottom, #rt-bottom a:hover, #rt-bottom .title, #rt-bottom .inputbox, #rt-copyright, #rt-copyright a:hover, #rt-copyright .title, #rt-copyright .inputbox {color:'.$gantry->get('bottom-text').';}'."\n";
		$css .= '.box9, .box9 .title, .box9 a:hover, .box12, .box12 .title, .box12 a:hover {color:'.$gantry->get('bottom-text').' !important;}'."\n";
		$css .= '#rt-bottom a, #rt-bottom .readon .button, #rt-bottom .title span, #rt-copyright a, #rt-copyright .title span, #rt-copyright .readon .button, #rt-bottom ul.roknewspager-numbers li.active {color:'.$gantry->get('bottom-link').';}'."\n";
		$css .= '.box9 a, .box9 .title span, .box9 .button, .box9 .roktabs-links li.active span, .box9 ul.roknewspager-numbers li.active, .box12 a, .box12 .title span, .box12 .button, .box12 .roktabs-links li.active span, .box12 ul.roknewspager-numbers li.active {color:'.$gantry->get('bottom-link').' !important;}'."\n";

		$css .= '#rt-footerbar {background-color:'.$gantry->get('footer-background').';}'."\n";
		$css .= '#rt-footer, #rt-footer .title, #rt-footer a:hover, #rt-footer .inputbox {color:'.$gantry->get('footer-text').';}'."\n";
		$css .= '#rt-footer a, #rt-footer .readon .button, #rt-footer .title span, #rt-footer ul.roknewspager-numbers li.active {color:'.$gantry->get('footer-link').';}'."\n";

		if ($gantry->get('iphone-enabled')) {
			$css .= 'body.rt-normal .rt-articleinfo, body.rt-flipped .rt-articleinfo, body.rt-left .rt-articleinfo, body.rt-right .rt-articleinfo {color:'.$gantry->get('body-link').';}'."\n";
		}

		if ($gantry->get('thirdparty')){

			// JomSocial
			$css .= '#community-wrap .cModule h3 {background-color:'.$gantry->get('showcase-background').';}'."\n";
			$css .= '#community-wrap .cModule h3, #community-wrap #community-group-action h3, #community-wrap #community-event-action h3 {color:'.$gantry->get('navigation-text').';}'."\n";
			$css .= '#community-wrap ul.submenu li a, #community-wrap ul.submenu li span {color:'.$gantry->get('page-link').';}'."\n";
			$css .= '#community-wrap ul.submenu li a.active:link, #community-wrap ul.submenu li a.active:visited, #community-wrap ul.submenu li a.active:hover {color:'.$gantry->get('page-text').';}'."\n";
			$css .= '#community-wrap #cToolbarNav.cToolbar ul#cToolbarNavList li.toolbar-active div a.has-separator, #community-wrap #cToolbarNav.cToolbar ul#cToolbarNavList li.toolbar-active div, #community-wrap #cToolbarNav.cToolbar ul#cToolbarNavList li.toolbar-active div a {border-bottom: 1px solid '.$gantry->get('body-background').' !important;background-color:'.$gantry->get('body-background').' !important;}'."\n";
			$css .= '#community-wrap #cToolbarNav.cToolbar ul#cToolbarNavList li#toolbar-item-logout, #community-wrap #cToolbarNav.cToolbar ul#cToolbarNavList li#toolbar-item-logout a, #community-wrap .cModule h4, #community-wrap dl.profile-right-info dd, #community-wrap .app-box-title {color:'.$gantry->get('body-text').';}'."\n";
			$css .= 'body #rt-main #community-wrap .loginform #form-login #submit {color:'.$gantry->get('body-link').';}'."\n";
			
			// Tienda
			$css .= '#billingDefaultAddress input, #shippingDefaultAddress input, #customer_note, #apply_action {color: '.$gantry->get('body-text').';}'."\n";

			// JComment
			$css .= '#comments-form input, #comments-report-form input, #comments-form textarea, #comments-form input.selected, #comments-form textarea.selected {color: '.$gantry->get('body-text').';}'."\n";

		}

		//ie6 specific style
		if ($gantry->browser->name == 'ie' && $gantry->browser->shortversion == '6') {
			$css .= '#rt-navigation .menutop li ul {background-color:'.$gantry->get('navigation-background').';}'."\n";
		}

		if ($gantry->get('static-enabled')) {
            // do file stuff
            jimport('joomla.filesystem.file');
            $filename = $gantry->templatePath.DS.'css'.DS.'static-styles.css';

            if (file_exists($filename)) {
                if ($gantry->get('static-check')) {
                    //check to see if it's outdated

                    $md5_static = md5_file($filename);
                    $md5_inline = md5($css);

                    if ($md5_static != $md5_inline) {
                        JFile::write($filename, $css);
                    }
                }
            } else {
                // file missing, save it
                JFile::write($filename, $css);
            }
            // add reference to static file
            $gantry->addStyle('static-styles.css',99);

        } else {
            // add inline style
            $gantry->addInlineStyle($css);
        }


		$this->_disableRokBoxForiPhone();

		//style stuff
        //$gantry->addStyle($gantry->get('cssstyle').".css");
		if ($gantry->get('thirdparty')) $gantry->addStyle('extended.css');

	}

	function _disableRokBoxForiPhone() {
		global $gantry;

		if ($gantry->browser->platform == 'iphone') {
			$gantry->addInlineScript("window.addEvent('domready', function() {\$\$('a[rel^=rokbox]').removeEvents('click');});");
		}
	}

}